/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.jdbcx.db2;

import com.metamatrix.jdbc.base.BaseConnection;
import com.metamatrix.jdbc.db2.DB2Connection;
import com.metamatrix.jdbc.db2.DB2ImplConnection;
import com.metamatrix.jdbc.db2.drda.DRDAByteOrderedDataReader;
import com.metamatrix.jdbc.db2.drda.DRDAByteOrderedDataWriter;
import com.metamatrix.jdbc.db2.drda.DRDASyncLog;
import com.metamatrix.jdbc.db2.drda.DRDASyncRequestMVS;
import com.metamatrix.jdbcx.base.BaseImplXAResource;
import com.metamatrix.jdbcx.db2.DB2Xid;
import java.sql.SQLException;
import java.sql.Statement;
import javax.transaction.xa.XAException;
import javax.transaction.xa.Xid;

public class DB2ImplXAResourceMVS
extends BaseImplXAResource {
    private static String footprint = "$Revision:   3.1.3.0  $";
    BaseConnection connection;
    DB2ImplConnection implConn;
    DRDASyncRequestMVS request;
    int sequenceNumber;
    int timeout;
    byte[] uniqueInstance = null;
    public DRDASyncLog clientSyncLog;
    private boolean isPrepared;
    public DRDAByteOrderedDataWriter writer;
    public DRDAByteOrderedDataReader reader;

    public DB2ImplXAResourceMVS(BaseConnection baseConnection) {
        this.connection = baseConnection;
        this.implConn = ((DB2Connection)baseConnection).implCon;
        this.sequenceNumber = 0;
        this.uniqueInstance = new byte[6];
        this.isPrepared = false;
        this.reader = this.implConn.comm.createReader();
        this.reader.setToBigEndian();
        this.writer = this.implConn.dataWriter;
        this.request = new DRDASyncRequestMVS(this.implConn, this.implConn.comm, this.reader, this.writer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void open() throws SQLException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            try {
                this.connection.setAutoCommit(false);
                this.request.writeLogInfoRequest();
                this.request.submitRequest();
                this.request.processReply(this.implConn.warnings);
                this.checkSystemXATable();
            }
            catch (XAException xAException) {
                throw new SQLException("XAOpen failed against target Database.");
            }
        }
    }

    protected void checkSystemXATable() throws SQLException {
        Statement statement = this.connection.createStatement();
        try {
            statement.executeQuery("select * from DDUOWMAP where XID = 0");
        }
        catch (SQLException sQLException) {
            if (sQLException.getSQLState().equalsIgnoreCase("42704")) {
                statement.executeUpdate("CREATE TABLE DDUOWMAP(XID VARCHAR(100) FOR BIT DATA, UOW VARCHAR(100) FOR BIT DATA)");
            }
            throw sQLException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void start(Xid xid, int n) throws XAException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            try {
                byte[] byArray = this.getNewUowid();
                DB2Xid dB2Xid = new DB2Xid(xid);
                try {
                    this.clientSyncLog = new DRDASyncLog(this.implConn, dB2Xid);
                }
                catch (Exception exception) {
                    throw new XAException(-5);
                }
                this.request.requestNewUOW(byArray, dB2Xid);
                this.request.submitTimedRequest(3000);
                this.request.processReply(this.implConn.warnings);
            }
            catch (SQLException sQLException) {
                throw new XAException("XAStart failed");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void rollback(Xid xid) throws XAException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            ++this.sequenceNumber;
            DB2Xid dB2Xid = new DB2Xid(xid);
            this.request.rollBackUOW();
            this.isPrepared = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void commit(Xid xid, boolean bl) throws XAException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            ++this.sequenceNumber;
            DB2Xid dB2Xid = new DB2Xid(xid);
            if (!this.isPrepared && !bl) {
                throw new XAException(-5);
            }
            if (bl) {
                this.request.commitUOW(true);
            } else {
                this.request.commitUOW(false);
            }
            this.isPrepared = false;
        }
    }

    protected Xid[] recover(int n) throws XAException {
        Xid[] xidArray = null;
        return xidArray;
    }

    protected int prepare(Xid xid) throws XAException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            try {
                this.isPrepared = false;
                this.request.prepareToCommit(this.clientSyncLog);
                this.request.submitRequest();
                this.request.processReply(this.implConn.warnings);
                this.isPrepared = true;
                return 0;
            }
            catch (SQLException sQLException) {
                throw new XAException(sQLException.getMessage());
            }
        }
    }

    protected void end(Xid xid, int n) throws XAException {
    }

    protected void forget(Xid xid) throws XAException {
    }

    protected int getTransactionTimeout() throws XAException {
        return this.timeout;
    }

    protected boolean setTransactionTimeout(int n) throws XAException {
        if (n < 0) {
            throw new XAException(-5);
        }
        this.timeout = n;
        return false;
    }

    protected String getRmIdentification() throws XAException {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.implConn.host);
        stringBuffer.append("_");
        stringBuffer.append(this.implConn.port);
        stringBuffer.append("_");
        stringBuffer.append(this.implConn.databaseName);
        return stringBuffer.toString();
    }

    protected byte[] getNewUowid() throws XAException {
        byte[] byArray = new byte[25];
        byte[] byArray2 = this.request.serverSyncLog.getNetName(this.implConn);
        byte[] byArray3 = Long.toHexString(System.currentTimeMillis()).getBytes();
        byte[] byArray4 = new byte[]{(byte)(this.sequenceNumber >>> 8 & 0xFF), (byte)(this.sequenceNumber >>> 0 & 0xFF)};
        System.arraycopy(byArray3, 4, this.uniqueInstance, 0, 6);
        System.arraycopy(byArray2, 0, byArray, 0, 17);
        System.arraycopy(this.uniqueInstance, 0, byArray, 17, 6);
        System.arraycopy(byArray4, 0, byArray, 23, 2);
        return byArray;
    }
}

