/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.jdbc.db2.drda;

import com.metamatrix.jdbc.base.BaseClassUtility;
import com.metamatrix.jdbc.base.BaseExceptions;
import com.metamatrix.jdbc.db2.DB2ImplConnection;
import com.metamatrix.jdbc.db2.DB2PackageManager;
import com.metamatrix.jdbc.db2.drda.DRDAByteOrderedDataReader;
import com.metamatrix.jdbc.db2.drda.DRDAUtil;
import com.metamatrix.util.UtilException;
import com.metamatrix.util.UtilPagedTempBuffer;
import com.metamatrix.util.UtilSocketCreator;
import com.metamatrix.util.UtilTransliterator;
import com.metamatrix.util.UtilTransliteratorPool;
import java.io.IOException;
import java.net.Socket;
import java.sql.SQLException;
import java.util.Properties;

public class DRDACommunication {
    private static String footprint = "$Revision:   3.56.1.2  $";
    public Socket socket;
    public byte[] socketBuffer;
    private String socketBufferSizeStr;
    public int socketBufferSize;
    boolean socketDebugging;
    public BaseExceptions exceptions;
    public UtilTransliteratorPool transliteratorPool;
    public UtilTransliterator defaultCCSIDTransliterator;
    public int sbcs;
    public int dbcs;
    public int mbcs;
    public UtilTransliterator SingleByteServerTransliterator;
    public UtilTransliterator DoubleByteServerTransliterator;
    public UtilTransliterator MultiByteServerTransliterator;
    public UtilTransliterator TempSingleByteServerTransliterator;
    public UtilTransliterator TempDoubleByteServerTransliterator;
    public UtilTransliterator TempMultiByteServerTransliterator;
    public int clientSBCS = 1252;
    public int clientDBCS = 1200;
    public int clientMBCS = 1208;
    public UtilTransliterator SingleByteClientTransliterator;
    public UtilTransliterator DoubleByteClientTransliterator;
    public UtilTransliterator MultiByteClientTransliterator;
    public int DDMAgentLevel = 0;
    public int SQLAMLevel = 0;
    public int SYNCPTMGRLevel = 0;
    public int RSYNCMGRLevel = 0;
    public int CCSIDMGRLevel = 0;
    public int SECMGRLevel = 0;
    public int CMNTCPIPLevel = 0;
    public int RDBLevel = 0;
    public int XAMGRLevel = 0;
    public String ServerExternalName = null;
    public String ServerClassName = null;
    public String ServerName = null;
    public String ServerReleaseLevel = null;
    public String ServerProductID = null;
    public String ServerTypDefname = null;
    public boolean isServerBigEndianOS;
    public DB2ImplConnection implConn;
    public int serverOS = 0;
    public int serverMajorVersion = 0;
    public int serverMinorVersion = 0;
    public String databasePatchVersion;
    public int serverType = 0;
    public boolean enableFullSizeLobs;
    public boolean enableDescribeParam;
    public boolean enableRealStoredProcPrepare;
    public boolean enableRealBigint;
    public boolean losesPreparedStateOnCommit;
    public boolean supportsCancel;
    public boolean supportsDRDABatchEmulation;
    public boolean clearsAutoGenRegisterOnCommit;
    public boolean allowsInsertIntoVarcharAsClob;
    public boolean supportsStoredProcMetadata;
    public boolean supportsXA;
    public boolean bindsPackagesAsSQLAMv6;
    public boolean useMultiByteCPForParams;
    public boolean disableImportedKeysSystemProc;
    public boolean disableTablesSystemProc;
    public boolean disableColumnsSystemProc;
    public boolean allowsLobStreamingAtSQLAM6;
    public boolean allowsLobStreamingAtSQLAM7;
    public boolean supportsExtendedTypSQLDA;
    public DB2PackageManager packageManager;
    public DRDAUtil drdaUtil;
    public String sendStreamAsBlobStr;
    public boolean sendStreamAsBlob;
    public boolean useBetaXAImplementation;

    public DRDACommunication(DB2ImplConnection dB2ImplConnection, String string, String string2, BaseExceptions baseExceptions) throws SQLException {
        this.exceptions = baseExceptions;
        this.enableFullSizeLobs = false;
        this.enableDescribeParam = false;
        this.enableRealStoredProcPrepare = false;
        this.enableRealBigint = false;
        this.losesPreparedStateOnCommit = false;
        this.supportsCancel = false;
        this.clearsAutoGenRegisterOnCommit = true;
        this.allowsInsertIntoVarcharAsClob = false;
        this.allowsLobStreamingAtSQLAM6 = false;
        this.allowsLobStreamingAtSQLAM7 = true;
        this.supportsStoredProcMetadata = false;
        this.supportsXA = false;
        this.drdaUtil = new DRDAUtil(this);
        this.useMultiByteCPForParams = true;
        this.sendStreamAsBlobStr = dB2ImplConnection.connectProps.get("sendStreamAsBlob");
        this.sendStreamAsBlob = this.sendStreamAsBlobStr == null ? false : (BaseClassUtility.exposeCtsIncompatibleOptions() ? this.sendStreamAsBlobStr.equalsIgnoreCase("true") : false);
        this.packageManager = new DB2PackageManager(this, dB2ImplConnection);
        this.socketBufferSizeStr = dB2ImplConnection.connectProps.get("socketBufferSize");
        if (this.socketBufferSizeStr == null) {
            this.socketBufferSize = Short.MAX_VALUE;
        } else {
            this.socketBufferSize = Integer.parseInt(this.socketBufferSizeStr) * 1024;
            if (this.socketBufferSize < 1024 || this.socketBufferSize > 0x200000) {
                throw this.exceptions.getException(7109);
            }
        }
        this.socketBuffer = new byte[this.socketBufferSize];
        Properties properties = dB2ImplConnection.connectProps.getSocketDebugProperties();
        if (properties != null) {
            properties.put("DDTDBG.PROTOCOLTRACEEBCDIC", "true");
            this.socketDebugging = true;
        }
        try {
            this.socket = UtilSocketCreator.getSocket((String)string, (int)Integer.parseInt(string2), (Properties)properties);
        }
        catch (Exception exception) {
            String[] stringArray = new String[]{exception.getMessage()};
            throw this.exceptions.getException(6001, stringArray, "08001");
        }
        try {
            this.socket.setReceiveBufferSize(this.socketBufferSize);
            this.socket.setSendBufferSize(this.socketBufferSize);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.implConn = dB2ImplConnection;
        this.transliteratorPool = new UtilTransliteratorPool(10);
    }

    public DRDAByteOrderedDataReader createReader() {
        return new DRDAByteOrderedDataReader(this.defaultCCSIDTransliterator, this);
    }

    public DRDAByteOrderedDataReader createReader(UtilPagedTempBuffer utilPagedTempBuffer, int n) {
        return new DRDAByteOrderedDataReader(utilPagedTempBuffer, n, this.defaultCCSIDTransliterator, this);
    }

    public void setClientSideTransliteration() throws SQLException {
        try {
            this.defaultCCSIDTransliterator = this.transliteratorPool.getTransliteratorForCodePage(Integer.toString(500));
            if (this.isUDBCompatible()) {
                this.clientSBCS = 1208;
            }
            this.SingleByteClientTransliterator = this.transliteratorPool.getTransliteratorForCodePage(Integer.toString(this.clientSBCS));
            this.DoubleByteClientTransliterator = this.transliteratorPool.getTransliteratorForCodePage(Integer.toString(this.clientDBCS));
            this.MultiByteClientTransliterator = this.transliteratorPool.getTransliteratorForCodePage(Integer.toString(this.clientMBCS));
            this.sbcs = this.clientSBCS;
            this.dbcs = this.clientDBCS;
            this.mbcs = this.clientMBCS;
        }
        catch (UtilException utilException) {
            throw this.exceptions.getException((Exception)((Object)utilException), "08001");
        }
    }

    public void setServerSideTransliteration() throws SQLException {
        try {
            this.SingleByteServerTransliterator = this.implConn.codePageOverride != null ? this.transliteratorPool.getTransliteratorForCodePage(this.implConn.codePageOverride) : this.transliteratorPool.getTransliteratorForCodePage(Integer.toString(this.sbcs));
            this.DoubleByteServerTransliterator = this.transliteratorPool.getTransliteratorForCodePage(Integer.toString(this.dbcs));
            this.MultiByteServerTransliterator = this.transliteratorPool.getTransliteratorForCodePage(Integer.toString(this.mbcs));
        }
        catch (UtilException utilException) {
            throw this.exceptions.getException((Exception)((Object)utilException), "08001");
        }
    }

    public void fixSQLAMLevels() throws SQLException {
        if (this.serverType == 7 || this.serverType == 8) {
            this.SQLAMLevel = 5;
        }
    }

    public boolean isUDBCompatible() {
        return this.implConn.isUDBCompatible();
    }

    public void setServerInfo() {
        this.serverOS = this.ServerClassName.equalsIgnoreCase("QDB2/NT") ? 1 : (this.ServerClassName.equalsIgnoreCase("QDB2/LINUX") ? 4 : (this.ServerClassName.equalsIgnoreCase("QDB2/LINUX390") ? 7 : (this.ServerClassName.equalsIgnoreCase("QDB2/6000") ? 2 : (this.ServerClassName.equalsIgnoreCase("QDB2/SUN") ? 5 : (this.ServerClassName.equalsIgnoreCase("QDB2/HPUX") ? 6 : (this.ServerClassName.equalsIgnoreCase("QDB2") ? 3 : (this.ServerClassName.equalsIgnoreCase("QAS") ? 8 : 1)))))));
        if (this.serverOS == 8) {
            this.clearsAutoGenRegisterOnCommit = false;
            this.supportsDRDABatchEmulation = true;
            if (this.serverMajorVersion == 5) {
                if (this.serverMinorVersion == 1) {
                    this.serverType = 2;
                    this.losesPreparedStateOnCommit = true;
                    this.useMultiByteCPForParams = false;
                } else if (this.serverMinorVersion == 2) {
                    this.serverType = 3;
                    this.enableDescribeParam = true;
                    this.enableRealStoredProcPrepare = true;
                    this.enableFullSizeLobs = true;
                    this.allowsLobStreamingAtSQLAM6 = true;
                    this.losesPreparedStateOnCommit = true;
                    this.useMultiByteCPForParams = true;
                } else {
                    this.serverType = 11;
                    this.enableDescribeParam = true;
                    this.enableRealStoredProcPrepare = true;
                    this.enableFullSizeLobs = true;
                    this.allowsLobStreamingAtSQLAM6 = true;
                    this.losesPreparedStateOnCommit = true;
                    this.allowsLobStreamingAtSQLAM7 = true;
                    this.supportsStoredProcMetadata = true;
                    this.disableImportedKeysSystemProc = true;
                    this.disableColumnsSystemProc = true;
                    this.disableTablesSystemProc = true;
                    this.enableRealBigint = true;
                    this.useMultiByteCPForParams = true;
                }
            } else {
                this.losesPreparedStateOnCommit = true;
                this.serverType = 1;
            }
            this.enableRealBigint = true;
        } else if (this.serverOS == 3) {
            this.enableFullSizeLobs = true;
            this.enableDescribeParam = true;
            this.losesPreparedStateOnCommit = true;
            this.supportsDRDABatchEmulation = true;
            if (this.serverMajorVersion == 6) {
                this.serverType = 5;
            } else if (this.serverMajorVersion == 7) {
                this.serverType = 6;
            } else if (this.serverMajorVersion == 8) {
                this.allowsInsertIntoVarcharAsClob = true;
                this.allowsLobStreamingAtSQLAM6 = true;
                this.enableRealBigint = true;
                this.supportsCancel = true;
                this.supportsXA = true;
                this.serverType = 10;
            } else {
                this.allowsInsertIntoVarcharAsClob = true;
                this.allowsLobStreamingAtSQLAM6 = true;
                this.enableRealBigint = true;
                this.supportsCancel = true;
                this.supportsXA = true;
                this.serverType = 10;
            }
        } else if (this.serverMajorVersion == 6) {
            this.serverType = 7;
        } else if (this.serverMajorVersion == 7) {
            this.serverType = 8;
            this.supportsDRDABatchEmulation = true;
        } else if (this.serverMajorVersion == 8) {
            this.serverType = 9;
            this.useBetaXAImplementation = true;
            this.enableFullSizeLobs = true;
            this.enableDescribeParam = true;
            this.enableRealStoredProcPrepare = true;
            this.enableRealBigint = true;
            this.supportsCancel = true;
            this.supportsDRDABatchEmulation = true;
            this.clearsAutoGenRegisterOnCommit = false;
            this.supportsStoredProcMetadata = true;
            this.supportsXA = true;
            this.supportsExtendedTypSQLDA = true;
        } else {
            this.serverType = 9;
            this.useBetaXAImplementation = true;
            this.enableFullSizeLobs = true;
            this.enableDescribeParam = true;
            this.enableRealStoredProcPrepare = true;
            this.enableRealBigint = true;
            this.supportsCancel = true;
            this.supportsDRDABatchEmulation = true;
            this.clearsAutoGenRegisterOnCommit = false;
            this.supportsStoredProcMetadata = true;
            this.supportsXA = true;
            this.bindsPackagesAsSQLAMv6 = true;
            this.supportsExtendedTypSQLDA = true;
        }
        this.isServerBigEndianOS = this.ServerTypDefname.equalsIgnoreCase("QTDSQL370") ? true : (this.ServerTypDefname.equalsIgnoreCase("QTDSQL400") ? true : (this.ServerTypDefname.equalsIgnoreCase("QTDSQLX86") ? false : (this.ServerTypDefname.equalsIgnoreCase("QTDSQLASC") ? true : (this.ServerTypDefname.equalsIgnoreCase("QTDSQLVAX") ? false : false))));
    }

    public Socket getSocket() {
        return this.socket;
    }

    public void close() {
        try {
            this.socket.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

