/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.jdbc.base;

import com.metamatrix.jdbc.base.BaseClassUtility;
import com.metamatrix.jdbc.base.BaseConnection;
import com.metamatrix.jdbc.base.BasePropertiesFile;
import com.metamatrix.util.UtilException;
import com.metamatrix.util.UtilJDKVersionChecker;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.sql.SQLException;
import java.util.Date;
import java.util.Properties;

public class BaseLicFileWrapper {
    private static String footprint = "$Revision:   1.9.1.3  $";
    long multiplier = 270815413524L;
    long largePrime = 2708154135240077L;
    int detectedCPUs = 0;
    long cpuCountLic = 0L;
    long oneDay = 86400000L;
    long oneHour = 3600000L;
    public String licFileLoc = null;
    public String datFileLoc = null;
    Date currentDate = null;
    BaseConnection connection = null;
    String driverName = null;
    Date endWhineDate = null;
    protected Properties propertiesFileLic = null;
    protected Properties propertiesFileDat = null;

    public BaseLicFileWrapper(BaseConnection baseConnection) throws SQLException {
        URL uRL = null;
        try {
            uRL = (URL)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() {
                    URL uRL = this.getClass().getResource("base.properties");
                    return uRL;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw baseConnection.exceptions.getException(privilegedActionException.getException());
        }
        if (uRL == null) {
            throw baseConnection.exceptions.getException((Exception)((Object)new UtilException(1028, "base.properties")), "08000");
        }
        if (uRL.getPath().indexOf("!") != -1) {
            if (this.getOSName().indexOf("windows") != -1) {
                this.licFileLoc = uRL.getPath().substring(6, uRL.getPath().lastIndexOf("base.jar!")) + "ddjdbc.lic";
                this.datFileLoc = uRL.getPath().substring(6, uRL.getPath().lastIndexOf("base.jar!")) + "ddjdbc.dat";
            } else {
                this.licFileLoc = uRL.getPath().substring(5, uRL.getPath().lastIndexOf("base.jar!")) + "ddjdbc.lic";
                this.datFileLoc = uRL.getPath().substring(5, uRL.getPath().lastIndexOf("base.jar!")) + "ddjdbc.dat";
            }
        } else if (this.getOSName().indexOf("windows") != -1) {
            this.licFileLoc = uRL.getPath().substring(1, uRL.getPath().lastIndexOf("/") + 1) + "ddjdbc.lic";
            this.datFileLoc = uRL.getPath().substring(1, uRL.getPath().lastIndexOf("/") + 1) + "ddjdbc.dat";
        } else {
            this.licFileLoc = uRL.getPath().substring(0, uRL.getPath().lastIndexOf("/") + 1) + "ddjdbc.lic";
            this.datFileLoc = uRL.getPath().substring(0, uRL.getPath().lastIndexOf("/") + 1) + "ddjdbc.dat";
        }
        this.currentDate = new Date();
        this.connection = baseConnection;
        this.propertiesFileLic = new Properties();
        this.propertiesFileDat = new Properties();
    }

    private String getOSName() throws SQLException {
        String string = "";
        try {
            string = (String)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() {
                    return System.getProperty("os.name").toLowerCase();
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw this.connection.exceptions.getException(privilegedActionException.getException());
        }
        return string;
    }

    public Properties getLicAsProperties() throws SQLException {
        try {
            this.propertiesFileLic = (Properties)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() {
                    try {
                        BaseLicFileWrapper.this.propertiesFileLic.load(new FileInputStream(BaseLicFileWrapper.this.licFileLoc));
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    return BaseLicFileWrapper.this.propertiesFileLic;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw this.connection.exceptions.getException(privilegedActionException.getException());
        }
        return this.propertiesFileLic;
    }

    public Properties getDatAsProperties() throws SQLException {
        try {
            this.propertiesFileDat = (Properties)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() {
                    try {
                        BaseLicFileWrapper.this.propertiesFileDat.load(new FileInputStream(BaseLicFileWrapper.this.datFileLoc));
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    return BaseLicFileWrapper.this.propertiesFileDat;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw this.connection.exceptions.getException(privilegedActionException.getException());
        }
        return this.propertiesFileDat;
    }

    public void storeDatPropertiesFile() throws SQLException {
        try {
            this.propertiesFileDat = (Properties)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() {
                    try {
                        BaseLicFileWrapper.this.propertiesFileDat.store(new FileOutputStream(BaseLicFileWrapper.this.datFileLoc), null);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    return BaseLicFileWrapper.this.propertiesFileDat;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw this.connection.exceptions.getException(privilegedActionException.getException());
        }
    }

    public String getLicLocation() {
        return this.licFileLoc;
    }

    public String getDatLocation() {
        return this.datFileLoc;
    }

    public boolean createLicFile(String string) {
        File file = new File(string);
        try {
            boolean bl = file.createNewFile();
            return bl;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public void checkCPUCount() throws SQLException {
        Object object;
        float f = UtilJDKVersionChecker.getJVMVersion();
        if (f >= 1.4f) {
            object = Runtime.getRuntime();
            this.detectedCPUs = ((Runtime)object).availableProcessors();
        } else {
            this.detectedCPUs = 1;
        }
        this.driverName = BaseClassUtility.getRootName(this.connection).toLowerCase();
        this.propertiesFileLic = this.getLicAsProperties();
        object = this.propertiesFileLic.getProperty(this.driverName);
        if (this.propertiesFileLic == null || object == null) {
            String[] stringArray;
            try {
                stringArray = new BasePropertiesFile();
                object = stringArray.getProperty("ddjdbc.lic", this.driverName);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (object == null) {
                if (!this.createLicFile(this.licFileLoc) && !new File(this.licFileLoc).exists()) {
                    stringArray = new String[]{this.getLicLocation()};
                    this.connection.warnings.add(6116, stringArray);
                    System.out.println(this.connection.warnings.getLast().getMessage());
                    System.err.println(this.connection.warnings.getLast().getMessage());
                    return;
                }
                this.propertiesFileLic = this.getLicAsProperties();
            }
        }
        this.cpuCountLic = 0L;
        long l = 0L;
        if (object != null) {
            l = new Long((String)object);
            this.cpuCountLic = l % this.largePrime / this.multiplier;
            long l2 = l % this.largePrime % this.multiplier;
            if (l2 != 0L) {
                this.cpuCountLic = 0L;
            }
        } else {
            this.cpuCountLic = 0L;
        }
        if ((long)this.detectedCPUs > this.cpuCountLic) {
            this.propertiesFileDat = this.getDatAsProperties();
            if (this.propertiesFileDat == null) {
                if (!this.createLicFile(this.datFileLoc)) {
                    String[] stringArray = new String[]{this.getDatLocation()};
                    this.connection.warnings.add(6116, stringArray);
                    System.out.println(this.connection.warnings.getLast().getMessage());
                    System.err.println(this.connection.warnings.getLast().getMessage());
                    return;
                }
                this.propertiesFileDat = this.getLicAsProperties();
            }
            String string = this.driverName.toLowerCase() + ".wdbgn";
            String string2 = this.driverName.toLowerCase() + ".dlw";
            String string3 = this.driverName.toLowerCase() + ".wdur";
            String string4 = this.propertiesFileDat.getProperty(string);
            String string5 = this.propertiesFileDat.getProperty(string2);
            String string6 = this.propertiesFileDat.getProperty(string3);
            long l3 = this.oneDay * 15L;
            if (string6 != null) {
                l3 = Long.parseLong(string6);
            }
            String string7 = String.valueOf(l3 / 1000L / 60L / 60L / 24L);
            if (string4 != null && string5 != null) {
                this.endWhineDate = new Date(Long.parseLong(string4) + l3);
                if (this.currentDate.after(this.endWhineDate)) {
                    String[] stringArray = new String[]{String.valueOf(this.cpuCountLic), String.valueOf(this.detectedCPUs), string7};
                    throw this.connection.exceptions.getException(6114, stringArray);
                }
                Date date = new Date(this.endWhineDate.getTime() - this.oneDay * 5L);
                if ((this.currentDate.after(date) || this.cpuCountLic == 0L) && this.currentDate.after(new Date(Long.parseLong(string5) + this.oneHour))) {
                    this.whine();
                } else if (this.currentDate.after(new Date(Long.parseLong(string5) + this.oneDay))) {
                    this.whine();
                }
            } else {
                this.propertiesFileDat.setProperty(this.driverName + ".wdbgn", String.valueOf(this.currentDate.getTime()));
                this.endWhineDate = new Date(this.currentDate.getTime() + l3);
                this.whine();
            }
        }
    }

    private void whine() throws SQLException {
        this.propertiesFileDat.setProperty(this.driverName + ".dlw", String.valueOf(this.currentDate.getTime()));
        this.storeDatPropertiesFile();
        long l = this.endWhineDate.getTime() - this.currentDate.getTime();
        String string = String.valueOf(l / 1000L / 60L / 60L / 24L);
        String[] stringArray = new String[]{String.valueOf(this.cpuCountLic), String.valueOf(this.detectedCPUs), string};
        this.connection.warnings.add(6115, stringArray);
        System.out.println(this.connection.warnings.getLast().getMessage());
        System.err.println(this.connection.warnings.getLast().getMessage());
    }
}

