/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.jdbc.base;

import com.metamatrix.jdbc.base.BaseData;
import com.metamatrix.util.UtilException;
import com.metamatrix.util.UtilTransliterator;

public class BaseColumn {
    private static String footprint = "$Revision:   3.4.6.1  $";
    public String catalogName;
    public int displaySize;
    public String label;
    public String name;
    public int type;
    public String typeName;
    public int precision;
    public int scale;
    public String schemaName;
    public String tableName;
    public boolean isAutoIncrement;
    public boolean isAutoIncrementDeterminedPostDescribe = false;
    public boolean isCaseSensitive;
    public boolean isCurrency;
    public boolean isDefinitelyWritable;
    public int isNullable;
    public boolean isReadOnly;
    public boolean isWritable;
    public int isSearchable;
    public static final int UNSEARCHABLE = 1;
    public static final int LIKE_ONLY = 2;
    public static final int EXCEPT_LIKE = 3;
    public static final int SEARCHABLE = 4;
    public boolean isHidden;
    public boolean isSigned;
    public boolean isKey;
    public int baseDataType;
    public UtilTransliterator transliterator;
    public String transliteratorCharSet;

    public BaseColumn(int n) {
        this.initializeFields();
        this.setType(n);
    }

    public BaseColumn() {
        this.initializeFields();
    }

    public void initializeFields() {
        this.catalogName = "";
        this.label = null;
        this.name = null;
        this.typeName = "";
        this.schemaName = "";
        this.tableName = "";
        this.isAutoIncrement = false;
        this.isCaseSensitive = false;
        this.isCurrency = false;
        this.isDefinitelyWritable = false;
        this.isWritable = true;
        this.isReadOnly = false;
        this.isNullable = 2;
        this.isSearchable = 4;
        this.isHidden = false;
        this.displaySize = 0;
        this.precision = 0;
        this.scale = 0;
        this.isSigned = true;
        this.isKey = false;
    }

    public void setType(int n) {
        this.type = n;
        int[] nArray = BaseData.getInfoForSQLType(this.type);
        if (nArray[0] != -1) {
            this.displaySize = nArray[0];
        }
        if (nArray[1] != -1) {
            this.precision = nArray[1];
        }
        if (nArray[2] != -1) {
            this.scale = nArray[2];
        }
        if (nArray[3] != -1) {
            this.baseDataType = nArray[3];
        }
    }

    public UtilTransliterator getTransliterator() {
        UtilTransliterator utilTransliterator = null;
        if (this.transliterator != null) {
            utilTransliterator = this.transliterator;
        } else if (this.transliteratorCharSet != null) {
            try {
                utilTransliterator = UtilTransliterator.GetNewTransliterator((String)this.transliteratorCharSet);
            }
            catch (UtilException utilException) {
                // empty catch block
            }
        }
        return utilTransliterator;
    }
}

