/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.sequelink.security;

import com.metamatrix.sequelink.security.JSafeRSAPrivateKey;
import com.metamatrix.sequelink.security.JSafeRSAPublicKey;
import com.metamatrix.sequelink.security.Message;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactorySpi;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.RSAPrivateKeySpec;
import java.security.spec.RSAPublicKeySpec;
import java.security.spec.X509EncodedKeySpec;

public final class JSafeRSAKeyFactory
extends KeyFactorySpi {
    protected PublicKey engineGeneratePublic(KeySpec keySpec) throws InvalidKeySpecException {
        if (keySpec instanceof RSAPublicKeySpec) {
            return new JSafeRSAPublicKey((RSAPublicKeySpec)keySpec);
        }
        if (keySpec instanceof X509EncodedKeySpec) {
            return new JSafeRSAPublicKey((X509EncodedKeySpec)keySpec);
        }
        throw new InvalidKeySpecException(Message.Gen.getException(7657));
    }

    protected PrivateKey engineGeneratePrivate(KeySpec keySpec) throws InvalidKeySpecException {
        if (keySpec instanceof RSAPrivateKeySpec) {
            return new JSafeRSAPrivateKey((RSAPrivateKeySpec)keySpec);
        }
        if (keySpec instanceof X509EncodedKeySpec) {
            return new JSafeRSAPrivateKey((X509EncodedKeySpec)keySpec);
        }
        if (keySpec instanceof PKCS8EncodedKeySpec) {
            return new JSafeRSAPrivateKey((PKCS8EncodedKeySpec)keySpec);
        }
        throw new InvalidKeySpecException(Message.Gen.getException(7658));
    }

    protected KeySpec engineGetKeySpec(Key key, Class clazz) throws InvalidKeySpecException {
        return null;
    }

    protected Key engineTranslateKey(Key key) throws InvalidKeyException {
        return null;
    }
}

