/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.sequelink.ctxt.conn;

import com.metamatrix.sequelink.SequeLinkProperties;
import com.metamatrix.sequelink.admin.AdminSubVerb;
import com.metamatrix.sequelink.auth.MGSSException;
import com.metamatrix.sequelink.auth.MGSSFactory;
import com.metamatrix.sequelink.auth.MGSSHandle;
import com.metamatrix.sequelink.auth.MGSSToken;
import com.metamatrix.sequelink.compat.Jdk;
import com.metamatrix.sequelink.ctxt.Context;
import com.metamatrix.sequelink.ctxt.CtxtAttributes;
import com.metamatrix.sequelink.ctxt.PidList;
import com.metamatrix.sequelink.ctxt.conn.SessionContext;
import com.metamatrix.sequelink.describe.VariableDescriptor;
import com.metamatrix.sequelink.ssp.AttribList;
import com.metamatrix.sequelink.ssp.BinarySetSetting;
import com.metamatrix.sequelink.ssp.CodecAdmin;
import com.metamatrix.sequelink.ssp.CodecAuthenticate;
import com.metamatrix.sequelink.ssp.CodecChainedPacket;
import com.metamatrix.sequelink.ssp.DiagnosticList;
import com.metamatrix.sequelink.ssp.GetSetting;
import com.metamatrix.sequelink.ssp.IntegerGetSetting;
import com.metamatrix.sequelink.ssp.IntegerSetSetting;
import com.metamatrix.sequelink.ssp.Message;
import com.metamatrix.sequelink.ssp.SetSetting;
import com.metamatrix.sequelink.ssp.SlXid;
import com.metamatrix.sequelink.ssp.SspFactory;
import com.metamatrix.sequelink.ssp.SspLob;
import com.metamatrix.sequelink.ssp.StringGetSetting;
import com.metamatrix.sequelink.ssp.StringSetSetting;
import com.metamatrix.sequelink.util.JDBCLogger;
import com.metamatrix.sequelink.util.SlXaException;
import com.metamatrix.sequelink.util.UnSyncVector;
import java.io.ByteArrayInputStream;
import java.io.InputStreamReader;
import java.sql.BatchUpdateException;
import java.sql.SQLException;
import java.util.Properties;

public class ConnectionContext
extends Context {
    CtxtAttributes ctxtAttr;
    JDBCLogger logger;
    SessionContext sesCtxt;
    PidList pidCache;
    private Object cancelMutex;
    private Boolean _allowBlockFetch;
    private Boolean _allowPreFetch;
    private Integer _SLKStaticCursorLongColBuffLen;
    private Boolean _ORANumber0IsNumeric;
    private Boolean _MSSMapLongToDecimal;
    private Boolean _WABadDescribeParam54;

    public ConnectionContext(CtxtAttributes ctxtAttributes, JDBCLogger jDBCLogger) {
        this.ctxtAttr = ctxtAttributes;
        this.logger = jDBCLogger;
        this.type = 1;
    }

    public void log(String string) {
        this.logger.println(string);
    }

    public Object getNetMutex() {
        return this;
    }

    public boolean supportsCancel() {
        return this.cancelMutex != null;
    }

    public Object getCancelMutex() {
        return this.cancelMutex;
    }

    public void connect(boolean bl, DiagnosticList diagnosticList) throws SQLException {
        try {
            this.doConnect(diagnosticList);
            this.doInitialProvides(diagnosticList);
            AttribList attribList = this.ctxtAttr.getSDSAttributes();
            if (this.ssp.getServerVersion() >= 0x5040000) {
                if (this.ssp.getServerVersion() < 0x5050000) {
                    this.ctxtAttr.getSDSAttributes54Only(attribList);
                }
                this.ctxtAttr.getSDSAttributes54(attribList);
            }
            attribList.addInteger(1, 77);
            AdminSubVerb adminSubVerb = new AdminSubVerb(106, 0, null, attribList);
            UnSyncVector unSyncVector = new UnSyncVector();
            unSyncVector.addElement(adminSubVerb);
            CodecAdmin codecAdmin = this.ssp.getCodecAdmin(this, unSyncVector);
            this.chain.add(codecAdmin);
            this.chain.send(diagnosticList);
            attribList = adminSubVerb.getAttributes();
            this.ctxtAttr.setSDSAttributes(attribList);
            if (this.ssp.getServerVersion() >= 0x5040000) {
                if (this.ssp.getServerVersion() < 0x5050000) {
                    this.ctxtAttr.setSDSAttributes54Only(attribList);
                }
                this.ctxtAttr.setSDSAttributes54(attribList);
            }
            this.ssp.setTransliterationWorkaroundClient(this.getTransliterationWorkaroundClient());
            this.ssp.setTransliterationWorkaroundServer(this.getTransliterationWorkaroundServer());
            this.ssp.applyTransliterationWorkarounds();
            this.sesCtxt = new SessionContext(this, bl, this.ctxtAttr, attribList, diagnosticList);
            this.pidCache = this.sesCtxt.pidCache;
        }
        catch (SQLException sQLException) {
            try {
                this.deactivate(diagnosticList);
            }
            catch (SQLException sQLException2) {
                // empty catch block
            }
            throw sQLException;
        }
    }

    public void deactivate(DiagnosticList diagnosticList) throws SQLException {
        this.isActive = false;
        try {
            if (this.sesCtxt != null) {
                this.doLogoff(diagnosticList);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            if (this.ssp != null) {
                this.ssp.close();
            }
        }
        catch (SQLException sQLException) {
            this.sesCtxt = null;
            this.ssp = null;
            throw sQLException;
        }
    }

    public void testAlive(DiagnosticList diagnosticList) throws SQLException {
        StringGetSetting stringGetSetting = new StringGetSetting(11129);
        GetSetting[] getSettingArray = new GetSetting[]{stringGetSetting};
        this.sesCtxt.getInfo(getSettingArray, diagnosticList);
    }

    public CtxtAttributes getCtxtAttributes() {
        return this.ctxtAttr;
    }

    public PidList getPidList() {
        return this.pidCache;
    }

    public int getSesRef() {
        return this.sesCtxt.getReference();
    }

    public void commit(DiagnosticList diagnosticList) throws SQLException {
        this.sesCtxt.commit(true, diagnosticList);
    }

    public void rollback(DiagnosticList diagnosticList) throws SQLException {
        this.sesCtxt.rollback(diagnosticList);
    }

    public void setAutoCommit(boolean bl, DiagnosticList diagnosticList) throws SQLException {
        Integer n2 = new Integer(11103);
        this.pidCache.removePid(n2);
        int n3 = bl ? 1 : 0;
        IntegerSetSetting integerSetSetting = new IntegerSetSetting(11103, n3);
        SetSetting[] setSettingArray = new SetSetting[]{integerSetSetting};
        this.sesCtxt.setInfo(setSettingArray, diagnosticList);
    }

    public boolean getAutoCommit(DiagnosticList diagnosticList) throws SQLException {
        return this.pidCache.getPidInt(11103, diagnosticList) == 1;
    }

    public boolean supportsCatalogs(DiagnosticList diagnosticList) throws SQLException {
        int n2 = this.pidCache.getPidInt(11148, diagnosticList);
        return n2 != 0;
    }

    public void setCatalog(String string, DiagnosticList diagnosticList) throws SQLException {
        if (!this.supportsCatalogs(diagnosticList)) {
            return;
        }
        Integer n2 = new Integer(11128);
        this.pidCache.removePid(n2);
        StringSetSetting stringSetSetting = new StringSetSetting(11128, string);
        SetSetting[] setSettingArray = new SetSetting[]{stringSetSetting};
        this.sesCtxt.setInfo(setSettingArray, diagnosticList);
    }

    public String getCatalog(DiagnosticList diagnosticList) throws SQLException {
        if (!this.supportsCatalogs(diagnosticList)) {
            return null;
        }
        Integer n2 = new Integer(11128);
        this.pidCache.removePid(n2);
        return this.pidCache.getPidString(11128, diagnosticList);
    }

    public void setTransactionIsolation(int n2, DiagnosticList diagnosticList) throws SQLException {
        this.sesCtxt.commit(false, diagnosticList);
        Integer n3 = new Integer(11167);
        this.pidCache.removePid(n3);
        IntegerSetSetting integerSetSetting = new IntegerSetSetting(11167, n2);
        SetSetting[] setSettingArray = new SetSetting[]{integerSetSetting};
        this.sesCtxt.setInfo(setSettingArray, diagnosticList);
    }

    public int getTransactionIsolation(DiagnosticList diagnosticList) throws SQLException {
        return this.pidCache.getPidInt(11167, diagnosticList);
    }

    public boolean supportsTransactionIsolation(int n2, DiagnosticList diagnosticList) throws SQLException {
        int n3 = this.pidCache.getPidInt(11168, diagnosticList);
        return (n3 & n2) != 0;
    }

    public int supportsLobs(DiagnosticList diagnosticList) throws SQLException {
        if (this.ssp.getServerVersion() < 0x5030000) {
            return 0;
        }
        return this.pidCache.getPidInt(11404, diagnosticList);
    }

    public VariableDescriptor[] getCursorDescribe() {
        return this.sesCtxt.cursorDescriptors;
    }

    public VariableDescriptor[] getParamDescribe() {
        return this.sesCtxt.paramDescriptors;
    }

    public boolean supportsDescribeParam() {
        return this.sesCtxt.describeParam != 0;
    }

    public boolean allowBlockFetch() {
        if (this._allowBlockFetch == null) {
            Integer n2 = this.ctxtAttr.getBlockFetchForUpdate();
            this._allowBlockFetch = n2 == null ? Boolean.TRUE : (n2 == 0 ? Boolean.TRUE : Boolean.FALSE);
        }
        return this._allowBlockFetch;
    }

    public boolean allowPreFetch() {
        if (this._allowPreFetch == null) {
            Integer n2 = this.ctxtAttr.getAllowPreFetch();
            this._allowPreFetch = n2 == null ? Boolean.FALSE : (n2 == 0 ? Boolean.FALSE : Boolean.TRUE);
        }
        return this._allowPreFetch;
    }

    public int getSLKStaticCursorLongColBuffLen() {
        if (this._SLKStaticCursorLongColBuffLen == null) {
            this._SLKStaticCursorLongColBuffLen = this.ctxtAttr.getSLKStaticCursorLongColBuffLen();
            this._SLKStaticCursorLongColBuffLen = this._SLKStaticCursorLongColBuffLen == null ? new Integer(4096) : new Integer(this._SLKStaticCursorLongColBuffLen * 1024);
        }
        return this._SLKStaticCursorLongColBuffLen;
    }

    public boolean ORANumber0IsNumeric() {
        if (this._ORANumber0IsNumeric == null) {
            Integer n2 = this.ctxtAttr.getORANumber0IsNumeric();
            this._ORANumber0IsNumeric = n2 == null ? Boolean.FALSE : (n2 == 0 ? Boolean.FALSE : Boolean.TRUE);
        }
        return this._ORANumber0IsNumeric;
    }

    public boolean MSSMapLongToDecimal() {
        if (this._MSSMapLongToDecimal == null) {
            Integer n2 = this.ctxtAttr.getMSSMapLongToDecimal();
            this._MSSMapLongToDecimal = n2 == null ? Boolean.FALSE : (n2 == 0 ? Boolean.FALSE : Boolean.TRUE);
        }
        return this._MSSMapLongToDecimal;
    }

    public boolean WABadDescribeParam54() {
        if (this._WABadDescribeParam54 == null) {
            Integer n2 = this.ctxtAttr.getWABadDescribeParam54();
            this._WABadDescribeParam54 = n2 == null ? Boolean.FALSE : (n2 == 0 ? Boolean.FALSE : Boolean.TRUE);
        }
        return this._WABadDescribeParam54;
    }

    private int getTransliterationWorkaroundServer() {
        Integer n2 = this.ctxtAttr.getTransliterationWorkaroundServer();
        if (n2 == null) {
            return 0;
        }
        return n2;
    }

    private int getTransliterationWorkaroundClient() {
        String string = new InputStreamReader(new ByteArrayInputStream(new byte[0])).getEncoding();
        if ("MS932".equals(string)) {
            return 1;
        }
        if ("SJIS".equals(string)) {
            return 1;
        }
        if ("EUC_JP".equals(string)) {
            return 2;
        }
        return 0;
    }

    public boolean deferDescribeParam() {
        return this.sesCtxt.describeParam != 1;
    }

    public int[] executeBatch(UnSyncVector unSyncVector, DiagnosticList diagnosticList) throws BatchUpdateException {
        return this.sesCtxt.executeBatch(unSyncVector, diagnosticList);
    }

    public String getKeysetName(DiagnosticList diagnosticList) throws SQLException {
        return this.pidCache.getPidString(11027, diagnosticList);
    }

    public int getRowIdOptions(DiagnosticList diagnosticList) throws SQLException {
        return this.pidCache.getPidInt(11029, diagnosticList);
    }

    public boolean supportsQueryTimeout(DiagnosticList diagnosticList) throws SQLException {
        return 1 == this.pidCache.getPidInt(11026, diagnosticList);
    }

    public String getDefaultParameterEncoding(DiagnosticList diagnosticList) throws SQLException {
        return this.pidCache.getPidString(11277, diagnosticList);
    }

    public void setSavepoint(String string, DiagnosticList diagnosticList) throws SQLException {
        this.sesCtxt.setSavepoint(string, diagnosticList);
    }

    public void releaseSavepoint(String string, DiagnosticList diagnosticList) throws SQLException {
        this.sesCtxt.releaseSavepoint(string, diagnosticList);
    }

    public void rollbackToSavepoint(String string, DiagnosticList diagnosticList) throws SQLException {
        this.sesCtxt.rollbackToSavepoint(string, diagnosticList);
    }

    public void getLobLength(SspLob sspLob, DiagnosticList diagnosticList) throws SQLException {
        this.sesCtxt.getLobLength(sspLob, diagnosticList);
    }

    public int getLobData(SspLob sspLob, byte[] byArray, int n2, long l2, int n3, DiagnosticList diagnosticList) throws SQLException {
        return this.sesCtxt.getLobData(sspLob, byArray, n2, l2, n3, diagnosticList);
    }

    public int setLobData(SspLob sspLob, byte[] byArray, int n2, long l2, int n3, DiagnosticList diagnosticList) throws SQLException {
        return this.sesCtxt.setLobData(sspLob, byArray, n2, l2, n3, diagnosticList);
    }

    public void lobTruncate(SspLob sspLob, long l2, DiagnosticList diagnosticList) throws SQLException {
        this.sesCtxt.lobTruncate(sspLob, l2, diagnosticList);
    }

    public long getLobPosition(SspLob sspLob, byte[] byArray, long l2, DiagnosticList diagnosticList) throws SQLException {
        return this.sesCtxt.getLobPosition(sspLob, byArray, l2, diagnosticList);
    }

    public void doUnlock(DiagnosticList diagnosticList) throws SQLException {
        IntegerSetSetting integerSetSetting = new IntegerSetSetting(2021, 0);
        SetSetting[] setSettingArray = new SetSetting[]{integerSetSetting};
        this.setInfo(setSettingArray, diagnosticList);
    }

    public void setOemId(String string, DiagnosticList diagnosticList) throws SQLException {
        String string2 = SequeLinkProperties.getInstance().getProperty("OEMID");
        if (string2 != null) {
            byte[] byArray = this.shash("JavaLink" + string, false);
            StringBuffer stringBuffer = new StringBuffer();
            for (int i2 = 0; i2 < byArray.length; ++i2) {
                stringBuffer.append(byArray[i2] & 0xFF);
            }
            String string3 = stringBuffer.toString();
            if (string2.equals(string3)) {
                this.doUnlock(diagnosticList);
            } else {
                throw Message.Gen.getSqlException(7448);
            }
        }
    }

    public void setApplicationId(String string, DiagnosticList diagnosticList) throws SQLException {
        byte[] byArray = this.shash(string, true);
        BinarySetSetting binarySetSetting = new BinarySetSetting(2022, byArray);
        SetSetting[] setSettingArray = new SetSetting[]{binarySetSetting};
        this.setInfo(setSettingArray, diagnosticList);
    }

    private byte[] shash(String string, boolean bl) throws SQLException {
        byte[] byArray;
        if (string == null || string.length() == 0) {
            throw Message.Gen.getSqlException(7393, "data");
        }
        if (bl) {
            byArray = this.ssp.transliterate(string);
        } else {
            int n2 = string.length();
            byArray = new byte[n2];
            for (int i2 = 0; i2 < n2; ++i2) {
                byArray[i2] = (byte)(string.charAt(i2) & 0xFF);
            }
        }
        return Jdk.getInstance().shash(byArray);
    }

    public int getServerVersion() {
        return this.sesCtxt.getServerVersion();
    }

    public int getXaTransactionTimeout(DiagnosticList diagnosticList) throws SlXaException {
        try {
            IntegerGetSetting integerGetSetting = new IntegerGetSetting(2035);
            GetSetting[] getSettingArray = new GetSetting[]{integerGetSetting};
            this.getInfo(getSettingArray, diagnosticList);
            int n2 = (Integer)integerGetSetting.getInfo();
            if (n2 == -1) {
                n2 = 0;
            }
            return n2;
        }
        catch (SQLException sQLException) {
            throw new SlXaException();
        }
    }

    public void xa_open(DiagnosticList diagnosticList) throws SQLException {
        this.sesCtxt.xa_open(diagnosticList);
    }

    public void xa_close(DiagnosticList diagnosticList) throws SQLException {
        this.sesCtxt.xa_close(diagnosticList);
    }

    public void xa_start(SlXid slXid, int n2) throws SlXaException {
        this.sesCtxt.xa_start(slXid, n2);
    }

    public void xa_end(SlXid slXid, int n2) throws SlXaException {
        this.sesCtxt.xa_end(slXid, n2);
    }

    public int xa_prepare(SlXid slXid) throws SlXaException {
        return this.sesCtxt.xa_prepare(slXid);
    }

    public void xa_commit(SlXid slXid, boolean bl) throws SlXaException {
        this.sesCtxt.xa_commit(slXid, bl);
    }

    public void xa_rollback(SlXid slXid) throws SlXaException {
        this.sesCtxt.xa_rollback(slXid);
    }

    public void xa_forget(SlXid slXid) throws SlXaException {
        this.sesCtxt.xa_forget(slXid);
    }

    public SlXid[] xa_recover(int n2) throws SlXaException {
        return this.sesCtxt.xa_recover(n2);
    }

    private void doConnect(DiagnosticList diagnosticList) throws SQLException {
        this.ssp = SspFactory.GetSsp(this.ctxtAttr);
        this.isActive = true;
        if (this.ssp.supportsCancel()) {
            this.cancelMutex = new Object();
        }
        this.chain = this.ssp.getChain();
        AttribList attribList = new AttribList();
        attribList.addInteger(1, 76);
        AdminSubVerb adminSubVerb = new AdminSubVerb(106, 0, null, attribList);
        UnSyncVector unSyncVector = new UnSyncVector();
        unSyncVector.addElement(adminSubVerb);
        CodecAdmin codecAdmin = this.ssp.getCodecAdmin(this, unSyncVector);
        this.chain.add(codecAdmin);
        this.chain.send(diagnosticList);
        attribList = adminSubVerb.getAttributes();
        String[] stringArray = attribList.getStringValues(76);
        this.authenticate(diagnosticList, stringArray);
    }

    private void authenticate(DiagnosticList diagnosticList, String[] stringArray) throws SQLException {
        SequeLinkProperties sequeLinkProperties = null;
        sequeLinkProperties = SequeLinkProperties.getInstance();
        try {
            MGSSFactory mGSSFactory = new MGSSFactory(sequeLinkProperties);
            MGSSHandle mGSSHandle = mGSSFactory.create(stringArray);
            if (mGSSHandle == null) {
                throw Message.Gen.getSqlException(7434);
            }
            Properties properties = new Properties();
            String string = this.ctxtAttr.getUser();
            if (string != null) {
                properties.put("UID", string);
            }
            if ((string = this.ctxtAttr.getPassword()) != null) {
                properties.put("PWD", string);
            }
            if ((string = this.ctxtAttr.getHUser()) != null) {
                properties.put("HUID", string);
            }
            if ((string = this.ctxtAttr.getHPassword()) != null) {
                properties.put("HPWD", string);
            }
            if ((string = this.ctxtAttr.getNewPassword()) != null) {
                properties.put("NEWPWD", string);
            }
            mGSSHandle.setAttribs(properties);
            MGSSToken mGSSToken = null;
            while (!mGSSHandle.isEstablished()) {
                if ((mGSSToken = mGSSHandle.establishClientContext(null, null, mGSSToken)) == null) continue;
                CodecAuthenticate codecAuthenticate = this.ssp.getCodecAuthenticate(this, mGSSHandle, mGSSToken, 0);
                this.chain.add(codecAuthenticate);
                this.chain.send(diagnosticList);
                mGSSToken = codecAuthenticate.getInputToken();
            }
        }
        catch (MGSSException mGSSException) {
            SQLException sQLException = Message.Gen.getSqlException(7853, mGSSException.getMessage());
            throw sQLException;
        }
    }

    private void doInitialProvides(DiagnosticList diagnosticList) throws SQLException {
        CodecChainedPacket codecChainedPacket;
        Object object;
        String string = this.ctxtAttr.getServerDataSource();
        if (string != null) {
            object = new SetSetting[]{new StringSetSetting(2016, string)};
            codecChainedPacket = this.ssp.getCodecSetSettings((SetSetting[])object, this);
            this.chain.add(codecChainedPacket);
        }
        if (this.ssp.getServerVersion() >= 0x5030000) {
            object = this.ctxtAttr.getApplicationName();
            if (object == null) {
                object = "SequeLink JDBC Application";
            }
            SetSetting[] setSettingArray = new SetSetting[]{new StringSetSetting(2034, (String)object)};
            codecChainedPacket = this.ssp.getCodecSetSettings(setSettingArray, this);
            this.chain.add(codecChainedPacket);
        }
    }

    private void doLogoff(DiagnosticList diagnosticList) throws SQLException {
        this.sesCtxt.deactivate(diagnosticList);
    }
}

