/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.jdbc.slbase;

import com.metamatrix.jdbc.slbase.BaseColumn;
import com.metamatrix.jdbc.slbase.BaseColumns;
import com.metamatrix.jdbc.slbase.BaseConnection;
import com.metamatrix.jdbc.slbase.BaseData;
import com.metamatrix.jdbc.slbase.BaseExceptions;
import com.metamatrix.jdbc.slbase.BaseImplConnection;
import com.metamatrix.jdbc.slbase.BasePreparedStatement;
import com.metamatrix.jdbc.slbase.BaseResultSet;
import com.metamatrix.jdbc.slbase.BaseSQL;
import com.metamatrix.jdbc.slbase.BaseSQLColumnSpecification;
import com.metamatrix.jdbc.slbase.BaseSQLTableReference;
import com.metamatrix.jdbc.slbase.BaseStatement;
import com.metamatrix.slutil.UtilVectorUnsynced;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;

public final class BaseResultSetMetaData
implements ResultSetMetaData {
    protected Object associate;
    protected BaseColumns columns;
    BaseExceptions exceptions;
    boolean metaDataDiscovered;

    protected BaseResultSetMetaData(Object object, BaseExceptions baseExceptions) {
        this.associate = object;
        this.exceptions = baseExceptions;
        this.setupColumns();
    }

    private void setupColumns() {
        this.columns = this.associate instanceof BaseResultSet ? ((BaseResultSet)this.associate).columns : ((BasePreparedStatement)this.associate).currentColumns;
    }

    public int getColumnCount() throws SQLException {
        this.validateClosedState();
        return this.columns.count(1);
    }

    public boolean isAutoIncrement(int n2) throws SQLException {
        this.validateClosedState();
        this.validateColumnIndex(n2);
        BaseColumn baseColumn = this.columns.get(n2);
        if (baseColumn.isAutoIncrementDeterminedPostDescribe) {
            BaseImplConnection baseImplConnection = null;
            baseImplConnection = this.associate instanceof BaseResultSet ? ((BaseResultSet)this.associate).connection.implConnection : ((BasePreparedStatement)this.associate).connection.implConnection;
            baseImplConnection.fixupAutoIncrement(baseColumn);
            baseColumn.isAutoIncrementDeterminedPostDescribe = false;
        }
        return baseColumn.isAutoIncrement;
    }

    public boolean isCaseSensitive(int n2) throws SQLException {
        this.validateClosedState();
        this.validateColumnIndex(n2);
        return this.columns.get((int)n2).isCaseSensitive;
    }

    public boolean isSearchable(int n2) throws SQLException {
        this.validateClosedState();
        this.validateColumnIndex(n2);
        return this.columns.get((int)n2).isSearchable != 1;
    }

    public boolean isCurrency(int n2) throws SQLException {
        this.validateClosedState();
        this.validateColumnIndex(n2);
        return this.columns.get((int)n2).isCurrency;
    }

    public int isNullable(int n2) throws SQLException {
        this.validateClosedState();
        this.validateColumnIndex(n2);
        return this.columns.get((int)n2).isNullable;
    }

    public boolean isSigned(int n2) throws SQLException {
        this.validateClosedState();
        this.validateColumnIndex(n2);
        return this.columns.get((int)n2).isSigned;
    }

    public int getColumnDisplaySize(int n2) throws SQLException {
        this.validateClosedState();
        this.validateColumnIndex(n2);
        return this.columns.get((int)n2).displaySize;
    }

    public String getColumnLabel(int n2) throws SQLException {
        this.validateClosedState();
        this.validateColumnIndex(n2);
        return this.columns.get((int)n2).label;
    }

    public String getColumnName(int n2) throws SQLException {
        this.validateClosedState();
        this.validateColumnIndex(n2);
        return this.columns.get((int)n2).name;
    }

    public String getSchemaName(int n2) throws SQLException {
        this.validateClosedState();
        this.validateColumnIndex(n2);
        String string = this.columns.get((int)n2).schemaName;
        if (!(string != null && string.length() != 0 || this.metaDataDiscovered)) {
            this.discoverMetaData();
            string = this.columns.get((int)n2).schemaName;
        }
        return string;
    }

    public int getPrecision(int n2) throws SQLException {
        this.validateClosedState();
        this.validateColumnIndex(n2);
        return this.columns.get((int)n2).precision;
    }

    public int getScale(int n2) throws SQLException {
        this.validateClosedState();
        this.validateColumnIndex(n2);
        return this.columns.get((int)n2).scale;
    }

    public String getTableName(int n2) throws SQLException {
        this.validateClosedState();
        this.validateColumnIndex(n2);
        String string = this.columns.get((int)n2).tableName;
        if (!(string != null && string.length() != 0 || this.metaDataDiscovered)) {
            this.discoverMetaData();
            string = this.columns.get((int)n2).tableName;
        }
        return string;
    }

    public String getCatalogName(int n2) throws SQLException {
        this.validateClosedState();
        this.validateColumnIndex(n2);
        String string = this.columns.get((int)n2).catalogName;
        if (!(string != null && string.length() != 0 || this.metaDataDiscovered)) {
            this.discoverMetaData();
            string = this.columns.get((int)n2).catalogName;
        }
        return string;
    }

    public int getColumnType(int n2) throws SQLException {
        this.validateClosedState();
        this.validateColumnIndex(n2);
        return this.columns.get((int)n2).type;
    }

    public String getColumnTypeName(int n2) throws SQLException {
        this.validateClosedState();
        this.validateColumnIndex(n2);
        return this.columns.get((int)n2).typeName;
    }

    public boolean isReadOnly(int n2) throws SQLException {
        this.validateClosedState();
        this.validateColumnIndex(n2);
        return this.columns.get((int)n2).isReadOnly;
    }

    public boolean isWritable(int n2) throws SQLException {
        this.validateClosedState();
        this.validateColumnIndex(n2);
        return this.columns.get((int)n2).isWritable;
    }

    public boolean isDefinitelyWritable(int n2) throws SQLException {
        this.validateClosedState();
        this.validateColumnIndex(n2);
        return this.columns.get((int)n2).isDefinitelyWritable;
    }

    public String getColumnClassName(int n2) throws SQLException {
        this.validateClosedState();
        this.validateColumnIndex(n2);
        return BaseData.mapJDBCTypeToJavaObjectTypeName(this.columns.get((int)n2).type);
    }

    private void validateClosedState() throws SQLException {
        if (this.associate instanceof BaseResultSet) {
            BaseResultSet baseResultSet = (BaseResultSet)this.associate;
            if (baseResultSet.implResultSet == null || baseResultSet.connection.implConnection == null) {
                throw this.exceptions.getException(6009);
            }
        } else {
            BasePreparedStatement basePreparedStatement = (BasePreparedStatement)this.associate;
            if (basePreparedStatement.implStatement == null || basePreparedStatement.connection.implConnection == null) {
                throw this.exceptions.getException(6009);
            }
        }
    }

    private void validateColumnIndex(int n2) throws SQLException {
        if (!this.columns.isValidColumnOrdinal(n2)) {
            Integer n3 = new Integer(n2);
            String[] stringArray = new String[]{n3.toString()};
            throw this.exceptions.getException(6006, stringArray);
        }
    }

    private void discoverMetaData() {
        this.metaDataDiscovered = true;
        BaseStatement baseStatement = null;
        baseStatement = this.associate instanceof BaseResultSet ? ((BaseResultSet)this.associate).statement : (BaseStatement)this.associate;
        String string = baseStatement.connection.connectProps.get("resultsetMetaDataOptions");
        if ((Integer.parseInt(string) & 1) != 0) {
            this.discoverMetaData(baseStatement);
        }
    }

    private void discoverMetaData(BaseStatement baseStatement) {
        BaseSQL baseSQL = baseStatement.implStatement.sql;
        UtilVectorUnsynced utilVectorUnsynced = baseSQL.getSelectTables();
        BaseSQLColumnSpecification[] baseSQLColumnSpecificationArray = baseSQL.getSelectColumns();
        if (utilVectorUnsynced == null || baseSQLColumnSpecificationArray == null) {
            return;
        }
        int n2 = utilVectorUnsynced.size();
        int n3 = 1;
        for (int i2 = 0; i2 < baseSQLColumnSpecificationArray.length; ++i2) {
            BaseSQLColumnSpecification baseSQLColumnSpecification = baseSQLColumnSpecificationArray[i2];
            if (baseSQLColumnSpecification.isTableColumn()) {
                if (n2 == 1) {
                    this.setMetaData((BaseSQLTableReference)utilVectorUnsynced.elementAt(0), n3++);
                } else {
                    n3 = this.getMetaDataFromTables(baseStatement.connection, utilVectorUnsynced, baseSQLColumnSpecification, true, n3);
                }
            } else {
                n3 = baseSQLColumnSpecification.isQualifiedStar() ? this.getMetaDataFromTables(baseStatement.connection, utilVectorUnsynced, baseSQLColumnSpecification, true, n3) : (baseSQLColumnSpecification.isUnqualifiedStar() ? this.getMetaDataFromTables(baseStatement.connection, utilVectorUnsynced, baseSQLColumnSpecification, false, n3) : ++n3);
            }
            if (n3 != -1) continue;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getMetaDataFromTables(BaseConnection baseConnection, UtilVectorUnsynced utilVectorUnsynced, BaseSQLColumnSpecification baseSQLColumnSpecification, boolean bl, int n2) {
        int n3 = utilVectorUnsynced.size();
        for (int i2 = 0; i2 < n3; ++i2) {
            int n4;
            BaseSQLTableReference baseSQLTableReference = (BaseSQLTableReference)utilVectorUnsynced.elementAt(i2);
            StringBuffer stringBuffer = new StringBuffer(5);
            stringBuffer.append("SELECT ");
            stringBuffer.append(baseSQLColumnSpecification.getFullSpecification());
            stringBuffer.append(" FROM ");
            stringBuffer.append(baseSQLTableReference.getFullReference() + " " + baseSQLTableReference.getCorrelation());
            stringBuffer.append(" WHERE 0 = 1");
            Statement statement = null;
            try {
                statement = baseConnection.createStatement();
                ResultSet resultSet = statement.executeQuery(stringBuffer.toString());
                n4 = resultSet.getMetaData().getColumnCount();
                resultSet.close();
                for (int i3 = 0; i3 < n4; ++i3) {
                    this.setMetaData(baseSQLTableReference, n2++);
                }
                if (!bl) continue;
                break;
            }
            catch (SQLException sQLException) {
                if (i2 != n3 - 1 && bl) continue;
                n4 = -1;
                return n4;
            }
            finally {
                try {
                    statement.close();
                    statement = null;
                }
                catch (SQLException sQLException) {}
            }
        }
        return n2;
    }

    private void setMetaData(BaseSQLTableReference baseSQLTableReference, int n2) {
        BaseColumn baseColumn = this.columns.get(n2);
        String string = baseSQLTableReference.getTable();
        String string2 = baseSQLTableReference.getSchema();
        String string3 = baseSQLTableReference.getCatalog();
        if (string != null && string.length() > 0) {
            baseColumn.tableName = baseSQLTableReference.getTable();
        }
        if (string2 != null && string2.length() > 0) {
            baseColumn.schemaName = baseSQLTableReference.getSchema();
        }
        if (string3 != null && string3.length() > 0) {
            baseColumn.catalogName = baseSQLTableReference.getCatalog();
        }
    }
}

