/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.modeler.internal.core.builder;

import com.metamatrix.modeler.core.ModelerCore;
import com.metamatrix.modeler.core.ModelerCoreException;
import com.metamatrix.modeler.core.TransactionRunnable;
import com.metamatrix.modeler.core.container.Container;
import com.metamatrix.modeler.core.notification.util.IgnorableNotificationSource;
import com.metamatrix.modeler.core.transaction.UnitOfWork;
import com.metamatrix.modeler.core.workspace.ModelResource;
import com.metamatrix.modeler.internal.core.builder.ModelBuildUtil;
import com.metamatrix.modeler.internal.core.index.IndexUtil;
import com.metamatrix.modeler.internal.core.workspace.ModelUtil;
import com.metamatrix.modeler.internal.core.workspace.ModelWorkspaceManager;
import com.metamatrix.modeler.internal.core.workspace.SearchIndexResourceVisitor;
import com.metamatrix.modeler.internal.core.workspace.WorkspaceResourceFinderUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.IncrementalProjectBuilder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;

public class ModelBuilder
extends IncrementalProjectBuilder
implements IgnorableNotificationSource {
    protected void clean(IProgressMonitor monitor) throws CoreException {
        super.clean(monitor);
        IProject proj = this.getProject();
        proj.deleteMarkers("org.eclipse.core.resources.problemmarker", true, 2);
        SearchIndexResourceVisitor visitor = new SearchIndexResourceVisitor();
        ModelWorkspaceManager.getModelWorkspaceManager().notifyClean(proj);
        ModelWorkspaceManager.getModelWorkspaceManager().deleteIndexes((IResource)proj, visitor);
        Iterator iter = visitor.getResources().iterator();
        while (iter.hasNext()) {
            ModelResource resrc = ModelerCore.getModelWorkspace().findModelResource((IResource)iter.next());
            if (resrc == null) continue;
            resrc.setIndexType(0);
        }
    }

    protected IProject[] build(int kind, Map args, IProgressMonitor monitor) throws CoreException {
        IProject project = this.getProject();
        if (project == null || project != null && !project.isAccessible()) {
            return null;
        }
        switch (kind) {
            case 6: {
                project.deleteMarkers("org.eclipse.core.resources.problemmarker", true, 2);
                this.performFullBuild(monitor);
                break;
            }
            case 9: 
            case 10: {
                IResourceDelta delta = this.getDelta(project);
                if (delta == null) {
                    this.performFullBuild(monitor);
                    break;
                }
                this.performIncrementaBuild(monitor, delta);
                break;
            }
        }
        return null;
    }

    private void performFullBuild(final IProgressMonitor monitor) throws CoreException {
        final SearchIndexResourceVisitor visitor = new SearchIndexResourceVisitor();
        this.getProject().accept((IResourceVisitor)visitor);
        TransactionRunnable runnable = new TransactionRunnable(){

            public Object run(UnitOfWork uow) throws ModelerCoreException {
                Container container = ModelBuilder.this.doGetContainer();
                ModelBuildUtil.buildResources((IProgressMonitor)monitor, (Collection)visitor.getResources(), (Container)container, (boolean)false);
                return null;
            }
        };
        List modifiedResources = ModelBuildUtil.getModifiedResources();
        ModelerCore.getModelEditor().executeAsTransaction(runnable, "Full Build", false, false, (Object)this);
        ModelBuildUtil.setModifiedResources((List)modifiedResources);
        this.cleanOrphanedIndexes();
    }

    private void performIncrementaBuild(final IProgressMonitor monitor, IResourceDelta delta) throws CoreException {
        class ResourceDeltaVisitor
        implements IResourceDeltaVisitor {
            List resources = new ArrayList();

            ResourceDeltaVisitor() {
            }

            public boolean visit(IResourceDelta delta) throws CoreException {
                IResource resource = delta.getResource();
                if (this.isIncludedResource(resource)) {
                    this.resources.add(resource);
                    resource.deleteMarkers("org.eclipse.core.resources.problemmarker", true, 2);
                }
                return true;
            }

            public List getResources() {
                return this.resources;
            }

            private boolean isIncludedResource(IResource resource) {
                if (resource == null || !resource.exists()) {
                    return false;
                }
                return ModelUtil.isModelFile((IResource)resource) || ModelUtil.isXsdFile((IResource)resource) || ModelUtil.isVdbArchiveFile((IResource)resource);
            }
        }
        final ResourceDeltaVisitor visitor = new ResourceDeltaVisitor();
        delta.accept((IResourceDeltaVisitor)visitor);
        TransactionRunnable runnable = new TransactionRunnable(){
            {
            }

            public Object run(UnitOfWork uow) throws ModelerCoreException {
                List iResources = visitor.getResources();
                IResource[] vdbResources = WorkspaceResourceFinderUtil.getVdbResourcesThatContain((Collection)iResources);
                for (int i = 0; i != vdbResources.length; ++i) {
                    IResource vdbResource = vdbResources[i];
                    if (iResources.contains(vdbResource)) continue;
                    iResources.add(vdbResource);
                }
                Container container = ModelBuilder.this.doGetContainer();
                ModelBuildUtil.buildResources((IProgressMonitor)monitor, (Collection)iResources, (Container)container, (boolean)false);
                return null;
            }
        };
        List modifiedResources = ModelBuildUtil.getModifiedResources();
        ModelerCore.getModelEditor().executeAsTransaction(runnable, "Incremental Build", false, false, (Object)this);
        ModelBuildUtil.setModifiedResources((List)modifiedResources);
    }

    protected Container doGetContainer() throws ModelerCoreException {
        try {
            return ModelerCore.getModelContainer();
        }
        catch (CoreException err) {
            throw new ModelerCoreException(err);
        }
    }

    protected void cleanOrphanedIndexes() throws CoreException {
        IWorkspace workspace;
        IWorkspaceRoot root;
        IProject currentProj = this.getProject();
        LinkedList<IProject> builtProjects = new LinkedList<IProject>();
        if (currentProj != null && (root = (workspace = currentProj.getWorkspace()).getRoot()) != null) {
            IProject[] projects = root.getProjects();
            for (int i = 0; i < projects.length; ++i) {
                IProject project = projects[i];
                if (project == null || !project.isAccessible()) continue;
                if (!super.hasBeenBuilt(project) && !currentProj.equals(project)) {
                    return;
                }
                builtProjects.add(project);
            }
        }
        if (!builtProjects.isEmpty()) {
            SearchIndexResourceVisitor visitor = new SearchIndexResourceVisitor();
            Iterator iter = builtProjects.iterator();
            while (iter.hasNext()) {
                IProject proj = (IProject)iter.next();
                proj.accept((IResourceVisitor)visitor);
            }
            File[] indexFiles = new File(IndexUtil.INDEX_PATH).listFiles();
            for (int i = 0; i < indexFiles.length; ++i) {
                File indexFile = indexFiles[i];
                if (!IndexUtil.isIndexFile((File)indexFile)) continue;
                String fileName = indexFile.getName();
                if (visitor.getIndexNames().contains(fileName)) continue;
                indexFile.delete();
            }
        }
    }
}

