/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.connector.sysadmin;

import com.metamatrix.admin.internal.server.IAdmin;
import com.metamatrix.api.exception.security.AuthorizationException;
import com.metamatrix.connector.sysadmin.SysAdminMethodManager;
import com.metamatrix.connector.sysadmin.SysAdminPlugin;
import com.metamatrix.connector.sysadmin.extension.IObjectCommand;
import com.metamatrix.connector.sysadmin.extension.ISourceTranslator;
import com.metamatrix.connector.sysadmin.extension.ISysAdminSource;
import com.metamatrix.data.api.ConnectorEnvironment;
import com.metamatrix.data.exception.ConnectorException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class SysAdminObjectSource
implements ISysAdminSource {
    private SysAdminMethodManager mm = null;
    private IAdmin api;
    private ISourceTranslator sourceTranslator = null;
    private boolean isAlive = false;
    private boolean isFailed = false;
    private ConnectorEnvironment env = null;

    protected SysAdminObjectSource(IAdmin sourceConnection, Class apiClass, ConnectorEnvironment environment, ISourceTranslator sourceTranslator) throws ConnectorException {
        this.api = sourceConnection;
        this.mm = new SysAdminMethodManager(sourceConnection.getClass());
        this.sourceTranslator = sourceTranslator;
        this.env = environment;
        this.isAlive();
    }

    public Object getSource() {
        return this.api;
    }

    public ISourceTranslator getSourceTranslator() {
        return this.sourceTranslator;
    }

    public List getObjects(IObjectCommand command) throws ConnectorException {
        try {
            Object data = this.executeMethod(command);
            if (command.hasResults()) {
                return this.convert(data);
            }
            return null;
        }
        catch (ConnectorException ce) {
            this.isFailed = true;
            throw ce;
        }
        catch (Throwable e) {
            this.isFailed = true;
            throw new ConnectorException(e);
        }
    }

    private Object executeMethod(IObjectCommand command) throws Throwable {
        Method m = this.getMethod(command);
        if (m != null) {
            String parm;
            Object obj;
            List criteriaValues;
            boolean authorized = false;
            String toLower = m.getName().toLowerCase();
            if (toLower.startsWith("get")) {
                authorized = true;
            } else if (toLower.equals("setuserpassword") && (criteriaValues = command.getCriteriaValues()) != null && criteriaValues.size() > 0 && (obj = command.getCriteriaValues().get(0)) instanceof String && (parm = (String)obj).equalsIgnoreCase(this.api.getSecurityContext().getUserName())) {
                authorized = true;
            }
            if (!authorized) {
                authorized = this.api.isUserAuthorizedToCallMethod(m.getName());
            }
            if (authorized) {
                try {
                    return m.invoke((Object)this.api, command.getCriteriaValues().toArray());
                }
                catch (InvocationTargetException ivt) {
                    if (ivt.getCause() != null) {
                        throw ivt.getCause();
                    }
                    throw ivt;
                }
            }
            Object[] args = new String[]{this.api.getSecurityContext().getUserName(), m.getName()};
            String msg = SysAdminPlugin.Util.getString("SysAdminObjectSource.User_does_not_have_role", args);
            this.env.getLogger().logError(msg);
            throw new AuthorizationException(msg);
        }
        return null;
    }

    private Method getMethod(IObjectCommand objectCommand) throws SecurityException, NoSuchMethodException {
        Method m = this.mm.getMethodFromAPI(objectCommand);
        if (m == null) {
            return null;
        }
        return m;
    }

    private List convert(Object object) {
        if (object == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<Object> resultData = new ArrayList<Object>();
        if (object.getClass().isArray()) {
            List<Object> resultRows = Arrays.asList((Object[])object);
            resultData = new ArrayList(resultRows.size());
            resultData.addAll(resultRows);
        } else if (object instanceof Collection) {
            Collection resultRows = (Collection)object;
            if (resultRows.isEmpty()) {
                return Collections.EMPTY_LIST;
            }
            resultData = new ArrayList(resultRows.size());
            resultData.addAll(resultRows);
        } else {
            ArrayList<Object> resultRow = new ArrayList<Object>(1);
            resultRow.add(object);
            resultData.add(resultRow);
        }
        return resultData;
    }

    public void closeSource() {
        this.isAlive = false;
        this.api = null;
        this.env = null;
        this.sourceTranslator = null;
        this.mm = null;
    }

    public void setIsAlive(boolean isAlive) {
        this.isAlive = isAlive;
    }

    public boolean isAlive() {
        return this.isAlive;
    }

    public boolean isFailed() {
        return this.isFailed;
    }
}

