/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.modeler.diagram.ui.custom.actions;

import com.metamatrix.core.util.I18nUtil;
import com.metamatrix.metamodels.diagram.Diagram;
import com.metamatrix.modeler.core.ModelerCore;
import com.metamatrix.modeler.core.workspace.ModelResource;
import com.metamatrix.modeler.core.workspace.ModelWorkspaceException;
import com.metamatrix.modeler.diagram.ui.DiagramUiConstants;
import com.metamatrix.modeler.diagram.ui.DiagramUiPlugin;
import com.metamatrix.modeler.diagram.ui.actions.DiagramAction;
import com.metamatrix.modeler.diagram.ui.connection.UmlRelationshipHelper;
import com.metamatrix.modeler.diagram.ui.custom.CustomDiagramModelFactory;
import com.metamatrix.modeler.diagram.ui.custom.actions.AssociatedLevelsDialog;
import com.metamatrix.modeler.diagram.ui.editor.DiagramEditor;
import com.metamatrix.modeler.diagram.ui.editor.DiagramEditorUtil;
import com.metamatrix.modeler.diagram.ui.model.DiagramModelNode;
import com.metamatrix.modeler.diagram.ui.util.DiagramUiUtilities;
import com.metamatrix.modeler.internal.core.workspace.ModelUtil;
import com.metamatrix.modeler.internal.ui.explorer.ModelExplorerContentProvider;
import com.metamatrix.modeler.internal.ui.explorer.ModelExplorerLabelProvider;
import com.metamatrix.modeler.internal.ui.viewsupport.ModelUtilities;
import com.metamatrix.modeler.internal.ui.viewsupport.ModelWorkspaceViewerFilter;
import com.metamatrix.modeler.ui.editors.ModelEditorManager;
import com.metamatrix.ui.internal.eventsupport.SelectionUtilities;
import com.metamatrix.ui.internal.util.WidgetUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;

public class AddToNewCustomDiagramAction
extends DiagramAction
implements DiagramUiConstants {
    private static final String I18N_PREFIX = I18nUtil.getPropertyPrefix((Class)(class$com$metamatrix$modeler$diagram$ui$custom$actions$AddToNewCustomDiagramAction == null ? (class$com$metamatrix$modeler$diagram$ui$custom$actions$AddToNewCustomDiagramAction = AddToNewCustomDiagramAction.class$("com.metamatrix.modeler.diagram.ui.custom.actions.AddToNewCustomDiagramAction")) : class$com$metamatrix$modeler$diagram$ui$custom$actions$AddToNewCustomDiagramAction));
    private static final String TARGET_SELECTION_DIALOG_TITLE = AddToNewCustomDiagramAction.getString("containerSelectionDialogTitle");
    private static final String EMPTY_STRING = "";
    private static final String TARGET_SELECTION_DIALOG_MESSAGE = AddToNewCustomDiagramAction.getString("containerSelectionDialogMessage");
    private static final String INVALID_SELECTION_MESSAGE = AddToNewCustomDiagramAction.getString("invalidSelectionMessage");
    private static final String READ_ONLY_MODEL_SELECTION_MESSAGE = AddToNewCustomDiagramAction.getString("readOnlyModelSelectionMessage");
    private static final String READ_ONLY_OBJECT_SELECTION_MESSAGE = AddToNewCustomDiagramAction.getString("readOnlyObjectSelectionMessage");
    private static final String LEVELS_SELECTION_DIALOG_TITLE = AddToNewCustomDiagramAction.getString("levelsDialogTitle");
    private static final boolean PERSIST_CUSTOM_DIAGRAMS = true;
    private static final String THIS_CLASS = "AddToNewCustomDiagramAction";
    static /* synthetic */ Class class$com$metamatrix$modeler$diagram$ui$custom$actions$AddToNewCustomDiagramAction;

    private static String getString(String id) {
        return DiagramUiConstants.Util.getString(I18N_PREFIX + id);
    }

    public AddToNewCustomDiagramAction() {
    }

    public AddToNewCustomDiagramAction(int theStyle) {
        super(theStyle);
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        super.selectionChanged(part, selection);
        this.determineEnablement();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void doRun() {
        block22: {
            DiagramEditor dEditor;
            boolean diagramWasConstructed;
            Diagram newDiagram;
            block23: {
                block24: {
                    List selectedEObjects = SelectionUtilities.getSelectedEObjects((ISelection)this.getSelection());
                    if (selectedEObjects == null || selectedEObjects.isEmpty()) break block22;
                    Object selectedContainer = this.getTargetForDiagram();
                    newDiagram = null;
                    diagramWasConstructed = false;
                    if (selectedContainer == null) break block22;
                    this.verifyResouceOpen(selectedContainer);
                    dEditor = null;
                    boolean requiredStart = false;
                    boolean succeeded = false;
                    try {
                        try {
                            requiredStart = ModelerCore.startTxn((boolean)true, (boolean)true, (String)"Add To New Custom Diagram", (Object)((Object)this));
                            newDiagram = this.createDiagram(selectedContainer);
                            if (newDiagram != null) {
                                diagramWasConstructed = true;
                                ModelEditorManager.open((EObject)newDiagram, (boolean)true);
                                dEditor = DiagramEditorUtil.getVisibleDiagramEditor();
                                DiagramModelNode diagramNode = dEditor.getCurrentModel();
                                CustomDiagramModelFactory modelFactory = (CustomDiagramModelFactory)dEditor.getModelFactory();
                                if (diagramNode != null && modelFactory != null) {
                                    DiagramEditorUtil.setDiagramUnderConstruction((Diagram)newDiagram);
                                    modelFactory.add(selectedEObjects, diagramNode);
                                    int levels = this.getAssociationLevels();
                                    this.addAssociatedObjects(dEditor, modelFactory, diagramNode, selectedEObjects, levels);
                                    dEditor.autoLayout();
                                }
                                this.updateImportsForResource(dEditor.getCurrentModelResource());
                            }
                            succeeded = true;
                        }
                        catch (ModelWorkspaceException e) {
                            String message = DiagramUiConstants.Util.getString("AddToNewCustomDiagramAction.createCustomDiagramError", (Object)selectedContainer.toString());
                            DiagramUiConstants.Util.log(4, (Throwable)e, message);
                            Object var12_15 = null;
                            if (requiredStart) {
                                if (succeeded) {
                                    ModelerCore.commitTxn();
                                } else {
                                    ModelerCore.rollbackTxn();
                                }
                            }
                            if (!diagramWasConstructed) break block22;
                            DiagramEditorUtil.setDiagramConstructionComplete((Diagram)newDiagram, (boolean)true);
                            if (dEditor != null) {
                                dEditor.openContext((Object)newDiagram, true);
                            }
                            break block22;
                        }
                        catch (Exception ex) {
                            DiagramUiConstants.Util.log(4, (Throwable)ex, ex.getClass().getName() + ":" + THIS_CLASS + ".doRun()");
                            Object var12_16 = null;
                            if (requiredStart) {
                                if (succeeded) {
                                    ModelerCore.commitTxn();
                                } else {
                                    ModelerCore.rollbackTxn();
                                }
                            }
                            if (!diagramWasConstructed) break block22;
                            DiagramEditorUtil.setDiagramConstructionComplete((Diagram)newDiagram, (boolean)true);
                            if (dEditor != null) {
                                dEditor.openContext((Object)newDiagram, true);
                            }
                            break block22;
                        }
                        Object var12_14 = null;
                        if (!requiredStart) break block23;
                        if (!succeeded) break block24;
                    }
                    catch (Throwable throwable) {
                        Object var12_17 = null;
                        if (requiredStart) {
                            if (succeeded) {
                                ModelerCore.commitTxn();
                            } else {
                                ModelerCore.rollbackTxn();
                            }
                        }
                        if (diagramWasConstructed) {
                            DiagramEditorUtil.setDiagramConstructionComplete((Diagram)newDiagram, (boolean)true);
                            if (dEditor != null) {
                                dEditor.openContext((Object)newDiagram, true);
                            }
                        }
                        throw throwable;
                    }
                    ModelerCore.commitTxn();
                    break block23;
                }
                ModelerCore.rollbackTxn();
            }
            if (diagramWasConstructed) {
                DiagramEditorUtil.setDiagramConstructionComplete((Diagram)newDiagram, (boolean)true);
                if (dEditor != null) {
                    dEditor.openContext((Object)newDiagram, true);
                }
            }
        }
        this.determineEnablement();
    }

    private void determineEnablement() {
        boolean enable = false;
        if (!SelectionUtilities.getSelectedEObjects((ISelection)this.getSelection()).isEmpty()) {
            enable = true;
        }
        this.setEnabled(enable);
    }

    protected boolean preRun() {
        return true;
    }

    protected boolean requiresEditorForRun() {
        return true;
    }

    private void verifyResouceOpen(Object targetContainer) {
        if (this.requiresEditorForRun()) {
            Object selectedObject = SelectionUtilities.getSelectedObject((ISelection)this.getSelection());
            ModelResource modelResource = null;
            if (targetContainer instanceof IResource && ModelUtilities.isModelFile((IResource)((IResource)targetContainer))) {
                try {
                    modelResource = ModelUtilities.getModelResource((IFile)((IFile)targetContainer), (boolean)false);
                }
                catch (ModelWorkspaceException e) {
                    String message = DiagramUiConstants.Util.getString("AddToNewCustomDiagramAction.createCustomDiagramError", (Object)selectedObject.toString());
                    DiagramUiConstants.Util.log(4, (Throwable)e, message);
                }
            } else {
                modelResource = ModelUtilities.getModelResourceForModelObject((EObject)((EObject)targetContainer));
            }
            if (modelResource != null) {
                ModelEditorManager.activate((ModelResource)modelResource, (boolean)true);
            }
        }
    }

    private Diagram createDiagram(Object targetContainer) throws ModelWorkspaceException {
        Diagram result = null;
        if (targetContainer instanceof IResource && ModelUtilities.isModelFile((IResource)((IResource)targetContainer))) {
            ModelResource modelResource = ModelUtilities.getModelResource((IFile)((IFile)targetContainer), (boolean)false);
            if (modelResource != null) {
                result = modelResource.getModelDiagrams().createNewDiagram(null, true);
                result.setType("customDiagramType");
            }
        } else {
            ModelResource modelResource = ModelUtilities.getModelResourceForModelObject((EObject)((EObject)targetContainer));
            if (modelResource != null) {
                result = modelResource.getModelDiagrams().createNewDiagram((EObject)targetContainer, true);
                result.setType("customDiagramType");
            }
        }
        return result;
    }

    public int getAssociationLevels() {
        int levels = 0;
        Shell shell = DiagramUiPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getShell();
        AssociatedLevelsDialog dialog = new AssociatedLevelsDialog(shell, LEVELS_SELECTION_DIALOG_TITLE);
        if (dialog.open() == 0) {
            levels = dialog.getLevels();
        }
        return levels;
    }

    private Object getTargetForDiagram() {
        ModelWorkspaceViewerFilter filter = new ModelWorkspaceViewerFilter(true){

            public boolean select(Viewer viewer, Object parent, Object element) {
                boolean doSelect = false;
                if (element instanceof IContainer) {
                    doSelect = true;
                } else if (element instanceof IResource) {
                    doSelect = true;
                } else if (element instanceof EObject && DiagramUiUtilities.isStandardUmlPackage((Object)element)) {
                    doSelect = true;
                }
                return doSelect;
            }
        };
        ISelectionStatusValidator validator = new ISelectionStatusValidator(){

            public IStatus validate(Object[] selection) {
                if (selection.length == 1) {
                    if (selection[0] instanceof IResource) {
                        if (ModelUtilities.isModelFile((IResource)((IResource)selection[0])) && !ModelUtil.isXsdFile((IResource)((IResource)selection[0]))) {
                            ModelResource mr = null;
                            try {
                                mr = ModelUtilities.getModelResource((IFile)((IFile)selection[0]), (boolean)false);
                            }
                            catch (ModelWorkspaceException err) {
                                String message = DiagramUiConstants.Util.getString("AddToNewCustomDiagramAction.findModelResourceError", (Object)selection[0].toString());
                                DiagramUiConstants.Util.log(4, (Throwable)err, message);
                            }
                            if (mr != null && mr.isReadOnly()) {
                                return new Status(4, "com.metamatrix.modeler.diagram.ui", 0, READ_ONLY_MODEL_SELECTION_MESSAGE, null);
                            }
                            return new Status(0, "com.metamatrix.modeler.diagram.ui", 0, AddToNewCustomDiagramAction.EMPTY_STRING, null);
                        }
                    } else if (selection[0] instanceof EObject && DiagramUiUtilities.isStandardUmlPackage((Object)selection[0])) {
                        ModelResource mr = ModelUtilities.getModelResourceForModelObject((EObject)((EObject)selection[0]));
                        if (mr != null && mr.isReadOnly()) {
                            return new Status(4, "com.metamatrix.modeler.diagram.ui", 0, READ_ONLY_OBJECT_SELECTION_MESSAGE, null);
                        }
                        return new Status(0, "com.metamatrix.modeler.diagram.ui", 0, AddToNewCustomDiagramAction.EMPTY_STRING, null);
                    }
                }
                return new Status(4, "com.metamatrix.modeler.diagram.ui", 0, INVALID_SELECTION_MESSAGE, null);
            }
        };
        Object[] targets = WidgetUtil.showWorkspaceObjectSelectionDialog((String)TARGET_SELECTION_DIALOG_TITLE, (String)TARGET_SELECTION_DIALOG_MESSAGE, (boolean)true, null, (ViewerFilter)filter, (ISelectionStatusValidator)validator, (ILabelProvider)new ModelExplorerLabelProvider(), (ITreeContentProvider)new ModelExplorerContentProvider());
        if (targets.length > 0) {
            return targets[0];
        }
        return null;
    }

    private void addAssociatedObjects(DiagramEditor editor, CustomDiagramModelFactory modelFactory, DiagramModelNode diagramNode, List startingList, int levels) {
        List newObjects;
        List currentContents = new ArrayList(startingList);
        for (int i = 0; i < levels && !(newObjects = this.getAssociatedObjectsNotInDiagram(editor, currentContents)).isEmpty(); ++i) {
            modelFactory.add(newObjects, diagramNode);
            currentContents = DiagramEditorUtil.getCurrentDiagramNodeEObjects();
        }
    }

    private List getAssociatedObjectsNotInDiagram(DiagramEditor editor, List objectList) {
        ArrayList<EObject> newObjects = new ArrayList<EObject>();
        if (editor != null && editor.getCurrentModel() != null) {
            DiagramModelNode diagramNode = editor.getCurrentModel();
            List allAssociatedToAdd = UmlRelationshipHelper.getRelatedObjects((List)objectList);
            Iterator iter = allAssociatedToAdd.iterator();
            EObject nextEObj = null;
            while (iter.hasNext()) {
                nextEObj = (EObject)iter.next();
                if (editor == null || editor.getCurrentModel() == null || DiagramUiUtilities.diagramContainsEObject((EObject)nextEObj, (DiagramModelNode)diagramNode)) continue;
                newObjects.add(nextEObj);
            }
        }
        if (newObjects.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        return newObjects;
    }

    private void updateImportsForResource(ModelResource mr) {
        if (mr != null && mr.exists()) {
            try {
                ModelUtilities.rebuildImports((ModelResource)mr, (Object)((Object)this), (boolean)true);
                mr.save(null, false);
            }
            catch (ModelWorkspaceException err) {
                String message = DiagramUiConstants.Util.getString("AddToNewCustomDiagramAction.rebuildImportsForResourceError", (Object)mr.toString());
                DiagramUiConstants.Util.log(4, (Throwable)err, message);
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

