/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.modeler.diagram.ui.custom.actions;

import com.metamatrix.metamodels.diagram.Diagram;
import com.metamatrix.modeler.core.ModelerCore;
import com.metamatrix.modeler.core.metamodel.aspect.MetamodelAspect;
import com.metamatrix.modeler.core.metamodel.aspect.uml.UmlClassifier;
import com.metamatrix.modeler.core.metamodel.aspect.uml.UmlPackage;
import com.metamatrix.modeler.core.workspace.ModelResource;
import com.metamatrix.modeler.core.workspace.ModelWorkspaceException;
import com.metamatrix.modeler.diagram.ui.DiagramUiConstants;
import com.metamatrix.modeler.diagram.ui.DiagramUiPlugin;
import com.metamatrix.modeler.diagram.ui.actions.DiagramAction;
import com.metamatrix.modeler.diagram.ui.custom.CustomDiagramModelFactory;
import com.metamatrix.modeler.diagram.ui.editor.DiagramEditor;
import com.metamatrix.modeler.diagram.ui.editor.DiagramEditorUtil;
import com.metamatrix.modeler.diagram.ui.editor.DiagramToolBarManager;
import com.metamatrix.modeler.diagram.ui.model.DiagramModelNode;
import com.metamatrix.modeler.diagram.ui.util.DiagramUiUtilities;
import com.metamatrix.modeler.internal.ui.editors.ModelEditor;
import com.metamatrix.modeler.internal.ui.search.SearchPageUtil;
import com.metamatrix.modeler.internal.ui.viewsupport.ModelObjectUtilities;
import com.metamatrix.modeler.internal.ui.viewsupport.ModelUtilities;
import com.metamatrix.modeler.ui.editors.ModelEditorManager;
import com.metamatrix.ui.internal.eventsupport.SelectionUtilities;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IWorkbenchPart;

public class AddToDiagramAction
extends DiagramAction {
    private static final String THIS_CLASS = "AddToDiagramAction";
    private DiagramEditor editor;
    private ActionContributionItem thisToolItem;
    private DiagramToolBarManager toolBarManager;
    private ISelection oldSelection;
    private ISelection focusedSelection;

    public AddToDiagramAction() {
        this.setImageDescriptor(DiagramUiPlugin.getDefault().getImageDescriptor("icons/full/cview16/tb_add_to_diagram.gif"));
    }

    public void selectionChanged(IWorkbenchPart thePart, ISelection theSelection) {
        if (thePart != null && thePart instanceof ModelEditor) {
            this.oldSelection = this.getSelection();
        }
        ISelection selection = theSelection;
        List searchResults = SearchPageUtil.getEObjectsFromSearchSelection((ISelection)theSelection);
        if (searchResults != null) {
            selection = searchResults.isEmpty() ? new StructuredSelection() : new StructuredSelection(searchResults);
        }
        super.selectionChanged(thePart, selection);
        this.setFocusedSelection();
        this.setEnabled(this.shouldEnable());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void doRun() {
        block14: {
            boolean handleConstruction;
            Diagram diagram;
            block15: {
                block16: {
                    if (this.editor == null) break block14;
                    DiagramModelNode diagramNode = this.editor.getCurrentModel();
                    diagram = (Diagram)diagramNode.getModelObject();
                    CustomDiagramModelFactory modelFactory = (CustomDiagramModelFactory)this.editor.getModelFactory();
                    if (diagramNode == null || modelFactory == null) break block14;
                    handleConstruction = !DiagramEditorUtil.isDiagramUnderConstruction((Diagram)diagram);
                    boolean requiredStart = false;
                    boolean succeeded = false;
                    try {
                        try {
                            if (handleConstruction) {
                                DiagramEditorUtil.setDiagramUnderConstruction((Diagram)diagram);
                            }
                            requiredStart = ModelerCore.startTxn((boolean)true, (boolean)false, (String)"Add To Custom Diagram", (Object)((Object)this));
                            modelFactory.add(SelectionUtilities.getSelectedEObjects((ISelection)this.focusedSelection), diagramNode);
                            this.updateImportsForResource(this.editor.getCurrentModelResource());
                            succeeded = true;
                        }
                        catch (Exception ex) {
                            DiagramUiConstants.Util.log(4, (Throwable)ex, ex.getClass().getName() + ":" + THIS_CLASS + ".doRun()");
                            Object var9_8 = null;
                            if (requiredStart) {
                                if (succeeded) {
                                    ModelerCore.commitTxn();
                                } else {
                                    ModelerCore.rollbackTxn();
                                }
                            }
                            if (handleConstruction) {
                                DiagramEditorUtil.setDiagramConstructionComplete((Diagram)diagram, (boolean)true);
                            }
                            break block14;
                        }
                        Object var9_7 = null;
                        if (!requiredStart) break block15;
                        if (!succeeded) break block16;
                    }
                    catch (Throwable throwable) {
                        Object var9_9 = null;
                        if (requiredStart) {
                            if (succeeded) {
                                ModelerCore.commitTxn();
                            } else {
                                ModelerCore.rollbackTxn();
                            }
                        }
                        if (handleConstruction) {
                            DiagramEditorUtil.setDiagramConstructionComplete((Diagram)diagram, (boolean)true);
                        }
                        throw throwable;
                    }
                    ModelerCore.commitTxn();
                    break block15;
                }
                ModelerCore.rollbackTxn();
            }
            if (handleConstruction) {
                DiagramEditorUtil.setDiagramConstructionComplete((Diagram)diagram, (boolean)true);
            }
        }
        this.toolBarManager.resetFocusedToolItem();
        this.setFocusedSelection();
    }

    public void setDiagramEditor(DiagramEditor editor) {
        this.editor = editor;
    }

    private boolean shouldEnable() {
        boolean enable = false;
        enable = this.isWritable() && this.allObjectsAddable();
        return enable;
    }

    public boolean wasToolBarItemSelected() {
        return this.toolBarManager != null && this.toolBarManager.getFocusedToolItem() != null && this.thisToolItem != null && this.thisToolItem.equals((Object)this.toolBarManager.getFocusedToolItem());
    }

    public void setItem(ActionContributionItem aci) {
        this.thisToolItem = aci;
    }

    private void setFocusedSelection() {
        this.focusedSelection = this.wasToolBarItemSelected() ? this.oldSelection : this.getSelection();
    }

    public void setToolBarManager(DiagramToolBarManager tbManager) {
        this.toolBarManager = tbManager;
    }

    private boolean isWritable() {
        EObject diagram;
        DiagramModelNode currentDiagram;
        return this.editor != null && (currentDiagram = this.editor.getCurrentModel()) != null && !ModelObjectUtilities.isReadOnly((EObject)(diagram = currentDiagram.getModelObject()));
    }

    private boolean allObjectsAddable() {
        boolean allOK = true;
        List selectedEObjects = SelectionUtilities.getSelectedEObjects((ISelection)this.focusedSelection);
        if (!selectedEObjects.isEmpty()) {
            Object nextObject = null;
            Iterator iter = selectedEObjects.iterator();
            MetamodelAspect someAspect = null;
            while (iter.hasNext() && allOK) {
                nextObject = iter.next();
                if (nextObject instanceof Diagram) {
                    allOK = false;
                    continue;
                }
                someAspect = ModelObjectUtilities.getUmlAspect((EObject)nextObject);
                if (someAspect == null || !(someAspect instanceof UmlPackage) && !(someAspect instanceof UmlClassifier)) {
                    allOK = false;
                }
                if (!allOK || this.editor == null || this.editor.getCurrentModel() == null) continue;
                allOK = !DiagramUiUtilities.diagramContainsEObject((EObject)nextObject, (DiagramModelNode)this.editor.getCurrentModel());
            }
        } else {
            allOK = false;
        }
        return allOK;
    }

    protected boolean preRun() {
        EObject eObject;
        ModelResource mr;
        List allSelectedEObjects;
        if (this.requiresEditorForRun() && (allSelectedEObjects = SelectionUtilities.getSelectedEObjects((ISelection)this.focusedSelection)) != null && !allSelectedEObjects.isEmpty() && (mr = ModelUtilities.getModelResourceForModelObject((EObject)(eObject = this.editor.getCurrentModel().getModelObject()))) != null) {
            ModelEditorManager.activate((ModelResource)mr, (boolean)false);
        }
        return true;
    }

    private void updateImportsForResource(ModelResource mr) {
        if (mr != null && mr.exists()) {
            try {
                ModelUtilities.rebuildImports((ModelResource)mr, (Object)((Object)this), (boolean)true);
                mr.save(null, false);
            }
            catch (ModelWorkspaceException err) {
                String message = DiagramUiConstants.Util.getString("AddToCustomDiagramAction.rebuildImportsForResourceError", (Object)mr.toString());
                DiagramUiConstants.Util.log(4, (Throwable)err, message);
            }
        }
    }
}

