/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.resource.jdbc;

import com.metamatrix.resource.jdbc.spi.JCAConnectionRequestInfo;
import com.metamatrix.resource.jdbc.spi.JCADefaultConnectionManager;
import com.metamatrix.resource.jdbc.spi.JCAExceptions;
import com.metamatrix.resource.jdbc.spi.JCALogger;
import com.metamatrix.resource.jdbc.spi.JCAManagedConnectionFactory;
import com.metamatrix.resource.jdbc.spi.JCAUtil;
import com.metamatrix.util.UtilDebug;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.resource.Referenceable;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionManager;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.ManagedConnectionFactory;
import javax.sql.DataSource;

public class JCAConnectionFactory
implements DataSource,
Serializable,
Referenceable {
    private static String footprint = "$Revision:   3.1.7.0  $";
    private JCAManagedConnectionFactory managedConnectionFactory;
    private ConnectionManager connectionManager;
    protected transient JCALogger logger;
    private transient JCAExceptions exceptions;
    private transient Reference reference;

    public JCAConnectionFactory(ConnectionManager connectionManager, JCAManagedConnectionFactory jCAManagedConnectionFactory, JCALogger jCALogger, JCAExceptions jCAExceptions) {
        UtilDebug.assert((String)"managedConnectionFactory must not be null", (jCAManagedConnectionFactory != null ? 1 : 0) != 0);
        UtilDebug.assert((String)"connectionManager must not be null", (connectionManager != null ? 1 : 0) != 0);
        UtilDebug.assert((String)"exceptions must not be null", (jCAExceptions != null ? 1 : 0) != 0);
        this.managedConnectionFactory = jCAManagedConnectionFactory;
        this.connectionManager = connectionManager;
        this.logger = jCALogger;
        this.exceptions = jCAExceptions;
    }

    public Connection getConnection() throws SQLException {
        if (this.logger.getLogWriter() != null) {
            this.logger.printEnter("ConnectionFactory.getConnection()");
        }
        this.validate();
        try {
            Connection connection = (Connection)this.connectionManager.allocateConnection((ManagedConnectionFactory)this.managedConnectionFactory, null);
            if (this.logger.getLogWriter() != null) {
                this.logger.printExit("ConnectionFactory.getConnection", connection);
            }
            return connection;
        }
        catch (ResourceException resourceException) {
            throw JCAExceptions.getSQLExceptionFromResourceException(resourceException);
        }
    }

    public Connection getConnection(String string, String string2) throws SQLException {
        if (this.logger.getLogWriter() != null) {
            this.logger.printEnter("ConnectionFactory.getConnection(String username, String password)");
            this.logger.println("username = " + string);
            this.logger.println("password = ********");
        }
        this.validate();
        JCAConnectionRequestInfo jCAConnectionRequestInfo = new JCAConnectionRequestInfo(string, string2);
        try {
            Connection connection = (Connection)this.connectionManager.allocateConnection((ManagedConnectionFactory)this.managedConnectionFactory, (ConnectionRequestInfo)jCAConnectionRequestInfo);
            if (this.logger.getLogWriter() != null) {
                this.logger.printExit("ConnectionFactory.getConnection", connection);
            }
            return connection;
        }
        catch (ResourceException resourceException) {
            throw JCAExceptions.getSQLExceptionFromResourceException(resourceException);
        }
    }

    public PrintWriter getLogWriter() throws SQLException {
        PrintWriter printWriter = this.logger.getLogWriter();
        if (printWriter != null) {
            this.logger.printEnter("ConnectionFactory.getLogWriter()");
        }
        this.validate();
        if (printWriter != null) {
            this.logger.printExit("ConnectionFactory.getLogWriter", printWriter);
        }
        return printWriter;
    }

    public int getLoginTimeout() throws SQLException {
        if (this.logger.getLogWriter() != null) {
            this.logger.printEnter("ConnectionFactory.getLoginTimeout()");
        }
        this.validate();
        int n = this.managedConnectionFactory.getLoginTimeout();
        if (this.logger.getLogWriter() != null) {
            this.logger.printExit("ConnectionFactory.getLoginTimeout", String.valueOf(n));
        }
        return n;
    }

    public void setLogWriter(PrintWriter printWriter) throws SQLException {
        if (this.logger != null) {
            if (this.logger.getLogWriter() != null) {
                this.logger.printEnter("ConnectionFactory.setLogWriter(PrintWriter logWriter)");
                this.logger.println("logWriter = " + printWriter);
            }
            this.logger.cleanup();
        }
        this.validate();
        this.logger = new JCALogger(printWriter);
        try {
            this.managedConnectionFactory.setLogWriter(printWriter);
        }
        catch (ResourceException resourceException) {
            throw JCAExceptions.getSQLExceptionFromResourceException(resourceException);
        }
        DriverManager.setLogWriter(printWriter);
        if (this.logger.getLogWriter() != null) {
            this.logger.printExit("ConnectionFactory.setLogWriter");
        }
    }

    public void setLoginTimeout(int n) throws SQLException {
        if (this.logger.getLogWriter() != null) {
            this.logger.printEnter("ConnectionFactory.setLoginTimeout(int seconds)");
            this.logger.println("seconds = " + n);
        }
        this.validate();
        this.managedConnectionFactory.setLoginTimeout(new Integer(n));
        if (this.logger.getLogWriter() != null) {
            this.logger.printExit("ConnectionFactory.setLoginTimeout");
        }
    }

    public void setReference(Reference reference) {
        if (this.logger.getLogWriter() != null) {
            this.logger.printEnter("ConnectionFactory.setReference(Reference reference)");
            this.logger.println("reference = " + reference);
        }
        this.reference = reference;
        if (this.logger.getLogWriter() != null) {
            this.logger.printExit("ConnectionFactory.setReference");
        }
    }

    public Reference getReference() throws NamingException {
        Reference reference = null;
        if (this.logger.getLogWriter() != null) {
            this.logger.printEnter("ConnectionFactory.getReference()");
        }
        reference = this.reference != null ? this.reference : this.createReference();
        if (this.logger.getLogWriter() != null) {
            this.logger.printExit("ConnectionFactory.getReference", reference);
        }
        return reference;
    }

    private void validate() throws SQLException {
        if (this.connectionManager == null || this.managedConnectionFactory == null) {
            ResourceException resourceException = this.exceptions.getException(4310, 2);
            throw JCAExceptions.getSQLExceptionFromResourceException(resourceException);
        }
    }

    private Reference createReference() {
        return JCAUtil.createConnectionFactoryReference(this.managedConnectionFactory);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        try {
            this.logger = new JCALogger(this.managedConnectionFactory.getLogWriter());
        }
        catch (ResourceException resourceException) {
            this.logger = new JCALogger();
        }
        this.exceptions = this.managedConnectionFactory.getExceptions();
        if (this.connectionManager instanceof JCADefaultConnectionManager) {
            ((JCADefaultConnectionManager)this.connectionManager).setExceptions(this.exceptions);
        }
        this.reference = null;
    }
}

