/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.resource.jdbc;

import com.ddtek.jdbc.extensions.ExtEmbeddedConnection;
import com.metamatrix.jdbc.extensions.ExtConnection;
import com.metamatrix.jdbc.extensions.ExtLogControl;
import com.metamatrix.resource.jdbc.spi.JCAExceptions;
import com.metamatrix.resource.jdbc.spi.JCALogger;
import com.metamatrix.resource.jdbc.spi.JCAManagedConnection;
import com.metamatrix.resource.jdbc.spi.JCAManagedConnectionFactory;
import com.metamatrix.util.UtilDebug;
import com.metamatrix.util.UtilResource;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Savepoint;
import java.sql.Statement;
import java.util.Map;
import javax.resource.ResourceException;

public class JCAConnection
implements Connection,
ExtConnection,
ExtEmbeddedConnection,
ExtLogControl {
    private static String footprint = "$Revision:   3.4.1.0  $";
    private Connection physConnectionHdl;
    protected JCALogger logger;
    private JCAExceptions exceptions;
    private JCAManagedConnection ownerManagedConnection;

    public JCAConnection(JCAManagedConnection jCAManagedConnection, JCALogger jCALogger, JCAExceptions jCAExceptions) {
        UtilDebug.assert((String)"ownerManagedConnection must not be null", (jCAManagedConnection != null ? 1 : 0) != 0);
        UtilDebug.assert((String)"exceptions must not be null", (jCAExceptions != null ? 1 : 0) != 0);
        this.setManagedConnection(jCAManagedConnection);
        this.logger = jCALogger;
        this.exceptions = jCAExceptions;
    }

    public synchronized void close() throws SQLException {
        if (this.logger.getLogWriter() != null) {
            this.logger.printEnter("Connection.close()");
        }
        if (!this.isClosed()) {
            try {
                this.ownerManagedConnection.connectionHandleClosed(this);
                this.ownerManagedConnection = null;
                this.physConnectionHdl = null;
            }
            catch (ResourceException resourceException) {
                SQLException sQLException = new SQLException(resourceException.getMessage());
                this.ownerManagedConnection.fireConnectionErrorOccurred(resourceException);
                throw sQLException;
            }
        }
        if (this.logger.getLogWriter() != null) {
            this.logger.printExit("Connection.close");
        }
    }

    public void abortConnection() throws SQLException {
        ResourceException resourceException = this.exceptions.getException(4313, 0);
        throw new SQLException(resourceException.getMessage());
    }

    public synchronized boolean isClosed() throws SQLException {
        if (this.logger.getLogWriter() != null) {
            this.logger.printEnter("Connection.isClosed()");
        }
        boolean bl = false;
        try {
            if (this.ownerManagedConnection == null || this.physConnectionHdl == null || this.physConnectionHdl.isClosed()) {
                bl = true;
            }
        }
        catch (SQLException sQLException) {
            this.ownerManagedConnection.fireConnectionErrorOccurred(new ResourceException(sQLException.getMessage()));
            throw sQLException;
        }
        if (this.logger.getLogWriter() != null) {
            this.logger.printExit("Connection.isClosed", String.valueOf(bl));
        }
        return bl;
    }

    public synchronized void setManagedConnection(JCAManagedConnection jCAManagedConnection) {
        try {
            this.ownerManagedConnection = jCAManagedConnection;
            this.physConnectionHdl = jCAManagedConnection.getPhysicalConnectionHandle();
        }
        catch (ResourceException resourceException) {
            this.physConnectionHdl = null;
        }
    }

    public JCAManagedConnection getManagedConnection() {
        return this.ownerManagedConnection;
    }

    public synchronized void invalidate() {
        this.ownerManagedConnection = null;
        this.physConnectionHdl = null;
    }

    public synchronized Statement createStatement() throws SQLException {
        this.validateClosed();
        return this.physConnectionHdl.createStatement();
    }

    public synchronized PreparedStatement prepareStatement(String string) throws SQLException {
        this.validateClosed();
        return this.physConnectionHdl.prepareStatement(string);
    }

    public synchronized CallableStatement prepareCall(String string) throws SQLException {
        this.validateClosed();
        return this.physConnectionHdl.prepareCall(string);
    }

    public synchronized String nativeSQL(String string) throws SQLException {
        this.validateClosed();
        return this.physConnectionHdl.nativeSQL(string);
    }

    public synchronized void setAutoCommit(boolean bl) throws SQLException {
        this.validateClosed();
        this.physConnectionHdl.setAutoCommit(bl);
    }

    public synchronized boolean getAutoCommit() throws SQLException {
        this.validateClosed();
        return this.physConnectionHdl.getAutoCommit();
    }

    public void setEnableLogging(boolean bl) {
        if (this.physConnectionHdl instanceof ExtLogControl) {
            ((ExtLogControl)this.physConnectionHdl).setEnableLogging(bl);
        }
    }

    public boolean getEnableLogging() {
        if (this.physConnectionHdl instanceof ExtLogControl) {
            return ((ExtLogControl)this.physConnectionHdl).getEnableLogging();
        }
        return false;
    }

    public synchronized void commit() throws SQLException {
        this.validateClosed();
        this.physConnectionHdl.commit();
    }

    public synchronized void rollback() throws SQLException {
        this.validateClosed();
        this.physConnectionHdl.rollback();
    }

    public synchronized DatabaseMetaData getMetaData() throws SQLException {
        this.validateClosed();
        return this.physConnectionHdl.getMetaData();
    }

    public synchronized void setReadOnly(boolean bl) throws SQLException {
        this.validateClosed();
        this.physConnectionHdl.setReadOnly(bl);
    }

    public synchronized boolean isReadOnly() throws SQLException {
        this.validateClosed();
        return this.physConnectionHdl.isReadOnly();
    }

    public synchronized void setCatalog(String string) throws SQLException {
        this.validateClosed();
        this.physConnectionHdl.setCatalog(string);
    }

    public synchronized String getCatalog() throws SQLException {
        this.validateClosed();
        return this.physConnectionHdl.getCatalog();
    }

    public synchronized void setTransactionIsolation(int n) throws SQLException {
        this.validateClosed();
        this.physConnectionHdl.setTransactionIsolation(n);
    }

    public synchronized Savepoint setSavepoint() throws SQLException {
        this.validateClosed();
        return this.physConnectionHdl.setSavepoint();
    }

    public synchronized Savepoint setSavepoint(String string) throws SQLException {
        this.validateClosed();
        return this.physConnectionHdl.setSavepoint(string);
    }

    public synchronized void rollback(Savepoint savepoint) throws SQLException {
        this.validateClosed();
        this.physConnectionHdl.rollback(savepoint);
    }

    public synchronized void releaseSavepoint(Savepoint savepoint) throws SQLException {
        this.validateClosed();
        this.physConnectionHdl.releaseSavepoint(savepoint);
    }

    public synchronized void setHoldability(int n) throws SQLException {
        this.validateClosed();
        this.physConnectionHdl.setHoldability(n);
    }

    public synchronized int getHoldability() throws SQLException {
        this.validateClosed();
        return this.physConnectionHdl.getHoldability();
    }

    public synchronized int getTransactionIsolation() throws SQLException {
        this.validateClosed();
        return this.physConnectionHdl.getTransactionIsolation();
    }

    public synchronized SQLWarning getWarnings() throws SQLException {
        this.validateClosed();
        return this.physConnectionHdl.getWarnings();
    }

    public synchronized void clearWarnings() throws SQLException {
        this.validateClosed();
        this.physConnectionHdl.clearWarnings();
    }

    public synchronized Statement createStatement(int n, int n2) throws SQLException {
        this.validateClosed();
        return this.physConnectionHdl.createStatement(n, n2);
    }

    public synchronized Statement createStatement(int n, int n2, int n3) throws SQLException {
        this.validateClosed();
        return this.physConnectionHdl.createStatement(n, n2, n3);
    }

    public synchronized PreparedStatement prepareStatement(String string, int n, int n2) throws SQLException {
        this.validateClosed();
        return this.physConnectionHdl.prepareStatement(string, n, n2);
    }

    public synchronized PreparedStatement prepareStatement(String string, int n, int n2, int n3) throws SQLException {
        this.validateClosed();
        return this.physConnectionHdl.prepareStatement(string, n, n2, n3);
    }

    public synchronized PreparedStatement prepareStatement(String string, int n) throws SQLException {
        this.validateClosed();
        return this.physConnectionHdl.prepareStatement(string, n);
    }

    public synchronized PreparedStatement prepareStatement(String string, int[] nArray) throws SQLException {
        this.validateClosed();
        return this.physConnectionHdl.prepareStatement(string, nArray);
    }

    public synchronized PreparedStatement prepareStatement(String string, String[] stringArray) throws SQLException {
        this.validateClosed();
        return this.physConnectionHdl.prepareStatement(string, stringArray);
    }

    public synchronized CallableStatement prepareCall(String string, int n, int n2) throws SQLException {
        this.validateClosed();
        return this.physConnectionHdl.prepareCall(string, n, n2);
    }

    public synchronized CallableStatement prepareCall(String string, int n, int n2, int n3) throws SQLException {
        this.validateClosed();
        return this.physConnectionHdl.prepareCall(string, n, n2, n3);
    }

    public synchronized Map getTypeMap() throws SQLException {
        this.validateClosed();
        return this.physConnectionHdl.getTypeMap();
    }

    public synchronized void setTypeMap(Map map) throws SQLException {
        this.validateClosed();
        this.physConnectionHdl.setTypeMap(map);
    }

    public synchronized String getResourceAdaptorName() {
        String string = " Resource Adaptor";
        JCAManagedConnectionFactory jCAManagedConnectionFactory = this.ownerManagedConnection.getOwnerFactory();
        return jCAManagedConnectionFactory.getResourceAdaptorName() + string;
    }

    public synchronized String getResourceAdaptorVersion() {
        String string = "0000";
        try {
            string = new UtilResource(this.ownerManagedConnection.getClass(), "JCA.properties").getAsProperties().getProperty("buildid", string);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "3.0." + string;
    }

    public synchronized boolean unlock(String string) throws SQLException {
        if (this.physConnectionHdl != null && this.physConnectionHdl instanceof ExtEmbeddedConnection) {
            return ((ExtEmbeddedConnection)this.physConnectionHdl).unlock(string);
        }
        ResourceException resourceException = this.exceptions.getException(4313, 2);
        throw new SQLException(resourceException.getMessage());
    }

    private void validateClosed() throws SQLException {
        if (this.isClosed()) {
            ResourceException resourceException = this.exceptions.getException(4309, 0);
            throw new SQLException(resourceException.getMessage());
        }
    }

    public synchronized void setClientApplicationName(String string) throws SQLException {
        this.validateClosed();
        ((ExtConnection)this.physConnectionHdl).setClientApplicationName(string);
    }

    public synchronized String getClientApplicationName() throws SQLException {
        this.validateClosed();
        return ((ExtConnection)this.physConnectionHdl).getClientApplicationName();
    }

    public synchronized void setClientHostName(String string) throws SQLException {
        this.validateClosed();
        ((ExtConnection)this.physConnectionHdl).setClientHostName(string);
    }

    public synchronized String getClientHostName() throws SQLException {
        this.validateClosed();
        return ((ExtConnection)this.physConnectionHdl).getClientHostName();
    }

    public synchronized void setClientUser(String string) throws SQLException {
        this.validateClosed();
        ((ExtConnection)this.physConnectionHdl).setClientUser(string);
    }

    public synchronized String getClientUser() throws SQLException {
        this.validateClosed();
        return ((ExtConnection)this.physConnectionHdl).getClientUser();
    }

    public synchronized void setClientAccountingInfo(String string) throws SQLException {
        this.validateClosed();
        ((ExtConnection)this.physConnectionHdl).setClientAccountingInfo(string);
    }

    public synchronized String getClientAccountingInfo() throws SQLException {
        this.validateClosed();
        return ((ExtConnection)this.physConnectionHdl).getClientAccountingInfo();
    }
}

