/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.jdbc.informix;

import com.metamatrix.util.UtilByteOrderedDataWriter;
import com.metamatrix.util.UtilException;
import java.io.IOException;
import java.io.OutputStream;

public class InformixLobOutputStream
extends OutputStream {
    private static String footprint = "$Revision:   3.1.7.0  $";
    public static final int CHUNKSIZE = 32000;
    private byte[] chunk = new byte[32000];
    private int chunkLength = 0;
    private int totalLength;
    private int lobHandle;
    private boolean header;
    UtilByteOrderedDataWriter writer;

    InformixLobOutputStream(int n, UtilByteOrderedDataWriter utilByteOrderedDataWriter, int n2) {
        this.writer = utilByteOrderedDataWriter;
        this.totalLength = n2;
        this.lobHandle = n;
        this.header = false;
    }

    private void writeHeader() throws UtilException {
        if (!this.header) {
            this.writer.writeInt16(97);
            this.writer.writeInt16(2);
            this.writer.writeInt16(this.lobHandle);
            this.writer.writeInt32(this.totalLength);
            this.writer.writeInt16(32000);
            this.header = true;
        }
    }

    public void write(int n) throws IOException {
        try {
            this.writeHeader();
            if (this.chunkLength + 1 == 32000) {
                this.writer.writeInt16(32000);
                this.writer.writeBytes(this.chunk, 0, this.chunkLength);
                this.chunkLength = 0;
            } else {
                this.chunk[this.chunkLength++] = (byte)n;
            }
        }
        catch (UtilException utilException) {
            throw new IOException();
        }
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        try {
            this.writeHeader();
            if (this.chunkLength != 0 && n2 + this.chunkLength > 32000) {
                this.writer.writeInt16(32000);
                this.writer.writeBytes(this.chunk, 0, this.chunkLength);
                this.writer.writeBytes(byArray, n, 32000 - this.chunkLength);
                n += 32000 - this.chunkLength;
                n2 -= 32000 - this.chunkLength;
                this.chunkLength = 0;
            }
            while (n2 >= 32000) {
                this.writer.writeInt16(32000);
                this.writer.writeBytes(byArray, n, 32000);
                n += 32000;
                n2 -= 32000;
            }
            if (n2 > 0) {
                System.arraycopy(byArray, n, this.chunk, this.chunkLength, n2);
                this.chunkLength += n2;
            }
        }
        catch (UtilException utilException) {
            throw new IOException();
        }
    }

    public void close() throws IOException {
        try {
            this.writeHeader();
            if (this.chunkLength > 0) {
                this.writer.writeInt16(this.chunkLength);
                this.writer.writeBytes(this.chunk, 0, this.chunkLength);
                if (this.chunkLength % 2 == 1) {
                    this.writer.writeInt8(0);
                }
            }
        }
        catch (UtilException utilException) {
            throw new IOException();
        }
    }
}

