/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.sequelink.net.ssl;

import com.metamatrix.sequelink.cert.AcceptNoneCertificateChecker;
import com.metamatrix.sequelink.cert.CertificateCheckerInterface;
import com.metamatrix.sequelink.net.EndPoint;
import com.metamatrix.sequelink.net.NetMessage;
import com.metamatrix.sequelink.net.NetworkException;
import com.metamatrix.sequelink.security.SLCrypto;
import iaik.security.ssl.ChainVerifier;
import iaik.security.ssl.CipherSuite;
import iaik.security.ssl.SSLClientContext;
import iaik.security.ssl.SSLContext;
import iaik.security.ssl.SSLSocket;
import iaik.security.ssl.SSLTransport;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.NoRouteToHostException;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;

public class IAIKSSLEndPoint
implements EndPoint {
    private SSLClientContext clientContext;
    private SSLSocket socket;

    public IAIKSSLEndPoint(String string, int n2, Properties properties) throws NetworkException {
        SLCrypto.init();
        this.clientContext = new SSLClientContext();
        this.clientContext.setChainVerifier(new Checker(properties.getProperty("certificatecheck")));
        CipherSuite[] cipherSuiteArray = IAIKSSLEndPoint.MakeSuiteList(properties.getProperty("ciphersuites"));
        this.clientContext.setEnabledCipherSuites(cipherSuiteArray);
        this.clientContext.setRandomGenerator(SLCrypto.getRandom());
        int[] nArray = IAIKSSLEndPoint.MakeVersionsList(properties.getProperty("sslversions"));
        this.clientContext.setAllowedProtocolVersions(nArray[0], nArray[1]);
        try {
            this.socket = new SSLSocket(string, n2, (SSLContext)this.clientContext);
        }
        catch (UnknownHostException unknownHostException) {
            NetworkException networkException = NetMessage.Message.getSSLNetworkException(unknownHostException.toString(), 7622);
            throw networkException;
        }
        catch (ConnectException connectException) {
            NetworkException networkException = NetMessage.Message.getSSLNetworkException(connectException.toString(), 7627);
            throw networkException;
        }
        catch (NoRouteToHostException noRouteToHostException) {
            NetworkException networkException = NetMessage.Message.getSSLNetworkException(noRouteToHostException.toString(), 7628);
            throw networkException;
        }
        catch (IOException iOException) {
            NetworkException networkException = NetMessage.Message.getSSLNetworkException(iOException.toString(), 7925);
            throw networkException;
        }
        try {
            this.socket.setTcpNoDelay(true);
        }
        catch (SocketException socketException) {
            NetworkException networkException = NetMessage.Message.getSSLNetworkException(socketException.toString(), 7631);
            try {
                this.socket.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw networkException;
        }
        String string2 = properties.getProperty("ssldebug");
        if ("true".equalsIgnoreCase(string2) || "1".equals(string2)) {
            this.setDebugStream(System.out);
        }
        try {
            this.socket.startHandshake();
        }
        catch (IOException iOException) {
            NetworkException networkException = NetMessage.Message.getSSLNetworkException(iOException.getMessage(), 7955);
            try {
                this.socket.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw networkException;
        }
    }

    public IAIKSSLEndPoint(InetAddress inetAddress, int n2, Properties properties) throws NetworkException {
        this(inetAddress.getHostAddress(), n2, properties);
    }

    public IAIKSSLEndPoint(SSLSocket sSLSocket) throws NetworkException {
        this.socket = sSLSocket;
        try {
            sSLSocket.startHandshake();
        }
        catch (IOException iOException) {
            NetworkException networkException = NetMessage.Message.getSSLNetworkException(iOException.getMessage(), 7955);
            throw networkException;
        }
    }

    public InputStream getInputStream() throws NetworkException {
        try {
            return this.socket.getInputStream();
        }
        catch (NullPointerException nullPointerException) {
            throw NetMessage.Message.getSSLNetworkException(7921);
        }
        catch (IOException iOException) {
            throw NetMessage.Message.getSSLNetworkException(7921);
        }
    }

    public OutputStream getOutputStream() throws NetworkException {
        try {
            return this.socket.getOutputStream();
        }
        catch (NullPointerException nullPointerException) {
            throw NetMessage.Message.getSSLNetworkException(7921);
        }
        catch (IOException iOException) {
            throw NetMessage.Message.getSSLNetworkException(7921);
        }
    }

    public InetAddress getInetAddress() {
        try {
            return this.socket.getInetAddress();
        }
        catch (NullPointerException nullPointerException) {
            return null;
        }
    }

    public int getPort() {
        try {
            return this.socket.getPort();
        }
        catch (NullPointerException nullPointerException) {
            return 0;
        }
    }

    public InetAddress getLocalAddress() {
        try {
            return this.socket.getLocalAddress();
        }
        catch (NullPointerException nullPointerException) {
            return null;
        }
    }

    public int getLocalPort() {
        try {
            return this.socket.getLocalPort();
        }
        catch (NullPointerException nullPointerException) {
            return 0;
        }
    }

    public void setTimeout(int n2) throws NetworkException {
        try {
            this.socket.setSoTimeout(n2 * 1000);
        }
        catch (SocketException socketException) {
            NetworkException networkException = NetMessage.Message.getSSLNetworkException(socketException.toString(), 7632);
            throw networkException;
        }
    }

    public void close() throws NetworkException {
        try {
            this.socket.close();
        }
        catch (IOException iOException) {
            NetworkException networkException = NetMessage.Message.getSSLNetworkException(iOException.getMessage(), 7926);
            throw networkException;
        }
        catch (NullPointerException nullPointerException) {
            throw NetMessage.Message.getSSLNetworkException(nullPointerException.toString(), 7921);
        }
    }

    public void setDebugStream(OutputStream outputStream) throws NetworkException {
        this.socket.setDebugStream(outputStream);
    }

    static CipherSuite[] MakeSuiteList(String string) throws NetworkException {
        if (string == null || string.compareTo("") == 0) {
            throw NetMessage.Message.getSSLNetworkException(7931);
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        Vector<String> vector = new Vector<String>();
        while (stringTokenizer.hasMoreElements()) {
            String string2 = (String)stringTokenizer.nextElement();
            vector.addElement(string2);
        }
        int n2 = vector.size();
        if (n2 == 0) {
            throw NetMessage.Message.getSSLNetworkException(7931);
        }
        CipherSuite[] cipherSuiteArray = new CipherSuite[vector.size()];
        for (int i2 = 0; i2 < n2; ++i2) {
            String string3 = (String)vector.elementAt(i2);
            if ("SSL_DH_anon_WITH_3DES_EDE_CBC_SHA".equalsIgnoreCase(string3)) {
                cipherSuiteArray[i2] = CipherSuite.SSL_DH_anon_WITH_3DES_EDE_CBC_SHA;
                continue;
            }
            if ("SSL_DH_anon_WITH_DES_CBC_SHA".equalsIgnoreCase(string3)) {
                cipherSuiteArray[i2] = CipherSuite.SSL_DH_anon_WITH_DES_CBC_SHA;
                continue;
            }
            if ("SSL_DH_anon_WITH_RC4_128_MD5".equalsIgnoreCase(string3)) {
                cipherSuiteArray[i2] = CipherSuite.SSL_DH_anon_WITH_RC4_MD5;
                continue;
            }
            if ("SSL_DHE_DSS_WITH_3DES_EDE_CBC_SHA".equalsIgnoreCase(string3)) {
                cipherSuiteArray[i2] = CipherSuite.SSL_DHE_DSS_WITH_3DES_EDE_CBC_SHA;
                continue;
            }
            if ("SSL_DHE_DSS_WITH_DES_CBC_SHA".equalsIgnoreCase(string3)) {
                cipherSuiteArray[i2] = CipherSuite.SSL_DHE_DSS_WITH_DES_CBC_SHA;
                continue;
            }
            if ("SSL_DHE_RSA_WITH_3DES_EDE_CBC_SHA".equalsIgnoreCase(string3)) {
                cipherSuiteArray[i2] = CipherSuite.SSL_DHE_RSA_WITH_3DES_EDE_CBC_SHA;
                continue;
            }
            if ("SSL_DHE_RSA_WITH_DES_CBC_SHA".equalsIgnoreCase(string3)) {
                cipherSuiteArray[i2] = CipherSuite.SSL_DHE_RSA_WITH_DES_CBC_SHA;
                continue;
            }
            if ("SSL_RSA_WITH_3DES_EDE_CBC_SHA".equalsIgnoreCase(string3)) {
                cipherSuiteArray[i2] = CipherSuite.SSL_RSA_WITH_3DES_EDE_CBC_SHA;
                continue;
            }
            if ("SSL_RSA_WITH_DES_CBC_SHA".equalsIgnoreCase(string3)) {
                cipherSuiteArray[i2] = CipherSuite.SSL_RSA_WITH_DES_CBC_SHA;
                continue;
            }
            if ("SSL_RSA_WITH_RC4_128_MD5".equalsIgnoreCase(string3)) {
                cipherSuiteArray[i2] = CipherSuite.SSL_RSA_WITH_RC4_128_MD5;
                continue;
            }
            if ("SSL_RSA_WITH_RC4_128_SHA".equalsIgnoreCase(string3)) {
                cipherSuiteArray[i2] = CipherSuite.SSL_RSA_WITH_RC4_128_SHA;
                continue;
            }
            if ("SSL_DHE_DSS_WITH_RC4_128_SHA".equalsIgnoreCase(string3)) {
                cipherSuiteArray[i2] = CipherSuite.SSL_DHE_DSS_WITH_RC4_128_SHA;
                continue;
            }
            if ("SSL_DH_anon_EXPORT_WITH_RC4_40_MD5".equalsIgnoreCase(string3)) {
                cipherSuiteArray[i2] = CipherSuite.SSL_DH_anon_EXPORT_WITH_RC4_40_MD5;
                continue;
            }
            if ("SSL_DHE_DSS_EXPORT_WITH_DES40_CBC_SHA".equalsIgnoreCase(string3)) {
                cipherSuiteArray[i2] = CipherSuite.SSL_DHE_DSS_EXPORT_WITH_DES40_CBC_SHA;
                continue;
            }
            if ("SSL_DHE_RSA_EXPORT_WITH_DES40_CBC_SHA".equalsIgnoreCase(string3)) {
                cipherSuiteArray[i2] = CipherSuite.SSL_DHE_RSA_EXPORT_WITH_DES40_CBC_SHA;
                continue;
            }
            if ("SSL_RSA_EXPORT_WITH_DES40_CBC_SHA".equalsIgnoreCase(string3)) {
                cipherSuiteArray[i2] = CipherSuite.SSL_RSA_EXPORT_WITH_DES40_CBC_SHA;
                continue;
            }
            if ("SSL_RSA_EXPORT_WITH_RC4_40_MD5".equalsIgnoreCase(string3)) {
                cipherSuiteArray[i2] = CipherSuite.SSL_RSA_EXPORT_WITH_RC4_40_MD5;
                continue;
            }
            if ("SSL_DH_anon_EXPORT_WITH_DES40_CBC_SHA".equalsIgnoreCase(string3)) {
                cipherSuiteArray[i2] = CipherSuite.SSL_DH_anon_EXPORT_WITH_DES40_CBC_SHA;
                continue;
            }
            if ("SSL_DHE_DSS_EXPORT1024_WITH_DES_CBC_SHA".equalsIgnoreCase(string3)) {
                cipherSuiteArray[i2] = CipherSuite.SSL_DHE_DSS_EXPORT1024_WITH_DES_CBC_SHA;
                continue;
            }
            if ("SSL_DHE_DSS_EXPORT1024_WITH_RC4_56_SHA".equalsIgnoreCase(string3)) {
                cipherSuiteArray[i2] = CipherSuite.SSL_DHE_DSS_EXPORT1024_WITH_RC4_56_SHA;
                continue;
            }
            if ("SSL_RSA_EXPORT1024_WITH_DES_CBC_SHA".equalsIgnoreCase(string3)) {
                cipherSuiteArray[i2] = CipherSuite.SSL_RSA_EXPORT1024_WITH_DES_CBC_SHA;
                continue;
            }
            if ("SSL_RSA_EXPORT1024_WITH_RC4_56_SHA".equalsIgnoreCase(string3)) {
                cipherSuiteArray[i2] = CipherSuite.SSL_RSA_EXPORT1024_WITH_RC4_56_SHA;
                continue;
            }
            if ("SSL_NULL_WITH_NULL_NULL".equalsIgnoreCase(string3) || "SSL_RSA_EXPORT_WITH_RC2_CBC_40_MD5".equalsIgnoreCase(string3) || "SSL_DH_DSS_EXPORT_WITH_DES40_CBC_SHA".equalsIgnoreCase(string3) || "SSL_DH_RSA_EXPORT_WITH_DES40_CBC_SHA".equalsIgnoreCase(string3) || "SSL_DH_DSS_WITH_DES_CBC_SHA".equalsIgnoreCase(string3) || "SSL_DH_DSS_WITH_3DES_EDE_CBC_SHA".equalsIgnoreCase(string3) || "SSL_DH_RSA_WITH_DES_CBC_SHA".equalsIgnoreCase(string3) || "SSL_DH_RSA_WITH_3DES_EDE_CBC_SHA".equalsIgnoreCase(string3) || "SSL_RSA_WITH_NULL_MD5".equalsIgnoreCase(string3) || "SSL_RSA_WITH_NULL_SHA".equalsIgnoreCase(string3) || "SSL_RSA_WITH_IDEA_CBC_SHA".equalsIgnoreCase(string3) || "SSL_FORTEZZA_DMS_WITH_NULL_SHA".equalsIgnoreCase(string3) || "SSL_FORTEZZA_DMS_WITH_FORTEZZA_CBC_SHA".equalsIgnoreCase(string3) || "SSL_FORTEZZA_DMS_WITH_RC4_128_SHA".equalsIgnoreCase(string3)) {
                throw NetMessage.Message.getSSLNetworkException(7929, string3);
            }
            throw NetMessage.Message.getSSLNetworkException(7930, string3);
        }
        return cipherSuiteArray;
    }

    static int[] MakeVersionsList(String string) throws NetworkException {
        int[] nArray = new int[]{769, 769};
        if (string == null) {
            return nArray;
        }
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreElements()) {
            String string2 = (String)stringTokenizer.nextElement();
            if (string.equalsIgnoreCase("ssl2")) {
                bl = true;
                continue;
            }
            if (string.equalsIgnoreCase("ssl3")) {
                bl2 = true;
                continue;
            }
            if (string.equalsIgnoreCase("tls1")) {
                bl3 = true;
                continue;
            }
            throw NetMessage.Message.getSSLNetworkException(7921);
        }
        if (bl && !bl2 && !bl3) {
            return new int[]{2, 2};
        }
        if (bl && bl2 && !bl3) {
            return new int[]{2, 768};
        }
        if (bl && bl2 && bl3) {
            return new int[]{2, 769};
        }
        if (!bl && bl2 && !bl3) {
            return new int[]{768, 768};
        }
        if (!bl && bl2 && bl3) {
            return new int[]{768, 769};
        }
        if (!bl && !bl2 && bl3) {
            return new int[]{769, 769};
        }
        throw NetMessage.Message.getSSLNetworkException(7921);
    }

    private boolean checkServerCertificate(X509Certificate[] x509CertificateArray, CertificateCheckerInterface certificateCheckerInterface) {
        if (x509CertificateArray != null) {
            try {
                int n2 = x509CertificateArray.length;
                byte[][] byArrayArray = new byte[n2][];
                for (int i2 = 0; i2 < n2; ++i2) {
                    try {
                        byArrayArray[i2] = x509CertificateArray[i2].getEncoded();
                        continue;
                    }
                    catch (CertificateEncodingException certificateEncodingException) {
                        return false;
                    }
                }
                certificateCheckerInterface.checkCertificate(byArrayArray);
            }
            catch (SecurityException securityException) {
                return false;
            }
        }
        return true;
    }

    public class Checker
    extends ChainVerifier {
        private CertificateCheckerInterface certChecker;

        public Checker(String string) throws NetworkException {
            if (string == null) {
                this.certChecker = new AcceptNoneCertificateChecker();
            } else {
                try {
                    this.certChecker = (CertificateCheckerInterface)Class.forName(string).newInstance();
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw NetMessage.Message.getSSLNetworkException(classNotFoundException.getMessage(), 7934);
                }
                catch (InstantiationException instantiationException) {
                    throw NetMessage.Message.getSSLNetworkException(instantiationException.getMessage(), 7934);
                }
                catch (IllegalAccessException illegalAccessException) {
                    throw NetMessage.Message.getSSLNetworkException(illegalAccessException.getMessage(), 7934);
                }
            }
        }

        public boolean verifyChain(X509Certificate[] x509CertificateArray, SSLTransport sSLTransport) {
            return IAIKSSLEndPoint.this.checkServerCertificate(x509CertificateArray, this.certChecker);
        }

        public CertificateCheckerInterface getCertificateChecker() {
            return this.certChecker;
        }
    }
}

