/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.util;

import com.metamatrix.util.UtilDataProvider;
import com.metamatrix.util.UtilException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.net.Socket;

public class UtilSocketDataProvider
implements UtilDataProvider {
    private static String footprint = "$Revision:   3.8.1.0  $";
    private Socket sourceSocket;
    int numBytesReturned = 1024;
    private InputStream socketInputStream = null;
    private int timeoutPeriodForReads;

    public UtilSocketDataProvider(Socket socket) {
        this.sourceSocket = socket;
        this.timeoutPeriodForReads = 0;
    }

    private InputStream getSocketInputStream() throws IOException {
        if (this.socketInputStream == null) {
            this.socketInputStream = this.sourceSocket.getInputStream();
        }
        return this.socketInputStream;
    }

    public void setTimeoutValue(int n) {
        this.timeoutPeriodForReads = n;
    }

    public int getTimeoutValue() {
        return this.timeoutPeriodForReads;
    }

    public byte getByte() throws UtilException {
        try {
            int n = this.getSocketInputStream().read();
            if (n == -1) {
                throw new UtilException(1002);
            }
            return (byte)n;
        }
        catch (InterruptedIOException interruptedIOException) {
            throw new UtilException(1029);
        }
        catch (IOException iOException) {
            throw new UtilException(1018, iOException.getMessage());
        }
    }

    public int getArrayOfBytes(byte[] byArray, int n, int n2) throws UtilException {
        if (n2 <= 0) {
            return 0;
        }
        try {
            this.numBytesReturned = this.getSocketInputStream().read(byArray, n, n2);
            if (this.numBytesReturned == -1) {
                throw new UtilException(1002);
            }
            return this.numBytesReturned;
        }
        catch (InterruptedIOException interruptedIOException) {
            throw new UtilException(1029);
        }
        catch (IOException iOException) {
            throw new UtilException(1018, iOException.getMessage());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void empty() throws UtilException {
        byte[] byArray = new byte[1024];
        boolean bl = true;
        try {
            if (this.sourceSocket.getInputStream().available() <= 0) return;
            while (bl) {
                if (this.numBytesReturned != 1024) return;
                try {
                    this.getArrayOfBytes(byArray, 0, byArray.length);
                }
                catch (UtilException utilException) {
                    if (utilException.getReason() != 1001) throw utilException;
                    return;
                }
            }
            return;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void receive() throws UtilException {
    }

    public boolean moreUnbufferedDataToReturn() {
        return true;
    }

    public void reset() {
    }
}

