/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.jdbc.oracle.tns;

import com.metamatrix.jdbc.oracle.tns.TnsAddress;
import com.metamatrix.jdbc.oracle.tns.TnsAddressList;
import com.metamatrix.jdbc.oracle.tns.TnsConnectData;
import com.metamatrix.jdbc.oracle.tns.TnsConnectDescriptor;
import com.metamatrix.jdbc.oracle.tns.TnsValueInfo;
import java.util.ArrayList;

public class TnsDescription {
    private static String footprint = "$Revision:   1.1.3.0  $";
    private boolean m_failover = true;
    private boolean m_loadBalance = false;
    private boolean m_sourceRoute = false;
    private int m_sdu = 2048;
    private ArrayList m_addressList = new ArrayList();
    private TnsConnectData m_connectData;
    private String m_typeOfService;

    TnsDescription(TnsValueInfo tnsValueInfo) {
        ArrayList arrayList = tnsValueInfo.getValues();
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            Object object;
            TnsValueInfo tnsValueInfo2 = new TnsValueInfo((String)arrayList.get(i));
            if (tnsValueInfo2.Equals("ADDRESS")) {
                object = new TnsAddress(tnsValueInfo2);
                this.m_addressList.add(object);
                continue;
            }
            if (tnsValueInfo2.Equals("CONNECT_DATA")) {
                this.m_connectData = new TnsConnectData(tnsValueInfo2);
                continue;
            }
            if (tnsValueInfo2.Equals("ADDRESS_LIST")) {
                object = new TnsAddressList(tnsValueInfo2);
                this.m_addressList.add(object);
                continue;
            }
            if (tnsValueInfo2.Equals("FAILOVER")) {
                this.m_failover = tnsValueInfo2.getBoolValue();
                continue;
            }
            if (tnsValueInfo2.Equals("LOAD_BALANCE")) {
                this.m_loadBalance = tnsValueInfo2.getBoolValue();
                continue;
            }
            if (tnsValueInfo2.Equals("SOURCE_ROUTE")) {
                this.m_sourceRoute = tnsValueInfo2.getBoolValue();
                continue;
            }
            if (tnsValueInfo2.Equals("SDU")) {
                this.m_sdu = Integer.parseInt(tnsValueInfo2.getValue());
                continue;
            }
            if (!tnsValueInfo2.Equals("TYPE_OF_SERVICE")) continue;
            this.m_typeOfService = tnsValueInfo2.getValue();
        }
    }

    public boolean getFailover() {
        return this.m_failover;
    }

    public boolean getLoadBalance() {
        return this.m_loadBalance;
    }

    public ArrayList getAddressList() {
        return this.m_addressList;
    }

    public boolean getSourceRoute() {
        return this.m_sourceRoute;
    }

    public TnsConnectData getConnectData() {
        return this.m_connectData;
    }

    public int getSDU() {
        return this.m_sdu;
    }

    public String getTypeOfService() {
        return this.m_typeOfService;
    }

    public TnsAddress getFirstTCPAddress() {
        int n = this.m_addressList.size();
        for (int i = 0; i < n; ++i) {
            TnsAddressList tnsAddressList;
            TnsAddress tnsAddress;
            Object e = this.m_addressList.get(i);
            if (!(e instanceof TnsAddressList ? (tnsAddress = (tnsAddressList = (TnsAddressList)e).GetFirstTCPAddress()) != null : (tnsAddress = (TnsAddress)e).getProtocol() == TnsAddress.TNSPROTOCOL_TCP)) continue;
            return tnsAddress;
        }
        return null;
    }

    void CollectConnectDescriptors(int n, ArrayList arrayList) {
        if (this.m_sourceRoute) {
            return;
        }
        int n2 = 0;
        int n3 = 0;
        if (this.m_loadBalance) {
            n2 = n % this.m_addressList.size();
        }
        int n4 = n2;
        do {
            Object object;
            Object e = this.m_addressList.get(n4);
            int n5 = arrayList.size();
            if (e instanceof TnsAddressList) {
                object = (TnsAddressList)e;
                ((TnsAddressList)object).CollectConnectDescriptors(n, this.m_connectData, arrayList);
            } else {
                object = (TnsAddress)e;
                if (((TnsAddress)object).getProtocol() == TnsAddress.TNSPROTOCOL_TCP) {
                    arrayList.add(new TnsConnectDescriptor((TnsAddress)object, this.m_connectData));
                }
            }
            if (!this.m_failover && n5 != arrayList.size()) break;
            if (n4 + 1 == this.m_addressList.size()) {
                n4 = 0;
                continue;
            }
            ++n4;
        } while (++n3 < this.m_addressList.size());
    }
}

