/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.util;

import com.metamatrix.util.UtilException;
import com.metamatrix.util.UtilSnoopIndirection;
import java.net.Socket;
import java.net.UnknownHostException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Properties;

public class UtilSocketCreator {
    private static String footprint = "$Revision:   3.6.1.0  $";
    public static final int DEFAULT_NUM_RETRIES = 5;
    public static final int DEFAULT_SLEEP_INTERVAL = 20;

    public static final Socket getSocket(String string, int n, Properties properties) throws UtilException {
        Socket socket = null;
        try {
            final String string2 = string;
            final int n2 = n;
            socket = (Socket)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws UtilException {
                    return UtilSocketCreator.createSocket(string2, n2);
                }
            });
            if (properties != null) {
                socket = UtilSnoopIndirection.createSocket(socket, properties);
            }
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw (UtilException)privilegedActionException.getException();
        }
        return socket;
    }

    public static final Socket createSocket(String string, int n) throws UtilException {
        Socket socket = null;
        try {
            socket = new Socket(string, n);
        }
        catch (UnknownHostException unknownHostException) {
            String[] stringArray = new String[]{string};
            throw new UtilException(1021, stringArray);
        }
        catch (Exception exception) {
            String[] stringArray = new String[]{string, String.valueOf(n), exception.getMessage()};
            throw new UtilException(1020, stringArray);
        }
        return socket;
    }
}

