/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.util;

import com.metamatrix.util.UtilBufferedDataQueue;
import com.metamatrix.util.UtilDataProvider;
import com.metamatrix.util.UtilException;

public class UtilIntelligentBufferingDataProvider
implements UtilDataProvider {
    static String footprint = "$Revision:   3.2.4.0  $";
    int buffSizeInKb;
    UtilDataProvider dataProvider;
    UtilBufferedDataQueue buffer;
    private byte[] staticByteArray = new byte[1];
    private byte[] pushedBytes;
    private int numPushedBytes;
    static final int pushedBytesArrayIncrementSize = 10;

    public UtilIntelligentBufferingDataProvider(UtilDataProvider utilDataProvider, int n) {
        this.buffSizeInKb = n;
        this.dataProvider = utilDataProvider;
        this.buffer = null;
        this.pushedBytes = null;
    }

    public void pushByte(byte by) throws UtilException {
        if (this.pushedBytes == null) {
            this.pushedBytes = new byte[10];
            this.numPushedBytes = 0;
        } else if (this.numPushedBytes == this.pushedBytes.length) {
            byte[] byArray = new byte[this.numPushedBytes + 10];
            System.arraycopy(this.pushedBytes, 0, byArray, 0, this.numPushedBytes);
            this.pushedBytes = byArray;
        }
        this.pushedBytes[this.numPushedBytes++] = by;
    }

    public boolean bufferAllData() throws UtilException {
        if (!this.moreUnbufferedDataToReturn()) {
            return true;
        }
        if (this.buffer == null) {
            this.buffer = new UtilBufferedDataQueue(this.buffSizeInKb);
        }
        return this.buffer.bufferAllData(this.dataProvider);
    }

    public byte getByte() throws UtilException {
        if (this.numPushedBytes > 0) {
            return this.pushedBytes[--this.numPushedBytes];
        }
        if (this.buffer != null && this.buffer.numBufferedBytes() > 0) {
            this.buffer.read(this.staticByteArray, 0, 1);
            return this.staticByteArray[0];
        }
        return this.dataProvider.getByte();
    }

    public int getArrayOfBytes(byte[] byArray, int n, int n2) throws UtilException {
        int n3;
        block7: {
            int n4;
            if (n2 <= 0) {
                return 0;
            }
            n3 = 0;
            if (this.numPushedBytes > 0) {
                n4 = Math.min(n2, this.numPushedBytes);
                int n5 = 0;
                while (n5 < n4) {
                    byArray[n + n5] = this.pushedBytes[--this.numPushedBytes];
                    ++n5;
                }
                n2 -= n4;
                n += n4;
            }
            if (n2 > 0 && this.buffer != null && this.buffer.numBufferedBytes() > 0) {
                n3 += this.buffer.read(byArray, n, n2);
                n2 -= n3;
            }
            if (n2 > 0) {
                n4 = 0;
                try {
                    n4 = this.dataProvider.getArrayOfBytes(byArray, n + n3, n2);
                    n3 += n4;
                }
                catch (UtilException utilException) {
                    if (utilException.getReason() == 1001 && n3 != 0) break block7;
                    throw utilException;
                }
            }
        }
        return n3;
    }

    public void empty() throws UtilException {
        if (this.buffer != null) {
            this.buffer.empty();
        }
        this.numPushedBytes = 0;
        this.dataProvider.empty();
    }

    public void receive() throws UtilException {
        this.dataProvider.receive();
    }

    public boolean moreUnbufferedDataToReturn() {
        return this.dataProvider.moreUnbufferedDataToReturn();
    }
}

