/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.jdbc.base;

import com.metamatrix.jdbc.base.BaseExceptions;
import com.metamatrix.jdbc.base.BaseImplBlob;
import com.metamatrix.util.UtilException;
import com.metamatrix.util.UtilPagedTempBuffer;
import java.io.InputStream;
import java.sql.SQLException;

public class BaseImplBlobEmulated
extends BaseImplBlob {
    private static String footprint = "$Revision:   1.3.1.0  $";
    private UtilPagedTempBuffer blobData;

    public BaseImplBlobEmulated(BaseExceptions baseExceptions, UtilPagedTempBuffer utilPagedTempBuffer) throws SQLException {
        super(baseExceptions);
        this.blobData = utilPagedTempBuffer;
    }

    public BaseImplBlobEmulated(BaseExceptions baseExceptions, InputStream inputStream) throws SQLException {
        super(baseExceptions);
        try {
            this.blobData = new UtilPagedTempBuffer(2048);
            int n = 1024;
            byte[] byArray = new byte[n];
            int n2 = inputStream.read(byArray);
            long l = 0L;
            while (n2 != -1) {
                this.blobData.write(l, byArray, 0, n2);
                l += (long)n2;
                n2 = inputStream.read(byArray);
            }
        }
        catch (Exception exception) {
            throw baseExceptions.getException(exception);
        }
    }

    public boolean supportsSearch() {
        return true;
    }

    public long find(byte[] byArray, long l) throws SQLException {
        long l2 = this.getLength();
        long l3 = l - 1L;
        int n = byArray.length;
        int n2 = 0;
        long l4 = l3;
        try {
            while (n2 < n) {
                byte by;
                byte by2;
                if (l3 == l2) {
                    return -1L;
                }
                if ((by2 = byArray[n2++]) == (by = this.blobData.read(l3++))) continue;
                n2 = 0;
                by2 = byArray[n2++];
                l3 = l4 + 1L;
                do {
                    if (l3 != l2) continue;
                    return -1L;
                } while (by2 != (by = this.blobData.read(l3++)));
                l4 = l3 - 1L;
            }
        }
        catch (Exception exception) {
            throw this.exceptions.getException(exception);
        }
        return l4 + 1L;
    }

    public int readData(byte[] byArray, int n, long l, int n2) throws SQLException {
        try {
            return this.blobData.read(l - 1L, byArray, n, n2);
        }
        catch (UtilException utilException) {
            throw this.exceptions.getException(utilException);
        }
    }

    public int writeData(long l, byte[] byArray, int n, int n2) throws SQLException {
        try {
            return this.blobData.write(l - 1L, byArray, n, n2);
        }
        catch (UtilException utilException) {
            throw this.exceptions.getException(utilException);
        }
    }

    public void truncate(long l) throws SQLException {
        try {
            this.blobData.truncate(l);
        }
        catch (UtilException utilException) {
            throw this.exceptions.getException(utilException);
        }
    }

    public long getLength() throws SQLException {
        return this.blobData.getSize();
    }

    public void close() throws SQLException {
        try {
            this.blobData.truncate(true);
        }
        catch (UtilException utilException) {
            throw this.exceptions.getException(utilException);
        }
    }
}

