/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.jdbc.db2;

import com.metamatrix.jdbc.base.BaseConnection;
import com.metamatrix.jdbc.base.BaseImplClob;
import com.metamatrix.jdbc.base.BaseParameter;
import com.metamatrix.jdbc.base.BaseParameters;
import com.metamatrix.jdbc.db2.DB2ImplConnection;
import com.metamatrix.jdbc.db2.DB2ImplResultSet;
import com.metamatrix.jdbc.db2.drda.DRDAByteOrderedDataReader;
import com.metamatrix.jdbc.db2.drda.DRDAParameter;
import com.metamatrix.jdbc.db2.drda.DRDAPkgNamCsn;
import com.metamatrix.jdbc.db2.drda.DRDAQueryStatementRequest;
import com.metamatrix.jdbc.db2.drda.DRDAUtil;
import com.metamatrix.util.UtilException;
import com.metamatrix.util.UtilPagedTempBuffer;
import com.metamatrix.util.UtilTransliterator;
import java.io.BufferedReader;
import java.io.Reader;
import java.sql.SQLException;

public class DB2ImplClob
extends BaseImplClob {
    private static String footprint = "$Revision:   3.10.1.0  $";
    private static final int MAX_CLOB_SIZE = Integer.MAX_VALUE;
    private static final int MAX_EMULATED_CLOB_SIZE = 32700;
    private long maxClobSize;
    private boolean byteSwapped = false;
    private boolean isEmulatedClob = false;
    public UtilPagedTempBuffer clobData;
    private DRDAUtil drdaUtil;
    private byte[] locator;
    public UtilTransliterator clobTransliterator;
    DB2ImplConnection con;
    DB2ImplResultSet results;

    public DB2ImplClob(byte[] byArray, DB2ImplConnection dB2ImplConnection, UtilTransliterator utilTransliterator) throws SQLException {
        super(dB2ImplConnection.exceptions);
        this.locator = byArray;
        this.con = dB2ImplConnection;
        this.clobTransliterator = utilTransliterator;
        this.maxClobSize = Integer.MAX_VALUE;
        this.initClobDataUsingLocator();
    }

    public DB2ImplClob(DB2ImplConnection dB2ImplConnection, UtilPagedTempBuffer utilPagedTempBuffer, UtilTransliterator utilTransliterator) throws SQLException {
        super(dB2ImplConnection.exceptions);
        this.locator = null;
        this.con = dB2ImplConnection;
        this.clobTransliterator = utilTransliterator;
        this.maxClobSize = Integer.MAX_VALUE;
        this.clobData = utilPagedTempBuffer;
    }

    public DB2ImplClob(Reader reader, DB2ImplConnection dB2ImplConnection) throws SQLException {
        super(dB2ImplConnection.exceptions);
        this.drdaUtil = new DRDAUtil(dB2ImplConnection.comm);
        this.con = dB2ImplConnection;
        this.isEmulatedClob = true;
        this.maxClobSize = 32700L;
        this.initEmulatedClobData(reader);
    }

    private void initEmulatedClobData(Reader reader) throws SQLException {
        long l = 0L;
        BufferedReader bufferedReader = new BufferedReader(reader);
        int n = 0;
        char[] cArray = new char[8192];
        this.clobData = new UtilPagedTempBuffer();
        try {
            while (n != -1) {
                n = bufferedReader.read(cArray, 0, 8192);
                if (n == -1) continue;
                l += (long)this.clobData.write(l, this.drdaUtil.UCS2CharsToBytes(cArray, n));
            }
        }
        catch (Exception exception) {
            throw this.con.exceptions.getException(exception);
        }
    }

    private void initClobDataUsingLocator() throws SQLException {
        String string = "SELECT CAST (? AS CLOB(2147483647)) FROM SYSIBM.SYSDUMMY1 FOR FETCH ONLY";
        string = "SELECT CAST (? AS CLOB(2147483647)) FROM SYSIBM.SYSDUMMY1 FOR FETCH ONLY";
        DRDAByteOrderedDataReader dRDAByteOrderedDataReader = this.con.comm.createReader();
        dRDAByteOrderedDataReader.setToBigEndian();
        BaseParameters baseParameters = new BaseParameters(1, this.con.exceptions, (BaseConnection)this.con.db2Connection);
        BaseParameter baseParameter = new BaseParameter(2005, 2, this.locator, this.con.db2Connection);
        baseParameters.set(1, 1, baseParameter);
        DRDAParameter dRDAParameter = new DRDAParameter(baseParameter, 26, 4, 0, false);
        dRDAParameter.isLobLocator = true;
        int n = this.con.comm.packageManager.getAvailableSectionNumber(false, false);
        String string2 = this.con.comm.packageManager.getPackageName(false);
        DRDAPkgNamCsn dRDAPkgNamCsn = new DRDAPkgNamCsn(this.con.databaseName, this.con.collectionId, string2, n, null);
        DRDAQueryStatementRequest dRDAQueryStatementRequest = new DRDAQueryStatementRequest(this.con, this.con.comm, dRDAByteOrderedDataReader, this.con.dataWriter, dRDAPkgNamCsn);
        dRDAQueryStatementRequest.setParameters(baseParameters);
        dRDAQueryStatementRequest.chainCommit = false;
        dRDAQueryStatementRequest.lobLocParam = dRDAParameter;
        dRDAQueryStatementRequest.writePRPSQLSTT(string, true, false);
        dRDAQueryStatementRequest.openQuery(this.con.warnings, false, (short)2);
        dRDAQueryStatementRequest.submitRequest();
        dRDAQueryStatementRequest.processMode = 1;
        dRDAQueryStatementRequest.processReply(this.con.warnings);
        this.results = new DB2ImplResultSet(dRDAQueryStatementRequest, this.con.comm);
        this.results.request.useOUTOVRlob = false;
        this.results.fetchAtPosition(0);
        long l = this.results.getData(1, 5).getLong(this.con.exceptions);
        if (l == 0L) {
            this.clobData = new UtilPagedTempBuffer();
        } else {
            this.results.request.discardReplyBytes();
            this.results.request.continueQuery(this.con.warnings);
            dRDAQueryStatementRequest.submitRequest();
            dRDAQueryStatementRequest.processReply(this.con.warnings);
            this.clobData = dRDAQueryStatementRequest.lobBuffer;
        }
        dRDAQueryStatementRequest.discardReplyBytes();
        this.results.close();
        this.con.comm.packageManager.markThisSectionNumber(dRDAPkgNamCsn, -1);
    }

    public void setIsEmulatedClob(boolean bl) {
        this.isEmulatedClob = bl;
    }

    public boolean getIsEmulatedClob() {
        return this.isEmulatedClob;
    }

    public UtilPagedTempBuffer getData() {
        return this.clobData;
    }

    public long getLength() throws SQLException {
        return this.clobData.getSize() / 2L;
    }

    public void close() throws SQLException {
        try {
            this.clobData.truncate(true);
        }
        catch (UtilException utilException) {
            throw this.con.exceptions.getException(utilException);
        }
        this.clobData = null;
    }

    public int getCharacterEncoding() {
        return 2;
    }

    public int readData(byte[] byArray, int n, long l, int n2) throws SQLException {
        try {
            int n3 = this.clobData.read((l - 1L) * 2L, byArray, n, n2 * 2);
            if (this.byteSwapped) {
                int n4 = 0;
                while (n4 < n3) {
                    byte by = byArray[n + n4];
                    byArray[n + n4] = byArray[n + n4 + 1];
                    byArray[n + n4 + 1] = by;
                    n4 += 2;
                }
            }
            return n3;
        }
        catch (Exception exception) {
            throw this.exceptions.getException(exception);
        }
    }

    public int writeData(long l, byte[] byArray, int n, int n2) throws SQLException {
        try {
            if (this.byteSwapped) {
                int n3 = 0;
                int n4 = n2 * 2;
                while (n3 < n4) {
                    this.clobData.write((l - 1L) * 2L + (long)n3, byArray, n + n3 + 1, 1);
                    this.clobData.write((l - 1L) * 2L + (long)n3 + 1L, byArray, n + n3, 1);
                    n3 += 2;
                }
                return n3 / 2;
            }
            return this.clobData.write((l - 1L) * 2L, byArray, n, n2 * 2) / 2;
        }
        catch (UtilException utilException) {
            throw this.exceptions.getException(utilException);
        }
    }

    public boolean supportsSearch() {
        return true;
    }

    public long find(String string, long l) throws SQLException {
        long l2 = this.getLength() * 2L;
        long l3 = (l - 1L) * 2L;
        long l4 = string.length();
        long l5 = 0L;
        byte[] byArray = new byte[2];
        long l6 = l3;
        try {
            while (l5 < l4) {
                byte by;
                if (l3 == l2) {
                    return -1L;
                }
                char c = string.charAt((int)l5++);
                this.clobData.read(l3, byArray, 0, 2);
                if (this.byteSwapped) {
                    by = byArray[0];
                    byArray[0] = byArray[1];
                    byArray[1] = by;
                }
                l3 += 2L;
                char c2 = (char)(((byArray[0] & 0xFF) << 8) + ((byArray[1] & 0xFF) << 0));
                if (c == c2) continue;
                l5 = 0L;
                c = string.charAt((int)l5++);
                l3 = l6 + 2L;
                do {
                    if (l3 >= l2) {
                        return -1L;
                    }
                    this.clobData.read(l3, byArray, 0, 2);
                    if (this.byteSwapped) {
                        by = byArray[0];
                        byArray[0] = byArray[1];
                        byArray[1] = by;
                    }
                    l3 += 2L;
                } while (c != (c2 = (char)(((byArray[0] & 0xFF) << 8) + ((byArray[1] & 0xFF) << 0))));
                l6 = l3 - 2L;
            }
        }
        catch (Exception exception) {
            throw this.exceptions.getException(exception);
        }
        return l6 / 2L + 1L;
    }

    public void truncate(long l) throws SQLException {
        try {
            this.clobData.truncate(l * 2L);
        }
        catch (UtilException utilException) {
            throw this.exceptions.getException(utilException);
        }
    }
}

