/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.jdbc.base;

import com.metamatrix.jdbc.base.BaseExceptions;
import com.metamatrix.jdbc.base.BaseSQLTreeNode;
import com.metamatrix.jdbc.base.BaseSQLTreePreOrderTraverser;
import com.metamatrix.jdbc.base.BaseSQLTreeTraversalVisitor;
import java.sql.SQLException;
import java.util.StringTokenizer;

public class BaseSQLStringGenerator
implements BaseSQLTreeTraversalVisitor {
    private static String footprint = "$Revision:   3.1.1.1  $";
    private boolean findVerbOnly;
    private boolean whereZeroEqualOne;
    int skipUntilBackToLevel = -1;
    private StringBuffer SQL;

    public String generateSQL(BaseSQLTreeNode baseSQLTreeNode, boolean bl, BaseExceptions baseExceptions) throws SQLException {
        BaseSQLTreePreOrderTraverser baseSQLTreePreOrderTraverser = new BaseSQLTreePreOrderTraverser();
        this.findVerbOnly = bl;
        this.SQL = new StringBuffer();
        baseSQLTreePreOrderTraverser.setExceptions(baseExceptions);
        baseSQLTreePreOrderTraverser.setVisitor(this);
        baseSQLTreePreOrderTraverser.traverse(baseSQLTreeNode);
        if (bl) {
            StringTokenizer stringTokenizer = new StringTokenizer(this.SQL.toString(), " \t\n\r\f(");
            String string = stringTokenizer.nextToken();
            if (string.toUpperCase().startsWith("SELECT")) {
                string = "select";
            } else if (string.toUpperCase().startsWith("CREATE")) {
                string = string + " " + stringTokenizer.nextToken();
            }
            return string;
        }
        return this.SQL.toString();
    }

    public String generateSQLWhereZeroEqualOne(BaseSQLTreeNode baseSQLTreeNode, BaseExceptions baseExceptions) throws SQLException {
        this.whereZeroEqualOne = true;
        return this.generateSQL(baseSQLTreeNode, false, baseExceptions);
    }

    public boolean visit(BaseSQLTreeNode baseSQLTreeNode, int n) throws SQLException {
        boolean bl = true;
        if (this.whereZeroEqualOne) {
            if (baseSQLTreeNode.type == 1009 && this.skipUntilBackToLevel == -1) {
                this.SQL.append(" where 0 = 1 ");
                this.skipUntilBackToLevel = n;
            } else {
                if (this.skipUntilBackToLevel >= n) {
                    this.skipUntilBackToLevel = -1;
                }
                if (this.skipUntilBackToLevel == -1 && baseSQLTreeNode.value != null) {
                    this.SQL.append(baseSQLTreeNode.value);
                }
            }
        } else if (baseSQLTreeNode.value != null) {
            this.SQL.append(baseSQLTreeNode.value);
        }
        if (this.findVerbOnly && baseSQLTreeNode.value != null && baseSQLTreeNode.type != 1020 && !baseSQLTreeNode.value.equalsIgnoreCase("create") && !baseSQLTreeNode.value.equalsIgnoreCase("(")) {
            bl = false;
        }
        return bl;
    }
}

