#!/bin/ksh
JAVA_BIN=
MM_JAVA=
MM_ROOT=
ROOT=

noJREFound() {
   echo "                                                                      "
   echo "!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!"
   echo "                                                                      "
   echo "The update utility was unable to locate a JRE.  Please verify the     "
   echo "path specified is the full path to a MetaMatrix installed component   "
   echo "or a valid JRE root directory.                                        "
   echo "                                                                      "
   echo "If you continue to have problems, please execute the tool directly    "
   echo "using the following form:                                             "
   echo "                                                                      "
   echo "java -jar tzupdater.jar -u                                            "
   echo "                                                                      "
   echo "The above command will update the time zone information for the JRE   "
   echo "that the java binary was executed from.                               "
   echo "                                                                      "
   exit 1
}

testFailed() {
   echo "                                                                      "
   echo "!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!"
   echo "                                                                      "
   echo "Time zone validation test failed for this version of the updater.     "
   echo "Please review any warnings or error messages above.                   "
   exit 1
}

echo "                                                                      "
echo "This utility is intended for use with the MetaMatrix installed        "
echo "JRE/JDK.  This utility can be used with MetaMatrix Server, MetaMatrix "
echo "Designer, MetaMatrix Modeler, MetaMatrix Console, and MetaMatrix CDK  "
echo "installation.  This utility can also be used to upgrade a JRE/JDK by  "
echo "specifying the home or root directory of the target JRE/JDK.          "
echo "                                                                      "
echo "Please note, this utility assumes that you are using the default      "
echo "recommended directory structure provided for each installed           "
echo "MetaMatrix component.                                                 "
echo "                                                                      "
echo "Enter the complete path to the root MetaMatrix installation           "
printf "directory [press ENTER to exit]: "
read ROOT

[ -z "$ROOT" ] && exit

if [ -f "$ROOT/bin/mmenv.sh" ]; then
   curDir=`pwd`
   cd "$ROOT/bin"
   . ./mmenv.sh > /dev/null
   cd "$curDir"
   curDir=
   if [ ! -z "$MM_JAVA_BIN" ]; then
      JAVA_BIN=$MM_JAVA_BIN/java
   elif [ ! -z "$MM_JAVA" ]; then
      JAVA_BIN=$MM_JAVA/bin/java
   fi
fi

if [ -f "$ROOT/bin/mmtoolsenv.sh" ]; then
   curDir=`pwd`
   cd "$ROOT/bin"
   . ./mmtoolsenv.sh > /dev/null
   cd "$curDir"
   curDir=
   if [ ! -z "$MM_JAVA" ]; then
      JAVA_BIN=$MM_JAVA/bin/java
   fi
fi

[ -f "$ROOT/eclipse/startup.jar" ] && JAVA_BIN=$ROOT/eclipse/jre/bin/java

[ -f "$ROOT/jre/bin/java" ] && JAVA_BIN=$ROOT/jre/bin/java

[ -f "$ROOT/bin/java" ] && JAVA_BIN=$ROOT/bin/java

[ -z "$JAVA_BIN" ] && noJREFound

[ ! -f "$JAVA_BIN" ] && noJREFound

echo "                                                                      "
echo "Using ${JAVA_BIN}...                                                  "
"$JAVA_BIN" -version
echo "                                                                      "
if [ ! -z "$1" ]; then
   echo "Running update tool using options $*                                  "   
   "$JAVA_BIN" -jar tzupdater.jar $*
   [ "$?" -gt 0 ] && testFailed
   echo "                                                                      "
   echo "Update command completed successfully.                                "
else
   echo "Applying update...                                                    "
   "$JAVA_BIN" -jar tzupdater.jar -u
   echo "                                                                      "
   echo "Performing validation tests...                                        "
   "$JAVA_BIN" -jar tzupdater.jar -t
   [ "$?" -gt 0 ] && testFailed
   echo "                                                                      "
   echo "Updates applied successfully.                                         "
fi

echo "                                                                      "
exit 0