/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.jdbcx.base;

import com.metamatrix.jdbcx.base.BaseDependent;
import java.lang.ref.WeakReference;
import java.util.Iterator;
import java.util.LinkedList;

public class BaseDependents {
    private static String footprint = "$Revision:   3.1.2.0  $";
    private LinkedList list = new LinkedList();
    private boolean hasGarbage;

    public void notifyGarbage() {
        this.hasGarbage = true;
    }

    public synchronized void add(BaseDependent baseDependent) {
        this.cleanupNullObjects();
        if (baseDependent == null) {
            return;
        }
        WeakReference<BaseDependent> weakReference = new WeakReference<BaseDependent>(baseDependent);
        this.list.add(weakReference);
    }

    public synchronized void remove(BaseDependent baseDependent) {
        this.cleanupNullObjects();
        Iterator iterator = this.list.iterator();
        while (iterator.hasNext()) {
            WeakReference weakReference = (WeakReference)iterator.next();
            BaseDependent baseDependent2 = (BaseDependent)weakReference.get();
            if (baseDependent2 == null) {
                iterator.remove();
                continue;
            }
            if (baseDependent2 != baseDependent) continue;
            iterator.remove();
            break;
        }
    }

    public synchronized void doClose() {
        Iterator iterator = this.list.iterator();
        while (iterator.hasNext()) {
            WeakReference weakReference = (WeakReference)iterator.next();
            BaseDependent baseDependent = (BaseDependent)weakReference.get();
            if (baseDependent == null) continue;
            baseDependent.doClose();
        }
    }

    public synchronized BaseDependent getDependent(Object object) {
        Iterator iterator = this.list.iterator();
        while (iterator.hasNext()) {
            WeakReference weakReference = (WeakReference)iterator.next();
            BaseDependent baseDependent = (BaseDependent)weakReference.get();
            if (baseDependent == null || baseDependent.realObject() != object) continue;
            return baseDependent;
        }
        return null;
    }

    public synchronized LinkedList getRealObjects() {
        LinkedList<Object> linkedList = new LinkedList<Object>();
        Iterator iterator = this.list.iterator();
        while (iterator.hasNext()) {
            WeakReference weakReference = (WeakReference)iterator.next();
            BaseDependent baseDependent = (BaseDependent)weakReference.get();
            if (baseDependent == null) continue;
            linkedList.add(baseDependent.realObject());
        }
        return linkedList;
    }

    private void cleanupNullObjects() {
        if (this.hasGarbage) {
            Iterator iterator = this.list.iterator();
            while (iterator.hasNext()) {
                WeakReference weakReference = (WeakReference)iterator.next();
                BaseDependent baseDependent = (BaseDependent)weakReference.get();
                if (baseDependent != null) continue;
                iterator.remove();
            }
        }
        this.hasGarbage = false;
    }
}

