/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.jdbc.base;

import com.metamatrix.jdbc.base.BaseMessages;
import java.sql.SQLException;
import java.sql.SQLWarning;

public final class BaseWarnings {
    private static String footprint = "$Revision:   3.3.1.0  $";
    private BaseMessages messages;
    private BaseWarning firstWarning;
    private BaseWarning lastWarning;

    public BaseWarnings(BaseMessages baseMessages) throws SQLException {
        this.messages = baseMessages;
        this.firstWarning = null;
        this.lastWarning = null;
    }

    public void add(int n, String[] stringArray, String string, int n2) {
        BaseWarning baseWarning = new BaseWarning(n, stringArray, string, new Integer(n2));
        this.addToList(baseWarning);
    }

    public void add(int n) {
        BaseWarning baseWarning = new BaseWarning(n, null, null, null);
        this.addToList(baseWarning);
    }

    public void add(int n, String[] stringArray) {
        BaseWarning baseWarning = new BaseWarning(n, stringArray, null, null);
        this.addToList(baseWarning);
    }

    public void add(int n, String[] stringArray, String string) {
        BaseWarning baseWarning = new BaseWarning(n, stringArray, string, null);
        this.addToList(baseWarning);
    }

    public void add(int n, String string) {
        BaseWarning baseWarning = new BaseWarning(n, null, string, null);
        this.addToList(baseWarning);
    }

    public void add(int n, String string, int n2) {
        BaseWarning baseWarning = new BaseWarning(n, null, string, new Integer(n2));
        this.addToList(baseWarning);
    }

    private void addToList(BaseWarning baseWarning) {
        if (null == this.firstWarning) {
            this.firstWarning = baseWarning;
        }
        if (null != this.lastWarning) {
            this.lastWarning.setNextWarning(baseWarning);
        }
        this.lastWarning = baseWarning;
    }

    public SQLWarning createSQLWarning(BaseWarning baseWarning) {
        SQLWarning sQLWarning = null;
        SQLWarning sQLWarning2 = null;
        boolean bl = true;
        while (baseWarning != null) {
            SQLWarning sQLWarning3 = null;
            String string = "";
            if (baseWarning.SQLstate != null) {
                string = baseWarning.SQLstate;
            }
            sQLWarning3 = baseWarning.vendorCode != null ? new SQLWarning(this.messages.getMessage(baseWarning.reasonKey, baseWarning.reasonArgs, true), string, baseWarning.vendorCode) : new SQLWarning(this.messages.getMessage(baseWarning.reasonKey, baseWarning.reasonArgs, false), string);
            if (bl) {
                sQLWarning2 = sQLWarning = sQLWarning3;
                bl = false;
            } else {
                sQLWarning2.setNextWarning(sQLWarning3);
                sQLWarning2 = sQLWarning3;
            }
            baseWarning = baseWarning.nextWarning;
        }
        return sQLWarning;
    }

    public SQLWarning get() {
        return this.createSQLWarning(this.firstWarning);
    }

    public SQLWarning getLast() {
        BaseWarning baseWarning = this.firstWarning;
        while (baseWarning.nextWarning != null) {
            baseWarning = baseWarning.nextWarning;
        }
        return this.createSQLWarning(baseWarning);
    }

    public void clear() {
        this.firstWarning = null;
        this.lastWarning = null;
    }

    private class BaseWarning {
        int reasonKey;
        String[] reasonArgs;
        String SQLstate;
        Integer vendorCode;
        BaseWarning nextWarning = null;

        public BaseWarning(int n, String[] stringArray, String string, Integer n2) {
            this.reasonKey = n;
            this.reasonArgs = stringArray;
            this.SQLstate = string;
            this.vendorCode = n2;
        }

        public void setNextWarning(BaseWarning baseWarning) {
            this.nextWarning = baseWarning;
        }
    }
}

