/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.jdbc.oracle;

import com.metamatrix.jdbc.base.BaseColumn;
import com.metamatrix.jdbc.base.BaseConnectionProperties;
import com.metamatrix.jdbc.base.BaseImplConnection;
import com.metamatrix.jdbc.base.BaseImplStatement;
import com.metamatrix.jdbc.base.BaseSQL;
import com.metamatrix.jdbc.oracle.OracleColumn;
import com.metamatrix.jdbc.oracle.OracleConnection;
import com.metamatrix.jdbc.oracle.OracleImplStatement;
import com.metamatrix.jdbc.oracle.net8.OracleNet8Communication;
import com.metamatrix.jdbc.oracle.net8.OracleNet8NSPTACPacket;
import com.metamatrix.jdbc.oracle.net8.OracleNet8NSPTCNPacket;
import com.metamatrix.jdbc.oracle.net8.OracleNet8NSPTDAPacket;
import com.metamatrix.jdbc.oracle.net8.OracleNet8NSPTRDPacket;
import com.metamatrix.jdbc.oracle.net8.OracleNet8NSPTRFPacket;
import com.metamatrix.jdbc.oracle.net8.TTIANODataPacket;
import com.metamatrix.jdbc.oracle.net8.TTIDCBDataPacket;
import com.metamatrix.jdbc.oracle.net8.TTIDTYDataPacket;
import com.metamatrix.jdbc.oracle.net8.TTIDataPacket;
import com.metamatrix.jdbc.oracle.net8.TTIFUNDataPacket;
import com.metamatrix.jdbc.oracle.net8.TTIFUN_O3LOG;
import com.metamatrix.jdbc.oracle.net8.TTIFUN_OALL8;
import com.metamatrix.jdbc.oracle.net8.TTIFUN_OAUTHENTICATE;
import com.metamatrix.jdbc.oracle.net8.TTIFUN_OCOMMIT;
import com.metamatrix.jdbc.oracle.net8.TTIFUN_OCOMOFF;
import com.metamatrix.jdbc.oracle.net8.TTIFUN_OCOMON;
import com.metamatrix.jdbc.oracle.net8.TTIFUN_OLOGOFF;
import com.metamatrix.jdbc.oracle.net8.TTIFUN_OROLLBACK;
import com.metamatrix.jdbc.oracle.net8.TTIFUN_OVERSION;
import com.metamatrix.jdbc.oracle.net8.TTIIOVDataPacket;
import com.metamatrix.jdbc.oracle.net8.TTIOERDataPacket;
import com.metamatrix.jdbc.oracle.net8.TTIPRODataPacket;
import com.metamatrix.jdbc.oracle.net8.TTIRXDDataPacket;
import com.metamatrix.jdbc.oracle.net8.TTIRXHDataPacket;
import com.metamatrix.jdbc.oracle.sec.C1;
import com.metamatrix.jdbc.oracle.tns.TnsCID;
import com.metamatrix.jdbc.oracle.tns.TnsConnectDescriptor;
import com.metamatrix.jdbc.oracle.tns.TnsDescriptionList;
import com.metamatrix.jdbc.oracle.tns.TnsFile;
import com.metamatrix.util.UtilDebug;
import com.metamatrix.util.UtilException;
import com.metamatrix.util.UtilSecurityContext;
import com.metamatrix.util.UtilSecurityContextCreator;
import com.metamatrix.util.UtilSocketCreator;
import com.metamatrix.util.UtilTransliterator;
import com.metamatrix.util.UtilTransliteratorForUTF8;
import java.net.Socket;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Hashtable;
import java.util.Properties;
import java.util.TimeZone;

public class OracleImplConnection
extends BaseImplConnection {
    private static String footprint = "$Revision:   3.83.1.14  $";
    public OracleConnection connection;
    UtilSecurityContext securityContext;
    public String authenticationMethodArg = null;
    public boolean useOSAuthentication;
    public boolean useClientAuthentication;
    public boolean useO3LOG;
    public String oracleServerVersionString = null;
    public long oracleServerVersion = 0L;
    public String user;
    public String database;
    protected int byteOrder;
    private boolean allowMaxFloat = false;
    private int numberPrecisionScaleOption = 0;
    private boolean sendFloatParametersAsString = false;
    private boolean supportLinks = false;
    public boolean useOAll7;
    public boolean describeAtPrepare = false;
    public boolean refCursorSupport = true;
    public boolean returnSynonyms;
    public boolean FetchTSWTZasTimestamp = false;
    private short m_cursorID;
    public OracleNet8Communication comm;
    public short currentOraCharset;
    public short originalReportedOraCharset;
    public short originalReportedOraNCharset = 0;
    UtilTransliterator transliterator = null;
    public boolean wireCSmatchesOracleCS = true;
    public TTIOERDataPacket gTTIoer;
    public OracleNet8NSPTDAPacket NSPTDAPacket;
    SQLException myException;
    public Hashtable procParamInfoHashtable = null;
    public int maxLengthOfVarcharParam;
    public int maxLengthOfVarcharParamForNCharset;
    public int maxLengthOfRawParam;
    public int maxLengthValueForStringParams;
    TnsCID cid = new TnsCID();
    public boolean japaneseAsUTF8;
    boolean alterStatementHasBeenIssued = false;
    String databaseTimeZone = null;
    String sessionTimeZone = null;
    int tzHours = 0;
    int tzMinutes = 0;
    static final int maxIntsRequiredForVNUConversion = 18;
    public int[] intBufferForVNUConversion = new int[18];
    public byte[][] byteBufferForVNUConversion = new byte[18][];
    public char[] charBufferForVNUConversion;
    public StringBuffer stringBufferForVNUConversion;

    public OracleImplConnection(OracleConnection oracleConnection) {
        int n = 0;
        while (n < 18) {
            this.byteBufferForVNUConversion[n] = new byte[(18 - n) * 3];
            ++n;
        }
        this.charBufferForVNUConversion = new char[150];
        this.stringBufferForVNUConversion = new StringBuffer(50);
        this.connection = oracleConnection;
        this.useOSAuthentication = false;
        this.useClientAuthentication = false;
        this.useO3LOG = false;
    }

    public boolean supportsQueryTimeout() {
        return false;
    }

    public Socket getQueryTimeoutSocket() {
        return this.comm.socket;
    }

    public boolean supportsCancel() {
        return true;
    }

    public boolean supportsSelectStarCommaColumn() {
        return false;
    }

    public String getUser() {
        return this.user;
    }

    public boolean getAllowMaxFloat() {
        return this.allowMaxFloat;
    }

    public int getNumberPrecisionScaleOption() {
        return this.numberPrecisionScaleOption;
    }

    public boolean getSendFloatParametersAsString() {
        return this.sendFloatParametersAsString;
    }

    public int getEmptyRowInsertSyntax() {
        return 3;
    }

    protected void startManualTransactionMode() throws SQLException {
        TTIFUN_OCOMOFF tTIFUN_OCOMOFF = new TTIFUN_OCOMOFF();
        this.NSPTDAPacket.appendTTISubPacket(tTIFUN_OCOMOFF);
        this.NSPTDAPacket.sendRequest();
        this.NSPTDAPacket.receiveReply();
        this.processReply(tTIFUN_OCOMOFF);
        if (this.gTTIoer.retCode != 0) {
            String[] stringArray = new String[]{this.gTTIoer.errMsg};
            this.myException = this.comm.exceptions.getException(6001, stringArray, this.gTTIoer.getSQLState(), this.gTTIoer.retCode);
            throw this.myException;
        }
    }

    protected int getTransactionIsolation() throws SQLException {
        return 2;
    }

    protected void setTransactionIsolation(int n) throws SQLException {
        String string;
        switch (n) {
            case 2: {
                string = "alter session set isolation_level = read committed";
                break;
            }
            case 8: {
                string = "alter session set isolation_level = serializable";
                break;
            }
            default: {
                throw this.exceptions.getException(7009, "HY024");
            }
        }
        TTIFUN_OALL8 tTIFUN_OALL8 = new TTIFUN_OALL8(this);
        tTIFUN_OALL8.setOptions(32801);
        tTIFUN_OALL8.setCommandText(string);
        tTIFUN_OALL8.setCursorID(this.m_cursorID);
        this.NSPTDAPacket.appendTTISubPacket(tTIFUN_OALL8);
        this.NSPTDAPacket.sendRequest();
        this.NSPTDAPacket.receiveReply();
        this.processReply(tTIFUN_OALL8);
        if (this.gTTIoer.retCode != 0) {
            String[] stringArray = new String[]{this.gTTIoer.errMsg};
            SQLException sQLException = this.comm.exceptions.getException(6001, stringArray, this.gTTIoer.getSQLState(), this.gTTIoer.retCode);
            throw sQLException;
        }
    }

    protected String getCatalog() throws SQLException {
        return "";
    }

    public void mergeAlternateConnectProps(BaseConnectionProperties baseConnectionProperties, BaseConnectionProperties baseConnectionProperties2) throws SQLException {
        String string;
        String string2;
        String string3;
        String string4;
        String string5;
        String string6;
        String string7;
        String string8 = baseConnectionProperties.get("serverName");
        if (string8 != null && string8.length() == 0) {
            string8 = null;
        }
        if ((string7 = baseConnectionProperties2.get("serverName")) != null && string7.length() == 0) {
            string7 = null;
        }
        if ((string6 = baseConnectionProperties.get("SID")) != null && string6.length() == 0) {
            string6 = null;
        }
        if ((string5 = baseConnectionProperties.get("serviceName")) != null && string5.length() == 0) {
            string5 = null;
        }
        if ((string4 = baseConnectionProperties.get("serverType")) != null && string4.length() == 0) {
            string4 = null;
        }
        if ((string3 = baseConnectionProperties.get("TNSNamesFile")) != null && string3.length() == 0) {
            string3 = null;
        }
        if ((string2 = baseConnectionProperties2.get("TNSNamesFile")) != null && string2.length() == 0) {
            string2 = null;
        }
        if ((string = baseConnectionProperties.get("TNSServerName")) != null && string.length() == 0) {
            string = null;
        }
        if (string6 != null) {
            if (string5 != null) {
                String[] stringArray = new String[]{"SID", "serviceName"};
                throw this.exceptions.getException(7026, stringArray, "08001");
            }
            baseConnectionProperties2.put("serviceName", null);
            if (string != null) {
                String[] stringArray = new String[]{"SID", "TNSServerName"};
                throw this.exceptions.getException(7026, stringArray, "08001");
            }
            baseConnectionProperties2.put("TNSServerName", null);
            if (string3 != null) {
                String[] stringArray = new String[]{"SID", "TNSNamesFile"};
                throw this.exceptions.getException(7026, stringArray, "08001");
            }
            baseConnectionProperties2.put("TNSNamesFile", null);
            if (string8 == null && string7 == null) {
                String[] stringArray = new String[]{"SID", "serverName"};
                throw this.exceptions.getException(7025, stringArray, "08001");
            }
        }
        if (string5 != null) {
            if (string != null) {
                String[] stringArray = new String[]{"serviceName", "TNSServerName"};
                throw this.exceptions.getException(7026, stringArray, "08001");
            }
            baseConnectionProperties2.put("TNSServerName", null);
            if (string3 != null) {
                String[] stringArray = new String[]{"serviceName", "TNSNamesFile"};
                throw this.exceptions.getException(7026, stringArray, "08001");
            }
            baseConnectionProperties2.put("TNSNamesFile", null);
            if (string8 == null && string7 == null) {
                String[] stringArray = new String[]{"serviceName", "serverName"};
                throw this.exceptions.getException(7025, stringArray, "08001");
            }
        }
        if (string != null) {
            if (string8 != null) {
                String[] stringArray = new String[]{"TNSServerName", "serverName"};
                throw this.exceptions.getException(7026, stringArray, "08001");
            }
            baseConnectionProperties2.put("serverName", null);
            if (string4 != null) {
                String[] stringArray = new String[]{"TNSServerName", "serverType"};
                throw this.exceptions.getException(7026, stringArray, "08001");
            }
            baseConnectionProperties2.put("serverType", null);
            if (string3 == null && string2 == null) {
                String[] stringArray = new String[]{"TNSServerName", "TNSNamesFile"};
                throw this.exceptions.getException(7025, stringArray, "08001");
            }
        }
        if (string3 != null) {
            if (string8 != null) {
                String[] stringArray = new String[]{"TNSNamesFile", "serverName"};
                throw this.exceptions.getException(7026, stringArray, "08001");
            }
            baseConnectionProperties2.put("serverName", null);
            if (string4 != null) {
                String[] stringArray = new String[]{"tnsNamesFile", "serverType"};
                throw this.exceptions.getException(7026, stringArray, "08001");
            }
            baseConnectionProperties2.put("serverType", null);
            if (string8 == null && string7 == null) {
                String[] stringArray = new String[]{"TNSNamesFile", "TNSServerName"};
                throw this.exceptions.getException(7025, stringArray, "08001");
            }
        }
        super.mergeAlternateConnectProps(baseConnectionProperties, baseConnectionProperties2);
    }

    private UtilSecurityContext createSecurityContext(String string, String string2, String string3) throws SQLException {
        try {
            if (string2.equalsIgnoreCase("type2")) {
                return UtilSecurityContextCreator.createType2SecurityContext(string3, 2);
            }
            if (string2.equalsIgnoreCase("type4")) {
                throw this.exceptions.getException(7037);
            }
            if (string2.equalsIgnoreCase("none")) {
                throw this.exceptions.getException(7035);
            }
            if (System.getProperty("os.name").startsWith("Windows")) {
                try {
                    return UtilSecurityContextCreator.createType2SecurityContext(string3, 2);
                }
                catch (UtilException utilException) {
                    return UtilSecurityContextCreator.createType4SecurityContext(string3);
                }
            }
            throw this.exceptions.getException(7037);
        }
        catch (UtilException utilException) {
            throw this.exceptions.getException(utilException);
        }
    }

    public void open() throws SQLException {
        String[] stringArray;
        Object object;
        block39: {
            this.user = this.connectProps.get("user");
            String string = this.connectProps.get("password");
            this.authenticationMethodArg = this.connectProps.get("authenticationMethod");
            String string2 = null;
            try {
                string2 = this.connectProps.get("allowMaxFloat");
            }
            catch (Exception exception) {
                // empty catch block
            }
            String string3 = null;
            try {
                string3 = this.connectProps.get("NumberPrecisionScale");
                if (Integer.parseInt(string3) == 1) {
                    this.numberPrecisionScaleOption = 1;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            String string4 = null;
            try {
                string4 = this.connectProps.get("describeAtPrepare");
                if (Integer.parseInt(string4) == 1) {
                    this.describeAtPrepare = true;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            String string5 = null;
            try {
                string5 = this.connectProps.get("supportLinks");
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (string5 != null && string5.equalsIgnoreCase("true")) {
                this.supportLinks = true;
            }
            String string6 = null;
            try {
                string6 = this.connectProps.get("WireProtocolMode");
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (string6 != null) {
                try {
                    this.useOAll7 = Integer.parseInt(string6) == 1;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            String string7 = null;
            try {
                string7 = this.connectProps.get("sendFloatParametersAsString");
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (string7 != null && string7.equalsIgnoreCase("true")) {
                this.sendFloatParametersAsString = true;
            }
            if (string2 != null && string2.equalsIgnoreCase("true")) {
                this.allowMaxFloat = true;
            }
            this.refCursorSupport = !this.connectProps.get("refCursorSupport").equalsIgnoreCase("false");
            this.FetchTSWTZasTimestamp = this.connectProps.get("FetchTSWTZasTimestamp").equalsIgnoreCase("true");
            try {
                this.connectAndAuthenticate(string, 1);
            }
            catch (Exception exception) {
                if (this.useOSAuthentication) {
                    try {
                        this.connectAndAuthenticate(string, 2);
                    }
                    catch (Exception exception2) {
                        try {
                            this.connectAndAuthenticate(string, 3);
                            break block39;
                        }
                        catch (Exception exception3) {
                            try {
                                this.connectAndAuthenticate(string, 4);
                                break block39;
                            }
                            catch (UtilException utilException) {
                                throw this.exceptions.getException(utilException);
                            }
                        }
                    }
                }
                if (exception instanceof SQLException) {
                    throw (SQLException)exception;
                }
                throw this.exceptions.getException(exception);
            }
        }
        TTIFUN_OALL8 tTIFUN_OALL8 = new TTIFUN_OALL8(this);
        TimeZone timeZone = TimeZone.getDefault();
        int n = timeZone.getRawOffset();
        if (timeZone.inDaylightTime(new Date())) {
            n += 3600000;
        }
        timeZone = null;
        int n2 = n / 3600000;
        int n3 = (n - n2 * 3600000) / 60000;
        if (n3 < 0) {
            n3 = -n3;
        }
        tTIFUN_OALL8.setOptions(32801);
        tTIFUN_OALL8.setCommandText("ALTER SESSION SET TIME_ZONE = '" + n2 + ":" + n3 + "'");
        tTIFUN_OALL8.setParameters(null);
        this.NSPTDAPacket.appendTTISubPacket(tTIFUN_OALL8);
        this.NSPTDAPacket.sendRequest();
        this.NSPTDAPacket.receiveReply();
        int n4 = this.processReply(tTIFUN_OALL8);
        if (this.gTTIoer.retCode == 0) {
            this.sessionTimeZone = n2 + ":" + n3;
            this.m_cursorID = tTIFUN_OALL8.getCursorID();
            object = " ALTER SESSION SET NLS_TIMESTAMP_FORMAT = 'YYYY-MM-DD HH24:MI:SS.FF'  NLS_TIMESTAMP_TZ_FORMAT = 'YYYY-MM-DD HH24:MI:SS.FF TZH:TZM' ";
            stringArray = System.getProperty("user.language");
            String string = System.getProperty("user.country");
            if (stringArray.equalsIgnoreCase("ja") && (string == null || string.equalsIgnoreCase("JP"))) {
                object = (String)object + " NLS_LANGUAGE = 'JAPANESE' ";
                object = (String)object + " NLS_TERRITORY = 'JAPAN' ";
            }
            tTIFUN_OALL8.setCommandText((String)object);
            tTIFUN_OALL8.setParameters(null);
            this.NSPTDAPacket.appendTTISubPacket(tTIFUN_OALL8);
            this.NSPTDAPacket.sendRequest();
            this.NSPTDAPacket.receiveReply();
            n4 = this.processReply(tTIFUN_OALL8);
        }
        if (this.gTTIoer.retCode != 0) {
            object = new String[]{this.gTTIoer.errMsg};
            stringArray = this.comm.exceptions.getException(6001, (String[])object, this.gTTIoer.getSQLState(), this.gTTIoer.retCode);
            this.comm.close();
            throw stringArray;
        }
        try {
            object = this.mapOraCharsetToName(this.originalReportedOraNCharset);
            if (object == null) {
                stringArray = new String[]{"character set " + this.originalReportedOraNCharset};
                this.warnings.add(7033, stringArray);
                object = "UTF8";
            }
            stringArray = UtilTransliterator.GetNewTransliterator((String)object);
            this.comm.transliteratorForNationalCharset = stringArray;
            this.comm.getReader().setTransliteratorForNationalCharacterSet((UtilTransliterator)stringArray);
            this.comm.getWriter().setTransliteratorForNationalCharacterSet((UtilTransliterator)stringArray);
        }
        catch (UtilException utilException) {
            // empty catch block
        }
        this.user = this.getUsernameFromServer();
        if (this.oracleServerVersion >= 900000000L) {
            this.databaseTimeZone = this.getDatabaseTimeZone();
            this.computeTimeZoneHoursAndMinutes();
        }
    }

    private void connectAndAuthenticate(String string, int n) throws UtilException, SQLException {
        String[] stringArray;
        Object object;
        Object object2;
        TTIDataPacket tTIDataPacket;
        this.gTTIoer = new TTIOERDataPacket(this);
        this.m_cursorID = 0;
        if (this.user == null || this.user.length() <= 0) {
            if (this.authenticationMethodArg.equalsIgnoreCase("client")) {
                this.user = "";
                this.useClientAuthentication = true;
                this.useO3LOG = true;
            } else {
                this.useOSAuthentication = true;
            }
        }
        this.makeConnection();
        this.NSPTDAPacket = new OracleNet8NSPTDAPacket(this.comm);
        if (this.useOSAuthentication) {
            try {
                tTIDataPacket = new TTIANODataPacket(this.exceptions);
                switch (n) {
                    case 2: {
                        ((TTIANODataPacket)tTIDataPacket).ANO3Triplet = ((TTIANODataPacket)tTIDataPacket).ANO3Triplet2;
                        ((TTIANODataPacket)tTIDataPacket).ANO4Triplet = ((TTIANODataPacket)tTIDataPacket).ANO4Triplet2;
                        break;
                    }
                    case 3: {
                        ((TTIANODataPacket)tTIDataPacket).ANO3Triplet = ((TTIANODataPacket)tTIDataPacket).ANO3Triplet2;
                        ((TTIANODataPacket)tTIDataPacket).ANO4Triplet = ((TTIANODataPacket)tTIDataPacket).ANO4Triplet3;
                        break;
                    }
                    case 4: {
                        ((TTIANODataPacket)tTIDataPacket).ANO3Triplet = ((TTIANODataPacket)tTIDataPacket).ANO3Triplet3;
                        ((TTIANODataPacket)tTIDataPacket).ANO4Triplet = ((TTIANODataPacket)tTIDataPacket).ANO4Triplet4;
                        break;
                    }
                }
                this.NSPTDAPacket.appendTTISubPacket(tTIDataPacket);
                this.NSPTDAPacket.sendRequest();
                this.NSPTDAPacket.receiveReply();
                if (this.NSPTDAPacket.getNextTTCCode() != -34) {
                    this.comm.close();
                    throw this.exceptions.getException(7002, "08001");
                }
                this.NSPTDAPacket.getNextNextTTISubpacket(tTIDataPacket);
                if (((TTIANODataPacket)tTIDataPacket).packetType == 1) {
                    this.NSPTDAPacket.appendTTISubPacket(tTIDataPacket);
                    this.NSPTDAPacket.sendRequest();
                    this.NSPTDAPacket.receiveReply();
                    if (this.NSPTDAPacket.getNextTTCCode() != -34) {
                        this.comm.close();
                        throw this.exceptions.getException(7002, "08001");
                    }
                    this.NSPTDAPacket.getNextNextTTISubpacket(tTIDataPacket);
                }
                this.securityContext = this.createSecurityContext(this.user, this.authenticationMethodArg, "");
                int n2 = 2049;
                ((TTIANODataPacket)tTIDataPacket).clientSecurityToken = this.securityContext.getSecurityToken2(null, n2);
                this.NSPTDAPacket.appendTTISubPacket(tTIDataPacket);
                this.NSPTDAPacket.sendRequest();
                this.NSPTDAPacket.receiveReply();
                if (this.NSPTDAPacket.getNextTTCCode() != -34) {
                    this.comm.close();
                    throw this.exceptions.getException(7002, "08001");
                }
                this.NSPTDAPacket.getNextNextTTISubpacket(tTIDataPacket);
                ((TTIANODataPacket)tTIDataPacket).clientSecurityToken = this.securityContext.getSecurityToken2(((TTIANODataPacket)tTIDataPacket).serverSecurityToken, n2);
                this.NSPTDAPacket.appendTTISubPacket(tTIDataPacket);
                this.NSPTDAPacket.sendRequestNoReply();
            }
            catch (UtilException utilException) {
                throw this.exceptions.getException(utilException);
            }
        }
        tTIDataPacket = new TTIPRODataPacket(8);
        this.NSPTDAPacket.appendTTISubPacket(tTIDataPacket);
        this.NSPTDAPacket.sendRequest();
        this.NSPTDAPacket.receiveReply();
        if (this.NSPTDAPacket.getNextTTCCode() != 1) {
            this.comm.close();
            throw this.exceptions.getException(7002, "08001");
        }
        this.NSPTDAPacket.getNextNextTTISubpacket(tTIDataPacket);
        this.originalReportedOraCharset = this.currentOraCharset = (short)tTIDataPacket.srvCharSet;
        this.originalReportedOraNCharset = tTIDataPacket.originalReportedOraNCharset;
        String string2 = null;
        String string3 = this.connectProps.get("codePageOverride");
        if (string3 != null && !string3.equals("")) {
            this.currentOraCharset = this.mapCodePageOverrideToOraCharset(string3);
            string2 = this.mapCodePageOverrideToName(string3);
        } else {
            string2 = this.mapOraCharsetToName(this.currentOraCharset);
            if (string2 == null) {
                string2 = "UTF8";
            }
        }
        if (string2.equalsIgnoreCase("UTF8")) {
            if (!this.isUTF8CharacterSet(this.originalReportedOraCharset)) {
                this.currentOraCharset = (short)871;
            }
            this.transliterator = new UtilTransliteratorForUTF8();
        } else {
            try {
                this.transliterator = UtilTransliterator.GetNewTransliterator(string2);
            }
            catch (UtilException utilException) {
                object2 = new String[]{string2};
                this.warnings.add(7033, (String[])object2);
                object = new String[]{utilException.getMessage()};
                this.warnings.add(6001, (String[])object);
                this.currentOraCharset = (short)871;
                this.transliterator = new UtilTransliteratorForUTF8();
            }
        }
        if (this.currentOraCharset == 871 && this.useOAll7) {
            this.warnings.add(7041);
            this.useOAll7 = false;
        }
        if (this.currentOraCharset == this.originalReportedOraCharset) {
            this.wireCSmatchesOracleCS = true;
        } else {
            tTIDataPacket.srvFlags = 2;
            this.wireCSmatchesOracleCS = false;
        }
        this.japaneseAsUTF8 = (this.originalReportedOraCharset == 830 || this.originalReportedOraCharset == 832 || this.originalReportedOraCharset == 834 || this.originalReportedOraCharset == 838) && this.currentOraCharset == 871;
        this.comm.transliterator = this.transliterator;
        this.comm.getReader().setTransliterator(this.transliterator);
        this.comm.getWriter().setTransliterator(this.transliterator);
        TTIDTYDataPacket tTIDTYDataPacket = new TTIDTYDataPacket();
        tTIDTYDataPacket.cliRIn = this.currentOraCharset;
        tTIDTYDataPacket.cliRout = this.currentOraCharset;
        tTIDTYDataPacket.flags = (byte)tTIDataPacket.srvFlags;
        this.NSPTDAPacket.appendTTISubPacket(tTIDTYDataPacket);
        this.NSPTDAPacket.sendRequest();
        this.NSPTDAPacket.receiveReply();
        if (this.NSPTDAPacket.getNextTTCCode() != 2) {
            this.comm.close();
            throw this.exceptions.getException(7002, "08001");
        }
        this.NSPTDAPacket.getNextNextTTISubpacket(tTIDTYDataPacket);
        object2 = new TTIFUN_OVERSION(this.wireCSmatchesOracleCS);
        this.NSPTDAPacket.appendTTISubPacket((TTIDataPacket)object2);
        this.NSPTDAPacket.sendRequest();
        this.NSPTDAPacket.receiveReply();
        this.gTTIoer.retCode = 0;
        this.processReply((TTIFUNDataPacket)object2);
        if (this.gTTIoer.retCode == 0) {
            this.oracleServerVersionString = object2.RdbmsVersion;
            int n3 = this.oracleServerVersionString.indexOf("Release ") + 8;
            int n4 = this.oracleServerVersionString.indexOf(" -", n3);
            if (n3 > 0 && n4 > 0 && n4 > n3) {
                this.oracleServerVersionString = this.oracleServerVersionString.substring(n3, n4);
            } else {
                UtilDebug.assert("cannot extract version number from Version Info", false);
                this.oracleServerVersionString = "8.0.0.0.0";
            }
            try {
                stringArray = new String[5];
                int n5 = 0;
                int n6 = this.oracleServerVersionString.indexOf(46);
                stringArray[0] = this.oracleServerVersionString.substring(n5, n6);
                int n7 = 1;
                while (n7 <= 3) {
                    n5 = n6 + 1;
                    n6 = this.oracleServerVersionString.indexOf(46, n5 + 1);
                    stringArray[n7] = this.oracleServerVersionString.substring(n5, n6);
                    ++n7;
                }
                n5 = n6 + 1;
                n6 = this.oracleServerVersionString.indexOf(46, n5 + 1);
                stringArray[4] = this.oracleServerVersionString.substring(n5, this.oracleServerVersionString.length());
                this.oracleServerVersion = Integer.parseInt(stringArray[0]) * 100000000 + Integer.parseInt(stringArray[1]) * 1000000 + Integer.parseInt(stringArray[2]) * 10000 + Integer.parseInt(stringArray[3]) * 100 + Integer.parseInt(stringArray[4]);
            }
            catch (Exception exception) {
                UtilDebug.assert("expecting 5 parts in version number string", false);
                this.oracleServerVersion = 800000000L;
            }
        }
        if (this.oracleServerVersion < 902000400L) {
            this.maxLengthOfVarcharParam = 4000 / this.maxBytesPerChar(this.originalReportedOraCharset);
            this.maxLengthOfVarcharParamForNCharset = 4000 / this.maxBytesPerChar(this.originalReportedOraNCharset);
            this.maxLengthOfRawParam = 4000;
        } else {
            this.maxLengthOfVarcharParam = 4000;
            this.maxLengthOfVarcharParamForNCharset = 4000;
            this.maxLengthOfRawParam = 4000;
        }
        this.maxLengthValueForStringParams = this.wireCSmatchesOracleCS ? 4000 : 4000 / this.maxBytesPerChar(this.originalReportedOraCharset);
        if (this.useO3LOG) {
            object = new TTIFUN_O3LOG(false, this.user, null, this.wireCSmatchesOracleCS);
            this.NSPTDAPacket.appendTTISubPacket((TTIDataPacket)object);
            this.NSPTDAPacket.sendRequest();
            this.NSPTDAPacket.receiveReply();
            this.gTTIoer.retCode = 0;
            this.processReply((TTIFUNDataPacket)object);
            if (this.gTTIoer.retCode != 0) {
                String[] stringArray2 = new String[]{this.gTTIoer.errMsg};
                this.myException = this.comm.exceptions.getException(6001, stringArray2, this.gTTIoer.getSQLState(), this.gTTIoer.retCode);
                this.comm.close();
                throw this.myException;
            }
            if (!this.useClientAuthentication) {
                byte[] byArray = this.encryptPassword(this.user, string, ((TTIFUN_O3LOG)object).getEncryptionKey());
                object = new TTIFUN_O3LOG(true, this.user, byArray, this.wireCSmatchesOracleCS);
                this.NSPTDAPacket.appendTTISubPacket((TTIDataPacket)object);
                this.NSPTDAPacket.sendRequest();
                this.NSPTDAPacket.receiveReply();
                this.gTTIoer.retCode = 0;
                this.processReply((TTIFUNDataPacket)object);
                if (this.gTTIoer.retCode != 0) {
                    stringArray = new String[]{this.gTTIoer.errMsg};
                    this.myException = this.comm.exceptions.getException(6001, stringArray, this.gTTIoer.getSQLState(), this.gTTIoer.retCode);
                    this.comm.close();
                    throw this.myException;
                }
            }
        } else {
            object = new TTIFUN_OAUTHENTICATE(this.user, this.wireCSmatchesOracleCS, this.supportLinks);
            this.NSPTDAPacket.appendTTISubPacket((TTIDataPacket)object);
            this.NSPTDAPacket.sendRequest();
            this.NSPTDAPacket.receiveReply();
            this.gTTIoer.retCode = 0;
            this.processReply((TTIFUNDataPacket)object);
            if (this.gTTIoer.retCode != 0) {
                String[] stringArray3 = new String[]{this.gTTIoer.errMsg};
                this.myException = this.comm.exceptions.getException(6001, stringArray3, this.gTTIoer.getSQLState(), this.gTTIoer.retCode);
                this.comm.close();
                throw this.myException;
            }
            if (!this.useOSAuthentication) {
                byte[] byArray = this.encryptPassword(this.user, string, ((TTIFUN_OAUTHENTICATE)object).getEncryptionKey());
                ((TTIFUN_OAUTHENTICATE)object).setEncryptedPassword(byArray);
                this.NSPTDAPacket.appendTTISubPacket((TTIDataPacket)object);
                this.NSPTDAPacket.sendRequest();
                this.NSPTDAPacket.receiveReply();
                this.gTTIoer.retCode = 0;
                this.processReply((TTIFUNDataPacket)object);
                if (this.gTTIoer.retCode != 0) {
                    stringArray = new String[]{this.gTTIoer.errMsg};
                    this.myException = this.comm.exceptions.getException(6001, stringArray, this.gTTIoer.getSQLState(), this.gTTIoer.retCode);
                    this.comm.close();
                    throw this.myException;
                }
            }
        }
        this.stopManualTransactionMode();
    }

    private String getColumnValueFromDatabase(String string) {
        block3: {
            try {
                TTIFUN_OALL8 tTIFUN_OALL8 = new TTIFUN_OALL8(this);
                tTIFUN_OALL8.setOptions(32865);
                tTIFUN_OALL8.setCommandText(string);
                tTIFUN_OALL8.setParameters(null);
                tTIFUN_OALL8.setIsSelect(true);
                tTIFUN_OALL8.setCursorID(this.m_cursorID);
                this.NSPTDAPacket.appendTTISubPacket(tTIFUN_OALL8);
                this.NSPTDAPacket.sendRequest();
                this.NSPTDAPacket.receiveReply();
                int n = this.processReply(tTIFUN_OALL8);
                if (n != 16) break block3;
                TTIDCBDataPacket tTIDCBDataPacket = new TTIDCBDataPacket(this);
                this.NSPTDAPacket.getNextNextTTISubpacket(tTIDCBDataPacket);
                BaseColumn[] baseColumnArray = tTIDCBDataPacket.getColumns();
                n = this.processReply(tTIFUN_OALL8);
                if (n != 6) break block3;
                this.NSPTDAPacket.getNextNextTTISubpacket(new TTIRXHDataPacket());
                n = this.processReply(tTIFUN_OALL8);
                if (n == 7) {
                    TTIRXDDataPacket tTIRXDDataPacket = new TTIRXDDataPacket(baseColumnArray, this, false);
                    this.NSPTDAPacket.getNextNextTTISubpacket(tTIRXDDataPacket);
                    OracleColumn oracleColumn = (OracleColumn)baseColumnArray[0];
                    return this.comm.transliterator.decode(oracleColumn.data, 0, oracleColumn.data.length);
                }
            }
            catch (Exception exception) {}
        }
        return null;
    }

    private String getUsernameFromServer() {
        return this.getColumnValueFromDatabase("select USER from DUAL");
    }

    private String getDatabaseTimeZone() {
        return this.getColumnValueFromDatabase("select TZ_OFFSET(DBTIMEZONE) from dual");
    }

    private void getSessionTimeZone() {
        this.sessionTimeZone = this.getColumnValueFromDatabase("select TZ_OFFSET(sessiontimezone) from dual");
    }

    private void computeTimeZoneHoursAndMinutes() {
        try {
            int n = this.databaseTimeZone.indexOf(58);
            String string = this.databaseTimeZone.substring(0, n);
            boolean bl = false;
            if (string.charAt(0) == '-') {
                bl = true;
                string = string.substring(1);
            } else if (string.charAt(0) == '+') {
                string = string.substring(1);
            }
            int n2 = Integer.parseInt(string);
            String string2 = this.databaseTimeZone.substring(n + 1);
            char c = string2.charAt(string2.length() - 1);
            if (c < '0' || c > '9') {
                string2 = string2.substring(0, string2.length() - 1);
            }
            int n3 = Integer.parseInt(string2);
            int n4 = this.sessionTimeZone.indexOf(58);
            String string3 = this.sessionTimeZone.substring(0, n4);
            boolean bl2 = false;
            if (string3.charAt(0) == '-') {
                bl2 = true;
                string3 = string3.substring(1);
            } else if (string3.charAt(0) == '+') {
                string3 = string3.substring(1);
            }
            int n5 = Integer.parseInt(string3);
            String string4 = this.sessionTimeZone.substring(n4 + 1);
            c = string4.charAt(string4.length() - 1);
            if (c < '0' || c > '9') {
                string4 = string4.substring(0, string4.length() - 1);
            }
            int n6 = Integer.parseInt(string4);
            int n7 = 0;
            n7 = bl ? -n2 * 60 - n3 : n2 * 60 + n3;
            int n8 = 0;
            n8 = bl2 ? -n5 * 60 - n6 : n5 * 60 + n6;
            int n9 = n8 - n7;
            this.tzHours = n9 / 60;
            this.tzMinutes = n9 % 60;
        }
        catch (Exception exception) {
            this.warnings.add(7043);
        }
    }

    public int getTimeZoneHours() {
        if (this.alterStatementHasBeenIssued) {
            this.getSessionTimeZone();
            this.computeTimeZoneHoursAndMinutes();
            this.alterStatementHasBeenIssued = false;
        }
        return this.tzHours;
    }

    public int getTimeZoneMinutes() {
        if (this.alterStatementHasBeenIssued) {
            this.getSessionTimeZone();
            this.computeTimeZoneHoursAndMinutes();
            this.alterStatementHasBeenIssued = false;
        }
        return this.tzMinutes;
    }

    private short mapCodePageOverrideToOraCharset(String string) throws SQLException {
        if (string.equalsIgnoreCase("SJIS") || string.equalsIgnoreCase("MS932") || string.equalsIgnoreCase("ENHANCED_SJIS") || string.equalsIgnoreCase("ENHANCED_SJIS_ORACLE")) {
            switch (this.currentOraCharset) {
                case 838: {
                    return 838;
                }
                case 834: {
                    return 834;
                }
            }
            return 832;
        }
        if (string.equalsIgnoreCase("UTF8")) {
            if (this.isUTF8CharacterSet(this.originalReportedOraCharset)) {
                return this.originalReportedOraCharset;
            }
            return 871;
        }
        String[] stringArray = new String[]{string};
        throw this.exceptions.getException(7032, stringArray);
    }

    private String mapCodePageOverrideToName(String string) throws SQLException {
        if (string.equalsIgnoreCase("SJIS")) {
            return "ORACLE_SJIS";
        }
        if (string.equalsIgnoreCase("ENHANCED_SJIS")) {
            return "CUSTOM_ICU_SJIS";
        }
        if (string.equalsIgnoreCase("ENHANCED_SJIS_ORACLE")) {
            return "CUSTOM_ICU_SJIS_MS932_BIAS";
        }
        if (string.equalsIgnoreCase("MS932")) {
            return string;
        }
        if (string.equalsIgnoreCase("UTF8")) {
            return string;
        }
        String[] stringArray = new String[]{string};
        throw this.exceptions.getException(7032, stringArray);
    }

    private String mapOraCharsetToName(short s) {
        String string = null;
        switch (s) {
            case 1: 
            case 31: {
                string = "ISO8859-1";
                break;
            }
            case 32: {
                string = "ISO8859-2";
                break;
            }
            case 33: {
                string = "ISO8859-3";
                break;
            }
            case 34: {
                string = "ISO8859-4";
                break;
            }
            case 35: {
                string = "ISO8859-5";
                break;
            }
            case 36: {
                string = "ISO8859-6";
                break;
            }
            case 37: {
                string = "ISO8859-7";
                break;
            }
            case 38: {
                string = "ISO8859-8";
                break;
            }
            case 39: {
                string = "ISO8859-9";
                break;
            }
            case 46: {
                string = "ISO8859-15";
                break;
            }
            case 167: {
                string = "ORA167";
                break;
            }
            case 178: {
                string = "1252";
                break;
            }
            case 180: {
                string = "273";
                break;
            }
            case 183: {
                string = "278";
                break;
            }
            case 181: {
                string = "280";
                break;
            }
            case 8: {
                string = "285";
                break;
            }
            case 186: {
                string = "297";
                break;
            }
            case 6: {
                string = "500";
                break;
            }
            case 10: {
                string = "850";
                break;
            }
            case 5: {
                string = "37";
                break;
            }
            case 261: 
            case 351: 
            case 352: {
                string = "ROMAN8";
                break;
            }
            case 832: {
                string = "CUSTOM_ICU_SJIS_MS932_BIAS";
                break;
            }
            case 834: {
                string = "CUSTOM_ICU_SJISYEN_MS932_BIAS";
                break;
            }
            case 838: {
                string = "CUSTOM_ICU_SJISTILDE_MS932_BIAS";
                break;
            }
            case 830: {
                string = "EUCJP";
                break;
            }
            case 840: {
                string = "EUC_KR";
                break;
            }
            case 846: {
                string = "MS949";
                break;
            }
            case 852: {
                string = "GBK";
                break;
            }
            case 865: {
                string = "BIG5";
                break;
            }
            case 174: {
                string = "1253";
                break;
            }
            case 2000: {
                string = "UCS2";
                break;
            }
            case 870: 
            case 871: 
            case 872: 
            case 873: {
                string = "UTF8";
            }
        }
        return string;
    }

    boolean isUTF8CharacterSet(int n) {
        switch (n) {
            case 870: 
            case 871: 
            case 872: 
            case 873: {
                return true;
            }
        }
        return false;
    }

    protected byte[] encryptPassword(String string, String string2, byte[] byArray) throws SQLException {
        int n = string2.length();
        int n2 = n % 8 > 0 ? 8 - n % 8 : 0;
        boolean bl = this.originalReportedOraCharset >= 800;
        C1 c1 = new C1();
        byte[] byArray2 = c1.m(string, string2, bl);
        byte[] byArray3 = c1.j(byArray2, byArray);
        byte[] byArray4 = new byte[n + n2];
        byte[] byArray5 = null;
        try {
            byArray5 = this.comm.transliterator.encode(string2);
        }
        catch (UtilException utilException) {
            throw this.exceptions.getException(7003, "08001");
        }
        System.arraycopy(byArray5, 0, byArray4, 0, n);
        byte[] byArray6 = c1.c(byArray3, byArray4);
        byte[] byArray7 = new byte[2 * byArray4.length + 1];
        if (byArray7.length < 2 * byArray6.length) {
            throw this.exceptions.getException(7003, "08001");
        }
        int n3 = 0;
        while (n3 < byArray6.length) {
            byArray7[n3 * 2] = this.nibbleToHex((byte)((byArray6[n3] & 0xF0) >> 4));
            byArray7[n3 * 2 + 1] = this.nibbleToHex((byte)(byArray6[n3] & 0xF));
            ++n3;
        }
        byArray7[byArray7.length - 1] = this.nibbleToHex((byte)n2);
        return byArray7;
    }

    private byte nibbleToHex(byte by) {
        return (byte)((by = (byte)(by & 0xF)) >= 10 ? by - 10 + 65 : by + 48);
    }

    protected void makeConnection() throws SQLException {
        String string = this.connectProps.get("serverName");
        String string2 = this.connectProps.get("portNumber");
        String string3 = this.connectProps.get("SID");
        String string4 = this.connectProps.get("serviceName");
        String string5 = this.connectProps.get("serverType");
        String string6 = this.connectProps.get("TNSNamesFile");
        String string7 = this.connectProps.get("TNSServerName");
        if (string != null && string.length() == 0) {
            string = null;
        }
        if (string2 != null && string2.length() == 0) {
            string2 = null;
        }
        if (string3 != null && string3.length() == 0) {
            string3 = null;
        }
        if (string4 != null && string4.length() == 0) {
            string4 = null;
        }
        if (string5 != null && string5.length() == 0) {
            string5 = null;
        }
        if (string6 != null && string6.length() == 0) {
            string6 = null;
        }
        if (string7 != null && string7.length() == 0) {
            string7 = null;
        }
        if (string3 != null) {
            if (string4 != null) {
                String[] stringArray = new String[]{"SID", "serviceName"};
                throw this.exceptions.getException(7026, stringArray, "08001");
            }
            if (string7 != null) {
                String[] stringArray = new String[]{"SID", "TNSServerName"};
                throw this.exceptions.getException(7026, stringArray, "08001");
            }
            if (string6 != null) {
                String[] stringArray = new String[]{"SID", "TNSNamesFile"};
                throw this.exceptions.getException(7026, stringArray, "08001");
            }
            if (string == null) {
                String[] stringArray = new String[]{"SID", "serverName"};
                throw this.exceptions.getException(7025, stringArray, "08001");
            }
        }
        if (string4 != null) {
            if (string7 != null) {
                String[] stringArray = new String[]{"serviceName", "TNSServerName"};
                throw this.exceptions.getException(7026, stringArray, "08001");
            }
            if (string6 != null) {
                String[] stringArray = new String[]{"serviceName", "TNSNamesFile"};
                throw this.exceptions.getException(7026, stringArray, "08001");
            }
            if (string == null) {
                String[] stringArray = new String[]{"serviceName", "serverName"};
                throw this.exceptions.getException(7025, stringArray, "08001");
            }
        }
        if (string7 != null) {
            if (string != null) {
                String[] stringArray = new String[]{"TNSServerName", "serverName"};
                throw this.exceptions.getException(7026, stringArray, "08001");
            }
            if (string5 != null) {
                String[] stringArray = new String[]{"TNSServerName", "serverType"};
                throw this.exceptions.getException(7026, stringArray, "08001");
            }
            if (string6 == null) {
                String[] stringArray = new String[]{"TNSServerName", "TNSNamesFile"};
                throw this.exceptions.getException(7025, stringArray, "08001");
            }
        }
        if (string6 != null) {
            if (string != null) {
                String[] stringArray = new String[]{"TNSNamesFile", "serverName"};
                throw this.exceptions.getException(7026, stringArray, "08001");
            }
            if (string5 != null) {
                String[] stringArray = new String[]{"tnsNamesFile", "serverType"};
                throw this.exceptions.getException(7026, stringArray, "08001");
            }
            if (string7 == null) {
                String[] stringArray = new String[]{"TNSNamesFile", "TNSServerName"};
                throw this.exceptions.getException(7025, stringArray, "08001");
            }
        }
        TnsConnectDescriptor tnsConnectDescriptor = null;
        if (string7 != null) {
            TnsDescriptionList tnsDescriptionList = TnsFile.CreateDescriptorList(string7, string6, this.exceptions);
            ArrayList arrayList = new ArrayList();
            tnsDescriptionList.CollectConnectDescriptors((int)(Math.random() * 100.0), arrayList, string7, this.exceptions);
            SQLException sQLException = null;
            SQLException sQLException2 = null;
            boolean bl = false;
            int n = 0;
            while (!bl && n < arrayList.size()) {
                tnsConnectDescriptor = (TnsConnectDescriptor)arrayList.get(n);
                try {
                    this.makeConnectionHelper(tnsConnectDescriptor);
                    bl = true;
                }
                catch (SQLException sQLException3) {
                    if (sQLException == null) {
                        sQLException = sQLException3;
                        sQLException2 = sQLException3;
                    } else {
                        sQLException2.setNextException(sQLException3);
                        sQLException2 = sQLException3;
                    }
                    ++n;
                }
            }
            if (!bl) {
                throw sQLException;
            }
        } else {
            if (string == null) {
                throw this.exceptions.getException(7012, "08001");
            }
            tnsConnectDescriptor = new TnsConnectDescriptor(string, string2, string4, string3, string5, this.exceptions);
            this.makeConnectionHelper(tnsConnectDescriptor);
        }
    }

    void makeConnectionHelper(TnsConnectDescriptor tnsConnectDescriptor) throws SQLException {
        boolean bl = false;
        String string = tnsConnectDescriptor.getConnectString(this.cid);
        String string2 = tnsConnectDescriptor.getAddress().getHost();
        int n = tnsConnectDescriptor.getAddress().getPort();
        Socket socket = null;
        Properties properties = this.connectProps.getSocketDebugProperties();
        try {
            socket = UtilSocketCreator.getSocket(string2, n, properties);
        }
        catch (UtilException utilException) {
            throw this.exceptions.getException(utilException, "08001");
        }
        this.comm = new OracleNet8Communication(socket, this, this.exceptions, this.warnings);
        while (!bl) {
            OracleNet8NSPTCNPacket oracleNet8NSPTCNPacket = new OracleNet8NSPTCNPacket(this.comm, string.toString());
            if (this.useOSAuthentication) {
                oracleNet8NSPTCNPacket.setANOFlag(1);
            }
            oracleNet8NSPTCNPacket.submitRequest();
            int n2 = oracleNet8NSPTCNPacket.getReplyNSPTPacketType();
            switch (n2) {
                case 4: {
                    String[] stringArray;
                    OracleNet8NSPTRFPacket oracleNet8NSPTRFPacket = new OracleNet8NSPTRFPacket(this.comm);
                    oracleNet8NSPTRFPacket.receiveReply();
                    int n3 = oracleNet8NSPTRFPacket.userReason;
                    int n4 = oracleNet8NSPTRFPacket.errorString.indexOf("ERR=") + 4;
                    int n5 = oracleNet8NSPTRFPacket.errorString.indexOf(41, n4);
                    this.comm.close();
                    if (n4 > 0 && n5 > n4) {
                        stringArray = oracleNet8NSPTRFPacket.errorString.substring(n4, n5);
                        n3 = Integer.parseInt((String)stringArray);
                    }
                    stringArray = new String[1];
                    if (n3 == 12505) {
                        stringArray[0] = tnsConnectDescriptor.getConnectData().getSID();
                        throw this.comm.exceptions.getException(7028, stringArray, "08001", n3);
                    }
                    if (n3 == 12514) {
                        stringArray[0] = tnsConnectDescriptor.getConnectData().getServiceName();
                        throw this.comm.exceptions.getException(7034, stringArray, "08001", n3);
                    }
                    if (n3 == 12519 || n3 == 12515) {
                        stringArray[0] = String.valueOf(n3);
                        throw this.comm.exceptions.getException(7029, stringArray, "08001", n3);
                    }
                    stringArray[0] = oracleNet8NSPTRFPacket.errorString;
                    throw this.comm.exceptions.getException(7027, stringArray, "08001", n3);
                }
                case 5: {
                    OracleNet8NSPTRDPacket oracleNet8NSPTRDPacket = new OracleNet8NSPTRDPacket(this.comm);
                    oracleNet8NSPTRDPacket.receiveReply();
                    tnsConnectDescriptor = new TnsConnectDescriptor(tnsConnectDescriptor, oracleNet8NSPTRDPacket.conString);
                    string = tnsConnectDescriptor.getConnectString(this.cid);
                    string2 = tnsConnectDescriptor.getAddress().getHost();
                    n = tnsConnectDescriptor.getAddress().getPort();
                    this.comm.close();
                    try {
                        socket = UtilSocketCreator.getSocket(string2, n, properties);
                    }
                    catch (Exception exception) {
                        String[] stringArray = new String[]{string2, String.valueOf(n)};
                        SQLException sQLException = this.exceptions.getException(7040, stringArray, "08001");
                        sQLException.setNextException(this.exceptions.getException(exception));
                        throw sQLException;
                    }
                    this.comm = new OracleNet8Communication(socket, this, this.exceptions, this.warnings);
                    break;
                }
                case 2: {
                    OracleNet8NSPTACPacket oracleNet8NSPTACPacket = new OracleNet8NSPTACPacket(this.comm);
                    oracleNet8NSPTACPacket.receiveReply();
                    this.byteOrder = oracleNet8NSPTACPacket.byteOrder;
                    this.comm.maxReceivedPacketSize = 2000;
                    bl = true;
                    break;
                }
                case 3: {
                    bl = true;
                    break;
                }
                case 11: {
                    break;
                }
                default: {
                    throw this.exceptions.getException(7002, "08001");
                }
            }
        }
    }

    protected BaseImplStatement createImplStatement(int n, int n2) throws SQLException {
        return new OracleImplStatement(n, n2, this.comm, this);
    }

    public short getCursorID() throws SQLException {
        return this.m_cursorID;
    }

    protected void setSavepoint(String string) throws SQLException {
        TTIFUN_OALL8 tTIFUN_OALL8 = new TTIFUN_OALL8(this);
        tTIFUN_OALL8.setOptions(32801);
        tTIFUN_OALL8.setCommandText("SAVEPOINT " + string);
        tTIFUN_OALL8.setCursorID(this.m_cursorID);
        this.NSPTDAPacket.appendTTISubPacket(tTIFUN_OALL8);
        this.NSPTDAPacket.sendRequest();
        this.NSPTDAPacket.receiveReply();
        this.processReply(tTIFUN_OALL8);
        if (this.gTTIoer.retCode != 0) {
            String[] stringArray = new String[]{this.gTTIoer.errMsg};
            SQLException sQLException = this.comm.exceptions.getException(6001, stringArray, this.gTTIoer.getSQLState(), this.gTTIoer.retCode);
            throw sQLException;
        }
    }

    protected void releaseSavepoint(String string) throws SQLException {
    }

    protected void rollbackTransaction(String string) throws SQLException {
        TTIFUN_OALL8 tTIFUN_OALL8 = new TTIFUN_OALL8(this);
        tTIFUN_OALL8.setOptions(32801);
        tTIFUN_OALL8.setCommandText("ROLLBACK TO SAVEPOINT " + string);
        tTIFUN_OALL8.setCursorID(this.m_cursorID);
        this.NSPTDAPacket.appendTTISubPacket(tTIFUN_OALL8);
        this.NSPTDAPacket.sendRequest();
        this.NSPTDAPacket.receiveReply();
        this.processReply(tTIFUN_OALL8);
        if (this.gTTIoer.retCode != 0) {
            String[] stringArray = new String[]{this.gTTIoer.errMsg};
            SQLException sQLException = this.comm.exceptions.getException(6001, stringArray, this.gTTIoer.getSQLState(), this.gTTIoer.retCode);
            throw sQLException;
        }
    }

    protected void commitTransaction() throws SQLException {
        TTIFUN_OCOMMIT tTIFUN_OCOMMIT = new TTIFUN_OCOMMIT();
        this.NSPTDAPacket.appendTTISubPacket(tTIFUN_OCOMMIT);
        this.NSPTDAPacket.sendRequest();
        this.NSPTDAPacket.receiveReply();
        this.processReply(tTIFUN_OCOMMIT);
        if (this.gTTIoer.retCode != 0) {
            String[] stringArray = new String[]{this.gTTIoer.errMsg};
            this.myException = this.comm.exceptions.getException(6001, stringArray, this.gTTIoer.getSQLState(), this.gTTIoer.retCode);
            throw this.myException;
        }
    }

    protected void rollbackTransaction() throws SQLException {
        TTIFUN_OROLLBACK tTIFUN_OROLLBACK = new TTIFUN_OROLLBACK();
        this.NSPTDAPacket.appendTTISubPacket(tTIFUN_OROLLBACK);
        this.NSPTDAPacket.sendRequest();
        this.NSPTDAPacket.receiveReply();
        this.processReply(tTIFUN_OROLLBACK);
        if (this.gTTIoer.retCode != 0) {
            String[] stringArray = new String[]{this.gTTIoer.errMsg};
            this.myException = this.comm.exceptions.getException(6001, stringArray, this.gTTIoer.getSQLState(), this.gTTIoer.retCode);
            throw this.myException;
        }
    }

    public boolean supportsIntegratedSecurity() {
        return true;
    }

    public void close() throws SQLException {
        TTIFUN_OLOGOFF tTIFUN_OLOGOFF = new TTIFUN_OLOGOFF();
        this.NSPTDAPacket.appendTTISubPacket(tTIFUN_OLOGOFF);
        this.NSPTDAPacket.sendRequest();
        this.NSPTDAPacket.receiveReply();
        this.processReply(tTIFUN_OLOGOFF);
        if (this.gTTIoer.retCode != 0) {
            String[] stringArray = new String[]{this.gTTIoer.errMsg};
            this.myException = this.comm.exceptions.getException(6001, stringArray, this.gTTIoer.getSQLState(), this.gTTIoer.retCode);
            throw this.myException;
        }
        if (this.securityContext != null) {
            try {
                this.securityContext.cleanup();
            }
            catch (UtilException utilException) {
                throw this.exceptions.getException(utilException);
            }
        }
        this.comm.close();
    }

    public void reset() throws SQLException {
        this.transliterator.setDefaultCacheSize();
    }

    protected void stopManualTransactionMode() throws SQLException {
        this.commitTransaction();
        TTIFUN_OCOMON tTIFUN_OCOMON = new TTIFUN_OCOMON();
        this.NSPTDAPacket.appendTTISubPacket(tTIFUN_OCOMON);
        this.NSPTDAPacket.sendRequest();
        this.NSPTDAPacket.receiveReply();
        this.processReply(tTIFUN_OCOMON);
        if (this.gTTIoer.retCode != 0) {
            String[] stringArray = new String[]{this.gTTIoer.errMsg};
            this.myException = this.comm.exceptions.getException(6001, stringArray, this.gTTIoer.getSQLState(), this.gTTIoer.retCode);
            throw this.myException;
        }
    }

    public int processReply(TTIFUNDataPacket tTIFUNDataPacket) throws SQLException {
        return this.processReply(tTIFUNDataPacket, this.gTTIoer);
    }

    public int processReply(TTIFUNDataPacket tTIFUNDataPacket, TTIOERDataPacket tTIOERDataPacket) throws SQLException {
        boolean bl = false;
        tTIOERDataPacket.retCode = 0;
        block13: while (!bl) {
            int n = this.NSPTDAPacket.getNextTTCCode();
            switch (n) {
                case 9: {
                    if (this.oracleServerVersion >= 1000000000L) {
                        try {
                            int n2 = this.NSPTDAPacket.reader.readB4();
                        }
                        catch (UtilException utilException) {
                            throw this.exceptions.getException(7002, "08001");
                        }
                    }
                }
                case -1: {
                    bl = true;
                    break;
                }
                case 4: {
                    this.NSPTDAPacket.getNextNextTTISubpacket(tTIOERDataPacket);
                    bl = true;
                    break;
                }
                case 8: {
                    this.NSPTDAPacket.getNextNextTTISubpacket(tTIFUNDataPacket);
                    break;
                }
                case 11: {
                    TTIIOVDataPacket tTIIOVDataPacket = new TTIIOVDataPacket();
                    this.NSPTDAPacket.getNextNextTTISubpacket(tTIIOVDataPacket);
                    break;
                }
                case 6: 
                case 7: 
                case 14: 
                case 16: 
                case 21: {
                    return n;
                }
                case 15: {
                    try {
                        short s = this.NSPTDAPacket.reader.readB2();
                        short s2 = this.NSPTDAPacket.reader.readB2();
                        this.NSPTDAPacket.reader.readB2();
                        if (s2 <= 0) continue block13;
                        byte[] byArray = new byte[s2];
                        this.NSPTDAPacket.reader.readBytes(byArray, 0, s2);
                        String[] stringArray = new String[]{this.comm.transliterator.decode(byArray, 0, s2)};
                        this.warnings.add(6001, stringArray, "01000", s);
                        break;
                    }
                    catch (Exception exception) {
                        throw this.exceptions.getException(exception, "08001");
                    }
                }
                default: {
                    throw this.exceptions.getException(7002, "08001");
                }
            }
        }
        return 0;
    }

    protected boolean supportsRowId() {
        return true;
    }

    protected String[] getAggregateFunctions() {
        String[] stringArray = new String[]{"AVG", "COUNT", "FIRST", "LAST", "MAX", "MIN", "SUM"};
        return stringArray;
    }

    public int maxBytesPerChar(int n) {
        if (n < 800) {
            return 1;
        }
        switch (n) {
            case 830: 
            case 835: 
            case 837: 
            case 842: 
            case 853: 
            case 864: 
            case 870: 
            case 871: 
            case 996: 
            case 998: 
            case 9996: 
            case 9997: 
            case 9998: 
            case 9999: {
                return 3;
            }
            case 854: 
            case 860: 
            case 861: 
            case 863: 
            case 872: 
            case 873: 
            case 1863: {
                return 4;
            }
        }
        return 2;
    }

    protected String setClientApplicationName(String string) throws SQLException {
        if (string.length() > 64) {
            string = string.substring(0, 64);
        }
        if (this.oracleServerVersion >= 900000000L) {
            String string2 = "begin dbms_session.set_identifier('" + string + "'); end;";
            OracleImplStatement oracleImplStatement = (OracleImplStatement)this.createImplStatement(1003, 1007);
            BaseSQL baseSQL = new BaseSQL(string2, 0, '\'', null, this.exceptions);
            oracleImplStatement.setup(this, this.warnings);
            oracleImplStatement.setSQL(baseSQL);
            oracleImplStatement.execute();
        }
        return string;
    }
}

