/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.jdbc.db2;

import com.metamatrix.jdbc.base.BaseConnection;
import com.metamatrix.jdbc.base.BaseExceptions;
import com.metamatrix.jdbc.base.BaseImplDatabaseMetaData;
import com.metamatrix.jdbc.base.BaseImplResultSet;
import com.metamatrix.jdbc.base.BaseResultSetFilterDescriptor;
import com.metamatrix.jdbc.base.BaseResultSetSortDescriptor;
import com.metamatrix.jdbc.base.BaseSQL;
import com.metamatrix.jdbc.base.BaseTableTypes;
import com.metamatrix.jdbc.base.BaseTypeInfos;
import com.metamatrix.jdbc.db2.DB2EscapeTranslator;
import com.metamatrix.jdbc.db2.DB2ImplConnection;
import com.metamatrix.jdbc.db2.DB2ImplStatement;
import com.metamatrix.jdbc.db2.DB2MetaDataLibrary;
import java.sql.SQLException;

public class DB2ImplDatabaseMetaData
extends BaseImplDatabaseMetaData {
    private static String footprint = "$Revision:   3.34.1.1  $";
    protected BaseExceptions exceptions;
    private String catalogSchema;
    private String catalogSchema2;
    public static String catalogName = " ";
    public String collectionID;
    protected DB2MetaDataLibrary mdLib;
    protected DB2ImplConnection con;
    private boolean useCSPs;
    private boolean userIsDBADM;
    public boolean restrictGetTables;

    public DB2ImplDatabaseMetaData(DB2ImplConnection dB2ImplConnection) throws SQLException {
        this.con = dB2ImplConnection;
        this.userIsDBADM = false;
        String string = dB2ImplConnection.connectProps.get("showSelectableTables");
        this.restrictGetTables = string == null ? true : new Boolean(string);
    }

    public void setup(BaseConnection baseConnection) throws SQLException {
        block8: {
            super.setup(baseConnection);
            this.initMetaData((DB2ImplConnection)this.getImplConnection());
            if (!this.restrictGetTables) break block8;
            try {
                String string = null;
                String string2 = null;
                if (((DB2ImplConnection)this.getImplConnection()).comm.serverOS == 3) {
                    string = "select DBADMAUTH from " + this.catalogSchema + ".sysdbauth where GRANTEE = '" + ((DB2ImplConnection)this.getImplConnection()).user + "'";
                } else if (((DB2ImplConnection)this.getImplConnection()).comm.serverOS != 8) {
                    string = "select DBADMAUTH from " + this.catalogSchema + ".dbauth where GRANTEE = '" + ((DB2ImplConnection)this.getImplConnection()).user + "'";
                }
                if (string != null) {
                    DB2ImplStatement dB2ImplStatement = (DB2ImplStatement)this.con.createImplStatement(1000, 1003);
                    dB2ImplStatement.setup(this.con, this.con.warnings);
                    dB2ImplStatement.setSQL(new BaseSQL(string, 0, this.con.quotingChar, new DB2EscapeTranslator(this.con), this.con.exceptions));
                    dB2ImplStatement.execute();
                    dB2ImplStatement.getNextResultType();
                    BaseImplResultSet baseImplResultSet = dB2ImplStatement.getNextResultSet();
                    baseImplResultSet.setImplStatement(dB2ImplStatement);
                    baseImplResultSet.setWarnings(this.con.warnings);
                    if (baseImplResultSet.fetchAtPosition(0)) {
                        string2 = baseImplResultSet.getData(1, 1).getString(10, this.con.exceptions);
                    }
                    baseImplResultSet.close();
                    dB2ImplStatement.close();
                }
                if (string2 != null && (string2.equalsIgnoreCase("Y") || string2.equalsIgnoreCase("G")) || ((DB2ImplConnection)this.getImplConnection()).comm.serverOS == 8) {
                    this.userIsDBADM = true;
                    this.restrictGetTables = false;
                }
            }
            catch (SQLException sQLException) {}
        }
    }

    private void initMetaData(DB2ImplConnection dB2ImplConnection) throws SQLException {
        if (dB2ImplConnection.catalogSchema == null) {
            this.useCSPs = true;
            switch (dB2ImplConnection.comm.serverOS) {
                case 8: {
                    this.catalogSchema = "QSYS2";
                    this.catalogSchema2 = "SYSIBM";
                    break;
                }
                case 3: {
                    this.catalogSchema = "SYSIBM";
                    break;
                }
                default: {
                    this.catalogSchema = "SYSCAT";
                    break;
                }
            }
        } else {
            this.catalogSchema = dB2ImplConnection.catalogSchema.toUpperCase();
            this.catalogSchema2 = dB2ImplConnection.catalogSchema.toUpperCase();
            switch (dB2ImplConnection.comm.serverOS) {
                case 8: {
                    this.useCSPs = this.catalogSchema.equals("QSYS2");
                    break;
                }
                case 3: {
                    this.useCSPs = this.catalogSchema.equals("SYSIBM");
                    break;
                }
                default: {
                    this.useCSPs = this.catalogSchema.equals("SYSCAT");
                }
            }
        }
        this.mdLib = new DB2MetaDataLibrary(dB2ImplConnection, this.catalogSchema, this.catalogSchema2);
        this.mdLib.catalogName = catalogName = dB2ImplConnection.databaseName.trim().toUpperCase();
        this.collectionID = dB2ImplConnection.collectionId;
        switch (dB2ImplConnection.comm.serverOS) {
            case 8: {
                this.supportsGetGeneratedKeys = Boolean.FALSE;
                this.databaseProductName = "DB2/" + dB2ImplConnection.comm.ServerClassName.substring(1) + "400";
                this.databaseProductVersion = dB2ImplConnection.comm.ServerProductID;
                this.catalogTerm = "LOCATION";
                this.maxColumnNameLength = new Integer(18);
                this.maxColumnsInGroupBy = new Integer(750);
                this.maxColumnsInIndex = new Integer(64);
                this.maxColumnsInOrderBy = new Integer(750);
                this.maxColumnsInSelect = new Integer(750);
                this.maxColumnsInTable = new Integer(750);
                this.maxCursorNameLength = new Integer(18);
                this.maxIndexLength = new Integer(254);
                this.maxCatalogNameLength = new Integer(16);
                this.maxProcedureNameLength = new Integer(18);
                this.maxBinaryLiteralLength = new Integer(254);
                this.maxCharLiteralLength = new Integer(254);
                this.maxSchemaNameLength = new Integer(8);
                this.maxUserNameLength = new Integer(8);
                this.maxStatementLength = new Integer(32765);
                this.supportsTransactionIsolationLevelNone = Boolean.TRUE;
                this.supportsOpenCursorsAcrossRollback = Boolean.TRUE;
                switch (dB2ImplConnection.comm.serverType) {
                    case 1: {
                        this.supportsSavepoints = Boolean.FALSE;
                        this.allTablesAreSelectable = Boolean.FALSE;
                        break;
                    }
                    case 2: {
                        this.supportsGetGeneratedKeys = Boolean.TRUE;
                        this.supportsSavepoints = Boolean.FALSE;
                        this.allTablesAreSelectable = Boolean.FALSE;
                        break;
                    }
                    case 3: 
                    case 11: {
                        this.supportsGetGeneratedKeys = Boolean.TRUE;
                        this.supportsSavepoints = Boolean.TRUE;
                        this.allTablesAreSelectable = Boolean.FALSE;
                        break;
                    }
                }
                this.numericFunctions = "ABS, ABSVAL, ACOS, ASIN, ATAN, ATANH, ATAN2, BIGINT, CEIL, CEILING, COS, COSH, COT, CURRENCY, DEC, DECIMAL, DEGREES, DIGITS, DOUBLE, DOUBLE_PRECISION, EXP, FLOAT, FLOOR, INT, INTEGER, LN, LOG, LOG10, MOD, POWER, RADIANS, RAND, REAL, ROUND, ROWID, SIGN, SIN, SINH, SMALLINT, SQRT, TAN, TANH, TRUNCATE";
                this.stringFunctions = "BLOB, CHAR, CLOB, CONCAT, DBCLOB, GRAPHIC, HEX, INSERT, LCASE, LOWER, LEFT, LENGTH, LOCATE, LTRIM, POSSTR, RIGHT, RTRIM, SPACE, SUBSTR, STRIP, TRUNCATE, TRUNC, UCASE, UPPER, VARCHAR, VARGRAPHIC";
                this.systemFunctions = "COALESCE, IFNULL, NULLIF, RAISE_ERROR, TABLE_NAME,  TABLE_LOCATION, TABLE_SCHEMA, TRANSLATE, VALUE";
                this.timeDateFunctions = "ALTDATE, ALTTIME, DATE, DAY, DAYOFMONTH, DAYOFWEEK, DAYOFYEAR, DAYS, HOUR, JULIAN_DAY, MICROSECOND, MIDNIGHT_SECONDS, MINUTE, MONTH, QUARTER, SECOND, TIME, TIMESTAMP, WEATHER, WEEK, YEAR,";
                break;
            }
            case 3: {
                this.supportsGetGeneratedKeys = Boolean.TRUE;
                this.databaseProductName = dB2ImplConnection.comm.ServerClassName.substring(1) + "/MVS";
                this.databaseProductVersion = dB2ImplConnection.comm.ServerProductID;
                this.catalogTerm = "LOCATION";
                this.maxColumnsInGroupBy = new Integer(750);
                this.maxColumnsInOrderBy = new Integer(750);
                this.maxColumnsInSelect = new Integer(750);
                this.maxColumnsInTable = new Integer(750);
                this.supportsSavepoints = Boolean.TRUE;
                this.allTablesAreSelectable = new Boolean(this.restrictGetTables);
                switch (dB2ImplConnection.comm.serverType) {
                    case 5: {
                        this.supportsOpenCursorsAcrossRollback = Boolean.FALSE;
                        this.maxColumnNameLength = new Integer(18);
                        this.maxColumnsInIndex = new Integer(64);
                        this.maxCursorNameLength = new Integer(18);
                        this.maxIndexLength = new Integer(254);
                        this.maxCatalogNameLength = new Integer(16);
                        this.maxProcedureNameLength = new Integer(18);
                        this.maxBinaryLiteralLength = new Integer(254);
                        this.maxCharLiteralLength = new Integer(254);
                        this.maxSchemaNameLength = new Integer(8);
                        this.maxUserNameLength = new Integer(8);
                        this.maxStatementLength = new Integer(32765);
                        break;
                    }
                    case 6: {
                        this.supportsOpenCursorsAcrossRollback = Boolean.TRUE;
                        this.maxColumnNameLength = new Integer(18);
                        this.maxColumnsInIndex = new Integer(64);
                        this.maxCursorNameLength = new Integer(18);
                        this.maxIndexLength = new Integer(254);
                        this.maxCatalogNameLength = new Integer(16);
                        this.maxProcedureNameLength = new Integer(18);
                        this.maxBinaryLiteralLength = new Integer(254);
                        this.maxCharLiteralLength = new Integer(254);
                        this.maxSchemaNameLength = new Integer(8);
                        this.maxUserNameLength = new Integer(8);
                        this.maxStatementLength = new Integer(32765);
                        break;
                    }
                    case 10: {
                        this.supportsOpenCursorsAcrossRollback = Boolean.TRUE;
                        this.maxColumnNameLength = new Integer(30);
                        this.maxColumnsInIndex = new Integer(128);
                        this.maxCursorNameLength = new Integer(30);
                        this.maxIndexLength = new Integer(2000);
                        this.maxCatalogNameLength = new Integer(128);
                        this.maxProcedureNameLength = new Integer(128);
                        this.maxBinaryLiteralLength = new Integer(32704);
                        this.maxCharLiteralLength = new Integer(32704);
                        this.maxSchemaNameLength = new Integer(128);
                        this.maxUserNameLength = new Integer(128);
                        this.maxStatementLength = new Integer(0x200000);
                        break;
                    }
                    default: {
                        this.supportsOpenCursorsAcrossRollback = Boolean.TRUE;
                        this.maxColumnNameLength = new Integer(30);
                        this.maxColumnsInIndex = new Integer(128);
                        this.maxCursorNameLength = new Integer(30);
                        this.maxIndexLength = new Integer(2000);
                        this.maxCatalogNameLength = new Integer(128);
                        this.maxProcedureNameLength = new Integer(128);
                        this.maxBinaryLiteralLength = new Integer(32704);
                        this.maxCharLiteralLength = new Integer(32704);
                        this.maxSchemaNameLength = new Integer(128);
                        this.maxUserNameLength = new Integer(128);
                        this.maxStatementLength = new Integer(0x200000);
                    }
                }
                this.numericFunctions = "ABS, ABSVAL, ACOS, ASIN, ATAN, ATANH, ATAN2, BIGINT, CEIL, CEILING, COS, COSH, CURRENCY, DEC, DECIMAL, DEGREES, DIGITS, DOUBLE, DOUBLE_PRECISION, EXP, FLOAT, FLOOR, INT, INTEGER, LN, LOG, LOG10, MOD, POWER, RADIANS, RAND, REAL, ROUND, ROWID, SIGN, SIN, SINH, SMALLINT, SQRT, TAN, TANH, TRUNCATE";
                this.stringFunctions = "BLOB, CHAR, CLOB, CONCAT, DBCLOB, GRAPHIC, HEX, INSERT, LCASE, LOWER, LEFT, LENGTH, LOCATE, LTRIM, POSSTR, REPEAT, REPLACE, RIGHT, RTRIM, SPACE, SUBSTR, STRIP, TRUNCATE, TRUNC, UCASE, UPPER, VARCHAR, VARGRAPHIC";
                this.systemFunctions = "COALESCE, IFNULL, NULLIF, RAISE_ERROR, TABLE_NAME,  TABLE_LOCATION, TABLE_SCHEMA, TRANSLATE, VALUE";
                this.timeDateFunctions = "ALTDATE, ALTTIME, DATE, DAY, DAYOFMONTH, DAYOFWEEK, DAYOFYEAR, DAYS, HOUR, JULIAN_DAY, MICROSECOND, MIDNIGHT_SECONDS, MINUTE, MONTH, MONTHNAME, QUARTER, SECOND, TIME, TIMESTAMP, WEATHER, WEEK, YEAR,";
                break;
            }
            default: {
                this.databaseProductVersion = dB2ImplConnection.comm.ServerReleaseLevel;
                this.databaseProductName = dB2ImplConnection.comm.ServerClassName.substring(1);
                this.catalogTerm = "DATABASE";
                this.maxColumnNameLength = new Integer(30);
                this.maxColumnsInGroupBy = new Integer(500);
                this.maxColumnsInIndex = new Integer(16);
                this.maxColumnsInOrderBy = new Integer(500);
                this.maxColumnsInSelect = new Integer(500);
                this.maxColumnsInTable = new Integer(500);
                this.maxCursorNameLength = new Integer(18);
                this.maxIndexLength = new Integer(1024);
                this.maxCatalogNameLength = new Integer(16);
                this.maxBinaryLiteralLength = new Integer(254);
                this.maxCharLiteralLength = new Integer(254);
                this.maxSchemaNameLength = new Integer(8);
                this.maxUserNameLength = new Integer(8);
                this.maxStatementLength = new Integer(32765);
                this.supportsGetGeneratedKeys = Boolean.FALSE;
                this.allTablesAreSelectable = new Boolean(this.restrictGetTables);
                this.supportsOpenCursorsAcrossRollback = Boolean.TRUE;
                String[] stringArray = null;
                switch (dB2ImplConnection.comm.serverType) {
                    case 7: {
                        String[] stringArray2;
                        stringArray = stringArray2 = new String[]{"", "", "", ""};
                        this.supportsSavepoints = Boolean.FALSE;
                        this.maxProcedureNameLength = new Integer(18);
                        break;
                    }
                    case 8: {
                        String[] stringArray3 = new String[]{"", "", "", ""};
                        stringArray = stringArray3;
                        this.supportsSavepoints = Boolean.FALSE;
                        this.supportsGetGeneratedKeys = Boolean.TRUE;
                        this.maxProcedureNameLength = new Integer(128);
                        break;
                    }
                    case 9: {
                        String[] stringArray4 = new String[]{", ATANH", ", COSH", ", SINH", ", TANH"};
                        stringArray = stringArray4;
                        this.supportsSavepoints = Boolean.TRUE;
                        this.supportsGetGeneratedKeys = Boolean.TRUE;
                        this.maxProcedureNameLength = new Integer(128);
                        break;
                    }
                    default: {
                        String[] stringArray5 = new String[]{"", "", "", ""};
                        stringArray = stringArray5;
                        this.supportsSavepoints = Boolean.FALSE;
                        this.maxProcedureNameLength = new Integer(18);
                    }
                }
                this.numericFunctions = "ABS, ABSVAL, ACOS, ASIN, ATAN" + stringArray[0] + ", ATAN2, BIGINT, CEIL, CEILING," + " COS" + stringArray[1] + ", COT, DECIMAL, DEGREES, DIGITS, DOUBLE, EXP, FLOAT," + " FLOOR, INTEGER, LN, LOG, LOG10, MOD, POWER, RADIANS, RAND, REAL," + " ROUND, SIGN, SIN" + stringArray[2] + ", SMALLINT, SQRT, TAN" + stringArray[3] + ", TRUNCATE";
                this.stringFunctions = "ASCII, BLOB, CHAR, CHR, CLOB, CONCAT, DBCLOB, DIFFERENCE, GRAPHIC, HEX, INSERT, LCASE, LOWER, LEFT, LENGTH, LOCATE, LONG_VARCHAR, LONG_VARGRAPHIC, LTRIM, POSSTR, REPEAT, REPLACE, RIGHT, RTRIM, SOUNDEX, SPACE, SUBSTR, TRUNCATE, TRUNC, UCASE, UPPER, VARCHAR, VARGRAPHIC";
                this.systemFunctions = "COALESCE, DEREF, DLCOMMENT, DLLINKTYPE, DLURLCOMPLETE, DLURLPATH, DLURLPATHONLY, DLURLSCHEME, DLURLSERVER, DLVALUE, EVENT_MON_STATE, GENERATE_UNIQUE, NODENUMBER, NULLIF, PARTITION, RAISE_ERROR, TABLE_NAME, TABLE_SCHEMA, TRANSLATE, TYPE_ID, TYPE_NAME, TYPE_SCHEMA, VALUE";
                this.timeDateFunctions = "DATE, DAY, DAYNAME, DAYOFWEEK, DAYOFYEAR, DAYS, HOUR, JULIAN_DAY, MICROSECOND, MIDNIGHT_SECONDS, MINUTE, MONTH, MONTHNAME, QUARTER, SECOND, TIME, TIMESTAMP, TIMESTAMP_ISO, TIMESTAMPDIFF, WEEK, YEAR,";
            }
        }
        this.SQLKeywords = " ADD, ALL, ALTER, AND, ANY, AS, AUDIT,  BETWEEN, BUFFERPOOL, BY, CALL, CASE, CAPTURE, CHAR, CHARACTER, CHECK, CLUSTER, COLLECTION, COLUMN, CONCAT, CONSTRAINT, COUNT, CURRENT, CURRENT_DATE, CURRENT_TIME, CURRENT_TIMESTAMP, CURSOR, DATABASE, DAY, DAYS, DEFAULT, DELETE, DESCRIPTOR, DISTINCT, DOUBLE, DROP, EDITPROC, END-EXEC (1), ERASE , SCAPE,  EXCEPT, EXECUTE, EXISTS, FIELDPROC, FOR , FROM, FULL, GO, GOTO, GRANT, GROUP, HAVING, HOUR, HOURS, IMMEDIATE, IN, INDEX, INNER, INOUT, INSERT, INTO, IS, REFERENCES, JOIN, KEY, LEFT, LIKE, LOCKMAX, LOCKSIZE, MICROSECOND, MICROSECONDS, MINUTE, MINUTES, MONTH, MONTHS, NOT, NULL, NUMPARTS, OBID, OF, ON, OPTIMIZE, OR, ORDER, OUT, OUTER, PACKAGE, PART, PLAN, PRECISION, PRIQTY, PRIVILEGES, PROGRAM, REFERENCES, RIGHT, SECOND, SECONDS, SECQTY, SELECT, SET, SOME, STOGROUP, SUBPAGES, SYNONYM, TABLE, TABLESPACE, TO, UNION, UNIQUE, UPDATE, USER, USING, VALIDPROC, VALUES, VCAT, VIEW, VOLUMES, WHERE, WITH, YEAR, YEARS";
        this.identifierQuoteString = "\"";
        this.catalogSeparator = ".";
        this.searchStringEscape = "\\";
        this.extraNameCharacters = "$, #, @";
        this.schemaTerm = "schema";
        this.procedureTerm = "STORED PROCEDURE";
        this.maxConnections = new Integer(0);
        this.maxRowSize = new Integer(0);
        this.maxTableNameLength = new Integer(128);
        this.maxTablesInSelect = new Integer(0);
        this.defaultTransactionIsolation = new Integer(2);
        this.sqlStateType = new Integer(1);
        this.databaseMajorVersion = new Integer(dB2ImplConnection.comm.serverMajorVersion);
        this.databaseMinorVersion = new Integer(dB2ImplConnection.comm.serverMinorVersion);
        this.databaseProductVersion = this.databaseMajorVersion + "." + this.databaseMinorVersion;
        this.resultSetHoldability = dB2ImplConnection.holdCursorsOverCommit ? new Integer(1) : new Integer(2);
        if (dB2ImplConnection.comm.databasePatchVersion != null) {
            this.databaseProductVersion = this.databaseProductVersion + "." + dB2ImplConnection.comm.databasePatchVersion;
        }
        this.doesMaxRowSizeIncludeBlobs = Boolean.TRUE;
        this.supportsTransactions = Boolean.TRUE;
        this.supportsTransactionIsolationLevel = Boolean.TRUE;
        this.supportsTransactionIsolationLevelReadUncommited = Boolean.TRUE;
        this.supportsTransactionIsolationLevelReadCommited = Boolean.TRUE;
        this.supportsTransactionIsolationLevelRepeatableRead = Boolean.TRUE;
        this.supportsTransactionIsolationLevelSerializable = Boolean.TRUE;
        this.supportsOpenCursorsAcrossCommit = Boolean.TRUE;
        this.supportsOpenStatementsAcrossCommit = Boolean.TRUE;
        this.isCatalogAtStart = Boolean.FALSE;
        this.supportsAlterTableWithAddColumn = Boolean.TRUE;
        this.supportsAlterTableWithDropColumn = Boolean.FALSE;
        this.supportsColumnAliasing = Boolean.TRUE;
        this.nullPlusNonNullIsNull = Boolean.TRUE;
        this.supportsConvert = Boolean.TRUE;
        this.supportsTableCorrelationNames = Boolean.TRUE;
        this.supportsDifferentTableCorrelationNames = Boolean.FALSE;
        this.supportsExpressionsInOrderBy = Boolean.TRUE;
        this.supportsOrderByUnrelated = Boolean.FALSE;
        this.supportsGroupBy = Boolean.TRUE;
        this.supportsGroupByUnrelated = Boolean.FALSE;
        this.supportsGroupByBeyondSelect = Boolean.TRUE;
        this.supportsLikeEscapeClause = Boolean.TRUE;
        this.supportsMultipleResultSets = Boolean.TRUE;
        this.supportsMultipleTransactions = Boolean.TRUE;
        this.supportsNonNullableColumns = Boolean.TRUE;
        this.supportsMinimumSQLGrammar = Boolean.TRUE;
        this.supportsCoreSQLGrammar = Boolean.TRUE;
        this.supportsExtendedSQLGrammar = Boolean.TRUE;
        this.supportsANSI92EntryLevelSQL = Boolean.TRUE;
        this.supportsANSI92IntermediateSQL = Boolean.FALSE;
        this.supportsANSI92FullSQL = Boolean.FALSE;
        this.supportsIntegrityEnhancementFacility = Boolean.TRUE;
        this.supportsOuterJoins = Boolean.TRUE;
        this.supportsFullOuterJoins = Boolean.FALSE;
        this.supportsLimitedOuterJoins = Boolean.TRUE;
        this.supportsSchemasInDataManipulation = Boolean.TRUE;
        this.supportsSchemasInProcedureCalls = Boolean.TRUE;
        this.supportsSchemasInTableDefinitions = Boolean.TRUE;
        this.supportsSchemasInIndexDefinitions = Boolean.TRUE;
        this.supportsSchemasInPrivilegeDefinitions = Boolean.TRUE;
        this.supportsCatalogsInDataManipulation = Boolean.FALSE;
        this.supportsCatalogsInProcedureCalls = Boolean.FALSE;
        this.supportsCatalogsInTableDefinitions = Boolean.FALSE;
        this.supportsCatalogsInIndexDefinitions = Boolean.FALSE;
        this.supportsCatalogsInPrivilegeDefinitions = Boolean.FALSE;
        this.supportsPositionedDelete = Boolean.FALSE;
        this.supportsPositionedUpdate = Boolean.FALSE;
        this.supportsSelectForUpdate = Boolean.FALSE;
        this.supportsStoredProcedures = Boolean.TRUE;
        this.supportsSubqueriesInComparisons = Boolean.TRUE;
        this.supportsSubqueriesInExists = Boolean.TRUE;
        this.supportsSubqueriesInIns = Boolean.TRUE;
        this.supportsSubqueriesInQuantifieds = Boolean.TRUE;
        this.supportsCorrelatedSubqueries = Boolean.TRUE;
        this.supportsUnion = Boolean.TRUE;
        this.supportsUnionAll = Boolean.TRUE;
        this.supportsOpenStatementsAcrossRollback = Boolean.TRUE;
        this.allProceduresAreCallable = Boolean.FALSE;
        this.isReadOnly = Boolean.FALSE;
        this.nullsAreSortedHigh = Boolean.TRUE;
        this.nullsAreSortedLow = Boolean.FALSE;
        this.nullsAreSortedAtStart = Boolean.FALSE;
        this.nullsAreSortedAtEnd = Boolean.FALSE;
        this.usesLocalFiles = Boolean.FALSE;
        this.usesLocalFilePerTable = Boolean.FALSE;
        this.supportsMixedCaseIdentifiers = Boolean.FALSE;
        this.storesUpperCaseIdentifiers = Boolean.TRUE;
        this.storesLowerCaseIdentifiers = Boolean.FALSE;
        this.storesMixedCaseIdentifiers = Boolean.FALSE;
        this.supportsMixedCaseQuotedIdentifiers = Boolean.TRUE;
        this.storesUpperCaseQuotedIdentifiers = Boolean.FALSE;
        this.storesLowerCaseQuotedIdentifiers = Boolean.FALSE;
        this.storesMixedCaseQuotedIdentifiers = Boolean.FALSE;
        this.supportsDataDefinitionAndDataManipulationTransactions = Boolean.TRUE;
        this.supportsDataManipulationTransactionsOnly = Boolean.FALSE;
        this.dataDefinitionCausesTransactionCommit = Boolean.FALSE;
        this.dataDefinitionIgnoredInTransactions = Boolean.FALSE;
        this.supportsResultSetTypeScrollInsensitive = Boolean.FALSE;
        this.supportsResultSetTypeScrollSensitive = Boolean.FALSE;
        this.ownUpdatesAreVisibleForwardOnly = Boolean.FALSE;
        this.ownUpdatesAreVisibleScrollInsensitive = Boolean.FALSE;
        this.ownUpdatesAreVisibleScrollSensitive = Boolean.FALSE;
        this.ownDeletesAreVisibleForwardOnly = Boolean.FALSE;
        this.ownDeletesAreVisibleScrollInsensitive = Boolean.FALSE;
        this.ownDeletesAreVisibleScrollSensitive = Boolean.FALSE;
        this.ownInsertsAreVisibleForwardOnly = Boolean.FALSE;
        this.ownInsertsAreVisibleScrollInsensitive = Boolean.FALSE;
        this.ownInsertsAreVisibleScrollSensitive = Boolean.FALSE;
        this.othersUpdatesAreVisibleForwardOnly = Boolean.FALSE;
        this.othersUpdatesAreVisibleScrollInsensitive = Boolean.FALSE;
        this.othersUpdatesAreVisibleScrollSensitive = Boolean.FALSE;
        this.othersDeletesAreVisibleForwardOnly = Boolean.FALSE;
        this.othersDeletesAreVisibleScrollInsensitive = Boolean.FALSE;
        this.othersDeletesAreVisibleScrollSensitive = Boolean.FALSE;
        this.othersInsertsAreVisibleForwardOnly = Boolean.FALSE;
        this.othersInsertsAreVisibleScrollInsensitive = Boolean.FALSE;
        this.othersInsertsAreVisibleScrollSensitive = Boolean.FALSE;
        this.updatesAreDetectedForwardOnly = Boolean.FALSE;
        this.updatesAreDetectedScrollInsensitive = Boolean.FALSE;
        this.updatesAreDetectedScrollSensitive = Boolean.FALSE;
        this.deletesAreDetectedForwardOnly = Boolean.FALSE;
        this.deletesAreDetectedScrollInsensitive = Boolean.FALSE;
        this.deletesAreDetectedScrollSensitive = Boolean.FALSE;
        this.insertsAreDetectedForwardOnly = Boolean.FALSE;
        this.insertsAreDetectedScrollInsensitive = Boolean.FALSE;
        this.insertsAreDetectedScrollSensitive = Boolean.FALSE;
        this.supportsBatchUpdates = Boolean.FALSE;
        this.locatorsUpdateCopy = Boolean.TRUE;
        this.supportsNamedParameters = Boolean.FALSE;
        this.supportsResultSetHoldability = Boolean.FALSE;
        this.supportsMultipleOpenResults = Boolean.TRUE;
        this.maxClientHostName = this.maxClientAppName = new Integer(255);
        this.maxClientUser = this.maxClientAppName;
    }

    public void initializeNonResultSetMetaData(int n) throws SQLException {
        switch (n) {
            case 101: {
                this.maxStatements = new Integer(this.con.comm.packageManager.getNumberOfSections());
            }
        }
    }

    protected boolean stripDoubleQuotesFromValues() {
        return true;
    }

    public boolean supportsConvert(int n, int n2) throws SQLException {
        return true;
    }

    protected BaseTypeInfos getTypeInfo() {
        DB2ImplDatabaseMetaData dB2ImplDatabaseMetaData = this;
        return dB2ImplDatabaseMetaData.mdLib.buildTypeInfo();
    }

    protected BaseTableTypes getTableTypes() {
        BaseTableTypes baseTableTypes = new BaseTableTypes();
        String[] stringArray = this.mdLib.getTableTypeNames();
        int n = 0;
        while (n < stringArray.length) {
            baseTableTypes.add(stringArray[n]);
            ++n;
        }
        return baseTableTypes;
    }

    public String getResultSetSQL(int n, BaseResultSetFilterDescriptor baseResultSetFilterDescriptor, BaseResultSetSortDescriptor baseResultSetSortDescriptor) {
        String string = null;
        switch (n) {
            case 1: {
                String[] stringArray;
                if (this.con.useCurrentSchema && ((stringArray = (String[])baseResultSetFilterDescriptor.getRestrictionByIndex(1)) == null || stringArray.equalsIgnoreCase("%"))) {
                    baseResultSetFilterDescriptor.setRestrictionByIndex(1, this.con.user.toUpperCase());
                }
                if (this.con.comm.supportsStoredProcMetadata && this.useCSPs && !this.restrictGetTables && !this.con.comm.disableTablesSystemProc) {
                    stringArray = DB2MetaDataLibrary.buildParameterSet(baseResultSetFilterDescriptor, 2, 3);
                    StringBuffer stringBuffer = new StringBuffer("{ call SYSIBM.SQLTABLES(");
                    if (baseResultSetFilterDescriptor.getRestriction(1) == null) {
                        stringBuffer.append("NULL,");
                    } else if (((String)baseResultSetFilterDescriptor.getRestriction(1)).equals(this.con.databaseName.toUpperCase())) {
                        stringBuffer.append("NULL,");
                    } else {
                        baseResultSetFilterDescriptor.removeAllRestrictions();
                        baseResultSetSortDescriptor.setSatisfied();
                        return null;
                    }
                    stringBuffer.append(stringArray[0] == null ? "NULL," : "'" + stringArray[0] + "',");
                    stringBuffer.append(stringArray[1] == null ? "NULL," : "'" + stringArray[1] + "',");
                    if (baseResultSetFilterDescriptor.getRestriction(4) == null) {
                        stringBuffer.append("NULL,");
                    } else {
                        String[] stringArray2 = (String[])baseResultSetFilterDescriptor.getRestriction(4);
                        stringBuffer.append("'");
                        boolean bl = false;
                        boolean bl2 = false;
                        int n2 = 0;
                        while (n2 < stringArray2.length) {
                            if (n2 != 0) {
                                stringBuffer.append(",");
                            }
                            if (stringArray2[n2].equals("TABLE") || stringArray2[n2].equals("ALIAS") || stringArray2[n2].equals("VIEW") || stringArray2[n2].equals("SYNONYMS") || stringArray2[n2].equals("SYNONYM") || stringArray2[n2].equals("NICKNAME") || stringArray2[n2].equals("SUMMARY TABLE") || stringArray2[n2].equals("HIERARCHY TABLE") || stringArray2[n2].equals("SYSTEM TABLE")) {
                                if ((stringArray2[n2].equals("SYNONYMS") || stringArray2[n2].equals("SYNONYM")) && this.con.comm.serverOS != 3 && !bl2) {
                                    stringBuffer.append("ALIAS");
                                    bl2 = true;
                                } else {
                                    stringBuffer.append(stringArray2[n2]);
                                }
                                bl = true;
                            }
                            ++n2;
                        }
                        if (bl) {
                            stringBuffer.append("',");
                        } else {
                            stringBuffer.append("NONE',");
                        }
                    }
                    stringBuffer.append("'DATATYPE=JDBC;DYNAMIC=0;REPORTPUBLICPRIVILEGES=1;CURSORHOLD=1') }");
                    string = stringBuffer.toString();
                    baseResultSetSortDescriptor.setSatisfied();
                    baseResultSetFilterDescriptor.removeAllRestrictions();
                    break;
                }
                if (this.con.comm.serverOS == 8) {
                    if ((this.con.comm.serverType == 3 || this.con.comm.serverType == 11) && this.restrictGetTables) {
                        string = this.mdLib.getAS400TableString(baseResultSetFilterDescriptor, baseResultSetSortDescriptor);
                        break;
                    }
                    string = this.mdLib.getTableString(baseResultSetFilterDescriptor, baseResultSetSortDescriptor);
                    break;
                }
                if (this.con.comm.serverOS == 3) {
                    string = this.mdLib.getMVSTableString(baseResultSetFilterDescriptor, baseResultSetSortDescriptor, this.restrictGetTables);
                    break;
                }
                string = this.mdLib.getUDBTableString(baseResultSetFilterDescriptor, baseResultSetSortDescriptor, this.restrictGetTables);
                break;
            }
            case 2: {
                String[] stringArray;
                if (this.con.useCurrentSchema && ((stringArray = (String[])baseResultSetFilterDescriptor.getRestrictionByIndex(1)) == null || stringArray.equalsIgnoreCase("%"))) {
                    baseResultSetFilterDescriptor.setRestrictionByIndex(1, this.con.user.toUpperCase());
                }
                if (this.con.comm.supportsStoredProcMetadata && this.useCSPs && !this.con.comm.disableColumnsSystemProc) {
                    stringArray = DB2MetaDataLibrary.buildParameterSet(baseResultSetFilterDescriptor, 2, 4);
                    StringBuffer stringBuffer = new StringBuffer("{ call SYSIBM.SQLCOLUMNS(");
                    if (baseResultSetFilterDescriptor.getRestriction(1) == null) {
                        stringBuffer.append("NULL,");
                    } else if (((String)baseResultSetFilterDescriptor.getRestriction(1)).equals(this.con.databaseName)) {
                        stringBuffer.append("NULL,");
                    } else {
                        baseResultSetFilterDescriptor.removeAllRestrictions();
                        baseResultSetSortDescriptor.setSatisfied();
                        return null;
                    }
                    stringBuffer.append(stringArray[0] == null ? "NULL," : "'" + stringArray[0] + "',");
                    stringBuffer.append(stringArray[1] == null ? "NULL," : "'" + stringArray[1] + "',");
                    stringBuffer.append(stringArray[2] == null ? "NULL," : "'" + stringArray[2] + "',");
                    stringBuffer.append("'DATATYPE=JDBC;DYNAMIC=0;REPORTPUBLICPRIVILEGES=1;CURSORHOLD=1') }");
                    string = stringBuffer.toString();
                    baseResultSetSortDescriptor.setSatisfied();
                    baseResultSetFilterDescriptor.removeAllRestrictions();
                    break;
                }
                if (this.con.comm.serverOS == 8) {
                    string = this.mdLib.getAS400ColumnString(baseResultSetFilterDescriptor, baseResultSetSortDescriptor);
                    break;
                }
                if (this.con.comm.serverOS == 3) {
                    string = this.mdLib.getMVSColumnString(baseResultSetFilterDescriptor, baseResultSetSortDescriptor);
                    break;
                }
                string = this.mdLib.getUDBColumnString(baseResultSetFilterDescriptor, baseResultSetSortDescriptor);
                break;
            }
            case 5: {
                if (this.con.comm.serverOS == 8) {
                    string = this.mdLib.getAS400ProcedureString(baseResultSetFilterDescriptor, baseResultSetSortDescriptor);
                    break;
                }
                if (this.con.comm.serverOS == 3) {
                    string = this.mdLib.getMVSProcedureString(baseResultSetFilterDescriptor, baseResultSetSortDescriptor);
                    break;
                }
                string = this.mdLib.getUDBProcedureString(baseResultSetFilterDescriptor, baseResultSetSortDescriptor);
                break;
            }
            case 6: {
                if (this.con.comm.serverOS == 8) {
                    string = this.mdLib.getAS400ProcedureColumnsString(baseResultSetFilterDescriptor, baseResultSetSortDescriptor);
                    break;
                }
                if (this.con.comm.serverOS == 3) {
                    string = this.mdLib.getMVSProcedureColumnsString(baseResultSetFilterDescriptor, baseResultSetSortDescriptor);
                    break;
                }
                string = this.mdLib.getUDBProcedureColumnsString(baseResultSetFilterDescriptor, baseResultSetSortDescriptor);
                break;
            }
            case 15: {
                if (this.con.comm.serverOS == 8) {
                    string = this.mdLib.getAS400SchemaString(baseResultSetFilterDescriptor, baseResultSetSortDescriptor);
                    break;
                }
                if (this.con.comm.serverOS == 3) {
                    string = this.mdLib.getMVSSchemaString(baseResultSetFilterDescriptor, baseResultSetSortDescriptor);
                    break;
                }
                string = this.mdLib.getUDBSchemaString(baseResultSetFilterDescriptor, baseResultSetSortDescriptor);
                break;
            }
            case 8: {
                if (this.con.comm.serverOS == 8) {
                    string = this.mdLib.getAS400CatalogString(baseResultSetFilterDescriptor, baseResultSetSortDescriptor);
                    break;
                }
                if (this.con.comm.serverOS == 3) {
                    string = this.mdLib.getMVSCatalogString(baseResultSetFilterDescriptor, baseResultSetSortDescriptor);
                    break;
                }
                string = this.mdLib.getUDBCatalogString(baseResultSetFilterDescriptor, baseResultSetSortDescriptor);
                break;
            }
            case 9: {
                if (this.con.comm.serverOS == 8) {
                    string = this.mdLib.getAS400ColumnPrivilegeString(baseResultSetFilterDescriptor, baseResultSetSortDescriptor);
                    break;
                }
                if (this.con.comm.serverOS == 3) {
                    string = this.mdLib.getMVSColumnPrivilegeString(baseResultSetFilterDescriptor, baseResultSetSortDescriptor);
                    break;
                }
                string = this.mdLib.getUDBColumnPrivilegeString(baseResultSetFilterDescriptor, baseResultSetSortDescriptor);
                break;
            }
            case 16: {
                if (this.con.comm.serverOS == 8) {
                    string = this.mdLib.getAS400TablePrivilegeString(baseResultSetFilterDescriptor, baseResultSetSortDescriptor);
                    break;
                }
                if (this.con.comm.serverOS == 3) {
                    string = this.mdLib.getMVSTablePrivilegeString(baseResultSetFilterDescriptor, baseResultSetSortDescriptor);
                    break;
                }
                string = this.mdLib.getUDBTablePrivilegeString(baseResultSetFilterDescriptor, baseResultSetSortDescriptor);
                break;
            }
            case 14: {
                if (this.con.comm.serverOS == 8) {
                    string = this.mdLib.getAS400PrimaryKeysString(baseResultSetFilterDescriptor, baseResultSetSortDescriptor);
                    break;
                }
                if (this.con.comm.serverOS == 3) {
                    string = this.mdLib.getMVSPrimaryKeysString(baseResultSetFilterDescriptor, baseResultSetSortDescriptor);
                    break;
                }
                string = this.mdLib.getUDBPrimaryKeysString(baseResultSetFilterDescriptor, baseResultSetSortDescriptor);
                break;
            }
            case 12: {
                if (this.con.comm.supportsStoredProcMetadata && !this.con.comm.disableImportedKeysSystemProc) {
                    String[] stringArray = DB2MetaDataLibrary.buildParameterSet(baseResultSetFilterDescriptor, 6, 7);
                    StringBuffer stringBuffer = new StringBuffer("{ call SYSIBM.SQLFOREIGNKEYS(");
                    if (baseResultSetFilterDescriptor.getRestriction(5) == null) {
                        stringBuffer.append("NULL,");
                    } else if (((String)baseResultSetFilterDescriptor.getRestriction(5)).equals(this.con.databaseName)) {
                        stringBuffer.append("NULL,");
                    } else {
                        baseResultSetFilterDescriptor.removeAllRestrictions();
                        baseResultSetSortDescriptor.setSatisfied();
                        return null;
                    }
                    stringBuffer.append("NULL, '', NULL,");
                    if (stringArray[0] == null) {
                        stringBuffer.append("NULL,");
                    } else if (stringArray[0].equalsIgnoreCase("")) {
                        stringBuffer.append("'*',");
                    } else {
                        stringBuffer.append("'" + stringArray[0] + "',");
                    }
                    if (stringArray[1] == null) {
                        stringBuffer.append("NULL,");
                    } else if (stringArray[1].equalsIgnoreCase("")) {
                        stringBuffer.append("'*',");
                    } else {
                        stringBuffer.append("'" + stringArray[1] + "',");
                    }
                    stringBuffer.append("'DATATYPE=JDBC;EXPORTEDKEY=1;CURSORHOLD=1') }");
                    string = stringBuffer.toString();
                    baseResultSetSortDescriptor.setSatisfied();
                    baseResultSetFilterDescriptor.removeAllRestrictions();
                    break;
                }
                if (this.con.comm.serverOS == 8) {
                    string = this.mdLib.getAS400ImportedKeysString(baseResultSetFilterDescriptor, baseResultSetSortDescriptor);
                    break;
                }
                if (this.con.comm.serverOS == 3) {
                    string = this.mdLib.getMVSImportedKeysString(baseResultSetFilterDescriptor, baseResultSetSortDescriptor);
                    break;
                }
                string = this.mdLib.getUDBImportedKeysString(baseResultSetFilterDescriptor, baseResultSetSortDescriptor);
                break;
            }
            case 11: {
                if (this.con.comm.supportsStoredProcMetadata) {
                    String[] stringArray = DB2MetaDataLibrary.buildParameterSet(baseResultSetFilterDescriptor, 2, 4);
                    StringBuffer stringBuffer = new StringBuffer("{ call SYSIBM.SQLFOREIGNKEYS(");
                    if (baseResultSetFilterDescriptor.getRestriction(1) == null) {
                        stringBuffer.append("NULL,");
                    } else if (((String)baseResultSetFilterDescriptor.getRestriction(1)).equals(this.con.databaseName)) {
                        stringBuffer.append("NULL,");
                    } else {
                        baseResultSetFilterDescriptor.removeAllRestrictions();
                        baseResultSetSortDescriptor.setSatisfied();
                        return null;
                    }
                    if (stringArray[0] == null) {
                        stringBuffer.append("NULL,");
                    } else if (stringArray[0] == "") {
                        stringBuffer.append("'*',");
                    } else {
                        stringBuffer.append("'" + stringArray[0] + "',");
                    }
                    if (stringArray[1] == null) {
                        stringBuffer.append("NULL,");
                    } else if (stringArray[1].equalsIgnoreCase("")) {
                        stringBuffer.append("'*',");
                    } else {
                        stringBuffer.append("'" + stringArray[1] + "',");
                    }
                    stringBuffer.append("'', NULL, '',");
                    stringBuffer.append("'DATATYPE=JDBC;EXPORTEDKEY=1;CURSORHOLD=1') }");
                    string = stringBuffer.toString();
                    baseResultSetSortDescriptor.setSatisfied();
                    baseResultSetFilterDescriptor.removeAllRestrictions();
                    break;
                }
                if (this.con.comm.serverOS == 8) {
                    string = this.mdLib.getAS400ExportedKeysString(baseResultSetFilterDescriptor, baseResultSetSortDescriptor);
                    break;
                }
                if (this.con.comm.serverOS == 3) {
                    string = this.mdLib.getMVSExportedKeysString(baseResultSetFilterDescriptor, baseResultSetSortDescriptor);
                    break;
                }
                string = this.mdLib.getUDBExportedKeysString(baseResultSetFilterDescriptor, baseResultSetSortDescriptor);
                break;
            }
            case 13: {
                if (this.con.comm.serverOS == 8) {
                    string = this.mdLib.getAS400IndexInfoString(baseResultSetFilterDescriptor, baseResultSetSortDescriptor);
                    break;
                }
                if (this.con.comm.serverOS == 3) {
                    string = this.mdLib.getMVSIndexInfoString(baseResultSetFilterDescriptor, baseResultSetSortDescriptor);
                    break;
                }
                string = this.mdLib.getUDBIndexInfoString(baseResultSetFilterDescriptor, baseResultSetSortDescriptor);
                break;
            }
            case 10: {
                if (this.con.comm.serverOS == 8) {
                    string = this.mdLib.getAS400CrossReferenceString(baseResultSetFilterDescriptor, baseResultSetSortDescriptor);
                    break;
                }
                if (this.con.comm.serverOS == 3) {
                    string = this.mdLib.getMVSCrossReferenceString(baseResultSetFilterDescriptor, baseResultSetSortDescriptor);
                    break;
                }
                string = this.mdLib.getUDBCrossReferenceString(baseResultSetFilterDescriptor, baseResultSetSortDescriptor);
                break;
            }
            case 7: {
                if (this.con.comm.supportsStoredProcMetadata) {
                    String[] stringArray = DB2MetaDataLibrary.buildParameterSet(baseResultSetFilterDescriptor, 0, 0);
                    StringBuffer stringBuffer = new StringBuffer("{ call SYSIBM.SQLSPECIALCOLUMNS(1, ");
                    if (stringArray[0] == null) {
                        stringBuffer.append("NULL,");
                    } else if (stringArray[0].equals(this.con.databaseName)) {
                        stringBuffer.append("NULL,");
                    } else {
                        baseResultSetFilterDescriptor.removeAllRestrictions();
                        baseResultSetSortDescriptor.setSatisfied();
                        return null;
                    }
                    if (stringArray[1] == null) {
                        stringBuffer.append("NULL,");
                    } else {
                        stringBuffer.append("'" + stringArray[1] + "',");
                    }
                    if (stringArray[2] == null) {
                        stringBuffer.append("NULL,");
                    } else if (stringArray[2].equalsIgnoreCase("")) {
                        stringBuffer.append("'*',");
                    } else {
                        stringBuffer.append("'" + stringArray[2] + "',");
                    }
                    stringBuffer.append(stringArray[3] + ", ");
                    if (stringArray[4].equalsIgnoreCase("true")) {
                        stringBuffer.append("1, ");
                    } else {
                        stringBuffer.append("0, ");
                    }
                    stringBuffer.append("'DATATYPE=JDBC;DYNAMIC=0;REPORTPUBLICPRIVILEGES=1;CURSORHOLD=1') }");
                    string = stringBuffer.toString();
                    baseResultSetSortDescriptor.setSatisfied();
                    baseResultSetFilterDescriptor.removeAllRestrictions();
                    break;
                }
                if (this.con.comm.serverOS == 8) {
                    string = this.mdLib.getAS400BestRowIdentifierString(baseResultSetFilterDescriptor, baseResultSetSortDescriptor);
                    break;
                }
                if (this.con.comm.serverOS == 3) {
                    string = this.mdLib.getMVSBestRowIdentifierString(baseResultSetFilterDescriptor, baseResultSetSortDescriptor);
                    break;
                }
                string = this.mdLib.getUDBBestRowIdentifierString(baseResultSetFilterDescriptor, baseResultSetSortDescriptor);
                break;
            }
            case 18: {
                if (this.con.comm.serverOS == 8) {
                    string = this.mdLib.getAS400VersionColumnString(baseResultSetFilterDescriptor, baseResultSetSortDescriptor);
                    break;
                }
                if (this.con.comm.serverOS == 3) {
                    string = this.mdLib.getMVSVersionColumnString(baseResultSetFilterDescriptor, baseResultSetSortDescriptor);
                    break;
                }
                string = this.mdLib.getUDBVersionColumnString(baseResultSetFilterDescriptor, baseResultSetSortDescriptor);
                break;
            }
            default: {
                string = null;
            }
        }
        if (string != null && string.trim().length() == 0) {
            string = null;
        }
        return string;
    }
}

