/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.jdbcx.informix;

import com.metamatrix.jdbc.base.BaseConnection;
import com.metamatrix.jdbc.base.BaseConnectionProperties;
import com.metamatrix.jdbc.informix.InformixConnection;
import com.metamatrix.jdbc.informix.sqli.InformixSQLICommunication;
import com.metamatrix.jdbcx.base.BaseImplXAResource;
import com.metamatrix.jdbcx.informix.InformixSQLIXARequest;
import javax.transaction.xa.XAException;
import javax.transaction.xa.Xid;

public class InformixImplXAResource
extends BaseImplXAResource {
    private static String footprint = "$Revision:   3.2.3.0  $";
    BaseConnectionProperties connectProps;
    int timeout;
    InformixSQLIXARequest request;
    Xid failedTxnXid;

    public InformixImplXAResource(BaseConnection baseConnection) {
        this.connection = baseConnection;
        this.connectProps = baseConnection.getConnectProperties();
        InformixSQLICommunication informixSQLICommunication = ((InformixConnection)baseConnection).getCommunication();
        this.request = new InformixSQLIXARequest(informixSQLICommunication);
        this.failedTxnXid = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void start(Xid xid, int n) throws XAException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            try {
                this.request.executeXA(72, xid, n);
            }
            catch (Exception exception) {
                throw new XAException(-3);
            }
            this.checkStatus();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void end(Xid xid, int n) throws XAException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            try {
                this.request.executeXA(68, xid, n);
            }
            catch (Exception exception) {
                throw new XAException(-3);
            }
            this.checkStatus();
            if (n == 0x20000000) {
                this.failedTxnXid = xid;
            } else if (xid.equals(this.failedTxnXid)) {
                this.failedTxnXid = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int prepare(Xid xid) throws XAException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            try {
                this.request.executeXA(70, xid, 0);
            }
            catch (Exception exception) {
                throw new XAException(-3);
            }
            this.checkStatus();
            return this.request.xaStatus == 0 ? 0 : 3;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void commit(Xid xid, boolean bl) throws XAException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            try {
                int n = bl ? 0x40000000 : 0;
                this.request.executeXA(67, xid, n);
            }
            catch (Exception exception) {
                throw new XAException(-3);
            }
            this.checkStatus();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void rollback(Xid xid) throws XAException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            if (xid.equals(this.failedTxnXid)) {
                this.failedTxnXid = null;
                return;
            }
            try {
                this.request.executeXA(65, xid, 0);
            }
            catch (Exception exception) {
                throw new XAException(-3);
            }
            this.checkStatus();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void forget(Xid xid) throws XAException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            try {
                this.request.executeXA(69, xid, 0);
            }
            catch (Exception exception) {
                throw new XAException(-3);
            }
            this.checkStatus();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Xid[] recover(int n) throws XAException {
        BaseConnection baseConnection = this.connection;
        synchronized (baseConnection) {
            try {
                this.request.executeXA(71, null, n);
            }
            catch (Exception exception) {
                throw new XAException(-3);
            }
            this.checkStatus();
            return this.request.recoverXids;
        }
    }

    protected boolean setTransactionTimeout(int n) throws XAException {
        if (n < 0) {
            throw new XAException(-5);
        }
        this.timeout = n;
        return false;
    }

    protected int getTransactionTimeout() throws XAException {
        return this.timeout;
    }

    protected String getRmIdentification() throws XAException {
        String string = this.connectProps.get("serverName");
        String string2 = this.connectProps.get("portNumber");
        String string3 = this.connectProps.get("databaseName");
        String string4 = this.connectProps.get("user");
        String string5 = string + "_" + string2 + "_" + string3 + "_" + string4;
        return string5;
    }

    void checkStatus() throws XAException {
        if (this.request.xaStatus >= 0) {
            return;
        }
        throw new XAException(this.request.xaStatus);
    }
}

