/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.connector.jdbc.oracle;

import com.metamatrix.common.types.DataTypeManager;
import com.metamatrix.connector.jdbc.extension.SQLConversionVisitor;
import com.metamatrix.connector.jdbc.oracle.Oracle8CriteriaPatternReplacementVisitor;
import com.metamatrix.connector.jdbc.oracle.Oracle8JoinCriteriaCollectorVisitor;
import com.metamatrix.connector.jdbc.oracle.Oracle8SQLConversionVisitor;
import com.metamatrix.connector.jdbc.oracle.OracleSQLTranslator;
import com.metamatrix.data.api.ExecutionContext;
import com.metamatrix.data.language.ICommand;
import com.metamatrix.data.language.ICriteria;
import com.metamatrix.data.language.IExpression;
import com.metamatrix.data.language.IFrom;
import com.metamatrix.data.language.ILanguageFactory;
import com.metamatrix.data.language.ILanguageObject;
import com.metamatrix.data.language.ILiteral;
import com.metamatrix.data.language.IQuery;
import com.metamatrix.data.language.ISelectSymbol;
import com.metamatrix.data.language.IUnion;
import com.metamatrix.data.language.LanguageUtil;
import com.metamatrix.data.visitor.framework.DelegatingHierarchyVisitor;
import com.metamatrix.data.visitor.framework.HierarchyVisitor;
import com.metamatrix.data.visitor.framework.LanguageObjectVisitor;
import com.metamatrix.data.visitor.util.CollectorVisitor;
import com.metamatrix.dqp.internal.datamgr.language.FunctionImpl;
import com.metamatrix.dqp.internal.datamgr.language.LiteralImpl;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class Oracle8SQLTranslator
extends OracleSQLTranslator {
    public SQLConversionVisitor getTranslationVisitor() {
        Oracle8SQLConversionVisitor visitor = new Oracle8SQLConversionVisitor();
        visitor.setRuntimeMetadata(this.getRuntimeMetadata());
        visitor.setFunctionModifiers(this.getFunctionModifiers());
        visitor.setProperties(this.getConnectorEnvironment().getProperties());
        visitor.setLanguageFactory(this.getConnectorEnvironment().getLanguageFactory());
        visitor.setDatabaseTimeZone(this.getDatabaseTimeZone());
        return visitor;
    }

    protected ICommand modifySingleCommand(ICommand command, ExecutionContext context) {
        if ((command = super.modifySingleCommand(command, context)) instanceof IQuery && (command = this.removeJoinPredicates(command)) instanceof IUnion) {
            this.replaceNullLiterals(command);
        }
        return command;
    }

    private void replaceNullLiterals(ICommand command) {
        HierarchyVisitor visitor = new HierarchyVisitor(){

            public void visit(ISelectSymbol obj) {
                if (!(obj.getExpression() instanceof ILiteral)) {
                    return;
                }
                ILiteral literal = (ILiteral)obj.getExpression();
                if (literal.getValue() == null && literal.getType() != DataTypeManager.DefaultDataClasses.NULL) {
                    LiteralImpl typeLiteral = new LiteralImpl((Object)DataTypeManager.getDataTypeName((Class)literal.getType()), DataTypeManager.DefaultDataClasses.STRING);
                    obj.setExpression((IExpression)new FunctionImpl("convert", new IExpression[]{literal, typeLiteral}, literal.getType()));
                }
            }
        };
        command.acceptVisitor((LanguageObjectVisitor)visitor);
    }

    private ICommand removeJoinPredicates(ICommand command) {
        Oracle8JoinCriteriaCollectorVisitor joinCriteriaCollectorVisitor = new Oracle8JoinCriteriaCollectorVisitor();
        List joinCriterias = this.collectJoinCriterias(command, joinCriteriaCollectorVisitor);
        this.replaceInnerElementPattern(command, joinCriteriaCollectorVisitor.getInnerGroupSymbols());
        command = this.copyGroupsFromJoinPredicatesToFromClause(command);
        command = this.moveJoinCriteriaToWhereClause(joinCriterias, command);
        return command;
    }

    private List collectJoinCriterias(ICommand command, Oracle8JoinCriteriaCollectorVisitor joinCriteriaCollectorVisitor) {
        UnionFirstBranchOnlyDelegatingHierarchyVisitor.preOrderVisit((LanguageObjectVisitor)joinCriteriaCollectorVisitor, (ILanguageObject)command);
        return joinCriteriaCollectorVisitor.getCriteriaList();
    }

    private void replaceInnerElementPattern(ICommand command, List innerGroupSymbols) {
        Oracle8CriteriaPatternReplacementVisitor critPatternReplacementVisitor = new Oracle8CriteriaPatternReplacementVisitor(innerGroupSymbols);
        UnionFirstBranchOnlyDelegatingHierarchyVisitor.preOrderVisit((LanguageObjectVisitor)critPatternReplacementVisitor, (ILanguageObject)command);
    }

    private ICommand copyGroupsFromJoinPredicatesToFromClause(ICommand command) {
        IQuery query = (IQuery)command;
        IFrom from = query.getFrom();
        Collection groups = CollectorVisitor.collectGroups((ILanguageObject)from);
        Iterator i = groups.iterator();
        LinkedList additionalClauses = new LinkedList();
        while (i.hasNext()) {
            Object group = i.next();
            additionalClauses.add(group);
        }
        from.setItems(additionalClauses);
        return command;
    }

    private ICommand moveJoinCriteriaToWhereClause(List joinCriterias, ICommand command) {
        IQuery query = (IQuery)command;
        ICriteria criteria = query.getWhere();
        Iterator criterias = joinCriterias.iterator();
        while (criterias.hasNext()) {
            ICriteria nextCriteria = (ICriteria)criterias.next();
            criteria = LanguageUtil.combineCriteria((ICriteria)criteria, (ICriteria)nextCriteria, (ILanguageFactory)this.getConnectorEnvironment().getLanguageFactory());
        }
        query.setWhere(criteria);
        return command;
    }

    private static class UnionFirstBranchOnlyDelegatingHierarchyVisitor
    extends DelegatingHierarchyVisitor {
        public static void preOrderVisit(LanguageObjectVisitor behaviorVisitor, ILanguageObject object) {
            UnionFirstBranchOnlyDelegatingHierarchyVisitor hierarchyVisitor = new UnionFirstBranchOnlyDelegatingHierarchyVisitor(behaviorVisitor, null);
            object.acceptVisitor((LanguageObjectVisitor)hierarchyVisitor);
        }

        public UnionFirstBranchOnlyDelegatingHierarchyVisitor(LanguageObjectVisitor preProcessingDelegate, LanguageObjectVisitor postProcessingDelegate) {
            super(preProcessingDelegate, postProcessingDelegate);
        }

        public void visit(IUnion obj) {
            if (this.getPreVisitor() != null) {
                this.getPreVisitor().visit(obj);
            }
            this.visitNode((ILanguageObject)obj.getSelect());
            this.visitNode((ILanguageObject)obj.getFrom());
            this.visitNode((ILanguageObject)obj.getWhere());
            this.visitNode((ILanguageObject)obj.getGroupBy());
            this.visitNode((ILanguageObject)obj.getHaving());
            this.visitNode((ILanguageObject)obj.getOrderBy());
            this.visitNode((ILanguageObject)obj.getUnionOrderBy());
            if (this.getPostVisitor() != null) {
                this.getPostVisitor().visit(obj);
            }
        }
    }
}

