/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.jdbc.db2.drda;

import com.metamatrix.jdbc.base.BaseInputStreamWrapper;
import com.metamatrix.jdbc.base.BaseParameter;
import com.metamatrix.jdbc.base.BaseWarnings;
import com.metamatrix.jdbc.db2.DB2ImplConnection;
import com.metamatrix.jdbc.db2.DB2ImplResultSet;
import com.metamatrix.jdbc.db2.DB2ImplStatement;
import com.metamatrix.jdbc.db2.drda.DRDAByteOrderedDataReader;
import com.metamatrix.jdbc.db2.drda.DRDAByteOrderedDataWriter;
import com.metamatrix.jdbc.db2.drda.DRDAColumn;
import com.metamatrix.jdbc.db2.drda.DRDACommunication;
import com.metamatrix.jdbc.db2.drda.DRDAParameter;
import com.metamatrix.jdbc.db2.drda.DRDAPkgNamCsn;
import com.metamatrix.jdbc.db2.drda.DRDAStatementRequest;
import com.metamatrix.util.UtilException;
import com.metamatrix.util.UtilPagedTempBuffer;
import java.sql.SQLException;

public class DRDAExecuteStatementRequest
extends DRDAStatementRequest {
    private static String footprint = "$Revision:   3.26.1.4  $";
    public DB2ImplStatement implStmt;
    public String spName;
    public boolean executingBatch;
    public boolean processingSQLCAforPrepare;
    public boolean lastBatchStatement;
    public int[] updateCounts;
    public int currentUpdateCount;
    public int currentExceptionCount;
    boolean cachingResults;
    boolean cachedRS_moreData;
    boolean cachedRS_isCursorOpen;
    public short queryProtocol;

    public DRDAExecuteStatementRequest(DB2ImplConnection dB2ImplConnection, DRDACommunication dRDACommunication, DRDAByteOrderedDataReader dRDAByteOrderedDataReader, DRDAByteOrderedDataWriter dRDAByteOrderedDataWriter, DB2ImplStatement dB2ImplStatement, DRDAPkgNamCsn dRDAPkgNamCsn) {
        super(dB2ImplConnection, dRDACommunication, dRDAByteOrderedDataReader, dRDAByteOrderedDataWriter, dRDAPkgNamCsn);
        this.implStmt = dB2ImplStatement;
    }

    public void setToPrepared() throws SQLException {
        super.setToPrepared();
        this.executingBatch = false;
        this.lastBatchStatement = true;
        this.updateCounts = null;
        this.currentUpdateCount = 0;
        this.currentExceptionCount = 0;
    }

    public void writeEXCSQLSTT(int n) throws SQLException {
        try {
            int n2;
            int n3;
            int n4;
            int n5;
            boolean bl;
            int n6 = n;
            boolean bl2 = bl = this.parameterDescriptions != null && this.numParams > 0;
            if (n6 == 1 && this.implConn.isXAImplConn && this.implConn.inLocalTransaction && this.implConn.comm.useBetaXAImplementation) {
                int n7 = ++n6;
                ++n6;
                n5 = this.writer.writePacketHeader((short)1, (short)64, n7);
                n4 = this.writer.writeCodePoint((short)4181);
                this.writer.writeInt16(5);
                this.writer.writeInt16(4487);
                this.writer.writeInt8(9);
                this.writer.writeInt16(8);
                this.writer.writeInt16(6145);
                this.writer.writeInt32(-1);
                this.writer.writeInt16(8);
                this.writer.writeInt16(6403);
                this.writer.writeInt32(0);
                this.writer.writeCodePointLength(n4);
                this.writer.writePacketLength(n5);
            }
            n5 = 0;
            n5 = bl ? this.writer.writePacketHeader((short)1, (short)80, n6) : (this.implConn.inAutoCommit && this.implConn.inLocalTransaction && this.chainCommit && !this.isStoredProcedure ? this.writer.writePacketHeader((short)1, (short)64, n6++) : this.writer.writePacketHeader((short)1, (short)0, n6));
            n4 = this.writer.writeCodePoint((short)8203);
            this.writer.writePKGNAMCSN(this.packageConsistencyToken);
            this.writer.writeInt16(5);
            this.writer.writeInt16(8465);
            if (this.lobLocParam != null || bl && this.isStoredProcedure) {
                this.writer.writeInt8(241);
            } else {
                this.writer.writeInt8(240);
            }
            if (this.isStoredProcedure) {
                if (!this.comm.enableRealStoredProcPrepare) {
                    n3 = this.writer.writeCodePoint((short)8504);
                    this.writer.writeString(this.spName);
                    this.writer.writeCodePointLength(n3);
                }
                this.writer.writeInt16(5);
                this.writer.writeInt16(8453);
                this.writer.writeInt8(241);
                this.writer.writeInt16(8);
                this.writer.writeInt16(8468);
                if (this.comm.SQLAMLevel < 7) {
                    this.writer.writeInt32(Short.MAX_VALUE);
                } else {
                    this.writer.writeInt32(Short.MAX_VALUE);
                }
                this.writer.writeInt16(6);
                this.writer.writeInt16(8512);
                this.writer.writeInt16(65535);
                this.writer.writeInt16(5);
                this.writer.writeInt16(8514);
                this.writer.writeInt8(224);
            }
            this.writer.writeCodePointLength(n4);
            this.writer.writePacketLength(n5);
            if (bl) {
                n3 = 0;
                n3 = this.implConn.inAutoCommit && this.implConn.inLocalTransaction && this.chainCommit && !this.isStoredProcedure ? this.writer.writePacketHeader((short)3, (short)64, n6++) : (this.executingBatch && !this.lastBatchStatement ? this.writer.writePacketHeader((short)3, (short)64, n6++) : this.writer.writePacketHeader((short)3, (short)0, n6++));
                n2 = this.writer.writeCodePoint((short)9234);
                int n8 = this.writer.writeCodePoint((short)16);
                this.writeFDODSC(false);
                this.writer.writeCodePointLength(n8);
                int n9 = this.writer.writeCodePoint((short)5242);
                this.writeFDODTA();
                this.writer.writeCodePointLength(n9);
                this.writer.writeCodePointLength(n2);
                if (this.lobInsertPos != 0) {
                    this.writer.writeNewPacketHeaderWithLen(n3, (short)3, (short)80, --n6);
                } else {
                    this.writer.writePacketLength(n3);
                }
                if (this.lobInsertPos != 0) {
                    int n10 = 0;
                    while (n10 < this.lobInsertPos) {
                        int n11;
                        int n12 = 0;
                        n12 = this.implConn.inAutoCommit && this.implConn.inLocalTransaction && this.chainCommit && !this.isStoredProcedure ? (n10 == this.lobInsertPos - 1 ? this.writer.writePacketHeader((short)3, (short)64, n6++) : this.writer.writePacketHeader((short)3, (short)80, n6)) : (n10 == this.lobInsertPos - 1 ? (this.executingBatch && !this.lastBatchStatement ? this.writer.writePacketHeader((short)3, (short)64, n6) : this.writer.writePacketHeader((short)3, (short)0, n6)) : this.writer.writePacketHeader((short)3, (short)80, n6));
                        BaseParameter baseParameter = this.parameterDescriptions.getInput(this.lobColumns[n10]);
                        long l = 0L;
                        l = ((BaseInputStreamWrapper)baseParameter.getObject()).determineLength();
                        if (l <= 32753L) {
                            if (this.comm.SQLAMLevel < 7) {
                                this.writer.writeInt16((int)l + 4);
                                n11 = this.writer.currentBufferInsertPosition;
                                this.writer.currentBufferInsertPosition = n12;
                                this.writer.writeInt16((int)l + 10);
                                this.writer.currentBufferInsertPosition = n11;
                                this.writer.writeInt16(5228);
                            } else {
                                this.writer.writeInt16((int)l + 5);
                                n11 = this.writer.currentBufferInsertPosition;
                                this.writer.currentBufferInsertPosition = n12;
                                this.writer.writeInt16((int)l + 11);
                                this.writer.currentBufferInsertPosition = n11;
                                this.writer.writeInt16(5228);
                                if (baseParameter.isNull()) {
                                    this.writer.writeInt8(255);
                                } else {
                                    this.writer.writeInt8(0);
                                }
                            }
                        } else {
                            this.writer.writeInt16(32776);
                            n11 = this.writer.currentBufferInsertPosition;
                            this.writer.currentBufferInsertPosition = n12;
                            this.writer.writeInt16(65535);
                            this.writer.currentBufferInsertPosition = n11;
                            this.writer.writeInt16(5228);
                            if (this.comm.SQLAMLevel < 7) {
                                this.writer.writeInt32((int)l);
                            } else {
                                this.writer.writeInt32((int)l + 1);
                                if (baseParameter.isNull()) {
                                    this.writer.writeInt8(255);
                                } else {
                                    this.writer.writeInt8(0);
                                }
                            }
                        }
                        if (l <= 32753L) {
                            this.writer.writeStream((BaseInputStreamWrapper)baseParameter.getObject(), (int)l);
                        } else {
                            n11 = 0;
                            n11 = this.comm.SQLAMLevel >= 7 ? 32752 : 32753;
                            this.writer.writeStream((BaseInputStreamWrapper)baseParameter.getObject(), n11);
                            this.writer.send();
                            long l2 = l - (long)n11;
                            while (l2 > 32765L) {
                                this.writer.writeInt16(65535);
                                this.writer.writeStream((BaseInputStreamWrapper)baseParameter.getObject(), 32765);
                                l2 -= 32765L;
                                this.writer.send();
                            }
                            this.writer.writeInt16((int)l2 + 2);
                            this.writer.writeStream((BaseInputStreamWrapper)baseParameter.getObject(), (int)l2);
                        }
                        ++n10;
                    }
                }
            }
            if (this.implConn.inAutoCommit && this.implConn.inLocalTransaction && this.chainCommit && !this.isStoredProcedure) {
                if (this.implConn.isXAImplConn && this.implConn.comm.useBetaXAImplementation) {
                    n3 = this.writer.writePacketHeader((short)1, (short)0, n6);
                    n2 = this.writer.writeCodePoint((short)4181);
                    this.writer.writeInt16(5);
                    this.writer.writeInt16(4487);
                    this.writer.writeInt8(3);
                    this.writer.writeInt16(8);
                    this.writer.writeInt16(6145);
                    this.writer.writeInt32(-1);
                    this.writer.writeInt16(8);
                    this.writer.writeInt16(6403);
                    this.writer.writeInt32(0x10000000);
                    this.writer.writeCodePointLength(n2);
                    this.writer.writePacketLength(n3);
                } else {
                    n3 = this.writer.writePacketHeader((short)1, (short)0, n6);
                    n2 = this.writer.writeCodePoint((short)8206);
                    this.writer.writeCodePointLength(n2);
                    this.writer.writePacketLength(n3);
                }
            }
        }
        catch (Exception exception) {
            try {
                this.writer.empty();
            }
            catch (UtilException utilException) {
                // empty catch block
            }
            if (exception instanceof UtilException) {
                throw this.comm.exceptions.getException(exception);
            }
            throw (SQLException)exception;
        }
    }

    public void writeEXCSQLIMM(String string, int n) throws SQLException {
        try {
            int n2;
            int n3;
            int n4 = 1 + n;
            if (n4 == 1 && this.implConn.isXAImplConn && this.implConn.inLocalTransaction && this.implConn.comm.useBetaXAImplementation) {
                n3 = this.writer.writePacketHeader((short)1, (short)64, n4++);
                n2 = this.writer.writeCodePoint((short)4181);
                this.writer.writeInt16(5);
                this.writer.writeInt16(4487);
                this.writer.writeInt8(9);
                this.writer.writeInt16(8);
                this.writer.writeInt16(6145);
                this.writer.writeInt32(-1);
                this.writer.writeInt16(8);
                this.writer.writeInt16(6403);
                this.writer.writeInt32(0);
                this.writer.writeCodePointLength(n2);
                this.writer.writePacketLength(n3);
            }
            n3 = this.writer.writePacketHeader((short)1, (short)80, n4);
            n2 = this.writer.writeCodePoint((short)8202);
            this.writer.writePKGNAMCSN(this.packageConsistencyToken);
            this.writer.writeInt16(5);
            this.writer.writeInt16(8453);
            this.writer.writeInt8(241);
            this.writer.writeCodePointLength(n2);
            this.writer.writePacketLength(n3);
            int n5 = 0;
            n5 = this.implConn.inAutoCommit && this.implConn.inLocalTransaction && this.chainCommit ? this.writer.writePacketHeader((short)3, (short)64, n4++) : (this.executingBatch && !this.lastBatchStatement ? this.writer.writePacketHeader((short)3, (short)64, n4++) : this.writer.writePacketHeader((short)3, (short)0, n4));
            int n6 = this.writer.writeCodePoint((short)9236);
            if (this.comm.SQLAMLevel >= 7) {
                this.writer.writeInt8(0);
                this.writer.writeEncodedStringWithLength32(string, this.comm.MultiByteClientTransliterator);
                this.writer.writeInt8(255);
            } else if (this.comm.serverType == 2) {
                this.writer.writeInt16(0);
                this.writer.writeEncodedStringWithLength16(string, this.comm.SingleByteClientTransliterator);
            } else {
                this.writer.writeEncodedStringWithLength16(string, this.comm.MultiByteClientTransliterator);
                this.writer.writeInt16(0);
            }
            this.writer.writeCodePointLength(n6);
            this.writer.writePacketLength(n5);
            if (this.implConn.inAutoCommit && this.implConn.inLocalTransaction && this.chainCommit) {
                if (this.implConn.isXAImplConn && this.implConn.comm.useBetaXAImplementation) {
                    int n7 = this.writer.writePacketHeader((short)1, (short)0, n4);
                    int n8 = this.writer.writeCodePoint((short)4181);
                    this.writer.writeInt16(5);
                    this.writer.writeInt16(4487);
                    this.writer.writeInt8(3);
                    this.writer.writeInt16(8);
                    this.writer.writeInt16(6145);
                    this.writer.writeInt32(-1);
                    this.writer.writeInt16(8);
                    this.writer.writeInt16(6403);
                    this.writer.writeInt32(0x10000000);
                    this.writer.writeCodePointLength(n8);
                    this.writer.writePacketLength(n7);
                } else {
                    int n9 = this.writer.writePacketHeader((short)1, (short)0, n4);
                    int n10 = this.writer.writeCodePoint((short)8206);
                    this.writer.writeCodePointLength(n10);
                    this.writer.writePacketLength(n9);
                }
            }
        }
        catch (Exception exception) {
            try {
                this.writer.empty();
            }
            catch (UtilException utilException) {
                // empty catch block
            }
            if (exception instanceof UtilException) {
                throw this.comm.exceptions.getException(exception);
            }
            throw (SQLException)exception;
        }
    }

    public void writeEXCSQLSET(String string, int n) throws SQLException {
        try {
            int n2;
            int n3;
            int n4 = 1 + n;
            if (n4 == 1 && this.implConn.isXAImplConn && this.implConn.inLocalTransaction) {
                n3 = this.writer.writePacketHeader((short)1, (short)64, n4++);
                n2 = this.writer.writeCodePoint((short)4181);
                this.writer.writeInt16(5);
                this.writer.writeInt16(4487);
                this.writer.writeInt8(9);
                this.writer.writeInt16(8);
                this.writer.writeInt16(6145);
                this.writer.writeInt32(-1);
                this.writer.writeInt16(8);
                this.writer.writeInt16(6403);
                this.writer.writeInt32(0);
                this.writer.writeCodePointLength(n2);
                this.writer.writePacketLength(n3);
            }
            n3 = this.writer.writePacketHeader((short)1, (short)80, n4);
            n2 = this.writer.writeCodePoint((short)8212);
            this.writer.writePKGNAMCSN(this.packageConsistencyToken);
            this.writer.writeCodePointLength(n2);
            this.writer.writePacketLength(n3);
            int n5 = 0;
            n5 = this.implConn.inAutoCommit && this.implConn.inLocalTransaction && this.chainCommit ? this.writer.writePacketHeader((short)3, (short)64, n4++) : (this.executingBatch && !this.lastBatchStatement ? this.writer.writePacketHeader((short)3, (short)64, n4++) : this.writer.writePacketHeader((short)3, (short)0, n4));
            int n6 = this.writer.writeCodePoint((short)9236);
            if (this.comm.SQLAMLevel >= 7) {
                this.writer.writeInt8(0);
                this.writer.writeEncodedStringWithLength32(string, this.comm.SingleByteClientTransliterator);
                this.writer.writeInt8(255);
            } else {
                this.writer.writeInt16(0);
                this.writer.writeEncodedStringWithLength16(string, this.comm.SingleByteClientTransliterator);
            }
            this.writer.writeCodePointLength(n6);
            this.writer.writePacketLength(n5);
            if (this.implConn.inAutoCommit && this.implConn.inLocalTransaction && this.chainCommit) {
                if (this.implConn.isXAImplConn) {
                    int n7 = this.writer.writePacketHeader((short)1, (short)0, n4);
                    int n8 = this.writer.writeCodePoint((short)4181);
                    this.writer.writeInt16(5);
                    this.writer.writeInt16(4487);
                    this.writer.writeInt8(3);
                    this.writer.writeInt16(8);
                    this.writer.writeInt16(6145);
                    this.writer.writeInt32(-1);
                    this.writer.writeInt16(8);
                    this.writer.writeInt16(6403);
                    this.writer.writeInt32(0x10000000);
                    this.writer.writeCodePointLength(n8);
                    this.writer.writePacketLength(n7);
                } else {
                    int n9 = this.writer.writePacketHeader((short)1, (short)0, n4);
                    int n10 = this.writer.writeCodePoint((short)8206);
                    this.writer.writeCodePointLength(n10);
                    this.writer.writePacketLength(n9);
                }
            }
        }
        catch (Exception exception) {
            try {
                this.writer.empty();
            }
            catch (UtilException utilException) {
                // empty catch block
            }
            if (exception instanceof UtilException) {
                throw this.comm.exceptions.getException(exception);
            }
            throw (SQLException)exception;
        }
    }

    public boolean processCodePoint(int n, int n2, BaseWarnings baseWarnings) throws SQLException {
        try {
            switch (n2) {
                case 8729: 
                case 9235: {
                    break;
                }
                case 8709: {
                    if (this.numResultSets >= 1) {
                        this.resultSetArray = new DB2ImplResultSet[this.numResultSets];
                        this.createResultSetCaches(baseWarnings);
                    }
                    this.isCursorOpen = true;
                    this.moreData = true;
                    this.resultType = 2;
                    if (this.numResultSets >= 1) {
                        return false;
                    }
                    break;
                }
                case 8505: {
                    this.numResultSets = n / 68;
                    this.packageNameCsnList = new DRDAPkgNamCsn[this.numResultSets];
                    int n3 = 0;
                    while (n3 < this.numResultSets) {
                        this.reader.readAndDiscardBytes(4);
                        String string = this.reader.readEncodedString(18, this.comm.defaultCCSIDTransliterator);
                        String string2 = this.reader.readEncodedString(18, this.comm.defaultCCSIDTransliterator);
                        String string3 = this.reader.readEncodedString(18, this.comm.defaultCCSIDTransliterator);
                        String string4 = this.reader.readEncodedString(8, this.comm.transliteratorPool.getTransliteratorForCodePage("1252"));
                        short s = this.reader.readInt16();
                        this.packageNameCsnList[n3] = new DRDAPkgNamCsn(string, string2, string3, s, string4);
                        ++n3;
                    }
                    break;
                }
                case 16: {
                    this.processFDODSC(n, true);
                    break;
                }
                case 5242: {
                    int n4 = this.reader.readPosition + n;
                    this.processSQLCA(baseWarnings);
                    this.updateParameterData();
                    int n5 = this.storedProcedureParams.size();
                    int n6 = 0;
                    while (n6 < n5) {
                        DRDAParameter dRDAParameter = (DRDAParameter)this.storedProcedureParams.get(n6);
                        if (dRDAParameter.hasExtendedData && !dRDAParameter.readExtendedData) {
                            this.processEXTDTAParam(dRDAParameter, false);
                        }
                        ++n6;
                    }
                    break;
                }
                case 9230: {
                    this.reader.readAndDiscardBytes(n);
                    break;
                }
                case 8450: {
                    this.queryProtocol = this.reader.readInt16();
                    break;
                }
                case 9242: {
                    this.processFDODSC(n, false);
                    break;
                }
                case 9227: {
                    this.processSQLCINRD();
                    break;
                }
                case 8469: {
                    byte by = this.reader.readInt8();
                    break;
                }
                case 8728: {
                    this.reader.readAndDiscardBytes(n);
                    break;
                }
                case 9224: {
                    if (this.executingBatch && this.currentUpdateCount < this.updateCounts.length) {
                        this.processSQLCA(baseWarnings);
                        if (this.processingSQLCAforPrepare) {
                            this.processingSQLCAforPrepare = false;
                            break;
                        }
                        if (this.exception != null && (this.currentExceptionCount == 0 || this.currentExceptionCount < this.numExceptions)) {
                            ++this.currentExceptionCount;
                            this.updateCounts[this.currentUpdateCount++] = -3;
                            break;
                        }
                        this.updateCounts[this.currentUpdateCount++] = this.numRowsAffected;
                        break;
                    }
                    if (this.cachingResults) {
                        this.queryDataEndPosition = 0L;
                        this.processSQLCA(baseWarnings);
                        if (!this.moreData) {
                            this.isCursorOpen = false;
                            this.cachedRS_isCursorOpen = false;
                            this.cachedRS_moreData = false;
                        }
                        break;
                    }
                    return super.processCodePoint(n, n2, baseWarnings);
                }
                default: {
                    return super.processCodePoint(n, n2, baseWarnings);
                }
            }
        }
        catch (UtilException utilException) {
            throw this.comm.exceptions.getException(utilException);
        }
        return true;
    }

    private void createResultSetCaches(BaseWarnings baseWarnings) throws UtilException, SQLException {
        this.cachingResults = true;
        this.cachedRS_isCursorOpen = true;
        this.cachedRS_moreData = true;
        byte[] byArray = new byte[32800];
        int n = 0;
        while (n < this.numResultSets) {
            UtilPagedTempBuffer utilPagedTempBuffer = new UtilPagedTempBuffer();
            int n2 = 0;
            boolean bl = true;
            while (bl && !this.reader.atEndOfReply()) {
                int n3 = this.reader.readInt16();
                short s = this.reader.readInt16();
                n3 -= 4;
                switch (s) {
                    case 8539: {
                        this.packageNameCsnList[n].queryInstanceId = new byte[n3];
                        this.reader.readBytes(this.packageNameCsnList[n].queryInstanceId, 0, n3);
                        bl = true;
                        break;
                    }
                    case 8709: {
                        bl = false;
                        break;
                    }
                    case 9243: {
                        n2 = this.cacheCodePoint(n3 + 4, 9243, utilPagedTempBuffer, n2, byArray, false);
                        boolean bl2 = false;
                        boolean bl3 = this.reader.getRemainingBytes() == 0L;
                        while (!bl2 && !bl3) {
                            short s2 = this.reader.readInt16();
                            short s3 = this.reader.readInt16();
                            if (s3 != 8709) {
                                n2 = s3 != 9243 ? this.cacheCodePoint(s2, s3, utilPagedTempBuffer, n2, byArray, false) : this.cacheCodePoint(s2, s3, utilPagedTempBuffer, n2, byArray, true);
                                if (this.reader.getRemainingBytes() != 0L) continue;
                                bl3 = true;
                                continue;
                            }
                            bl2 = true;
                        }
                        bl = false;
                        break;
                    }
                    default: {
                        this.processCodePoint(n3, s, baseWarnings);
                        bl = true;
                    }
                }
            }
            this.resultSetArray[n] = new DB2ImplResultSet(this, this.comm);
            this.resultSetArray[n].makeResultSetCached(utilPagedTempBuffer, n2, this.columnDescriptions, this.parameterDescriptions, this.packageNameCsnList[n], true, this.cachedRS_isCursorOpen, this.cachedRS_moreData);
            this.resultSetArray[n].setImplStatement(this.implStmt);
            this.columnDescriptions = null;
            this.cachedRS_isCursorOpen = true;
            this.cachedRS_moreData = true;
            ++n;
        }
        this.cachingResults = true;
    }

    private final int cacheCodePoint(int n, int n2, UtilPagedTempBuffer utilPagedTempBuffer, int n3, byte[] byArray, boolean bl) throws UtilException {
        int n4 = 0;
        if ((short)n == -32760) {
            n4 = this.reader.readInt32();
        } else if ((short)n == -32764) {
            n4 = this.reader.queryDataLength;
        }
        if (!bl) {
            utilPagedTempBuffer.write((long)n3++, (byte)(n >>> 8 & 0xFF));
            utilPagedTempBuffer.write((long)n3++, (byte)(n >>> 0 & 0xFF));
            utilPagedTempBuffer.write((long)n3++, (byte)(n2 >>> 8 & 0xFF));
            utilPagedTempBuffer.write((long)n3++, (byte)(n2 >>> 0 & 0xFF));
            if (n4 != 0) {
                utilPagedTempBuffer.write((long)n3++, (byte)(n4 >>> 24));
                utilPagedTempBuffer.write((long)n3++, (byte)(n4 >>> 16));
                utilPagedTempBuffer.write((long)n3++, (byte)(n4 >>> 8));
                utilPagedTempBuffer.write((long)n3++, (byte)n4);
            }
        }
        int n5 = 0;
        n5 = n4 != 0 ? n4 : n - 4;
        int n6 = 0;
        while (n5 > 0) {
            n6 = this.reader.readBytes(byArray, 0, Math.min(32800, n5));
            utilPagedTempBuffer.write(n3, byArray, 0, n6);
            n3 += n6;
            n5 -= n6;
        }
        return n3;
    }

    public void updateColumnDescriptions(int n) throws UtilException {
        int n2 = this.columnDescriptions.count(0);
        int n3 = 0;
        while (n3 < n2) {
            if (n3 % 84 == 0 && n3 != 0) {
                this.reader.readAndDiscardBytes(3);
            }
            DRDAColumn dRDAColumn = (DRDAColumn)this.columnDescriptions.get(n3 + 1);
            dRDAColumn.fdocaType = this.reader.readInt8();
            dRDAColumn.type = this.implConn.charSetFor65535 != null && this.implConn.charSetFor65535 != "" ? this.drdaUtil.Drda2JdbcType(dRDAColumn.fdocaType, true) : this.drdaUtil.Drda2JdbcType(dRDAColumn.fdocaType, false);
            dRDAColumn.isNullable = dRDAColumn.fdocaType % 2 == 0 ? 0 : 1;
            switch (dRDAColumn.type) {
                case -4: 
                case -3: {
                    dRDAColumn.setLongDataBuffer();
                }
                case -2: {
                    dRDAColumn.precision = dRDAColumn.fdocaLen = (int)this.reader.readInt16();
                    dRDAColumn.displaySize = dRDAColumn.fdocaLen * 2;
                    break;
                }
                case 2: 
                case 3: {
                    dRDAColumn.precision = this.reader.readInt8();
                    dRDAColumn.scale = this.reader.readInt8();
                    dRDAColumn.displaySize = dRDAColumn.precision + 3;
                    dRDAColumn.fdocaLen = dRDAColumn.precision / 2 + 1;
                    break;
                }
                case 5: {
                    dRDAColumn.fdocaLen = this.reader.readInt16();
                    dRDAColumn.precision = 5;
                    dRDAColumn.displaySize = 6;
                    break;
                }
                case 4: {
                    dRDAColumn.fdocaLen = this.reader.readInt16();
                    dRDAColumn.precision = 10;
                    dRDAColumn.displaySize = 11;
                    break;
                }
                case 7: {
                    dRDAColumn.fdocaLen = this.reader.readInt16();
                    dRDAColumn.precision = 7;
                    dRDAColumn.displaySize = dRDAColumn.precision + 6;
                    break;
                }
                case 6: 
                case 8: {
                    dRDAColumn.fdocaLen = this.reader.readInt16();
                    dRDAColumn.precision = 15;
                    dRDAColumn.displaySize = dRDAColumn.precision + 7;
                    break;
                }
                case -1: {
                    dRDAColumn.setLongDataBuffer();
                }
                default: {
                    dRDAColumn.precision = dRDAColumn.fdocaLen = (int)this.reader.readInt16();
                    dRDAColumn.displaySize = dRDAColumn.fdocaLen;
                    dRDAColumn.scale = dRDAColumn.fdocaScale = 0;
                    dRDAColumn.transliterator = this.comm.SingleByteServerTransliterator;
                    if (dRDAColumn.type != 93) break;
                    dRDAColumn.scale = 6;
                }
            }
            ++n3;
        }
    }
}

