/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.jdbc.sqlserver.tds;

import com.metamatrix.jdbc.base.BaseConnection;
import com.metamatrix.jdbc.base.BaseData;
import com.metamatrix.jdbc.base.BaseParameter;
import com.metamatrix.jdbc.base.BaseWarnings;
import com.metamatrix.jdbc.sqlserver.SQLServerByteOrderedDataReader;
import com.metamatrix.jdbc.sqlserver.SQLServerByteOrderedDataWriter;
import com.metamatrix.jdbc.sqlserver.SQLServerImplStatement;
import com.metamatrix.jdbc.sqlserver.tds.TDSConnection;
import com.metamatrix.jdbc.sqlserver.tds.TDSConstants;
import com.metamatrix.jdbc.sqlserver.tds.TDSRPCParameter;
import com.metamatrix.jdbc.sqlserver.tds.TDSRequest;
import com.metamatrix.util.UtilException;
import com.metamatrix.util.UtilTransliterator;
import com.metamatrix.util.UtilVectorUnsynced;
import java.sql.SQLException;

public class TDSRPCRequest
extends TDSRequest {
    private static String footprint = "$Revision:   3.31.1.3  $";
    protected UtilVectorUnsynced baseParamSets;
    protected int maxPrecision;
    protected boolean sendStringParametersAsUnicode;
    protected int receiveStringParameterType;
    protected UtilVectorUnsynced parameters = new UtilVectorUnsynced();
    public UtilVectorUnsynced userParameters = new UtilVectorUnsynced();
    public String procedureName = null;
    public int procedureNumber;
    protected int RPCOptions = 0;
    private int[] returnValueType = new int[1];
    private int numReturnedParameters;
    private BaseData udfReturnParamData;

    public TDSRPCRequest(TDSConnection tDSConnection, SQLServerByteOrderedDataReader sQLServerByteOrderedDataReader, SQLServerByteOrderedDataWriter sQLServerByteOrderedDataWriter) {
        super(tDSConnection, sQLServerByteOrderedDataReader, sQLServerByteOrderedDataWriter, 3);
    }

    public void reset() {
        this.parameters.removeAllElements();
        this.procedureName = null;
        this.RPCOptions = 0;
        this.resultType = 0;
    }

    protected void addUserParametersToRPC() {
        for (int i = 0; i < this.userParameters.size(); ++i) {
            this.addRPCParameter((TDSRPCParameter)this.userParameters.get(i));
        }
    }

    protected void addUserParameter(TDSRPCParameter tDSRPCParameter) {
        this.userParameters.addElement((Object)tDSRPCParameter);
    }

    public UtilVectorUnsynced getUserParameters() {
        return this.userParameters;
    }

    public void encodeRPCCall(boolean bl) throws SQLException {
        try {
            this.conn.setMessageType(this.messageType);
            if (!bl) {
                this.writer.writeInt8(-128);
            }
            if (this.procedureName != null) {
                this.writer.writeInt16(this.procedureName.length());
                this.writer.writeStringAsUCS2(this.procedureName);
                this.procedureName = null;
            } else if (this.conn.getTDSVersion() == 1) {
                this.procedureName = TDSConstants.SP_NAMES[this.procedureNumber - 1];
                this.writer.writeInt16(this.procedureName.length());
                this.writer.writeStringAsUCS2(this.procedureName);
                this.procedureName = null;
                this.procedureNumber = 0;
            } else {
                this.writer.writeInt16(65535);
                this.writer.writeInt16(this.procedureNumber);
                this.procedureNumber = 0;
            }
            this.writer.writeInt16(this.RPCOptions);
            int n = this.parameters.size();
            for (int i = 0; i < n; ++i) {
                TDSRPCParameter tDSRPCParameter = (TDSRPCParameter)this.parameters.elementAt(i);
                tDSRPCParameter.write(this.writer);
            }
        }
        catch (UtilException utilException) {
            throw this.conn.exceptions.getException((Exception)((Object)utilException));
        }
    }

    public void addRPCToBatch(String string, int n) {
        this.procedureName = string;
        this.RPCOptions = n;
        this.parameters.removeAllElements();
    }

    public void addRPCToBatch(int n, int n2) {
        this.procedureNumber = n;
        this.RPCOptions = n2;
        this.parameters.removeAllElements();
    }

    public void addRPCParameter(TDSRPCParameter tDSRPCParameter) {
        this.parameters.addElement((Object)tDSRPCParameter);
    }

    public void removeLastRPCFromBatch() {
        this.procedureName = null;
    }

    public TDSRPCParameter getOutputParam(int n) {
        int n2 = 0;
        for (int i = 0; i < this.parameters.size(); ++i) {
            TDSRPCParameter tDSRPCParameter = (TDSRPCParameter)this.parameters.elementAt(i);
            if (!tDSRPCParameter.isOutput || ++n2 != n) continue;
            return tDSRPCParameter;
        }
        return null;
    }

    public TDSRPCParameter getOutputParam(String string) {
        boolean bl = false;
        for (int i = 0; i < this.parameters.size(); ++i) {
            TDSRPCParameter tDSRPCParameter = (TDSRPCParameter)this.parameters.elementAt(i);
            if (!tDSRPCParameter.isOutput || tDSRPCParameter.paramName == null || !tDSRPCParameter.paramName.equalsIgnoreCase(string)) continue;
            return tDSRPCParameter;
        }
        return null;
    }

    public TDSRPCParameter getUserOutputParam(int n) {
        int n2 = 0;
        for (int i = 0; i < this.userParameters.size(); ++i) {
            TDSRPCParameter tDSRPCParameter = (TDSRPCParameter)this.userParameters.elementAt(i);
            if (!tDSRPCParameter.isOutput || ++n2 != n) continue;
            return tDSRPCParameter;
        }
        return null;
    }

    void processReturnValue() throws SQLException {
        try {
            Object object;
            String string;
            short s = this.reader.readInt16();
            TDSRPCParameter tDSRPCParameter = null;
            int n = this.reader.readInt8() * 2;
            if (n != 0 && (tDSRPCParameter = this.getOutputParam(string = this.reader.readString(n))) == null) {
                this.reader.readAndDiscardBytes(s - n - 1);
                return;
            }
            this.reader.readInt8();
            this.reader.readInt16();
            this.reader.readInt16();
            byte by = this.reader.readInt8();
            boolean bl = false;
            int n2 = 0;
            int n3 = 0;
            switch (by) {
                case 36: 
                case 38: 
                case 104: 
                case 109: 
                case 111: {
                    this.reader.readUnsignedInt8();
                    break;
                }
                case 110: {
                    n3 = 4;
                    this.reader.readUnsignedInt8();
                    break;
                }
                case -91: 
                case -89: 
                case -83: 
                case -81: 
                case -25: 
                case -17: {
                    n2 = this.reader.readUnsignedInt16();
                    break;
                }
                case 106: 
                case 108: {
                    this.reader.readUnsignedInt8();
                    n2 = this.reader.readUnsignedInt8();
                    n3 = this.reader.readUnsignedInt8();
                    break;
                }
                case 48: 
                case 50: 
                case 52: 
                case 56: 
                case 61: 
                case 62: 
                case 127: {
                    break;
                }
                default: {
                    String[] stringArray = new String[]{this.getNameOfUnhandledDataType(by)};
                    throw this.conn.exceptions.getException(7005, stringArray);
                }
            }
            UtilTransliterator utilTransliterator = null;
            if (this.conn.getTDSVersion() == 2) {
                object = new byte[5];
                switch (by) {
                    case -89: 
                    case -81: {
                        this.reader.getArrayOfBytes((byte[])object, 0, 5);
                        utilTransliterator = this.conn.getTransliteratorForCodePage(this.conn.mapCollationToCodePage((byte[])object));
                        break;
                    }
                    case -25: 
                    case -17: {
                        this.reader.getArrayOfBytes((byte[])object, 0, 5);
                        break;
                    }
                }
            } else if (by == -81 || by == -89) {
                utilTransliterator = this.conn.nonUnicodeTransliterator;
            }
            if (this.returnStatusIsValid) {
                ++this.numReturnedParameters;
                if (tDSRPCParameter == null) {
                    tDSRPCParameter = this.getOutputParam(this.numReturnedParameters);
                }
                if (tDSRPCParameter != null) {
                    this.getReturnedValue(0, tDSRPCParameter.data, by, utilTransliterator, n2, n3, false, 0);
                } else {
                    object = new BaseData((BaseConnection)this.conn.connection);
                    this.getReturnedValue(0, (BaseData)object, by, utilTransliterator, n2, n3, false, 0);
                }
            } else {
                if (this.udfReturnParamData == null) {
                    this.udfReturnParamData = new BaseData((BaseConnection)this.conn.connection);
                }
                this.getReturnedValue(0, this.udfReturnParamData, by, utilTransliterator, n2, n3, false, 0);
            }
        }
        catch (UtilException utilException) {
            throw this.conn.exceptions.getException((Exception)((Object)utilException));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void submitRequest(SQLServerImplStatement sQLServerImplStatement) throws SQLException {
        try {
            Object var2_2 = null;
            TDSConnection tDSConnection = this.conn;
            synchronized (tDSConnection) {
                if (sQLServerImplStatement != null && sQLServerImplStatement.getCancelOnNextRead()) {
                    if (this.prepareSubmitted && this.prepareHandleParam.data.isNull) {
                        this.readPrepareHandle(this.conn.warnings);
                    }
                    sQLServerImplStatement.setCancelableWork(false);
                    sQLServerImplStatement.setCancelOnNextRead(false);
                    throw this.conn.exceptions.getException(6078, "HY008");
                }
                this.clearReplyChannel();
                if (this.procedureName != null || this.procedureNumber > 0) {
                    this.encodeRPCCall(true);
                }
                this.writer.send();
                if (sQLServerImplStatement != null) {
                    sQLServerImplStatement.setCancelableWork(true);
                }
            }
            this.reader.receive();
            this.numReturnedParameters = 0;
            this.returnStatus = 0;
            this.returnStatusIsValid = false;
        }
        catch (UtilException utilException) {
            throw this.conn.exceptions.getException((Exception)((Object)utilException));
        }
        catch (Error error) {
            this.conn.connection.close();
            throw error;
        }
    }

    public boolean processReplyToken(byte by, BaseWarnings baseWarnings) throws SQLException {
        switch (by) {
            case -84: {
                this.processReturnValue();
                return true;
            }
        }
        return super.processReplyToken(by, baseWarnings);
    }

    public void populateReturnParam(BaseParameter baseParameter) {
        if (this.returnStatusIsValid) {
            baseParameter.setInteger(this.returnStatus);
        } else {
            baseParameter.populate(this.udfReturnParamData);
        }
    }

    public void populateOuputParam(BaseParameter baseParameter, int n) {
        TDSRPCParameter tDSRPCParameter = this.getUserOutputParam(n);
        baseParameter.populate(tDSRPCParameter.data);
    }
}

