/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.jdbc.sqlserver;

import com.metamatrix.jdbc.base.BaseData;
import com.metamatrix.jdbc.sqlserver.SQLServerImplResultSet;
import com.metamatrix.jdbc.sqlserver.tds.TDSRPCCursorExecuteRequest;
import java.sql.SQLException;

public final class SQLServerImplResultSetServerSideCursor
extends SQLServerImplResultSet {
    private static String footprint = "$Revision:   3.11.1.1  $";
    TDSRPCCursorExecuteRequest tdsCursorRequest;
    boolean positionedOnValidRow;
    private BaseData[] updatedValues;
    private int numUpdatedValues;
    private boolean onInsertRow = false;

    public void reset() {
        super.reset();
        this.tdsCursorRequest = null;
        this.positionedOnValidRow = false;
        this.cancelUpdates();
    }

    public void initialize(TDSRPCCursorExecuteRequest tDSRPCCursorExecuteRequest, int n) {
        super.initialize(tDSRPCCursorExecuteRequest, n);
        this.tdsCursorRequest = tDSRPCCursorExecuteRequest;
    }

    public void close() throws SQLException {
        if (!this.isClosed) {
            this.internalClose();
        }
        this.reset();
        this.getConnection().putImplResultSetServerSideCursor(this);
    }

    public void setFetchSize(int n) {
        this.tdsCursorRequest.setFetchSize(this.implStatement.getMaxRows(), n);
    }

    public int getConcurrency() {
        return this.tdsCursorRequest.getConcurrency();
    }

    public int getScrollType() {
        return this.tdsCursorRequest.getScrollTypeToReport();
    }

    public void prepareInsertRow() throws SQLException {
        this.cancelUpdates();
        this.onInsertRow = true;
    }

    public BaseData getData(int n, int n2) throws SQLException {
        if (this.numUpdatedValues != 0 && this.updatedValues != null && this.updatedValues[n - 1] != null) {
            return this.updatedValues[n - 1];
        }
        if (this.onInsertRow) {
            String[] stringArray = new String[]{Integer.toString(n)};
            throw this.exceptions.getException(6102, stringArray);
        }
        return super.getData(n, n2);
    }

    public boolean fetchAtPosition(int n) throws SQLException {
        if (this.isClosed) {
            return false;
        }
        if (this.getScrollType() == 1003) {
            return super.fetchAtPosition(n);
        }
        boolean bl = ((TDSRPCCursorExecuteRequest)this.tdsRequest).fetchAbsolute(n, this.warnings, this.statementLongDataCache);
        if (!bl && n == this.maxCursorPosition) {
            this.maxCursorPosition = this.tdsCursorRequest.getRowCount(this.warnings);
        }
        return bl;
    }

    protected boolean isCursorPositionValid() throws SQLException {
        if (this.implStatement.getMaxRows() != 0) {
            return super.isCursorPositionValid();
        }
        return this.positionedOnValidRow;
    }

    protected boolean next() throws SQLException {
        if (this.implStatement.getMaxRows() != 0) {
            return super.next();
        }
        if (this.isClosed) {
            return false;
        }
        if (this.tdsCursorRequest.fetchNext(this.warnings, this.statementLongDataCache)) {
            this.positionedOnValidRow = true;
            if (this.getScrollType() == 1003) {
                ++this.cursorPosition;
            }
            return true;
        }
        if (this.getScrollType() == 1003) {
            this.internalClose();
        }
        this.positionedOnValidRow = false;
        return false;
    }

    protected boolean previous() throws SQLException {
        if (this.implStatement.getMaxRows() != 0) {
            return super.previous();
        }
        if (this.isClosed) {
            return false;
        }
        if (this.tdsCursorRequest.fetchPrevious(this.warnings, this.statementLongDataCache)) {
            this.positionedOnValidRow = true;
            return true;
        }
        this.positionedOnValidRow = false;
        return false;
    }

    protected boolean first() throws SQLException {
        if (this.implStatement.getMaxRows() != 0) {
            return super.first();
        }
        if (this.isClosed) {
            return false;
        }
        if (this.tdsCursorRequest.fetchFirst(this.warnings, this.statementLongDataCache)) {
            this.positionedOnValidRow = true;
            return true;
        }
        this.positionedOnValidRow = false;
        return false;
    }

    protected boolean last() throws SQLException {
        if (this.implStatement.getMaxRows() != 0) {
            return super.last();
        }
        if (this.isClosed) {
            return false;
        }
        if (this.tdsCursorRequest.fetchLast(this.warnings, this.statementLongDataCache)) {
            this.positionedOnValidRow = true;
            return true;
        }
        this.positionedOnValidRow = false;
        return false;
    }

    protected void beforeFirst() throws SQLException {
        if (this.implStatement.getMaxRows() != 0) {
            super.beforeFirst();
        } else {
            if (this.isClosed) {
                return;
            }
            this.tdsCursorRequest.positionBeforeFirst(this.warnings);
            this.positionedOnValidRow = false;
        }
    }

    protected void afterLast() throws SQLException {
        if (this.implStatement.getMaxRows() != 0) {
            super.afterLast();
        } else {
            if (this.isClosed) {
                return;
            }
            this.tdsCursorRequest.positionAfterLast(this.warnings);
            this.positionedOnValidRow = false;
        }
    }

    protected boolean absolute(int n) throws SQLException {
        if (this.implStatement.getMaxRows() != 0) {
            return super.absolute(n);
        }
        if (this.isClosed) {
            return false;
        }
        if (n == 0) {
            throw this.exceptions.getException(6041, "HY107");
        }
        if (this.tdsCursorRequest.fetchAbsolute(n, this.warnings, this.statementLongDataCache)) {
            this.positionedOnValidRow = true;
            return true;
        }
        this.positionedOnValidRow = false;
        return false;
    }

    protected boolean relative(int n) throws SQLException {
        if (this.implStatement.getMaxRows() != 0) {
            return super.relative(n);
        }
        if (this.isClosed) {
            return false;
        }
        if (!this.positionedOnValidRow) {
            throw this.exceptions.getException(6042, "HY109");
        }
        if (this.tdsCursorRequest.fetchRelative(n, this.warnings, this.statementLongDataCache)) {
            this.positionedOnValidRow = true;
            return true;
        }
        this.positionedOnValidRow = false;
        return false;
    }

    protected int getRow() throws SQLException {
        if (this.implStatement.getMaxRows() != 0) {
            return super.getRow();
        }
        if (this.isClosed) {
            return 0;
        }
        if (this.getScrollType() == 1003) {
            return this.cursorPosition;
        }
        return this.tdsCursorRequest.getCurrentPosition(this.warnings);
    }

    protected boolean isAfterLast() throws SQLException {
        if (this.implStatement.getMaxRows() != 0) {
            return super.isAfterLast();
        }
        if (this.getScrollType() == 1003) {
            return this.cursorPosition != 0 && !this.positionedOnValidRow;
        }
        if (this.isClosed) {
            return false;
        }
        return this.tdsCursorRequest.isAfterLastRow(this.warnings);
    }

    protected boolean isBeforeFirst() throws SQLException {
        if (this.implStatement.getMaxRows() != 0) {
            return super.isBeforeFirst();
        }
        if (this.getScrollType() == 1003) {
            return this.cursorPosition == 0;
        }
        if (this.isClosed) {
            return false;
        }
        return this.tdsCursorRequest.isBeforeFirstRow(this.warnings);
    }

    protected boolean isFirst() throws SQLException {
        if (this.implStatement.getMaxRows() != 0 || this.getScrollType() == 1003) {
            return super.isFirst();
        }
        if (this.isClosed) {
            return false;
        }
        return this.tdsCursorRequest.isOnFirstRow(this.warnings);
    }

    protected boolean isLast() throws SQLException {
        if (this.implStatement.getMaxRows() != 0) {
            return super.isLast();
        }
        if (this.isClosed) {
            return false;
        }
        return this.tdsCursorRequest.isOnLastRow(this.warnings);
    }

    protected void refreshRow() throws SQLException {
        if (this.implStatement.getMaxRows() != 0) {
            super.refreshRow();
        } else if (!this.relative(0)) {
            // empty if block
        }
    }

    public boolean onDeletedRow() throws SQLException {
        if (this.tdsCursorRequest.usingNativeUpdatability()) {
            return this.tdsCursorRequest.onDeletedRow();
        }
        if (this.getScrollType() != 1005) {
            return false;
        }
        BaseData baseData = this.getData(this.tdsCursorRequest.getRowstatOrdinal(), 4);
        int n = baseData.getInteger(this.exceptions);
        return n == 2;
    }

    public void cancelUpdates() {
        if (this.updatedValues != null) {
            for (int i = 0; i < this.updatedValues.length; ++i) {
                this.updatedValues[i] = null;
            }
        }
        this.numUpdatedValues = 0;
        this.onInsertRow = false;
    }

    public void updateData(int n, BaseData baseData) throws SQLException {
        if (this.updatedValues == null) {
            this.updatedValues = new BaseData[this.tdsCursorRequest.currentNativeColumns.length];
        } else if (n > this.updatedValues.length) {
            BaseData[] baseDataArray = new BaseData[this.tdsCursorRequest.currentNativeColumns.length];
            for (int i = 0; i < this.updatedValues.length; ++i) {
                baseDataArray[i] = this.updatedValues[i];
            }
            this.updatedValues = baseDataArray;
        }
        this.updatedValues[n - 1] = baseData;
        ++this.numUpdatedValues;
    }

    public void updateRow() throws SQLException {
        if (this.numUpdatedValues > 0) {
            this.tdsCursorRequest.submitRowChange(1, this.updatedValues, this.warnings, this.statementLongDataCache);
        }
    }

    public void deleteRow() throws SQLException {
        this.tdsCursorRequest.submitRowChange(2, null, this.warnings, this.statementLongDataCache);
    }

    public void insertRow() throws SQLException {
        if (this.numUpdatedValues > 0) {
            this.tdsCursorRequest.submitRowChange(4, this.updatedValues, this.warnings, this.statementLongDataCache);
        } else {
            this.tdsCursorRequest.submitRowChange(4, null, this.warnings, this.statementLongDataCache);
        }
    }
}

