/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.jdbc.sybase;

import com.metamatrix.jdbc.base.BaseConnection;
import com.metamatrix.jdbc.base.BaseConnectionProperties;
import com.metamatrix.jdbc.base.BaseDriverPropertyInfos;
import com.metamatrix.jdbc.base.BaseEscapeTranslator;
import com.metamatrix.jdbc.base.BaseImplConnection;
import com.metamatrix.jdbc.base.BaseImplDatabaseMetaData;
import com.metamatrix.jdbc.sybase.SybaseEscapeTranslator;
import com.metamatrix.jdbc.sybase.SybaseImplConnection;
import com.metamatrix.jdbc.sybase.SybaseImplDatabaseMetaData;
import java.sql.SQLException;

public class SybaseConnection
extends BaseConnection {
    private static String footprint = "$Revision:   3.15.1.0  $";
    SybaseImplDatabaseMetaData databaseMetaData = null;
    private float serverVersion = 0.0f;
    private int pageSize = 0;
    public String serverDefaultCharSet = null;
    public boolean supportsUniCharTypes;
    public boolean supportsDateAndTimeTypes;

    public float getServerVersion() {
        return this.serverVersion;
    }

    public void setServerVersion(int n, int n2) {
        this.serverVersion = Float.valueOf(n + "." + n2).floatValue();
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(int n) {
        this.pageSize = n;
    }

    protected void getImplPropertyInfo(BaseDriverPropertyInfos baseDriverPropertyInfos) {
        baseDriverPropertyInfos.put("user", "Login ID", "", null, true);
        baseDriverPropertyInfos.put("password", "Login Password", "", null, false);
        baseDriverPropertyInfos.put("databaseName", "Database Name", "", null, false);
        String[] stringArray = new String[]{"cursor", "direct"};
        baseDriverPropertyInfos.put("selectMethod", "Select Method", "direct", stringArray, false);
        String[] stringArray2 = new String[]{"storedProcIfParam", "storedProc", "direct"};
        baseDriverPropertyInfos.put("prepareMethod", "Prepare Method", "storedProcIfParam", stringArray2, false);
        baseDriverPropertyInfos.put("codePageOverride", "Code page override", "", null, false);
        baseDriverPropertyInfos.put("useAlternateProductInfo", "useAlternateProductInfo", "false", null, false);
        baseDriverPropertyInfos.put("errorBehavior", "errorBehavior", "Exception", null, false);
    }

    protected BaseImplConnection createImplConnection(BaseConnectionProperties baseConnectionProperties) {
        return new SybaseImplConnection(this);
    }

    public BaseImplDatabaseMetaData createImplDatabaseMetaData(BaseConnectionProperties baseConnectionProperties) throws SQLException {
        if (this.databaseMetaData == null) {
            this.databaseMetaData = new SybaseImplDatabaseMetaData(baseConnectionProperties);
        }
        return this.databaseMetaData;
    }

    public BaseEscapeTranslator createEscapeTranslator() throws SQLException {
        return new SybaseEscapeTranslator(this.serverVersion);
    }
}

