/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.jdbc.sqlserver.tds;

import com.metamatrix.jdbc.base.BaseData;
import com.metamatrix.jdbc.base.BaseParameter;
import com.metamatrix.jdbc.base.BaseWarnings;
import com.metamatrix.jdbc.sqlserver.SQLServerByteOrderedDataReader;
import com.metamatrix.jdbc.sqlserver.SQLServerByteOrderedDataWriter;
import com.metamatrix.jdbc.sqlserver.SQLServerImplStatement;
import com.metamatrix.jdbc.sqlserver.tds.TDSConnection;
import com.metamatrix.jdbc.sqlserver.tds.TDSRPCParameter;
import com.metamatrix.jdbc.sqlserver.tds.TDSRequest;
import com.metamatrix.util.UtilException;
import com.metamatrix.util.UtilTransliterator;
import com.metamatrix.util.UtilVectorUnsynced;
import java.sql.SQLException;

public class TDSRPCRequest
extends TDSRequest {
    private static String footprint = "$Revision:   3.28.1.3  $";
    protected UtilVectorUnsynced baseParamSets;
    protected int maxPrecision;
    protected boolean sendStringParametersAsUnicode;
    protected int receiveStringParameterType;
    protected UtilVectorUnsynced parameters = new UtilVectorUnsynced();
    public UtilVectorUnsynced userParameters = new UtilVectorUnsynced();
    public String procedureName = null;
    protected int RPCOptions = 0;
    private int[] returnValueType = new int[1];
    private int numReturnedParameters;
    private BaseData udfReturnParamData;

    public TDSRPCRequest(TDSConnection tDSConnection, SQLServerByteOrderedDataReader sQLServerByteOrderedDataReader, SQLServerByteOrderedDataWriter sQLServerByteOrderedDataWriter) {
        super(tDSConnection, sQLServerByteOrderedDataReader, sQLServerByteOrderedDataWriter, 3);
    }

    public void reset() {
        this.parameters.removeAllElements();
        this.procedureName = null;
        this.RPCOptions = 0;
        this.resultType = 0;
    }

    protected void addUserParametersToRPC() {
        int n = 0;
        while (n < this.userParameters.size()) {
            this.addRPCParameter((TDSRPCParameter)this.userParameters.get(n));
            ++n;
        }
    }

    protected void addUserParameter(TDSRPCParameter tDSRPCParameter) {
        this.userParameters.addElement(tDSRPCParameter);
    }

    public UtilVectorUnsynced getUserParameters() {
        return this.userParameters;
    }

    public void encodeRPCCall(boolean bl) throws SQLException {
        try {
            this.conn.setMessageType(this.messageType);
            if (!bl) {
                this.writer.writeInt8(-128);
            }
            this.writer.writeInt16(this.procedureName.length());
            this.writer.writeStringAsUCS2(this.procedureName);
            this.writer.writeInt16(this.RPCOptions);
            int n = this.parameters.size();
            int n2 = 0;
            while (n2 < n) {
                TDSRPCParameter tDSRPCParameter = (TDSRPCParameter)this.parameters.elementAt(n2);
                tDSRPCParameter.write(this.conn, this.writer);
                ++n2;
            }
            this.procedureName = null;
        }
        catch (UtilException utilException) {
            throw this.conn.exceptions.getException(utilException);
        }
    }

    public void addRPCToBatch(String string, int n) {
        this.procedureName = string;
        this.RPCOptions = n;
        this.parameters.removeAllElements();
    }

    public void addRPCParameter(TDSRPCParameter tDSRPCParameter) {
        this.parameters.addElement(tDSRPCParameter);
    }

    public void removeLastRPCFromBatch() {
        this.procedureName = null;
    }

    public TDSRPCParameter getOutputParam(int n) {
        int n2 = 0;
        int n3 = 0;
        while (n3 < this.parameters.size()) {
            TDSRPCParameter tDSRPCParameter = (TDSRPCParameter)this.parameters.elementAt(n3);
            if (tDSRPCParameter.isOutput && ++n2 == n) {
                return tDSRPCParameter;
            }
            ++n3;
        }
        return null;
    }

    public TDSRPCParameter getUserOutputParam(int n) {
        int n2 = 0;
        int n3 = 0;
        while (n3 < this.userParameters.size()) {
            TDSRPCParameter tDSRPCParameter = (TDSRPCParameter)this.userParameters.elementAt(n3);
            if (tDSRPCParameter.isOutput && ++n2 == n) {
                return tDSRPCParameter;
            }
            ++n3;
        }
        return null;
    }

    void processReturnValue() throws SQLException {
        try {
            Object object;
            short s = this.reader.readInt16();
            byte by = this.reader.readInt8();
            if (by != 0) {
                this.reader.readAndDiscardBytes(s - 1);
                return;
            }
            this.reader.readInt8();
            this.reader.readInt16();
            this.reader.readInt16();
            byte by2 = this.reader.readInt8();
            boolean bl = false;
            int n = 0;
            int n2 = 0;
            switch (by2) {
                case 36: 
                case 38: 
                case 104: 
                case 109: 
                case 111: {
                    this.reader.readUnsignedInt8();
                    break;
                }
                case 110: {
                    n2 = 4;
                    this.reader.readUnsignedInt8();
                    break;
                }
                case -91: 
                case -89: 
                case -83: 
                case -81: 
                case -25: 
                case -17: {
                    n = this.reader.readUnsignedInt16();
                    break;
                }
                case 106: 
                case 108: {
                    this.reader.readUnsignedInt8();
                    n = this.reader.readUnsignedInt8();
                    n2 = this.reader.readUnsignedInt8();
                    break;
                }
                case 48: 
                case 50: 
                case 52: 
                case 56: 
                case 61: 
                case 62: 
                case 127: {
                    break;
                }
                default: {
                    String[] stringArray = new String[]{this.getNameOfUnhandledDataType(by2)};
                    throw this.conn.exceptions.getException(7005, stringArray);
                }
            }
            UtilTransliterator utilTransliterator = null;
            if (this.conn.getTDSVersion() == 2) {
                object = new byte[5];
                switch (by2) {
                    case -89: 
                    case -81: {
                        this.reader.getArrayOfBytes((byte[])object, 0, 5);
                        utilTransliterator = this.conn.getTransliteratorForCodePage(this.conn.mapCollationToCodePage((byte[])object));
                        break;
                    }
                    case -25: 
                    case -17: {
                        this.reader.getArrayOfBytes((byte[])object, 0, 5);
                        break;
                    }
                }
            } else if (by2 == -81 || by2 == -89) {
                utilTransliterator = this.conn.nonUnicodeTransliterator;
            }
            if (this.returnStatusIsValid) {
                ++this.numReturnedParameters;
                object = this.getOutputParam(this.numReturnedParameters);
                if (object != null) {
                    this.getReturnedValue(0, object.data, by2, utilTransliterator, n, n2, false, 0);
                } else {
                    BaseData baseData = new BaseData(this.conn.connection);
                    this.getReturnedValue(0, baseData, by2, utilTransliterator, n, n2, false, 0);
                }
            } else {
                if (this.udfReturnParamData == null) {
                    this.udfReturnParamData = new BaseData(this.conn.connection);
                }
                this.getReturnedValue(0, this.udfReturnParamData, by2, utilTransliterator, n, n2, false, 0);
            }
        }
        catch (UtilException utilException) {
            throw this.conn.exceptions.getException(utilException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void submitRequest(SQLServerImplStatement sQLServerImplStatement) throws SQLException {
        try {
            Object var2_2 = null;
            TDSConnection tDSConnection = this.conn;
            synchronized (tDSConnection) {
                if (sQLServerImplStatement != null && sQLServerImplStatement.getCancelOnNextRead()) {
                    sQLServerImplStatement.setCancelableWork(false);
                    sQLServerImplStatement.setCancelOnNextRead(false);
                    throw this.conn.exceptions.getException(6078, "HY008");
                }
                this.clearReplyChannel();
                if (this.procedureName != null) {
                    this.encodeRPCCall(true);
                }
                this.writer.send();
                if (sQLServerImplStatement != null) {
                    sQLServerImplStatement.setCancelableWork(true);
                }
            }
            this.reader.receive();
            this.numReturnedParameters = 0;
            this.returnStatus = 0;
            this.returnStatusIsValid = false;
        }
        catch (UtilException utilException) {
            throw this.conn.exceptions.getException(utilException);
        }
        catch (Error error) {
            this.conn.connection.close();
            throw error;
        }
    }

    public boolean processReplyToken(byte by, BaseWarnings baseWarnings) throws SQLException {
        switch (by) {
            case -84: {
                this.processReturnValue();
                return true;
            }
        }
        return super.processReplyToken(by, baseWarnings);
    }

    public void populateReturnParam(BaseParameter baseParameter) {
        if (this.returnStatusIsValid) {
            baseParameter.setInteger(this.returnStatus);
        } else {
            baseParameter.populate(this.udfReturnParamData);
        }
    }

    public void populateOuputParam(BaseParameter baseParameter, int n) {
        TDSRPCParameter tDSRPCParameter = this.getUserOutputParam(n);
        baseParameter.populate(tDSRPCParameter.data);
    }
}

