/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.jdbcspy;

import com.metamatrix.jdbcspy.SpyInputStream;
import com.metamatrix.jdbcspy.SpyLogger;
import com.metamatrix.jdbcspy.SpyReader;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.sql.Clob;
import java.sql.SQLException;

class SpyClob
implements Clob {
    private static String footprint = "$Revision:   1.2.1.0  $";
    private Clob realClob;
    private SpyLogger spyLogger;
    private int id;
    private static int Id = 0;

    SpyClob(Clob clob, SpyLogger spyLogger) {
        this.realClob = clob;
        this.spyLogger = spyLogger;
        this.id = ++Id;
    }

    public final long length() throws SQLException {
        long l;
        this.spyLogger.println("\n" + this + ".length()");
        this.spyLogger.enter();
        try {
            l = this.realClob.length();
        }
        catch (Throwable throwable) {
            this.spyLogger.leave();
            throw this.spyLogger.sqlException(throwable);
        }
        this.spyLogger.leave();
        this.spyLogger.println("OK (" + l + ")");
        return l;
    }

    public final String getSubString(long l, int n) throws SQLException {
        String string;
        this.spyLogger.println("\n" + this + ".getSubString(long pos, int length)");
        this.spyLogger.println("pos = " + l);
        this.spyLogger.println("length = " + n);
        this.spyLogger.enter();
        try {
            string = this.realClob.getSubString(l, n);
        }
        catch (Throwable throwable) {
            this.spyLogger.leave();
            throw this.spyLogger.sqlException(throwable);
        }
        this.spyLogger.leave();
        this.spyLogger.println("OK (" + string + ")");
        return string;
    }

    public final Reader getCharacterStream() throws SQLException {
        Reader reader;
        this.spyLogger.println("\n" + this + ".getCharacterStream()");
        this.spyLogger.enter();
        try {
            reader = this.realClob.getCharacterStream();
            if (this.spyLogger.logIS && reader != null) {
                reader = new SpyReader(reader, this.spyLogger);
            }
        }
        catch (Throwable throwable) {
            this.spyLogger.leave();
            throw this.spyLogger.sqlException(throwable);
        }
        this.spyLogger.leave();
        this.spyLogger.println("OK (" + reader + ")");
        return reader;
    }

    public final InputStream getAsciiStream() throws SQLException {
        InputStream inputStream;
        this.spyLogger.println("\n" + this + ".getAsciiStream()");
        this.spyLogger.enter();
        try {
            inputStream = this.realClob.getAsciiStream();
            if (this.spyLogger.logIS && inputStream != null) {
                inputStream = new SpyInputStream(inputStream, this.spyLogger);
            }
        }
        catch (Throwable throwable) {
            this.spyLogger.leave();
            throw this.spyLogger.sqlException(throwable);
        }
        this.spyLogger.leave();
        this.spyLogger.println("OK (" + inputStream + ")");
        return inputStream;
    }

    public final long position(String string, long l) throws SQLException {
        long l2;
        this.spyLogger.println("\n" + this + ".position(String searchstr, long start)");
        this.spyLogger.println("searchstr = " + string);
        this.spyLogger.println("start = " + l);
        this.spyLogger.enter();
        try {
            l2 = this.realClob.position(string, l);
        }
        catch (Throwable throwable) {
            this.spyLogger.leave();
            throw this.spyLogger.sqlException(throwable);
        }
        this.spyLogger.leave();
        this.spyLogger.println("OK (" + l2 + ")");
        return l2;
    }

    public final long position(Clob clob, long l) throws SQLException {
        long l2;
        this.spyLogger.println("\n" + this + ".position(Clob searchstr, long start)");
        this.spyLogger.println("searchstr = " + clob);
        this.spyLogger.println("start = " + l);
        this.spyLogger.enter();
        try {
            l2 = this.realClob.position(clob, l);
        }
        catch (Throwable throwable) {
            this.spyLogger.leave();
            throw this.spyLogger.sqlException(throwable);
        }
        this.spyLogger.leave();
        this.spyLogger.println("OK (" + l2 + ")");
        return l2;
    }

    public final int setString(long l, String string) throws SQLException {
        int n;
        this.spyLogger.println("\n" + this + ".setString(long pos, String str)");
        this.spyLogger.println("pos = " + l);
        this.spyLogger.println("str = " + string);
        this.spyLogger.enter();
        try {
            n = this.realClob.setString(l, string);
        }
        catch (Throwable throwable) {
            this.spyLogger.leave();
            throw this.spyLogger.sqlException(throwable);
        }
        this.spyLogger.leave();
        this.spyLogger.println("OK (" + n + ")");
        return n;
    }

    public final int setString(long l, String string, int n, int n2) throws SQLException {
        int n3;
        this.spyLogger.println("\n" + this + ".setString(long pos, String str, int offset, int len)");
        this.spyLogger.println("pos = " + l);
        this.spyLogger.println("str = " + string);
        this.spyLogger.println("offset = " + n);
        this.spyLogger.println("len = " + n2);
        this.spyLogger.enter();
        try {
            n3 = this.realClob.setString(l, string, n, n2);
        }
        catch (Throwable throwable) {
            this.spyLogger.leave();
            throw this.spyLogger.sqlException(throwable);
        }
        this.spyLogger.leave();
        this.spyLogger.println("OK (" + n3 + ")");
        return n3;
    }

    public final OutputStream setAsciiStream(long l) throws SQLException {
        OutputStream outputStream;
        this.spyLogger.println("\n" + this + ".setAsciiStream(long pos)");
        this.spyLogger.println("pos = " + l);
        this.spyLogger.enter();
        try {
            outputStream = this.realClob.setAsciiStream(l);
        }
        catch (Throwable throwable) {
            this.spyLogger.leave();
            throw this.spyLogger.sqlException(throwable);
        }
        this.spyLogger.leave();
        this.spyLogger.println("OK (" + outputStream + ")");
        return outputStream;
    }

    public final Writer setCharacterStream(long l) throws SQLException {
        Writer writer;
        this.spyLogger.println("\n" + this + ".setCharacterStream(long pos)");
        this.spyLogger.println("pos = " + l);
        this.spyLogger.enter();
        try {
            writer = this.realClob.setCharacterStream(l);
        }
        catch (Throwable throwable) {
            this.spyLogger.leave();
            throw this.spyLogger.sqlException(throwable);
        }
        this.spyLogger.leave();
        this.spyLogger.println("OK (" + writer + ")");
        return writer;
    }

    public final void truncate(long l) throws SQLException {
        this.spyLogger.println("\n" + this + ".truncate(long len)");
        this.spyLogger.println("len = " + l);
        this.spyLogger.enter();
        try {
            this.realClob.truncate(l);
        }
        catch (Throwable throwable) {
            this.spyLogger.leave();
            throw this.spyLogger.sqlException(throwable);
        }
        this.spyLogger.leave();
        this.spyLogger.println("OK");
    }

    public final String toString() {
        return "Clob[" + this.id + "]";
    }
}

