/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.jdbc.informix;

import com.metamatrix.jdbc.base.BaseData;
import com.metamatrix.jdbc.base.BaseExceptions;
import com.metamatrix.jdbc.base.BaseImplBlob;
import com.metamatrix.jdbc.base.BaseImplClob;
import com.metamatrix.jdbc.base.BaseImplResultSet;
import com.metamatrix.jdbc.base.BaseImplResultSetClientSideInsensitiveMemory;
import com.metamatrix.jdbc.base.BaseImplStatement;
import com.metamatrix.jdbc.informix.InformixColumn;
import com.metamatrix.jdbc.informix.InformixImplBlob;
import com.metamatrix.jdbc.informix.InformixImplClob;
import com.metamatrix.jdbc.informix.InformixImplDatabaseMetaData;
import com.metamatrix.jdbc.informix.InformixImplStatement;
import com.metamatrix.jdbc.informix.InformixLongInputStream;
import com.metamatrix.jdbc.informix.sqli.InformixSQLIRequest;
import com.metamatrix.util.UtilException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.sql.Date;
import java.sql.SQLException;
import java.util.List;

public class InformixImplResultSet
extends BaseImplResultSet {
    private static String footprint = "$Revision:   3.4.1.1  $";
    BaseExceptions exceptions;
    List multiRowData;
    InformixSQLIRequest request;
    private int resultSetType;
    private int resultSetConcurrency;
    BaseImplResultSetClientSideInsensitiveMemory procedureColumnsResultSet;
    int procedureColumnsResultSetCurrentRow;
    boolean cachingOffDataForprocedureColumnsResultSet;

    public InformixImplResultSet(InformixSQLIRequest informixSQLIRequest, int n, int n2) {
        this.request = informixSQLIRequest;
        this.resultSetType = n;
        this.resultSetConcurrency = n2;
        this.multiRowData = null;
    }

    public void setImplStatement(BaseImplStatement baseImplStatement) {
        super.setImplStatement(baseImplStatement);
        this.exceptions = ((BaseImplResultSet)this).exceptions;
    }

    public void close() throws SQLException {
        this.request.closeCursor();
    }

    InformixImplStatement getStatement() {
        return (InformixImplStatement)this.implStatement;
    }

    public boolean fetchAtPosition(int n) throws SQLException {
        InformixImplStatement informixImplStatement = (InformixImplStatement)this.implStatement;
        try {
            if (informixImplStatement.databaseMetaDataResultSet != 0 && !this.cachingOffDataForprocedureColumnsResultSet) {
                return InformixImplDatabaseMetaData.fetch(this);
            }
            return this.request.fetch();
        }
        catch (UtilException utilException) {
            throw this.exceptions.getException(utilException);
        }
    }

    public BaseData getData(int n, int n2) throws SQLException {
        this.request.buildRow();
        try {
            InformixImplStatement informixImplStatement = (InformixImplStatement)this.implStatement;
            InformixColumn informixColumn = (InformixColumn)informixImplStatement.request.columns.get(n);
            if (informixColumn.data == null) {
                informixColumn.baseData.setData(informixColumn.baseDataType, null);
            } else if (informixColumn.nativeType == 7 && n2 == 10) {
                String string = this.request.getSQLICommunication().getImplConnection().formatDate((Date)informixColumn.data, null);
                if (string == null) {
                    informixColumn.baseData.setData(informixColumn.baseDataType, informixColumn.data);
                } else {
                    informixColumn.baseData.setData(10, string);
                }
            } else if (informixColumn.nativeType == 12) {
                if (n2 == 15) {
                    informixColumn.baseData.setData(15, informixImplStatement.comm.backendTransliterator.decodeAsAsciiStream(new InformixLongInputStream(informixImplStatement, (byte[])informixColumn.data)));
                } else {
                    informixColumn.baseData.setData(18, informixImplStatement.comm.backendTransliterator.decodeAsReader(new InformixLongInputStream(informixImplStatement, (byte[])informixColumn.data)));
                }
            } else if (informixColumn.nativeType == 11) {
                informixColumn.baseData.setData(14, new InformixLongInputStream(informixImplStatement, (byte[])informixColumn.data));
            } else if (informixColumn.nativeType == 44) {
                if (informixColumn.extId == 11) {
                    informixColumn.baseData.setData(20, new InformixImplClob(informixImplStatement.comm, (byte[])informixColumn.data));
                } else {
                    informixColumn.baseData.setData(19, new InformixImplBlob(informixImplStatement.comm, (byte[])informixColumn.data));
                }
            } else {
                informixColumn.baseData.setData(informixColumn.baseDataType, informixColumn.data);
            }
            return informixColumn.baseData;
        }
        catch (UtilException utilException) {
            throw this.exceptions.getException(utilException);
        }
    }

    public int getScrollType() {
        return 1003;
    }

    public int getColumnAccess() {
        return 2;
    }

    public void setFetchSize(int n) {
        if (this.request != null) {
            this.request.setFetchSize(n);
        }
    }

    public void writeBlob(RandomAccessFile randomAccessFile, BaseImplBlob baseImplBlob) throws SQLException, IOException {
        randomAccessFile.write(((InformixImplBlob)baseImplBlob).getLocator());
    }

    public BaseImplBlob readBlob(RandomAccessFile randomAccessFile) throws SQLException, IOException {
        byte[] byArray = new byte[56];
        randomAccessFile.read(byArray);
        return new InformixImplBlob(this.request.getSQLICommunication(), byArray);
    }

    public void writeClob(RandomAccessFile randomAccessFile, BaseImplClob baseImplClob) throws SQLException, IOException {
        randomAccessFile.write(((InformixImplClob)baseImplClob).getLocator());
    }

    public BaseImplClob readClob(RandomAccessFile randomAccessFile) throws SQLException, IOException {
        byte[] byArray = new byte[56];
        randomAccessFile.read(byArray);
        return new InformixImplClob(this.request.getSQLICommunication(), byArray);
    }
}

