/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.platform.config.persistence.impl.jdbc;

import com.metamatrix.api.exception.MetaMatrixException;
import com.metamatrix.common.config.StartupStateException;
import com.metamatrix.common.config.api.ComponentTypeID;
import com.metamatrix.common.config.api.ConfigurationID;
import com.metamatrix.common.config.api.ConfigurationModelContainer;
import com.metamatrix.common.config.api.exceptions.ConfigurationException;
import com.metamatrix.common.extensionmodule.exception.ExtensionModuleNotFoundException;
import com.metamatrix.common.extensionmodule.spi.jdbc.JDBCExtensionModuleReader;
import com.metamatrix.common.extensionmodule.spi.jdbc.JDBCExtensionModuleWriter;
import com.metamatrix.common.jdbc.JDBCPlatform;
import com.metamatrix.common.jdbc.JDBCPlatformFactory;
import com.metamatrix.core.util.Assertion;
import com.metamatrix.core.util.DateUtil;
import com.metamatrix.platform.PlatformPlugin;
import com.metamatrix.platform.config.persistence.api.ConfigurationModelAdapter;
import com.metamatrix.platform.config.persistence.api.PersistentConnection;
import com.metamatrix.platform.config.persistence.impl.jdbc.SQL_Translator;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;

public class JDBCPersistentConnection
implements PersistentConnection {
    private Connection connection;
    private ConfigurationModelAdapter adapter;
    private JDBCPlatform platform;

    public JDBCPersistentConnection(Connection conn, ConfigurationModelAdapter adapter, Properties props) {
        if (conn == null) {
            Assertion.isNotNull((Object)conn, (String)PlatformPlugin.Util.getString("ERR.014.002.0146"));
        }
        if (adapter == null) {
            Assertion.isNotNull((Object)adapter, (String)PlatformPlugin.Util.getString("ERR.014.002.0147"));
        }
        this.connection = conn;
        this.adapter = adapter;
        try {
            this.platform = JDBCPlatformFactory.getPlatform((Connection)conn);
        }
        catch (MetaMatrixException e) {
            this.platform = null;
        }
    }

    protected void finalize() {
        try {
            this.close();
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
    }

    public void close() {
        if (!this.isClosed()) {
            try {
                this.connection.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        this.connection = null;
    }

    public boolean isClosed() {
        if (this.connection != null) {
            try {
                if (this.platform != null) {
                    return this.platform.isClosed(this.connection);
                }
                return this.connection.isClosed();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        return true;
    }

    public synchronized void setServerStarting() throws StartupStateException, ConfigurationException {
        int state = this.getServerState();
        if (state != 0) {
            throw new StartupStateException(0, state);
        }
        this.updateStartupState(0, 1);
    }

    public synchronized void setServerStarting(boolean force) throws StartupStateException, ConfigurationException {
        this.forceUpdateStartupState(1);
    }

    public synchronized void setServerStarted() throws StartupStateException, ConfigurationException {
        int state = this.getServerState();
        if (state != 1) {
            throw new StartupStateException(1, state);
        }
        this.updateStartupState(1, 2);
    }

    public synchronized void setServerStopped() throws StartupStateException, ConfigurationException {
        this.forceUpdateStartupState(0);
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized int getServerState() throws ConfigurationException {
        int state = -1;
        String sql = null;
        PreparedStatement statement = null;
        sql = "SELECT STATE, LASTCHANGED FROM CFG_STARTUP_STATE";
        statement = this.connection.prepareStatement(sql);
        if (!statement.execute()) {
            throw new ConfigurationException("ERR.014.002.0148", PlatformPlugin.Util.getString("ERR.014.002.0148", (Object)sql));
        }
        ResultSet results = statement.getResultSet();
        if (!results.next()) {
            throw new ConfigurationException("ERR.014.002.0149", PlatformPlugin.Util.getString("ERR.014.002.0149"));
        }
        state = SQL_Translator.getStartupState((ResultSet)results);
        if (results != null) {
            results.close();
        }
        this.connection.commit();
        Object var6_7 = null;
        if (statement == null) return state;
        try {
            statement.close();
            statement = null;
            return state;
        }
        catch (SQLException e) {
            e.printStackTrace();
            System.out.println(PlatformPlugin.Util.getString("ERR.014.002.0151", (Object)sql));
        }
        return state;
        {
            catch (SQLException e) {
                throw new ConfigurationException((Throwable)e, "ERR.014.002.0150", PlatformPlugin.Util.getString("ERR.014.002.0150", (Object)sql));
            }
            catch (Exception e) {
                if (!(e instanceof ConfigurationException)) throw new ConfigurationException((Throwable)e);
                throw (ConfigurationException)e;
            }
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            if (statement == null) throw throwable;
            try {
                statement.close();
                statement = null;
                throw throwable;
            }
            catch (SQLException e) {
                e.printStackTrace();
                System.out.println(PlatformPlugin.Util.getString("ERR.014.002.0151", (Object)sql));
            }
            throw throwable;
        }
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized Date getStartupTime() throws ConfigurationException {
        Date timestamp = null;
        String sql = null;
        PreparedStatement statement = null;
        sql = "SELECT STATE, LASTCHANGED FROM CFG_STARTUP_STATE";
        statement = this.connection.prepareStatement(sql);
        if (!statement.execute()) {
            throw new ConfigurationException("ERR.014.002.0148", PlatformPlugin.Util.getString("ERR.014.002.0148", (Object)sql));
        }
        ResultSet results = statement.getResultSet();
        timestamp = SQL_Translator.getServerStartupTime((ResultSet)results);
        this.connection.commit();
        Object var6_7 = null;
        if (statement == null) return timestamp;
        try {
            statement.close();
            statement = null;
            return timestamp;
        }
        catch (SQLException e) {
            e.printStackTrace();
            System.out.println(PlatformPlugin.Util.getString("ERR.014.002.0151", (Object)sql));
        }
        return timestamp;
        {
            catch (SQLException e) {
                throw new ConfigurationException((Throwable)e, "ERR.014.002.0150", PlatformPlugin.Util.getString("ERR.014.002.0150", (Object)sql));
            }
            catch (Exception e) {
                if (!(e instanceof ConfigurationException)) throw new ConfigurationException((Throwable)e);
                throw (ConfigurationException)e;
            }
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            if (statement == null) throw throwable;
            try {
                statement.close();
                statement = null;
                throw throwable;
            }
            catch (SQLException e) {
                e.printStackTrace();
                System.out.println(PlatformPlugin.Util.getString("ERR.014.002.0151", (Object)sql));
            }
            throw throwable;
        }
    }

    public synchronized ConfigurationModelContainer read(ConfigurationID configID) throws ConfigurationException {
        return this.readExtensionConfiguration(configID, true);
    }

    public synchronized Collection read(Collection configIDs) throws ConfigurationException {
        ArrayList<ConfigurationModelContainer> configs = new ArrayList<ConfigurationModelContainer>(configIDs.size());
        Iterator it = configIDs.iterator();
        while (it.hasNext()) {
            ConfigurationID configID = (ConfigurationID)it.next();
            configs.add(this.readExtensionConfiguration(configID, true));
        }
        return configs;
    }

    public synchronized void write(ConfigurationModelContainer model, String principal) throws ConfigurationException {
        this.writeExtensionConfiguration(model, principal, this.connection);
    }

    public synchronized void write(Collection models, String principal) throws ConfigurationException {
        Iterator it = models.iterator();
        while (it.hasNext()) {
            ConfigurationModelContainer model = (ConfigurationModelContainer)it.next();
            this.write(model, principal);
        }
    }

    public synchronized void delete(ConfigurationID configID, String principal) throws ConfigurationException {
        try {
            boolean inUse = JDBCExtensionModuleReader.isNameInUse((String)configID.getFullName(), (Connection)this.connection);
            if (inUse) {
                JDBCExtensionModuleWriter.removeSource((String)principal, (String)configID.getFullName(), (Connection)this.connection);
                this.connection.commit();
            }
        }
        catch (Exception e) {
            JDBCPersistentConnection.rollback(this.connection);
            throw new ConfigurationException((Throwable)e, "ERR.014.002.0153", PlatformPlugin.Util.getString("ERR.014.002.0153", (Object)configID));
        }
    }

    private ConfigurationModelContainer readExtensionConfiguration(ConfigurationID configID, boolean errorOnNotFound) throws ConfigurationException {
        try {
            byte[] data;
            if (this.connection == null) {
                Assertion.isNotNull((Object)this.connection, (String)PlatformPlugin.Util.getString("ERR.014.002.0152"));
            }
            if ((data = JDBCExtensionModuleReader.getSource((String)configID.getFullName(), (Connection)this.connection)) == null) {
                throw new ConfigurationException("ERR.014.002.0154", PlatformPlugin.Util.getString("ERR.014.002.0154", (Object)configID));
            }
            ByteArrayInputStream bais = new ByteArrayInputStream(data);
            BufferedInputStream isContent = new BufferedInputStream(bais);
            ConfigurationModelContainer model = this.adapter.readConfigurationModel((InputStream)isContent, configID);
            return model;
        }
        catch (ExtensionModuleNotFoundException notFound) {
            if (errorOnNotFound) {
                throw new ConfigurationException((Throwable)notFound, "ERR.014.002.0154", PlatformPlugin.Util.getString("ERR.014.002.0154", (Object)configID));
            }
            return null;
        }
        catch (Exception e) {
            throw new ConfigurationException((Throwable)e, "ERR.014.002.0155", PlatformPlugin.Util.getString("ERR.014.002.0155", (Object)configID));
        }
    }

    public synchronized void writeExtensionConfiguration(ConfigurationModelContainer config, String principalName, Connection connection) throws ConfigurationException {
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            BufferedOutputStream bos = new BufferedOutputStream(out);
            this.adapter.writeConfigurationModel((OutputStream)bos, config, principalName);
            bos.close();
            out.close();
            byte[] data = out.toByteArray();
            if (data == null || data.length == 0) {
                throw new ConfigurationException("ERR.014.002.0156", PlatformPlugin.Util.getString("ERR.014.002.0156"));
            }
            boolean inUse = JDBCExtensionModuleReader.isNameInUse((String)config.getConfigurationID().getFullName(), (Connection)connection);
            if (inUse) {
                JDBCExtensionModuleWriter.setSource((String)principalName, (String)config.getConfigurationID().getFullName(), (byte[])data, (long)data.length, (Connection)connection);
            } else {
                JDBCExtensionModuleWriter.addSource((String)principalName, (String)"Configuration Model", (String)config.getConfigurationID().getFullName(), (byte[])data, (long)data.length, (String)(config.getConfigurationID().getFullName() + " Configuration Model"), (boolean)true, (Connection)connection);
            }
            if (config.getConfigurationID().getFullName().equals("Startup")) {
                this.cleanSystemPropertiesTable();
                ComponentTypeID id = (ComponentTypeID)config.getComponentType("Configuration").getID();
                Properties allprops = new Properties();
                allprops.putAll((Map<?, ?>)config.getDefaultPropertyValues(id));
                allprops.putAll((Map<?, ?>)config.getConfiguration().getProperties());
                this.insertSystemProperties(allprops);
            }
            connection.commit();
        }
        catch (Exception e) {
            JDBCPersistentConnection.rollback(connection);
            throw new ConfigurationException((Throwable)e, "ERR.014.002.0157", PlatformPlugin.Util.getString("ERR.014.002.0157", (Object)config.getConfigurationID()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void cleanSystemPropertiesTable() throws SQLException {
        String sql = null;
        Statement statement = null;
        try {
            sql = "DELETE  FROM CS_SYSTEM_PROPS";
            statement = this.connection.createStatement();
            statement.execute(sql);
            Object var4_3 = null;
            if (statement == null) return;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (statement == null) throw throwable;
            try {
                statement.close();
                statement = null;
                throw throwable;
            }
            catch (SQLException e) {
                e.printStackTrace();
                System.out.println(PlatformPlugin.Util.getString("ERR.014.002.0151", (Object)sql));
            }
            throw throwable;
        }
        try {
            statement.close();
            return;
        }
        catch (SQLException e) {
            e.printStackTrace();
            System.out.println(PlatformPlugin.Util.getString("ERR.014.002.0151", (Object)sql));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void insertSystemProperties(Properties props) throws SQLException {
        String sql = null;
        PreparedStatement statement = null;
        try {
            sql = "INSERT  INTO CS_SYSTEM_PROPS(PROPERTY_NAME,Property_VALUE) VALUES (?,?)";
            statement = this.connection.prepareStatement(sql);
            Iterator<Object> it = props.keySet().iterator();
            while (it.hasNext()) {
                String key = (String)it.next();
                String value = ((String)props.get(key)).trim();
                statement.setString(1, key);
                if (value.length() > 255) {
                    value = value.substring(0, 255);
                }
                statement.setString(2, value);
                if (!statement.execute()) {
                    // empty if block
                }
                statement.clearParameters();
            }
            Object var8_7 = null;
            if (statement == null) return;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            if (statement == null) throw throwable;
            try {
                statement.close();
                statement = null;
                throw throwable;
            }
            catch (SQLException e) {
                e.printStackTrace();
                System.out.println(PlatformPlugin.Util.getString("ERR.014.002.0151", (Object)sql));
            }
            throw throwable;
        }
        try {
            statement.close();
            return;
        }
        catch (SQLException e) {
            e.printStackTrace();
            System.out.println(PlatformPlugin.Util.getString("ERR.014.002.0151", (Object)sql));
        }
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void updateStartupState(int from, int to) throws StartupStateException, ConfigurationException {
        String sql = null;
        PreparedStatement statement = null;
        sql = "UPDATE CFG_STARTUP_STATE  SET STATE= ?, LASTCHANGED= ? WHERE STATE= ? ";
        statement = this.connection.prepareStatement(sql);
        statement.setInt(1, to);
        statement.setString(2, DateUtil.getCurrentDateAsString());
        statement.setInt(3, from);
        statement.execute();
        int updateCount = statement.getUpdateCount();
        this.connection.commit();
        if (updateCount == 0) {
            int startupState = this.getServerState();
            throw new StartupStateException(2, startupState);
        }
        if (updateCount < 0) {
            throw new ConfigurationException("ERR.014.002.0158", PlatformPlugin.Util.getString("ERR.014.002.0158", (Object)sql));
        }
        Object var8_9 = null;
        if (statement == null) return;
        try {
            statement.close();
            return;
        }
        catch (SQLException e) {
            e.printStackTrace();
            System.out.println(PlatformPlugin.Util.getString("ERR.014.002.0151", (Object)sql));
        }
        return;
        {
            catch (SQLException e) {
                JDBCPersistentConnection.rollback(this.connection);
                throw new ConfigurationException((Throwable)e, "ERR.014.002.0150", PlatformPlugin.Util.getString("ERR.014.002.0150", (Object)sql));
            }
            catch (Exception e) {
                JDBCPersistentConnection.rollback(this.connection);
                if (e instanceof ConfigurationException) {
                    throw (ConfigurationException)e;
                }
                if (!(e instanceof StartupStateException)) throw new ConfigurationException((Throwable)e);
                throw (StartupStateException)e;
            }
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            if (statement == null) throw throwable;
            try {
                statement.close();
                statement = null;
                throw throwable;
            }
            catch (SQLException e) {
                e.printStackTrace();
                System.out.println(PlatformPlugin.Util.getString("ERR.014.002.0151", (Object)sql));
            }
            throw throwable;
        }
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void forceUpdateStartupState(int state) throws ConfigurationException {
        String sql = null;
        PreparedStatement statement = null;
        sql = "UPDATE CFG_STARTUP_STATE  SET STATE= ?, LASTCHANGED= ?";
        statement = this.connection.prepareStatement(sql);
        statement.setInt(1, state);
        statement.setString(2, DateUtil.getCurrentDateAsString());
        statement.execute();
        int updateCount = statement.getUpdateCount();
        this.connection.commit();
        if (updateCount <= 0) {
            throw new ConfigurationException("ERR.014.002.0158", PlatformPlugin.Util.getString("ERR.014.002.0158", (Object)sql));
        }
        Object var6_7 = null;
        if (statement == null) return;
        try {
            statement.close();
            return;
        }
        catch (SQLException e) {
            e.printStackTrace();
            System.out.println(PlatformPlugin.Util.getString("ERR.014.002.0151", (Object)sql));
        }
        return;
        {
            catch (SQLException e) {
                JDBCPersistentConnection.rollback(this.connection);
                throw new ConfigurationException((Throwable)e, "ERR.014.002.0150", PlatformPlugin.Util.getString("ERR.014.002.0150", (Object)sql));
            }
            catch (Exception e) {
                JDBCPersistentConnection.rollback(this.connection);
                if (!(e instanceof ConfigurationException)) throw new ConfigurationException((Throwable)e);
                throw (ConfigurationException)e;
            }
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            if (statement == null) throw throwable;
            try {
                statement.close();
                statement = null;
                throw throwable;
            }
            catch (SQLException e) {
                e.printStackTrace();
                System.out.println(PlatformPlugin.Util.getString("ERR.014.002.0151", (Object)sql));
            }
            throw throwable;
        }
    }

    private static void rollback(Connection jdbcConnection) {
        try {
            jdbcConnection.rollback();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }
}

