/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.dqp.internal.process;

import com.metamatrix.api.exception.MetaMatrixComponentException;
import com.metamatrix.api.exception.MetaMatrixException;
import com.metamatrix.common.buffer.BlockedException;
import com.metamatrix.common.buffer.BlockedOnMemoryException;
import com.metamatrix.common.buffer.BufferManager;
import com.metamatrix.common.buffer.MemoryNotAvailableException;
import com.metamatrix.common.buffer.TupleSourceID;
import com.metamatrix.common.buffer.TupleSourceNotFoundException;
import com.metamatrix.common.comm.api.ClientConnection;
import com.metamatrix.common.comm.api.Message;
import com.metamatrix.common.comm.exception.CommunicationException;
import com.metamatrix.common.log.LogManager;
import com.metamatrix.common.queue.QueueSuspendedException;
import com.metamatrix.common.queue.QueueWorker;
import com.metamatrix.common.queue.QueueWorkerException;
import com.metamatrix.common.queue.WorkerPool;
import com.metamatrix.common.xa.TransactionID;
import com.metamatrix.data.api.ValueChunk;
import com.metamatrix.data.basic.BasicValueChunk;
import com.metamatrix.dqp.DQPPlugin;
import com.metamatrix.dqp.internal.cache.CacheID;
import com.metamatrix.dqp.internal.cache.CacheResults;
import com.metamatrix.dqp.internal.cache.ResultSetCache;
import com.metamatrix.dqp.internal.cache.ResultSetCacheUtil;
import com.metamatrix.dqp.internal.datamgr.ConnectorID;
import com.metamatrix.dqp.internal.process.DQPProcessorContext;
import com.metamatrix.dqp.internal.process.DataTierManager;
import com.metamatrix.dqp.internal.process.RequestManager;
import com.metamatrix.dqp.internal.process.WorkItem;
import com.metamatrix.dqp.message.AtomicRequestMessage;
import com.metamatrix.dqp.message.ParameterInfo;
import com.metamatrix.dqp.message.RequestID;
import com.metamatrix.dqp.message.RequestMessage;
import com.metamatrix.dqp.message.ResultsMessage;
import com.metamatrix.dqp.service.TrackingService;
import com.metamatrix.query.analysis.AnalysisRecord;
import com.metamatrix.query.analysis.QueryAnnotation;
import com.metamatrix.query.processor.QueryProcessor;
import com.metamatrix.query.processor.xml.XMLValueIDImpl;
import com.metamatrix.query.sql.lang.Command;
import com.metamatrix.query.sql.lang.SPParameter;
import com.metamatrix.query.sql.lang.StoredProcedure;
import com.metamatrix.query.util.ValueID;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class ProcessWorker
extends QueueWorker {
    public static final String LOB_MESSAGE_KEY_PREFIX = "LOB_";
    private RequestManager requestMgr;
    private BufferManager bufferMgr;
    private int processorTimeslice;
    private DataTierManager dataTierMgr;
    private TrackingService tracker;
    private ResultSetCache rsCache;
    private boolean isLobRequest;

    public ProcessWorker(RequestManager requestMgr, BufferManager bufferMgr, WorkerPool processPool, int processorTimeslice, DataTierManager dataTierMgr, TrackingService tracker, ResultSetCache rsCache) {
        this.dataTierMgr = dataTierMgr;
        this.requestMgr = requestMgr;
        this.bufferMgr = bufferMgr;
        this.processorTimeslice = processorTimeslice;
        this.tracker = tracker;
        this.rsCache = rsCache;
    }

    public void initialize() throws QueueWorkerException {
    }

    public void cleanup() throws QueueWorkerException {
        this.requestMgr = null;
    }

    public void process(Object o) throws QueueWorkerException {
        WorkItem workItem = (WorkItem)o;
        RequestID requestID = workItem.getRequestID();
        RequestMessage request = this.requestMgr.getRequest(requestID);
        this.isLobRequest = workItem.getType() == 1 || workItem.getType() == 2;
        try {
            if (request != null) {
                this.processDirect(o, workItem, requestID, request);
            }
        }
        catch (Throwable e) {
            LogManager.logError((String)"DQP", (Throwable)e, (String)"############# PW PROCESSING ERROR OCCURRED");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private void processDirect(Object o, WorkItem workItem, RequestID requestID, RequestMessage request) {
        if (LogManager.isMessageToBeRecorded((String)"DQP", (int)5)) {
            LogManager.logDetail((String)"DQP", (String)("############# PW PROCESSING on " + requestID + " ###########"));
        }
        if (!this.shouldContinue(processor = this.requestMgr.getProcessor((Object)requestID), workItem, request)) {
            LogManager.logDetail((String)"DQP", (String)("############# PW EXITING on " + requestID + " - no processor found ###########"));
            return;
        }
        switch (workItem.getType()) {
            case 3: {
                try {
                    this.requestMgr.startProcessing((Object)requestID);
                    this.requestMgr.markResultsSent((Object)requestID);
                    this.sendResultsFromCache(requestID, request, workItem.getResultSetCache(), null, null, false);
                    var7_6 = null;
                }
                catch (Throwable var6_22) {
                    var7_7 = null;
                    try {
                        this.requestMgr.markDoneProcessing((Object)requestID, (WorkItem)o);
                    }
                    catch (Throwable e2) {
                        this.sendError(request, e2);
                    }
                    throw var6_22;
                }
                try {
                    this.requestMgr.markDoneProcessing((Object)requestID, (WorkItem)o);
                }
                catch (Throwable e2) {
                    this.sendError(request, e2);
                }
                break;
            }
            case 1: {
                mainErr = this.requestMgr.getProcessingException((Object)requestID);
                if (mainErr != null) {
                    this.sendError(request, mainErr);
                }
                if ((valueID = workItem.getValueID()) instanceof XMLValueIDImpl) {
                    try {
                        startPosition = workItem.getStartPos();
                        isLengthOnly = workItem.getStartPos() == 0L && workItem.getValueChunkSize() == 0;
                        batchFirst = 1;
                        if (!isLengthOnly) {
                            batchFirst = this.requestMgr.getNextChunkPosition((Object)requestID, valueID, startPosition);
                        }
                        if (this.hasResultsInCache(request)) {
                            this.sendResultsFromCache(requestID, request, this.rsCache, new int[]{batchFirst, batchFirst}, valueID, isLengthOnly);
                            break;
                        }
                        this.sendResults(requestID, request, valueID, new int[]{batchFirst, batchFirst}, workItem, isLengthOnly);
                    }
                    catch (BlockedOnMemoryException e) {
                        try {
                            this.requestMgr.markHasData((Object)requestID, workItem);
                        }
                        catch (QueueSuspendedException qse) {
                        }
                    }
                    catch (BlockedException e) {
                        if (!LogManager.isMessageToBeRecorded((String)"DQP", (int)5)) break;
                        LogManager.logDetail((String)"DQP", (String)("############# PW EXITING on " + requestID + " - processor blocked ###########"));
                    }
                    catch (Throwable e) {
                        LogManager.logError((String)"DQP", (Throwable)e, (String)("############# PW EXITING on " + requestID + " - error occurred ###########"));
                        try {
                            processor.getProcessorPlan().close();
                        }
                        catch (Throwable me) {
                            LogManager.logWarning((String)"DQP", (Throwable)me, (String)"Failed to close the processor plan after an error occurred.");
                        }
                        this.sendError(request, e);
                    }
                    break;
                }
                context = (DQPProcessorContext)processor.getContext();
                clientConn = context.getClientConnection();
                chunkRequest = new AtomicRequestMessage(request);
                chunkRequest.setType(4);
                chunkRequest.assignToClientConnection(clientConn);
                chunkRequest.setUserParameters(clientConn);
                chunkRequest.setConnectorID(new ConnectorID(workItem.getValueID().getConnectorID()));
                chunkRequest.setValueID(workItem.getValueID());
                chunkRequest.setStartPosition(workItem.getStartPos());
                chunkRequest.setChunkSize(workItem.getValueChunkSize());
                try {
                    this.dataTierMgr.registerRequest(chunkRequest);
                }
                catch (MetaMatrixComponentException me) {
                    LogManager.logDetail((String)"DQP", (String)("############# PW EXITING on " + requestID + " - error occurred ###########"));
                    this.sendError(request, me);
                }
                break;
            }
            case 2: {
                this.sendResponse(request, workItem.getResponse(), false);
                break;
            }
            case 0: {
                doneProducingBatches = false;
                processSucceeded = false;
                this.requestMgr.startProcessing((Object)requestID);
                try {
                    try {
                        if (this.requestMgr.isPlanOnly((Object)requestID)) {
                            this.bufferMgr.setStatus(processor.getResultsID(), 2);
                            doneProducingBatches = true;
                        } else {
                            doneProducingBatches = this.bufferMgr.getFinalRowCount(processor.getResultsID()) < 0 ? processor.process((long)this.processorTimeslice, this.requestMgr.needsResults((Object)requestID)) : true;
                        }
                        processSucceeded = true;
                    }
                    catch (BlockedOnMemoryException e) {
                        try {
                            this.requestMgr.markHasData((Object)requestID, workItem);
                        }
                        catch (QueueSuspendedException qse) {}
                    }
                    catch (BlockedException e) {
                        if (LogManager.isMessageToBeRecorded((String)"DQP", (int)5)) {
                            LogManager.logDetail((String)"DQP", (String)("############# PW EXITING on " + requestID + " - processor blocked ###########"));
                        }
                    }
                    catch (TupleSourceNotFoundException e) {
                    }
                    catch (Throwable e) {
                        if (this.requestMgr.isRequestCancelled((Object)requestID)) {
                            LogManager.logDetail((String)"DQP", (Throwable)e, (String)("############# PW EXITING on " + requestID + " - error occurred ###########"));
                        } else {
                            LogManager.logError((String)"DQP", (Throwable)e, (String)("############# PW EXITING on " + requestID + " - error occurred ###########"));
                        }
                        try {
                            processor.getProcessorPlan().close();
                        }
                        catch (Throwable me) {
                            LogManager.logWarning((String)"DQP", (Throwable)me, (String)"Failed to close the processor plan after an error occurred.");
                        }
                        this.requestMgr.setProcessingException((Object)requestID, e);
                        if (!this.requestMgr.needsResults((Object)requestID)) ** GOTO lbl123
                        this.requestMgr.markResultsSent((Object)requestID);
                        this.sendError(request, e);
                    }
lbl123:
                    // 7 sources

                    if (processSucceeded && this.requestMgr.needsResults((Object)requestID)) {
                        processingException = this.requestMgr.getProcessingException((Object)requestID);
                        if (processingException != null) {
                            this.requestMgr.markResultsSent((Object)requestID);
                            this.sendError(request, processingException);
                        } else {
                            warnings = processor.getAndClearWarnings();
                            if (warnings != null && !warnings.isEmpty()) {
                                warningIter = warnings.iterator();
                                while (warningIter.hasNext()) {
                                    this.requestMgr.addWarning((MetaMatrixException)warningIter.next(), (Object)requestID);
                                }
                            }
                            if ((analysisRecord = this.requestMgr.getAnalysisRecord((Object)requestID)).recordQueryPlan()) {
                                analysisRecord.setQueryPlan(processor.getProcessorPlan().getDescriptionProperties());
                            }
                            this.requestMgr.markResultsSent((Object)requestID);
                            try {
                                this.sendResults(requestID, request, processor.getResultsID(), processor.getProcessorPlan().getOutputElements(), doneProducingBatches, workItem);
                            }
                            catch (BlockedOnMemoryException err) {
                                range = this.requestMgr.getBatchInterval((Object)requestID);
                                try {
                                    this.requestMgr.markNeedsResults((Object)requestID, workItem, range[0], range[1]);
                                }
                                catch (QueueSuspendedException err1) {
                                    this.sendError(request, err1);
                                }
                            }
                            catch (Throwable e) {
                                this.sendError(request, e);
                            }
                        }
                    }
                    var15_40 = null;
                }
                catch (Throwable var14_44) {
                    var15_41 = null;
                    try {
                        if (processSucceeded && !doneProducingBatches) {
                            this.requestMgr.markHasData((Object)requestID, workItem);
                        }
                        if (doneProducingBatches) {
                            this.requestMgr.markDoneProcessing((Object)requestID, workItem);
                        } else {
                            this.requestMgr.markEndProcessing((Object)requestID, workItem);
                        }
                    }
                    catch (Throwable e2) {
                        this.sendError(request, e2);
                    }
                    throw var14_44;
                }
                try {
                    if (processSucceeded && !doneProducingBatches) {
                        this.requestMgr.markHasData((Object)requestID, workItem);
                    }
                    if (doneProducingBatches) {
                        this.requestMgr.markDoneProcessing((Object)requestID, workItem);
                        break;
                    }
                    this.requestMgr.markEndProcessing((Object)requestID, workItem);
                }
                catch (Throwable e2) {
                    this.sendError(request, e2);
                }
                break;
            }
        }
    }

    private boolean shouldContinue(QueryProcessor processor, WorkItem workItem, RequestMessage request) {
        if (processor != null) {
            return true;
        }
        return workItem.getType() == 3 || this.hasResultsInCache(request);
    }

    private boolean checkRequest(RequestMessage request) {
        if (request == null) {
            String msg = DQPPlugin.Util.getString("ProcessWorker.Could_not_deliver_response_as_request_has_been_removed.");
            LogManager.logDetail((String)"DQP", (String)msg);
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void sendResults(RequestID requestID, RequestMessage request, TupleSourceID resultsID, List elements, boolean done, WorkItem work) throws BlockedOnMemoryException, QueueSuspendedException {
        block22: {
            block21: {
                if (!this.checkRequest(request)) {
                    return;
                }
                batch = null;
                range = null;
                try {
                    try {
                        range = this.requestMgr.getBatchInterval((Object)requestID);
                        range[1] = Math.min(range[1], this.bufferMgr.getRowCount(resultsID));
                        batch = this.bufferMgr.pinTupleBatch(resultsID, range[0], range[1]);
                        if (!done && batch.getRowCount() == 0) {
                            var17_9 = null;
                            break block21;
                        }
                        response = null;
                        response = new ResultsMessage(request, batch.getAllTuples(), elements, false);
                        response.setFirstRow(batch.getBeginRow());
                        response.setLastRow(batch.getEndRow());
                        finalRowCount = this.bufferMgr.getFinalRowCount(resultsID);
                        response.setFinalRow(finalRowCount);
                        isPartialResultSet = finalRowCount < 0 || batch.getEndRow() < finalRowCount;
                        response.setPartialResults(isPartialResultSet);
                        response.setSchemas(this.requestMgr.getSchemas((Object)requestID));
                        response.setWarnings(this.requestMgr.getAndClearWarnings((Object)requestID));
                        analysisRecord = this.requestMgr.getAnalysisRecord((Object)requestID);
                        this.setAnalysisRecords(response, analysisRecord);
                        command = request.getCommand();
                        if (command instanceof StoredProcedure) {
                            response.setParameters(this.getParameterInfo((StoredProcedure)command));
                        }
                        this.sendResponse(request, response, false);
                        if (this.rsCache != null && request.useResultSetCache() && request.getCommand().areResultsCachable() && !this.rsCache.hasResults(cid = ResultSetCacheUtil.createCacheID((RequestMessage)request, (ResultSetCache)this.rsCache))) {
                            cr = new CacheResults(response.getResults(), elements, response.getFirstRow(), response.isPartialResults() == false);
                            cr.setCommand(this.requestMgr.getOriginalCommand((Object)requestID));
                            if (batch.getSize() != -1L) {
                                cr.setSize(batch.getSize());
                            }
                            if (analysisRecord != null) {
                                cr.setAnalysisRecord(analysisRecord);
                            }
                            this.rsCache.setResults(cid, cr, (Object)requestID);
                        }
                        break block22;
                    }
                    catch (MemoryNotAvailableException e) {
                        throw BlockedOnMemoryException.INSTANCE;
                    }
                    catch (TupleSourceNotFoundException e) {
                        var17_11 = null;
                        try {
                            if (batch == null) return;
                            this.bufferMgr.unpinTupleBatch(resultsID, batch.getBeginRow(), batch.getEndRow());
                            return;
                        }
                        catch (Exception e) {
                            return;
                        }
                    }
                    catch (MetaMatrixComponentException e) {
                        params = new Object[]{requestID};
                        msg = DQPPlugin.Util.getString("ProcessWorker.Failed_getting_first_batch_for_{0}.", (Object)params);
                        LogManager.logWarning((String)"DQP", (Throwable)e, (String)msg);
                        this.sendError(request, e);
                        var17_12 = null;
                        try {}
                        catch (Exception e) {
                            return;
                        }
                        if (batch == null) return;
                        this.bufferMgr.unpinTupleBatch(resultsID, batch.getBeginRow(), batch.getEndRow());
                        return;
                    }
                    catch (RemoteException e) {
                        params = new Object[]{requestID};
                        msg = DQPPlugin.Util.getString("ProcessWorker.Failed_getting_first_batch_for_{0}.", (Object)params);
                        LogManager.logWarning((String)"DQP", (Throwable)e, (String)msg);
                        this.sendError(request, e);
                        var17_13 = null;
                        try {}
                        catch (Exception e) {
                            return;
                        }
                        if (batch == null) return;
                        this.bufferMgr.unpinTupleBatch(resultsID, batch.getBeginRow(), batch.getEndRow());
                        return;
                    }
                }
                catch (Throwable var16_36) {
                    var17_14 = null;
                    ** try [egrp 2[TRYBLOCK] [14 : 517->545)] { 
lbl80:
                    // 1 sources

                    if (batch == null) throw var16_36;
                    this.bufferMgr.unpinTupleBatch(resultsID, batch.getBeginRow(), batch.getEndRow());
                    throw var16_36;
lbl83:
                    // 1 sources

                    catch (Exception e) {
                        // empty catch block
                    }
                    throw var16_36;
                }
            }
            ** try [egrp 2[TRYBLOCK] [14 : 517->545)] { 
lbl88:
            // 1 sources

            if (batch == null) return;
            this.bufferMgr.unpinTupleBatch(resultsID, batch.getBeginRow(), batch.getEndRow());
            return;
lbl91:
            // 1 sources

            catch (Exception e) {
                // empty catch block
            }
            return;
        }
        var17_10 = null;
        try {}
        catch (Exception e) {}
        if (batch == null) return;
        this.bufferMgr.unpinTupleBatch(resultsID, batch.getBeginRow(), batch.getEndRow());
        return;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void sendResults(RequestID requestID, RequestMessage request, ValueID valueID, int[] range, WorkItem work, boolean isLengthOnly) throws BlockedOnMemoryException, QueueSuspendedException {
        block30: {
            block29: {
                block28: {
                    block27: {
                        if (!this.checkRequest(request)) {
                            return;
                        }
                        resultsID = ((XMLValueIDImpl)valueID).getTupleSourceID();
                        batch = null;
                        try {
                            try {
                                response = new ResultsMessage(request, true);
                                finalRowCount = this.bufferMgr.getFinalRowCount(resultsID);
                                if (isLengthOnly) {
                                    if (finalRowCount < 0) {
                                        this.requestMgr.getWorkQueue().add(work);
                                        var19_17 = null;
                                        break block27;
                                    }
                                    docSize = this.requestMgr.getLobLength((Object)requestID, valueID);
                                    if (docSize == 0L) {
                                        for (i = 1; i <= finalRowCount; ++i) {
                                            batch = this.bufferMgr.pinTupleBatch(resultsID, i, i);
                                            chars = (char[])batch.getAllTuples()[0].get(0);
                                            if (chars != null) {
                                                docSize += (long)chars.length;
                                            }
                                            this.bufferMgr.unpinTupleBatch(resultsID, i, i);
                                        }
                                        this.requestMgr.setLobLength((Object)requestID, valueID, docSize);
                                    }
                                    response.setStreamLength(docSize);
                                    this.sendResponse(request, response, false);
                                    break block28;
                                }
                                batch = this.bufferMgr.pinTupleBatch(resultsID, range[0], range[1]);
                                v0 = isPartialResultSet = finalRowCount < 0 || batch.getEndRow() < finalRowCount;
                                if (batch.getRowCount() == 0 && isPartialResultSet) {
                                    this.requestMgr.getWorkQueue().add(work);
                                    break block29;
                                }
                                allTuples = batch.getAllTuples();
                                chunk = null;
                                if (allTuples != null && allTuples.length > 0) {
                                    chunk = (char[])batch.getAllTuples()[0].get(0);
                                    isPartialResultSet = true;
                                }
                                valueChunk = new BasicValueChunk(chunk, false, batch.getTerminationFlag());
                                response.setValueChunk((ValueChunk)valueChunk);
                                this.sendResponse(request, response, false);
                                if (this.rsCache != null && request.useResultSetCache() && request.getCommand().areResultsCachable() && !this.rsCache.hasResults(cid = ResultSetCacheUtil.createCacheID((RequestMessage)request, (ResultSetCache)this.rsCache))) {
                                    results = new List[]{new ArrayList<E>()};
                                    results[0].add(valueChunk);
                                    cr = new CacheResults(results, batch.getBeginRow(), isPartialResultSet == false);
                                    if (batch.getSize() != -1L) {
                                        cr.setSize(batch.getSize());
                                    }
                                    this.rsCache.setResults(cid, cr, (Object)requestID, (Object)work.getValueID());
                                }
                                break block30;
                            }
                            catch (MemoryNotAvailableException e) {
                                throw BlockedOnMemoryException.INSTANCE;
                            }
                            catch (TupleSourceNotFoundException e) {
                                var19_21 = null;
                                try {
                                    if (batch == null) return;
                                    this.bufferMgr.unpinTupleBatch(resultsID, batch.getBeginRow(), batch.getEndRow());
                                    return;
                                }
                                catch (Exception e) {
                                    return;
                                }
                            }
                            catch (MetaMatrixComponentException e) {
                                params = new Object[]{requestID};
                                msg = DQPPlugin.Util.getString("ProcessWorker.Failed_getting_first_batch_for_{0}.", (Object)params);
                                LogManager.logWarning((String)"DQP", (Throwable)e, (String)msg);
                                this.sendError(request, e);
                                var19_22 = null;
                                try {}
                                catch (Exception e) {
                                    return;
                                }
                                if (batch == null) return;
                                this.bufferMgr.unpinTupleBatch(resultsID, batch.getBeginRow(), batch.getEndRow());
                                return;
                            }
                            catch (RemoteException e) {
                                params = new Object[]{requestID};
                                msg = DQPPlugin.Util.getString("ProcessWorker.Failed_getting_first_batch_for_{0}.", (Object)params);
                                LogManager.logWarning((String)"DQP", (Throwable)e, (String)msg);
                                this.sendError(request, e);
                                var19_23 = null;
                                try {}
                                catch (Exception e) {
                                    return;
                                }
                                if (batch == null) return;
                                this.bufferMgr.unpinTupleBatch(resultsID, batch.getBeginRow(), batch.getEndRow());
                                return;
                            }
                        }
                        catch (Throwable var18_45) {
                            var19_24 = null;
                            ** try [egrp 2[TRYBLOCK] [24 : 614->643)] { 
lbl93:
                            // 1 sources

                            if (batch == null) throw var18_45;
                            this.bufferMgr.unpinTupleBatch(resultsID, batch.getBeginRow(), batch.getEndRow());
                            throw var18_45;
lbl96:
                            // 1 sources

                            catch (Exception e) {
                                // empty catch block
                            }
                            throw var18_45;
                        }
                    }
                    ** try [egrp 2[TRYBLOCK] [24 : 614->643)] { 
lbl101:
                    // 1 sources

                    if (batch == null) return;
                    this.bufferMgr.unpinTupleBatch(resultsID, batch.getBeginRow(), batch.getEndRow());
                    return;
lbl104:
                    // 1 sources

                    catch (Exception e) {
                        // empty catch block
                    }
                    return;
                }
                var19_18 = null;
                ** try [egrp 2[TRYBLOCK] [24 : 614->643)] { 
lbl110:
                // 1 sources

                if (batch == null) return;
                this.bufferMgr.unpinTupleBatch(resultsID, batch.getBeginRow(), batch.getEndRow());
                return;
lbl113:
                // 1 sources

                catch (Exception e) {
                    // empty catch block
                }
                return;
            }
            var19_19 = null;
            ** try [egrp 2[TRYBLOCK] [24 : 614->643)] { 
lbl119:
            // 1 sources

            if (batch == null) return;
            this.bufferMgr.unpinTupleBatch(resultsID, batch.getBeginRow(), batch.getEndRow());
            return;
lbl122:
            // 1 sources

            catch (Exception e) {
                // empty catch block
            }
            return;
        }
        var19_20 = null;
        try {}
        catch (Exception e) {}
        if (batch == null) return;
        this.bufferMgr.unpinTupleBatch(resultsID, batch.getBeginRow(), batch.getEndRow());
        return;
    }

    private void setAnalysisRecords(ResultsMessage response, AnalysisRecord analysisRecord) {
        if (analysisRecord != null) {
            response.setPlanDescription(analysisRecord.getQueryPlan());
            response.setDebugLog(analysisRecord.getDebugLog());
            Collection anns = analysisRecord.getAnnotations();
            ArrayList<String[]> converted = null;
            if (anns != null) {
                converted = new ArrayList<String[]>(anns.size());
                Iterator annIter = anns.iterator();
                while (annIter.hasNext()) {
                    QueryAnnotation ann = (QueryAnnotation)annIter.next();
                    String[] jdbcAnn = new String[]{ann.getCategory(), ann.getAnnotation(), ann.getResolution(), "" + ann.getPriority()};
                    converted.add(jdbcAnn);
                }
                response.setAnnotations(converted);
            }
        }
    }

    private void sendResultsFromCache(RequestID requestID, RequestMessage request, ResultSetCache resultSetCache, int[] interval, Object valueID, boolean isDocLengthOnly) {
        if (!this.checkRequest(request)) {
            return;
        }
        if (interval == null) {
            interval = this.requestMgr.getBatchInterval((Object)requestID);
        }
        if (interval == null || interval[0] == 0) {
            return;
        }
        CacheID cID = ResultSetCacheUtil.createCacheID((RequestMessage)request, (ResultSetCache)this.rsCache);
        CacheResults cResult = resultSetCache.getResults(cID, interval, valueID);
        List[] results = cResult.getResults();
        int firstRow = cResult.getFirstRow();
        ResultsMessage response = null;
        if (valueID != null) {
            response = new ResultsMessage(request, true);
            if (isDocLengthOnly) {
                response.setStreamLength(cResult.getLength());
            } else {
                response.setValueChunk((ValueChunk)results[0].get(0));
            }
        } else {
            response = new ResultsMessage(request, results, cResult.getElements(), false);
        }
        response.setFirstRow(firstRow);
        response.setLastRow(firstRow + results.length - 1);
        boolean isFinal = cResult.isFinal();
        if (isFinal) {
            response.setFinalRow(cResult.getFinalRow());
        }
        response.setPartialResults(!isFinal);
        AnalysisRecord analysisRecord = cResult.getAnalysisRecord();
        this.setAnalysisRecords(response, analysisRecord);
        try {
            request.getClientConnection().send((Message)response, request.getMessageKey());
        }
        catch (CommunicationException e) {
            Object[] params = new Object[]{requestID};
            String msg = DQPPlugin.Util.getString("ProcessWorker.Failed_to_deliver_response_for_{0}", (Object)params);
            LogManager.logError((String)"DQP", (Throwable)e, (String)msg);
        }
    }

    private void sendError(RequestMessage request, Throwable error) {
        if (!this.checkRequest(request)) {
            return;
        }
        ResultsMessage response = new ResultsMessage(request, false);
        response.setException(error);
        AnalysisRecord analysisRecord = this.requestMgr.getAnalysisRecord((Object)request.getRequestID());
        this.setAnalysisRecords(response, analysisRecord);
        this.sendResponse(request, response, !this.requestMgr.isRequestCancelled((Object)request.getRequestID()));
        if (this.rsCache != null) {
            CacheID cID = ResultSetCacheUtil.createCacheID((RequestMessage)request, (ResultSetCache)this.rsCache);
            this.rsCache.removeTempResults(cID);
        }
    }

    private void sendResponse(RequestMessage request, ResultsMessage response, boolean error) {
        RequestID requestID = request.getRequestID();
        QueryProcessor processor = this.requestMgr.getProcessor((Object)requestID);
        if (processor == null) {
            return;
        }
        DQPProcessorContext context = (DQPProcessorContext)processor.getContext();
        ClientConnection clientConn = context.getClientConnection();
        if (error) {
            this.logCommandError(request);
        }
        String messageKey = context.getMessageKey();
        if (this.isLobRequest) {
            messageKey = LOB_MESSAGE_KEY_PREFIX + messageKey;
        }
        try {
            clientConn.send((Message)response, messageKey);
        }
        catch (CommunicationException e) {
            Object[] params = new Object[]{requestID};
            String msg = DQPPlugin.Util.getString("ProcessWorker.Failed_to_deliver_response_for_{0}", (Object)params);
            LogManager.logError((String)"DQP", (Throwable)e, (String)msg);
        }
    }

    private void logCommandError(RequestMessage request) {
        if (this.tracker == null || !this.tracker.willRecordMMCmd()) {
            return;
        }
        RequestID rID = request.getRequestID();
        TransactionID transactionID = null;
        Command command = request.getCommand();
        if (request.isTransactional()) {
            transactionID = request.getTransactionContext().getTopLevelTxnID();
        }
        this.tracker.log(rID.toString(), transactionID == null ? null : transactionID.asString(), (short)2, (short)4, request.getRequestID().getConnectionID(), (String)request.getClientConnection().getConnectionProperty("ApplicationName"), request.getUserName(), request.getVdbName(), request.getVdbVersion(), command, -1);
    }

    private List getParameterInfo(StoredProcedure procedure) {
        List params = procedure.getParameters();
        ArrayList<ParameterInfo> paramInfos = new ArrayList<ParameterInfo>(params.size());
        Iterator iter = params.iterator();
        while (iter.hasNext()) {
            SPParameter param = (SPParameter)iter.next();
            ParameterInfo info = new ParameterInfo(param.getParameterType(), param.getResultSetColumns().size());
            paramInfos.add(info);
        }
        return paramInfos;
    }

    private boolean hasResultsInCache(RequestMessage requestMsg) {
        if (this.rsCache == null) {
            return false;
        }
        if (!requestMsg.useResultSetCache()) {
            return false;
        }
        CacheID cID = ResultSetCacheUtil.createCacheID((RequestMessage)requestMsg, (ResultSetCache)this.rsCache);
        return this.rsCache.hasResults(cID);
    }
}

