/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.jdbc.api;

import com.metamatrix.core.util.StringUtil;
import com.metamatrix.jdbc.api.DefaultDisplayHelper;
import com.metamatrix.jdbc.api.DisplayHelper;
import com.metamatrix.jdbc.api.PlanNode;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class XMLOutputVisitor {
    private DisplayHelper displayHelper;
    private int tabs = 0;
    private Map nodeLevels = new HashMap();
    private StringBuffer text;
    private Map tabCache = new HashMap();

    public XMLOutputVisitor(DisplayHelper displayHelper) {
        this(displayHelper, 0, true);
    }

    public XMLOutputVisitor(DisplayHelper displayHelper, int initialTabs, boolean printXMLHeader) {
        this.displayHelper = displayHelper;
        this.tabs = initialTabs;
        this.text = new StringBuffer();
        if (printXMLHeader) {
            this.text.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        }
    }

    public String getText() {
        return this.text.toString();
    }

    public void visit(PlanNode node) {
        Integer nodeLevel;
        PlanNode parent = node.getParent();
        if (parent == null) {
            nodeLevel = new Integer(0);
        } else {
            Integer parentLevel = (Integer)this.nodeLevels.get(parent);
            nodeLevel = new Integer(parentLevel + 1);
        }
        this.nodeLevels.put(node, nodeLevel);
        int numTabs = nodeLevel + this.tabs;
        this.text.append(this.getTab(numTabs));
        String name = this.displayHelper.getName(node);
        this.text.append("<node name=\"");
        this.text.append(this.escapeForXML(name));
        this.text.append("\">\n");
        int propTabs = numTabs + 2;
        List orderedProps = this.displayHelper.getOrderedProperties(node);
        if (orderedProps.size() > 0) {
            this.text.append(this.getTab(numTabs + 1));
            this.text.append("<properties>\n");
            for (int i = 0; i < orderedProps.size(); ++i) {
                String propName = (String)orderedProps.get(i);
                Object propObject = node.getProperties().get(propName);
                this.text.append(this.getTab(propTabs));
                if (propObject instanceof Collection) {
                    this.printCollectionValue(propTabs, propName, propObject);
                    continue;
                }
                if (propObject instanceof PlanNode) {
                    this.printNodeValue(propTabs, propName, propObject);
                    continue;
                }
                this.printScalarValue(node, propName);
            }
            this.text.append(this.getTab(numTabs + 1));
            this.text.append("</properties>\n");
        }
        List children = node.getChildren();
        Iterator childIter = children.iterator();
        while (childIter.hasNext()) {
            PlanNode child = (PlanNode)childIter.next();
            this.visit(child);
        }
        this.text.append(this.getTab(numTabs));
        this.text.append("</node>\n");
    }

    private void printScalarValue(PlanNode node, String propName) {
        this.text.append("<property name=\"");
        this.text.append(this.escapeForXML(this.displayHelper.getPropertyName(propName)));
        this.text.append("\" value=\"");
        this.text.append(this.escapeForXML(node.getProperties().get(propName)));
        this.text.append("\"/>\n");
    }

    private void printNodeValue(int numTabs, String propName, Object propObject) {
        this.text.append("<property name=\"");
        this.text.append(this.escapeForXML(this.displayHelper.getPropertyName(propName)));
        this.text.append("\">\n");
        XMLOutputVisitor nestedVisitor = new XMLOutputVisitor(this.displayHelper, numTabs + 1, false);
        PlanNode nestedNode = (PlanNode)propObject;
        nestedVisitor.visit(nestedNode);
        this.text.append(nestedVisitor.getText());
        this.text.append(this.getTab(numTabs));
        this.text.append("</property>\n");
    }

    private void printCollectionValue(int propTabs, String propName, Object propObject) {
        this.text.append("<property name=\"");
        this.text.append(this.escapeForXML(this.displayHelper.getPropertyName(propName)));
        this.text.append("\">\n");
        this.text.append(this.getTab(propTabs + 1));
        this.text.append("<collection>\n");
        Collection collection = (Collection)propObject;
        Iterator collectionIter = collection.iterator();
        int v = 1;
        while (collectionIter.hasNext()) {
            Object collectionValue = collectionIter.next();
            this.text.append(this.getTab(propTabs + 2));
            this.text.append("<value>");
            this.text.append(this.escapeForXML(collectionValue));
            this.text.append("</value>\n");
            ++v;
        }
        this.text.append(this.getTab(propTabs + 1));
        this.text.append("</collection>\n");
        this.text.append(this.getTab(propTabs));
        this.text.append("</property>\n");
    }

    private String getTab(int tab) {
        Integer tabKey = new Integer(tab);
        String tabStr = (String)this.tabCache.get(tabKey);
        if (tabStr != null) {
            return tabStr;
        }
        StringBuffer tabBuffer = new StringBuffer();
        for (int t = 0; t < tab; ++t) {
            tabBuffer.append("  ");
        }
        tabStr = tabBuffer.toString();
        this.tabCache.put(tabKey, tabStr);
        return tabStr;
    }

    private String escapeForXML(Object obj) {
        if (obj == null) {
            return "null";
        }
        String str = obj.toString();
        if (str.indexOf("<") >= 0 || str.indexOf(">") >= 0 || str.indexOf("\"") >= 0) {
            StringBuffer newStr = new StringBuffer(str);
            StringUtil.replaceAll((StringBuffer)newStr, (String)"<", (String)"&lt;");
            StringUtil.replaceAll((StringBuffer)newStr, (String)">", (String)"&gt;");
            StringUtil.replaceAll((StringBuffer)newStr, (String)"\"", (String)"&quot;");
            return newStr.toString();
        }
        return str;
    }

    public static String convertToXML(PlanNode node) {
        XMLOutputVisitor visitor = new XMLOutputVisitor(new DefaultDisplayHelper());
        visitor.visit(node);
        return visitor.getText();
    }
}

