/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.common.protocol;

import com.metamatrix.common.protocol.classpath.ClasspathURLConnection;
import com.metamatrix.common.protocol.jar.JarURLConnection;
import com.metamatrix.common.protocol.mmfile.MMFileURLConnection;
import com.metamatrix.common.protocol.mmrofile.Handler;
import com.metamatrix.common.protocol.mmrofile.MMROFileURLConnection;
import java.net.URLStreamHandler;
import java.net.URLStreamHandlerFactory;

public class MetaMatrixURLStreamHandlerFactory
implements URLStreamHandlerFactory {
    private static final String DEFAULT_HANDLER_PKG = "sun.net.www.protocol";

    public URLStreamHandler createURLStreamHandler(String protocol) {
        if (protocol.equals(ClasspathURLConnection.PROTOCOL)) {
            return new com.metamatrix.common.protocol.classpath.Handler();
        }
        if (protocol.equals(MMFileURLConnection.PROTOCOL)) {
            return new com.metamatrix.common.protocol.mmfile.Handler();
        }
        if (protocol.equals(MMROFileURLConnection.PROTOCOL)) {
            return new Handler();
        }
        if (protocol.equals(JarURLConnection.PROTOCOL)) {
            return new com.metamatrix.common.protocol.jar.Handler();
        }
        String handlerName = "sun.net.www.protocol." + protocol + ".Handler";
        try {
            Class<?> handlerClass = Class.forName(handlerName);
            return (URLStreamHandler)handlerClass.newInstance();
        }
        catch (Exception exception) {
            return null;
        }
    }
}

