/*
 * Decompiled with CFR 0.152.
 */
package org.osgi.service.condpermadmin;

import java.util.Vector;

public class ConditionInfo {
    private String type;
    private String[] args;

    public ConditionInfo(String type, String[] args) {
        this.type = type;
        this.args = args;
        if (type == null) {
            throw new NullPointerException("type is null");
        }
    }

    public ConditionInfo(String encodedCondition) {
        if (encodedCondition == null) {
            throw new NullPointerException("missing encoded permission");
        }
        if (encodedCondition.length() == 0) {
            throw new IllegalArgumentException("empty encoded permission");
        }
        try {
            int end;
            char[] encoded = encodedCondition.toCharArray();
            if (encoded[0] != '[') {
                throw new IllegalArgumentException("first character not open bracket");
            }
            int begin = end = 1;
            while (encoded[end] != ' ' && encoded[end] != ')') {
                ++end;
            }
            if (end == begin) {
                throw new IllegalArgumentException("expecting type");
            }
            this.type = new String(encoded, begin, end - begin);
            Vector<String> args = new Vector<String>();
            while (encoded[end] == ' ') {
                if (encoded[++end] != '\"') {
                    throw new IllegalArgumentException("expecting quoted name");
                }
                begin = ++end;
                while (encoded[end] != '\"') {
                    if (encoded[end] == '\\') {
                        ++end;
                    }
                    ++end;
                }
                args.add(ConditionInfo.decodeString(encoded, begin, end));
                ++end;
            }
            this.args = args.toArray(new String[0]);
            if (encoded[end] != ']' || end + 1 != encoded.length) {
                throw new IllegalArgumentException("last character not close bracket");
            }
        }
        catch (ArrayIndexOutOfBoundsException e2) {
            throw new IllegalArgumentException("parsing terminated abruptly");
        }
    }

    public final String getEncoded() {
        StringBuffer output = new StringBuffer();
        output.append('[');
        output.append(this.type);
        for (int i2 = 0; i2 < this.args.length; ++i2) {
            output.append(" \"");
            ConditionInfo.encodeString(this.args[i2], output);
            output.append('\"');
        }
        output.append(']');
        return output.toString();
    }

    public String toString() {
        return this.getEncoded();
    }

    public final String getType() {
        return this.type;
    }

    public final String[] getArgs() {
        return this.args;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ConditionInfo)) {
            return false;
        }
        ConditionInfo other = (ConditionInfo)obj;
        if (!this.type.equals(other.type) || this.args.length != other.args.length) {
            return false;
        }
        for (int i2 = 0; i2 < this.args.length; ++i2) {
            if (this.args[i2].equals(other.args[i2])) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int hash = this.type.hashCode();
        for (int i2 = 0; i2 < this.args.length; ++i2) {
            hash ^= this.args[i2].hashCode();
        }
        return hash;
    }

    private static void encodeString(String str, StringBuffer output) {
        int len = str.length();
        block5: for (int i2 = 0; i2 < len; ++i2) {
            char c2 = str.charAt(i2);
            switch (c2) {
                case '\"': 
                case '\\': {
                    output.append('\\');
                    output.append(c2);
                    continue block5;
                }
                case '\r': {
                    output.append("\\r");
                    continue block5;
                }
                case '\n': {
                    output.append("\\n");
                    continue block5;
                }
                default: {
                    output.append(c2);
                }
            }
        }
    }

    private static String decodeString(char[] str, int begin, int end) {
        StringBuffer output = new StringBuffer(end - begin);
        for (int i2 = begin; i2 < end; ++i2) {
            int c2 = str[i2];
            if (c2 == 92 && ++i2 < end) {
                c2 = str[i2];
                if (c2 == 110) {
                    c2 = 10;
                } else if (c2 == 114) {
                    c2 = 13;
                }
            }
            output.append((char)c2);
        }
        return output.toString();
    }
}

