/*
 * Decompiled with CFR 0.152.
 */
package org.osgi.service.condpermadmin;

import java.util.Dictionary;

public interface Condition {
    public static final Condition TRUE = new BooleanCondition(true);
    public static final Condition FALSE = new BooleanCondition(false);

    public boolean isPostponed();

    public boolean isSatisfied();

    public boolean isMutable();

    public boolean isSatisfied(Condition[] var1, Dictionary var2);

    public static final class BooleanCondition
    implements Condition {
        boolean satisfied;

        BooleanCondition(boolean satisfied) {
            this.satisfied = satisfied;
        }

        public boolean isPostponed() {
            return false;
        }

        public boolean isSatisfied() {
            return this.satisfied;
        }

        public boolean isMutable() {
            return false;
        }

        public boolean isSatisfied(Condition[] conds, Dictionary context) {
            for (int i2 = 0; i2 < conds.length; ++i2) {
                if (conds[i2].isSatisfied()) continue;
                return false;
            }
            return true;
        }
    }
}

