/*
 * Decompiled with CFR 0.152.
 */
package org.osgi.framework;

import java.security.Permission;
import java.security.PermissionCollection;
import java.util.Enumeration;
import java.util.Hashtable;
import org.osgi.framework.PackagePermission;

final class PackagePermissionCollection
extends PermissionCollection {
    static final long serialVersionUID = -3350758995234427603L;
    private Hashtable permissions = new Hashtable();
    private boolean all_allowed = false;

    public void add(Permission permission) {
        if (!(permission instanceof PackagePermission)) {
            throw new IllegalArgumentException("invalid permission: " + permission);
        }
        if (this.isReadOnly()) {
            throw new SecurityException("attempt to add a Permission to a readonly PermissionCollection");
        }
        PackagePermission pp = (PackagePermission)permission;
        String name = pp.getName();
        PackagePermission existing = (PackagePermission)this.permissions.get(name);
        if (existing != null) {
            int newMask;
            int oldMask = existing.getMask();
            if (oldMask != (newMask = pp.getMask())) {
                this.permissions.put(name, new PackagePermission(name, oldMask | newMask));
            }
        } else {
            this.permissions.put(name, permission);
        }
        if (!this.all_allowed && name.equals("*")) {
            this.all_allowed = true;
        }
    }

    public boolean implies(Permission permission) {
        int last;
        PackagePermission x2;
        if (!(permission instanceof PackagePermission)) {
            return false;
        }
        PackagePermission pp = (PackagePermission)permission;
        int desired = pp.getMask();
        int effective = 0;
        if (this.all_allowed && (x2 = (PackagePermission)this.permissions.get("*")) != null && ((effective |= x2.getMask()) & desired) == desired) {
            return true;
        }
        String name = pp.getName();
        x2 = (PackagePermission)this.permissions.get(name);
        if (x2 != null && ((effective |= x2.getMask()) & desired) == desired) {
            return true;
        }
        int offset = name.length() - 1;
        while ((last = name.lastIndexOf(".", offset)) != -1) {
            x2 = (PackagePermission)this.permissions.get(name = name.substring(0, last + 1) + "*");
            if (x2 != null && ((effective |= x2.getMask()) & desired) == desired) {
                return true;
            }
            offset = last - 1;
        }
        return false;
    }

    public Enumeration elements() {
        return this.permissions.elements();
    }
}

