/*
 * Decompiled with CFR 0.152.
 */
package org.osgi.framework;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.security.BasicPermission;
import java.security.Permission;
import java.security.PermissionCollection;
import org.osgi.framework.PackagePermissionCollection;

public final class PackagePermission
extends BasicPermission {
    static final long serialVersionUID = -5107705877071099135L;
    public static final String EXPORT = "export";
    public static final String IMPORT = "import";
    private static final int ACTION_EXPORT = 1;
    private static final int ACTION_IMPORT = 2;
    private static final int ACTION_ALL = 3;
    private static final int ACTION_NONE = 0;
    private static final int ACTION_ERROR = Integer.MIN_VALUE;
    private transient int action_mask = 0;
    private String actions = null;

    public PackagePermission(String name, String actions) {
        this(name, PackagePermission.getMask(actions));
    }

    PackagePermission(String name, int mask) {
        super(name);
        this.init(mask);
    }

    private void init(int mask) {
        if (mask == 0 || (mask & 3) != mask) {
            throw new IllegalArgumentException("invalid action string");
        }
        this.action_mask = mask;
    }

    /*
     * WARNING - void declaration
     */
    private static int getMask(String actions) {
        boolean seencomma = false;
        int mask = 0;
        if (actions == null) {
            return mask;
        }
        char[] a2 = actions.toCharArray();
        int i2 = a2.length - 1;
        if (i2 < 0) {
            return mask;
        }
        while (i2 != -1) {
            void var6_6;
            int matchlen;
            char c2;
            while (i2 != -1 && ((c2 = a2[i2]) == ' ' || c2 == '\r' || c2 == '\n' || c2 == '\f' || c2 == '\t')) {
                --i2;
            }
            if (!(i2 < 5 || a2[i2 - 5] != 'i' && a2[i2 - 5] != 'I' || a2[i2 - 4] != 'm' && a2[i2 - 4] != 'M' || a2[i2 - 3] != 'p' && a2[i2 - 3] != 'P' || a2[i2 - 2] != 'o' && a2[i2 - 2] != 'O' || a2[i2 - 1] != 'r' && a2[i2 - 1] != 'R' || a2[i2] != 't' && a2[i2] != 'T')) {
                matchlen = 6;
                mask |= 2;
            } else if (!(i2 < 5 || a2[i2 - 5] != 'e' && a2[i2 - 5] != 'E' || a2[i2 - 4] != 'x' && a2[i2 - 4] != 'X' || a2[i2 - 3] != 'p' && a2[i2 - 3] != 'P' || a2[i2 - 2] != 'o' && a2[i2 - 2] != 'O' || a2[i2 - 1] != 'r' && a2[i2 - 1] != 'R' || a2[i2] != 't' && a2[i2] != 'T')) {
                matchlen = 6;
                mask |= 3;
            } else {
                throw new IllegalArgumentException("invalid permission: " + actions);
            }
            seencomma = false;
            while (i2 >= var6_6 && !seencomma) {
                switch (a2[i2 - var6_6]) {
                    case ',': {
                        seencomma = true;
                    }
                    case '\t': 
                    case '\n': 
                    case '\f': 
                    case '\r': 
                    case ' ': {
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("invalid permission: " + actions);
                    }
                }
                --i2;
            }
            i2 -= var6_6;
        }
        if (seencomma) {
            throw new IllegalArgumentException("invalid permission: " + actions);
        }
        return mask;
    }

    public boolean implies(Permission p2) {
        if (p2 instanceof PackagePermission) {
            PackagePermission target = (PackagePermission)p2;
            return (this.action_mask & target.action_mask) == target.action_mask && super.implies(p2);
        }
        return false;
    }

    public String getActions() {
        if (this.actions == null) {
            StringBuffer sb = new StringBuffer();
            boolean comma = false;
            if ((this.action_mask & 1) == 1) {
                sb.append(EXPORT);
                comma = true;
            }
            if ((this.action_mask & 2) == 2) {
                if (comma) {
                    sb.append(',');
                }
                sb.append(IMPORT);
            }
            this.actions = sb.toString();
        }
        return this.actions;
    }

    public PermissionCollection newPermissionCollection() {
        return new PackagePermissionCollection();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof PackagePermission)) {
            return false;
        }
        PackagePermission p2 = (PackagePermission)obj;
        return this.action_mask == p2.action_mask && this.getName().equals(p2.getName());
    }

    public int hashCode() {
        return this.getName().hashCode() ^ this.getActions().hashCode();
    }

    int getMask() {
        return this.action_mask;
    }

    private synchronized void writeObject(ObjectOutputStream s2) throws IOException {
        if (this.actions == null) {
            this.getActions();
        }
        s2.defaultWriteObject();
    }

    private synchronized void readObject(ObjectInputStream s2) throws IOException, ClassNotFoundException {
        s2.defaultReadObject();
        this.init(PackagePermission.getMask(this.actions));
    }
}

