/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xsd.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.EObjectEList;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.xsd.XSDAnnotation;
import org.eclipse.xsd.XSDCompositor;
import org.eclipse.xsd.XSDConcreteComponent;
import org.eclipse.xsd.XSDDiagnostic;
import org.eclipse.xsd.XSDDiagnosticSeverity;
import org.eclipse.xsd.XSDFactory;
import org.eclipse.xsd.XSDModelGroup;
import org.eclipse.xsd.XSDModelGroupDefinition;
import org.eclipse.xsd.XSDPackage;
import org.eclipse.xsd.XSDParticle;
import org.eclipse.xsd.impl.XSDAnnotationImpl;
import org.eclipse.xsd.impl.XSDConcreteComponentImpl;
import org.eclipse.xsd.impl.XSDParticleImpl;
import org.eclipse.xsd.impl.XSDTermImpl;
import org.eclipse.xsd.util.XSDConstants;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class XSDModelGroupImpl
extends XSDTermImpl
implements XSDModelGroup {
    protected static final XSDCompositor COMPOSITOR_EDEFAULT = XSDCompositor.ALL_LITERAL;
    protected XSDCompositor compositor = COMPOSITOR_EDEFAULT;
    protected XSDAnnotation annotation = null;
    protected EList contents = null;
    protected EList particles = null;
    static /* synthetic */ Class class$org$eclipse$xsd$XSDParticle;

    public static XSDModelGroup createModelGroup(Node node) {
        switch (XSDConstants.nodeType(node)) {
            case 0: {
                XSDModelGroup xsdModelGroup = XSDFactory.eINSTANCE.createXSDModelGroup();
                xsdModelGroup.setCompositor(XSDCompositor.ALL_LITERAL);
                xsdModelGroup.setElement((Element)node);
                return xsdModelGroup;
            }
            case 7: {
                XSDModelGroup xsdModelGroup = XSDFactory.eINSTANCE.createXSDModelGroup();
                xsdModelGroup.setCompositor(XSDCompositor.CHOICE_LITERAL);
                xsdModelGroup.setElement((Element)node);
                return xsdModelGroup;
            }
            case 35: {
                XSDModelGroup xsdModelGroup = XSDFactory.eINSTANCE.createXSDModelGroup();
                xsdModelGroup.setCompositor(XSDCompositor.SEQUENCE_LITERAL);
                xsdModelGroup.setElement((Element)node);
                return xsdModelGroup;
            }
        }
        return null;
    }

    protected XSDModelGroupImpl() {
    }

    protected EClass eStaticClass() {
        return XSDPackage.eINSTANCE.getXSDModelGroup();
    }

    public XSDCompositor getCompositor() {
        return this.compositor;
    }

    public void setCompositor(XSDCompositor newCompositor) {
        XSDCompositor oldCompositor = this.compositor;
        XSDCompositor xSDCompositor = this.compositor = newCompositor == null ? COMPOSITOR_EDEFAULT : newCompositor;
        if (this.eNotificationRequired()) {
            this.eNotify(new ENotificationImpl((InternalEObject)this, 1, 5, (Object)oldCompositor, (Object)this.compositor));
        }
    }

    public XSDAnnotation getAnnotation() {
        return this.annotation;
    }

    public void setAnnotation(XSDAnnotation newAnnotation) {
        if (newAnnotation != this.annotation) {
            NotificationChain msgs = null;
            if (this.annotation != null) {
                msgs = ((InternalEObject)((Object)this.annotation)).eInverseRemove(this, -7, null, msgs);
            }
            if (newAnnotation != null) {
                msgs = ((InternalEObject)((Object)newAnnotation)).eInverseAdd(this, -7, null, msgs);
            }
            if ((msgs = this.basicSetAnnotation(newAnnotation, msgs)) != null) {
                msgs.dispatch();
            }
        } else if (this.eNotificationRequired()) {
            this.eNotify(new ENotificationImpl((InternalEObject)this, 1, 6, (Object)newAnnotation, (Object)newAnnotation));
        }
    }

    public NotificationChain basicSetAnnotation(XSDAnnotation newAnnotation, NotificationChain msgs) {
        XSDAnnotation oldAnnotation = this.annotation;
        this.annotation = newAnnotation;
        if (this.eNotificationRequired()) {
            ENotificationImpl notification = new ENotificationImpl((InternalEObject)this, 1, 6, (Object)oldAnnotation, (Object)newAnnotation);
            if (msgs == null) {
                msgs = notification;
            } else {
                msgs.add(notification);
            }
        }
        return msgs;
    }

    public EList getContents() {
        if (this.contents == null) {
            this.contents = new EObjectContainmentEList(class$org$eclipse$xsd$XSDParticle == null ? (class$org$eclipse$xsd$XSDParticle = XSDModelGroupImpl.class$("org.eclipse.xsd.XSDParticle")) : class$org$eclipse$xsd$XSDParticle, this, 7);
        }
        return this.contents;
    }

    public EList getParticles() {
        if (this.particles == null) {
            this.particles = new EObjectEList(class$org$eclipse$xsd$XSDParticle == null ? (class$org$eclipse$xsd$XSDParticle = XSDModelGroupImpl.class$("org.eclipse.xsd.XSDParticle")) : class$org$eclipse$xsd$XSDParticle, this, 8);
        }
        return this.particles;
    }

    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs) {
        if (featureID >= 0) {
            switch (this.eDerivedStructuralFeatureID(featureID, baseClass)) {
                case 4: {
                    return ((InternalEList)this.getDiagnostics()).basicRemove(otherEnd, msgs);
                }
                case 6: {
                    return this.basicSetAnnotation(null, msgs);
                }
                case 7: {
                    return ((InternalEList)this.getContents()).basicRemove(otherEnd, msgs);
                }
            }
            return this.eDynamicInverseRemove(otherEnd, featureID, baseClass, msgs);
        }
        return this.eBasicSetContainer(null, featureID, msgs);
    }

    public Object eGet(EStructuralFeature eFeature, boolean resolve) {
        switch (this.eDerivedStructuralFeatureID(eFeature)) {
            case 0: {
                return this.getElement();
            }
            case 1: {
                return this.getContainer();
            }
            case 2: {
                return this.getRootContainer();
            }
            case 3: {
                return this.getSchema();
            }
            case 4: {
                return this.getDiagnostics();
            }
            case 5: {
                return this.getCompositor();
            }
            case 6: {
                return this.getAnnotation();
            }
            case 7: {
                return this.getContents();
            }
            case 8: {
                return this.getParticles();
            }
        }
        return this.eDynamicGet(eFeature, resolve);
    }

    public void eSet(EStructuralFeature eFeature, Object newValue) {
        switch (this.eDerivedStructuralFeatureID(eFeature)) {
            case 0: {
                this.setElement((Element)newValue);
                return;
            }
            case 4: {
                this.getDiagnostics().clear();
                this.getDiagnostics().addAll((Collection)newValue);
                return;
            }
            case 5: {
                this.setCompositor((XSDCompositor)newValue);
                return;
            }
            case 6: {
                this.setAnnotation((XSDAnnotation)newValue);
                return;
            }
            case 7: {
                this.getContents().clear();
                this.getContents().addAll((Collection)newValue);
                return;
            }
            case 8: {
                this.getParticles().clear();
                this.getParticles().addAll((Collection)newValue);
                return;
            }
        }
        this.eDynamicSet(eFeature, newValue);
    }

    public void eUnset(EStructuralFeature eFeature) {
        switch (this.eDerivedStructuralFeatureID(eFeature)) {
            case 0: {
                this.setElement(ELEMENT_EDEFAULT);
                return;
            }
            case 4: {
                this.getDiagnostics().clear();
                return;
            }
            case 5: {
                this.setCompositor(COMPOSITOR_EDEFAULT);
                return;
            }
            case 6: {
                this.setAnnotation(null);
                return;
            }
            case 7: {
                this.getContents().clear();
                return;
            }
            case 8: {
                this.getParticles().clear();
                return;
            }
        }
        this.eDynamicUnset(eFeature);
    }

    public boolean eIsSet(EStructuralFeature eFeature) {
        switch (this.eDerivedStructuralFeatureID(eFeature)) {
            case 0: {
                return ELEMENT_EDEFAULT == null ? this.element != null : !ELEMENT_EDEFAULT.equals(this.element);
            }
            case 1: {
                return this.getContainer() != null;
            }
            case 2: {
                return this.getRootContainer() != null;
            }
            case 3: {
                return this.getSchema() != null;
            }
            case 4: {
                return this.diagnostics != null && !this.diagnostics.isEmpty();
            }
            case 5: {
                return this.compositor != COMPOSITOR_EDEFAULT;
            }
            case 6: {
                return this.annotation != null;
            }
            case 7: {
                return this.contents != null && !this.contents.isEmpty();
            }
            case 8: {
                return this.particles != null && !this.particles.isEmpty();
            }
        }
        return this.eDynamicIsSet(eFeature);
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (compositor: ");
        result.append(this.compositor);
        result.append(')');
        return result.toString();
    }

    public Element createElement() {
        XSDCompositor theCompositor = this.getCompositor();
        Element newElement = this.createElement(XSDCompositor.ALL_LITERAL == theCompositor ? 0 : (XSDCompositor.CHOICE_LITERAL == theCompositor ? 7 : 35));
        this.setElement(newElement);
        Iterator contents = this.getContents().iterator();
        while (contents.hasNext()) {
            XSDParticle xsdParticle = (XSDParticle)contents.next();
            Element newParticleElement = ((XSDConcreteComponentImpl)((Object)xsdParticle)).createElement();
            newElement.appendChild(newParticleElement);
        }
        return newElement;
    }

    protected void patch() {
        super.patch();
        ArrayList newParticles = new ArrayList(this.getContents());
        ArrayList<XSDParticle> remainingParticles = new ArrayList<XSDParticle>(this.getParticles());
        ListIterator particles = newParticles.listIterator();
        while (particles.hasNext()) {
            XSDParticle xsdParticle = (XSDParticle)particles.next();
            if (xsdParticle.getMaxOccurs() == 0) {
                particles.remove();
                remainingParticles.add(xsdParticle);
                continue;
            }
            remainingParticles.remove(xsdParticle);
        }
        if (!remainingParticles.isEmpty()) {
            this.getParticles().removeAll(remainingParticles);
        }
        XSDModelGroupImpl.setListContentAndOrder(this.getParticles(), newParticles);
    }

    public void validate() {
        super.validate();
        boolean hasBounds = !(this.getContainer() instanceof XSDModelGroupDefinition);
        String anchor = null;
        String contentType = null;
        switch (this.getCompositor().getValue()) {
            case 0: {
                anchor = "element-all";
                contentType = "all";
                Iterator i2 = this.getContents().iterator();
                block8: while (i2.hasNext()) {
                    XSDParticle xsdParticle = (XSDParticle)i2.next();
                    switch (xsdParticle.getMaxOccurs()) {
                        case 0: 
                        case 1: {
                            continue block8;
                        }
                    }
                    this.createDiagnostic(XSDDiagnosticSeverity.ERROR_LITERAL, "cos-all-limited.2");
                }
                break;
            }
            case 2: {
                anchor = "element-sequence";
                contentType = "explicitGroup";
                break;
            }
            case 1: {
                anchor = "element-choice";
                contentType = "explicitGroup";
            }
        }
        Element theElement = this.getElement();
        if (theElement != null) {
            String[] stringArray;
            if (hasBounds) {
                String[] stringArray2 = new String[3];
                stringArray2[0] = "id";
                stringArray2[1] = "maxOccurs";
                stringArray = stringArray2;
                stringArray2[2] = "minOccurs";
            } else {
                String[] stringArray3 = new String[1];
                stringArray = stringArray3;
                stringArray3[0] = "id";
            }
            String[] attributes = stringArray;
            this.checkAttributes("http://www.w3.org/TR/xmlschema-1/", anchor, theElement, attributes);
            this.checkBuiltInTypeConstraint("ID", null, "http://www.w3.org/TR/xmlschema-1/", anchor, theElement, "id", false);
            if (hasBounds) {
                this.checkAttributeTypeConstraint(contentType, "maxOccurs", null, "http://www.w3.org/TR/xmlschema-1/", anchor, theElement, "maxOccurs", false);
                this.checkAttributeTypeConstraint(contentType, "minOccurs", null, "http://www.w3.org/TR/xmlschema-1/", anchor, theElement, "minOccurs", false);
            }
            this.checkComplexContent(contentType, "http://www.w3.org/TR/xmlschema-1/", anchor, theElement);
        }
    }

    public void validateRoot() {
        XSDParticleImpl.XSDNFA dfa;
        Collection diagnostics;
        XSDParticle xsdParticle;
        XSDConcreteComponent diagnosticTarget = this;
        if (this.getContainer() instanceof XSDParticle) {
            xsdParticle = (XSDParticle)this.getContainer();
            if (xsdParticle.eContainmentFeature() == XSDPackage.eINSTANCE.getXSDComplexTypeDefinition_SyntheticParticle()) {
                diagnosticTarget = xsdParticle.getContainer();
            }
        } else {
            xsdParticle = XSDFactory.eINSTANCE.createXSDParticle();
            xsdParticle.setTerm(this);
        }
        if (!(diagnostics = (dfa = (XSDParticleImpl.XSDNFA)xsdParticle.getDFA()).getDiagnostics()).isEmpty()) {
            Iterator i2 = diagnostics.iterator();
            while (i2.hasNext()) {
                XSDDiagnostic xsdDiagnostic = (XSDDiagnostic)i2.next();
                xsdDiagnostic.setPrimaryComponent(diagnosticTarget);
                xsdDiagnostic.setNode(diagnosticTarget.getElement());
            }
            this.getDiagnostics().addAll(diagnostics);
        }
    }

    protected boolean isUpdatingDOM() {
        return super.isUpdatingDOM() || this.getContainer() instanceof XSDConcreteComponentImpl && ((XSDConcreteComponentImpl)this.getContainer()).isUpdatingDOM();
    }

    protected void handleUnreconciledElement(Element child, List newContents, List remainingContents) {
        XSDParticle xsdParticle = XSDParticleImpl.createParticle(child);
        if (xsdParticle != null) {
            newContents.add(xsdParticle);
        } else {
            XSDAnnotation xsdAnnotation = XSDAnnotationImpl.createAnnotation(child);
            if (xsdAnnotation != null && newContents.isEmpty()) {
                newContents.add(xsdAnnotation);
            }
        }
    }

    protected void handleReconciliation(List newContents, List remainingContents) {
        this.handleAnnotationReconciliation(XSDPackage.eINSTANCE.getXSDModelGroup_Annotation(), newContents, remainingContents);
        if (!remainingContents.isEmpty()) {
            this.getContents().removeAll(remainingContents);
        }
        if (!newContents.isEmpty()) {
            XSDModelGroupImpl.setListContentAndOrder(this.getContents(), newContents);
        }
    }

    protected void changeAttribute(EAttribute eAttribute) {
        super.changeAttribute(eAttribute);
        Element theElement = this.getElement();
        if (!(eAttribute != null && eAttribute != XSDPackage.eINSTANCE.getXSDModelGroup_Compositor() || theElement == null || eAttribute == null || this.isReconciling)) {
            XSDCompositor theCompositor = this.getCompositor();
            Element newElement = this.createElement(XSDCompositor.ALL_LITERAL == theCompositor ? 0 : (XSDCompositor.CHOICE_LITERAL == theCompositor ? 7 : 35));
            this.forceReplace(newElement, theElement);
            this.setElement(newElement);
            XSDConcreteComponentImpl container = (XSDConcreteComponentImpl)this.getContainer();
            if (container instanceof XSDParticle) {
                ((XSDParticle)((Object)container)).setElement(newElement);
                container.changeAttribute(null);
            }
        }
    }

    protected void adoptContent(EReference eReference, XSDConcreteComponent xsdConcreteComponent) {
        super.adoptContent(eReference, xsdConcreteComponent);
        if (eReference == XSDPackage.eINSTANCE.getXSDModelGroup_Contents()) {
            this.traverseToRootForPatching();
        }
    }

    protected void orphanContent(EReference eReference, XSDConcreteComponent xsdConcreteComponent) {
        super.orphanContent(eReference, xsdConcreteComponent);
        if (eReference == XSDPackage.eINSTANCE.getXSDModelGroup_Contents()) {
            this.traverseToRootForPatching();
        }
    }

    public XSDConcreteComponent cloneConcreteComponent(boolean deep, boolean shareDOM) {
        XSDModelGroupImpl clonedModelGroup = (XSDModelGroupImpl)this.getXSDFactory().createXSDModelGroup();
        clonedModelGroup.isReconciling = true;
        clonedModelGroup.setCompositor(this.getCompositor());
        if (deep) {
            if (this.getAnnotation() != null) {
                clonedModelGroup.setAnnotation((XSDAnnotation)this.getAnnotation().cloneConcreteComponent(deep, shareDOM));
            }
            if (!this.getContents().isEmpty()) {
                clonedModelGroup.getContents().addAll(XSDModelGroupImpl.cloneConcreteComponents(this.getContents(), true, shareDOM));
            }
        }
        if (shareDOM && this.getElement() != null) {
            clonedModelGroup.setElement(this.getElement());
        }
        clonedModelGroup.isReconciling = shareDOM;
        return clonedModelGroup;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

