/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xsd.impl;

import java.util.Collection;
import java.util.Iterator;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.xsd.XSDAnnotation;
import org.eclipse.xsd.XSDConcreteComponent;
import org.eclipse.xsd.XSDDiagnostic;
import org.eclipse.xsd.XSDFixedFacet;
import org.eclipse.xsd.XSDMaxExclusiveFacet;
import org.eclipse.xsd.XSDMaxFacet;
import org.eclipse.xsd.XSDMaxInclusiveFacet;
import org.eclipse.xsd.XSDMinExclusiveFacet;
import org.eclipse.xsd.XSDPackage;
import org.eclipse.xsd.XSDSimpleTypeDefinition;
import org.eclipse.xsd.impl.XSDFixedFacetImpl;
import org.eclipse.xsd.impl.XSDSimpleTypeDefinitionImpl;
import org.w3c.dom.Element;

public abstract class XSDMaxFacetImpl
extends XSDFixedFacetImpl
implements XSDMaxFacet {
    protected static final Object VALUE_EDEFAULT = null;
    protected Object value = VALUE_EDEFAULT;
    protected static final boolean INCLUSIVE_EDEFAULT = false;
    protected static final boolean EXCLUSIVE_EDEFAULT = false;

    protected XSDMaxFacetImpl() {
    }

    protected EClass eStaticClass() {
        return XSDPackage.eINSTANCE.getXSDMaxFacet();
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object newValue) {
        Object oldValue = this.value;
        this.value = newValue;
        if (this.eNotificationRequired()) {
            this.eNotify(new ENotificationImpl((InternalEObject)this, 1, 11, oldValue, this.value));
        }
    }

    public Boolean getInclusive() {
        return this.isInclusive() ? Boolean.TRUE : Boolean.FALSE;
    }

    public boolean isInclusive() {
        return false;
    }

    public Boolean getExclusive() {
        return this.isExclusive() ? Boolean.TRUE : Boolean.FALSE;
    }

    public boolean isExclusive() {
        return false;
    }

    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs) {
        if (featureID >= 0) {
            switch (this.eDerivedStructuralFeatureID(featureID, baseClass)) {
                case 4: {
                    return ((InternalEList)this.getDiagnostics()).basicRemove(otherEnd, msgs);
                }
                case 8: {
                    return this.basicSetAnnotation(null, msgs);
                }
            }
            return this.eDynamicInverseRemove(otherEnd, featureID, baseClass, msgs);
        }
        return this.eBasicSetContainer(null, featureID, msgs);
    }

    public Object eGet(EStructuralFeature eFeature, boolean resolve) {
        switch (this.eDerivedStructuralFeatureID(eFeature)) {
            case 0: {
                return this.getElement();
            }
            case 1: {
                return this.getContainer();
            }
            case 2: {
                return this.getRootContainer();
            }
            case 3: {
                return this.getSchema();
            }
            case 4: {
                return this.getDiagnostics();
            }
            case 5: {
                return this.getLexicalValue();
            }
            case 6: {
                return this.getFacetName();
            }
            case 7: {
                return this.getEffectiveValue();
            }
            case 8: {
                return this.getAnnotation();
            }
            case 9: {
                return this.getSimpleTypeDefinition();
            }
            case 10: {
                return this.isFixed() ? Boolean.TRUE : Boolean.FALSE;
            }
            case 11: {
                return this.getValue();
            }
            case 12: {
                return this.isInclusive() ? Boolean.TRUE : Boolean.FALSE;
            }
            case 13: {
                return this.isExclusive() ? Boolean.TRUE : Boolean.FALSE;
            }
        }
        return this.eDynamicGet(eFeature, resolve);
    }

    public void eSet(EStructuralFeature eFeature, Object newValue) {
        switch (this.eDerivedStructuralFeatureID(eFeature)) {
            case 0: {
                this.setElement((Element)newValue);
                return;
            }
            case 4: {
                this.getDiagnostics().clear();
                this.getDiagnostics().addAll((Collection)newValue);
                return;
            }
            case 5: {
                this.setLexicalValue((String)newValue);
                return;
            }
            case 8: {
                this.setAnnotation((XSDAnnotation)newValue);
                return;
            }
            case 10: {
                this.setFixed((Boolean)newValue);
                return;
            }
            case 11: {
                this.setValue(newValue);
                return;
            }
        }
        this.eDynamicSet(eFeature, newValue);
    }

    public void eUnset(EStructuralFeature eFeature) {
        switch (this.eDerivedStructuralFeatureID(eFeature)) {
            case 0: {
                this.setElement(ELEMENT_EDEFAULT);
                return;
            }
            case 4: {
                this.getDiagnostics().clear();
                return;
            }
            case 5: {
                this.setLexicalValue(LEXICAL_VALUE_EDEFAULT);
                return;
            }
            case 8: {
                this.setAnnotation(null);
                return;
            }
            case 10: {
                this.unsetFixed();
                return;
            }
            case 11: {
                this.setValue(VALUE_EDEFAULT);
                return;
            }
        }
        this.eDynamicUnset(eFeature);
    }

    public boolean eIsSet(EStructuralFeature eFeature) {
        switch (this.eDerivedStructuralFeatureID(eFeature)) {
            case 0: {
                return ELEMENT_EDEFAULT == null ? this.element != null : !ELEMENT_EDEFAULT.equals(this.element);
            }
            case 1: {
                return this.getContainer() != null;
            }
            case 2: {
                return this.getRootContainer() != null;
            }
            case 3: {
                return this.getSchema() != null;
            }
            case 4: {
                return this.diagnostics != null && !this.diagnostics.isEmpty();
            }
            case 5: {
                return LEXICAL_VALUE_EDEFAULT == null ? this.lexicalValue != null : !LEXICAL_VALUE_EDEFAULT.equals(this.lexicalValue);
            }
            case 6: {
                return FACET_NAME_EDEFAULT == null ? this.getFacetName() != null : !FACET_NAME_EDEFAULT.equals(this.getFacetName());
            }
            case 7: {
                return EFFECTIVE_VALUE_EDEFAULT == null ? this.getEffectiveValue() != null : !EFFECTIVE_VALUE_EDEFAULT.equals(this.getEffectiveValue());
            }
            case 8: {
                return this.annotation != null;
            }
            case 9: {
                return this.getSimpleTypeDefinition() != null;
            }
            case 10: {
                return this.isSetFixed();
            }
            case 11: {
                return VALUE_EDEFAULT == null ? this.value != null : !VALUE_EDEFAULT.equals(this.value);
            }
            case 12: {
                return this.isInclusive();
            }
            case 13: {
                return this.isExclusive();
            }
        }
        return this.eDynamicIsSet(eFeature);
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (value: ");
        result.append(this.value);
        result.append(')');
        return result.toString();
    }

    public void validate() {
        XSDMaxInclusiveFacet xsdMaxInclusiveFacet;
        super.validate();
        XSDSimpleTypeDefinition xsdSimpleTypeDefinition = this.getSimpleTypeDefinition();
        if (this.isExclusive() && (xsdMaxInclusiveFacet = xsdSimpleTypeDefinition.getMaxInclusiveFacet()) != null) {
            XSDDiagnostic xsdDiagnostic = this.reportConstraintViolation("http://www.w3.org/TR/xmlschema-2/", "maxInclusive-maxExclusive", this.getElement(), "value", new Object[0]);
            xsdDiagnostic.getComponents().add(xsdMaxInclusiveFacet);
        }
    }

    protected void validateValue() {
        XSDSimpleTypeDefinition xsdSimpleTypeDefinition = (XSDSimpleTypeDefinition)this.getContainer();
        XSDSimpleTypeDefinition baseTypeDefinition = xsdSimpleTypeDefinition.getBaseTypeDefinition();
        if (baseTypeDefinition != null) {
            if (this.getLexicalValue() == null) {
                this.createRequiredAttributeDiagnostic("http://www.w3.org/TR/xmlschema-2/", "element-" + this.getFacetName(), this.getElement(), "value");
            } else {
                XSDSimpleTypeDefinitionImpl.AssessmentImpl assessment = (XSDSimpleTypeDefinitionImpl.AssessmentImpl)baseTypeDefinition.assess(this.getLexicalValue());
                Collection allDiagnostics = assessment.getDiagnostics();
                if (!allDiagnostics.isEmpty()) {
                    if (this.isExclusive()) {
                        Iterator i2 = allDiagnostics.iterator();
                        while (i2.hasNext()) {
                            XSDDiagnostic xsdDiagnostic = (XSDDiagnostic)i2.next();
                            XSDConcreteComponent primaryComponent = xsdDiagnostic.getPrimaryComponent();
                            if (!(primaryComponent instanceof XSDMaxExclusiveFacet) || !baseTypeDefinition.equalLiterals(this.getLexicalValue(), ((XSDMaxExclusiveFacet)primaryComponent).getLexicalValue())) continue;
                            i2.remove();
                        }
                    }
                    assessment.assignDiagnostics(this, this.getElement(), "value");
                    this.getDiagnostics().addAll(allDiagnostics);
                }
            }
        }
    }

    protected boolean restrictionMatch(XSDFixedFacet xsdFixedFacet) {
        return xsdFixedFacet instanceof XSDMaxExclusiveFacet || xsdFixedFacet instanceof XSDMinExclusiveFacet;
    }

    protected void validateRestriction(XSDFixedFacet xsdFixedFacet) {
        XSDSimpleTypeDefinition xsdSimpleTypeDefinition = this.getSimpleTypeDefinition();
        int compare = xsdSimpleTypeDefinition.compareValues(this.getValue(), xsdFixedFacet.getEffectiveValue());
        if (xsdFixedFacet instanceof XSDMaxExclusiveFacet ? compare > 0 : compare <= 0) {
            XSDDiagnostic xsdDiagnostic = this.reportConstraintViolation("http://www.w3.org/TR/xmlschema-2/", this.getFacetName() + (xsdFixedFacet instanceof XSDMaxExclusiveFacet ? "-valid-restriction.2" : "-valid-restriction.4"), this.getElement(), "value", new Object[]{this.getLexicalValue(), xsdFixedFacet.getLexicalValue(), xsdFixedFacet.getSimpleTypeDefinition().getURI()});
            xsdDiagnostic.getComponents().add(xsdFixedFacet);
        }
    }
}

