/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xsd.impl;

import java.text.Collator;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.xsd.XSDAttributeDeclaration;
import org.eclipse.xsd.XSDAttributeUse;
import org.eclipse.xsd.XSDAttributeUseCategory;
import org.eclipse.xsd.XSDConcreteComponent;
import org.eclipse.xsd.XSDConstraint;
import org.eclipse.xsd.XSDDiagnosticSeverity;
import org.eclipse.xsd.XSDFactory;
import org.eclipse.xsd.XSDPackage;
import org.eclipse.xsd.XSDSimpleTypeDefinition;
import org.eclipse.xsd.impl.XSDAttributeDeclarationImpl;
import org.eclipse.xsd.impl.XSDComponentImpl;
import org.eclipse.xsd.impl.XSDConcreteComponentImpl;
import org.eclipse.xsd.util.XSDConstants;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class XSDAttributeUseImpl
extends XSDComponentImpl
implements XSDAttributeUse {
    protected static final boolean REQUIRED_EDEFAULT = false;
    protected static final int REQUIRED_EFLAG = 256;
    protected static final Object VALUE_EDEFAULT = null;
    protected Object value = VALUE_EDEFAULT;
    protected static final XSDConstraint CONSTRAINT_EDEFAULT = XSDConstraint.DEFAULT_LITERAL;
    protected XSDConstraint constraint = CONSTRAINT_EDEFAULT;
    protected static final int CONSTRAINT_ESETFLAG = 512;
    protected static final XSDAttributeUseCategory USE_EDEFAULT = XSDAttributeUseCategory.OPTIONAL_LITERAL;
    protected XSDAttributeUseCategory use = USE_EDEFAULT;
    protected static final int USE_ESETFLAG = 1024;
    protected static final String LEXICAL_VALUE_EDEFAULT = null;
    protected String lexicalValue = LEXICAL_VALUE_EDEFAULT;
    protected XSDAttributeDeclaration attributeDeclaration = null;
    protected XSDAttributeDeclaration content = null;

    public static XSDAttributeUse createAttributeUse(Node node) {
        if (XSDConstants.nodeType(node) == 5) {
            XSDAttributeUse xsdAttributeUse = XSDFactory.eINSTANCE.createXSDAttributeUse();
            xsdAttributeUse.setElement((Element)node);
            XSDAttributeDeclaration xsdAttributeDeclaration = XSDAttributeDeclarationImpl.createAttributeDeclaration(node);
            xsdAttributeUse.setContent(xsdAttributeDeclaration);
            return xsdAttributeUse;
        }
        return null;
    }

    public static List sortAttributeUses(Collection xsdAttributeUses) {
        Object[] objects = xsdAttributeUses.toArray();
        Arrays.sort(objects, new Comparator(){

            public boolean equals(Object that) {
                return this == that;
            }

            public int compare(Object o1, Object o2) {
                String name1 = ((XSDAttributeUse)o1).getContent().getResolvedAttributeDeclaration().getName();
                String name2 = ((XSDAttributeUse)o2).getContent().getResolvedAttributeDeclaration().getName();
                if (name1 == null && name2 == null) {
                    return 0;
                }
                if (name1 == null) {
                    return 1;
                }
                if (name2 == null) {
                    return -1;
                }
                return Collator.getInstance().compare(name1, name2);
            }
        });
        return Arrays.asList(objects);
    }

    protected XSDAttributeUseImpl() {
    }

    protected EClass eStaticClass() {
        return XSDPackage.eINSTANCE.getXSDAttributeUse();
    }

    public boolean isRequired() {
        return (this.eFlags & 0x100) != 0;
    }

    public void setRequired(boolean newRequired) {
        boolean oldRequired;
        boolean bl = oldRequired = (this.eFlags & 0x100) != 0;
        this.eFlags = newRequired ? (this.eFlags |= 0x100) : (this.eFlags &= 0xFFFFFEFF);
        if (this.eNotificationRequired()) {
            this.eNotify(new ENotificationImpl((InternalEObject)this, 1, 5, oldRequired, newRequired));
        }
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object newValue) {
        Object oldValue = this.value;
        this.value = newValue;
        if (this.eNotificationRequired()) {
            this.eNotify(new ENotificationImpl((InternalEObject)this, 1, 6, oldValue, this.value));
        }
    }

    public XSDConstraint getConstraint() {
        return this.constraint;
    }

    public void setConstraint(XSDConstraint newConstraint) {
        XSDConstraint oldConstraint = this.constraint;
        this.constraint = newConstraint == null ? CONSTRAINT_EDEFAULT : newConstraint;
        boolean oldConstraintESet = (this.eFlags & 0x200) != 0;
        this.eFlags |= 0x200;
        if (this.eNotificationRequired()) {
            this.eNotify(new ENotificationImpl((InternalEObject)this, 1, 7, (Object)oldConstraint, (Object)this.constraint, !oldConstraintESet));
        }
    }

    public void unsetConstraint() {
        XSDConstraint oldConstraint = this.constraint;
        boolean oldConstraintESet = (this.eFlags & 0x200) != 0;
        this.constraint = CONSTRAINT_EDEFAULT;
        this.eFlags &= 0xFFFFFDFF;
        if (this.eNotificationRequired()) {
            this.eNotify(new ENotificationImpl((InternalEObject)this, 2, 7, (Object)oldConstraint, (Object)CONSTRAINT_EDEFAULT, oldConstraintESet));
        }
    }

    public boolean isSetConstraint() {
        return (this.eFlags & 0x200) != 0;
    }

    public XSDAttributeUseCategory getUse() {
        return this.use;
    }

    public void setUse(XSDAttributeUseCategory newUse) {
        XSDAttributeUseCategory oldUse = this.use;
        this.use = newUse == null ? USE_EDEFAULT : newUse;
        boolean oldUseESet = (this.eFlags & 0x400) != 0;
        this.eFlags |= 0x400;
        if (this.eNotificationRequired()) {
            this.eNotify(new ENotificationImpl((InternalEObject)this, 1, 8, (Object)oldUse, (Object)this.use, !oldUseESet));
        }
    }

    public void unsetUse() {
        XSDAttributeUseCategory oldUse = this.use;
        boolean oldUseESet = (this.eFlags & 0x400) != 0;
        this.use = USE_EDEFAULT;
        this.eFlags &= 0xFFFFFBFF;
        if (this.eNotificationRequired()) {
            this.eNotify(new ENotificationImpl((InternalEObject)this, 2, 8, (Object)oldUse, (Object)USE_EDEFAULT, oldUseESet));
        }
    }

    public boolean isSetUse() {
        return (this.eFlags & 0x400) != 0;
    }

    public String getLexicalValue() {
        return this.lexicalValue;
    }

    public void setLexicalValue(String newLexicalValue) {
        String oldLexicalValue = this.lexicalValue;
        this.lexicalValue = newLexicalValue;
        if (this.eNotificationRequired()) {
            this.eNotify(new ENotificationImpl((InternalEObject)this, 1, 9, (Object)oldLexicalValue, (Object)this.lexicalValue));
        }
    }

    public XSDAttributeDeclaration getAttributeDeclaration() {
        return this.attributeDeclaration;
    }

    public void setAttributeDeclaration(XSDAttributeDeclaration newAttributeDeclaration) {
        XSDAttributeDeclaration oldAttributeDeclaration = this.attributeDeclaration;
        this.attributeDeclaration = newAttributeDeclaration;
        if (this.eNotificationRequired()) {
            this.eNotify(new ENotificationImpl((InternalEObject)this, 1, 10, (Object)oldAttributeDeclaration, (Object)this.attributeDeclaration));
        }
    }

    public XSDAttributeDeclaration getContent() {
        return this.content;
    }

    public void setContent(XSDAttributeDeclaration newContent) {
        if (newContent != this.content) {
            NotificationChain msgs = null;
            if (this.content != null) {
                msgs = ((InternalEObject)((Object)this.content)).eInverseRemove(this, -12, null, msgs);
            }
            if (newContent != null) {
                msgs = ((InternalEObject)((Object)newContent)).eInverseAdd(this, -12, null, msgs);
            }
            if ((msgs = this.basicSetContent(newContent, msgs)) != null) {
                msgs.dispatch();
            }
        } else if (this.eNotificationRequired()) {
            this.eNotify(new ENotificationImpl((InternalEObject)this, 1, 11, (Object)newContent, (Object)newContent));
        }
    }

    public NotificationChain basicSetContent(XSDAttributeDeclaration newContent, NotificationChain msgs) {
        XSDAttributeDeclaration oldContent = this.content;
        this.content = newContent;
        if (this.eNotificationRequired()) {
            ENotificationImpl notification = new ENotificationImpl((InternalEObject)this, 1, 11, (Object)oldContent, (Object)newContent);
            if (msgs == null) {
                msgs = notification;
            } else {
                msgs.add(notification);
            }
        }
        return msgs;
    }

    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs) {
        if (featureID >= 0) {
            switch (this.eDerivedStructuralFeatureID(featureID, baseClass)) {
                case 4: {
                    return ((InternalEList)this.getDiagnostics()).basicRemove(otherEnd, msgs);
                }
                case 11: {
                    return this.basicSetContent(null, msgs);
                }
            }
            return this.eDynamicInverseRemove(otherEnd, featureID, baseClass, msgs);
        }
        return this.eBasicSetContainer(null, featureID, msgs);
    }

    public Object eGet(EStructuralFeature eFeature, boolean resolve) {
        switch (this.eDerivedStructuralFeatureID(eFeature)) {
            case 0: {
                return this.getElement();
            }
            case 1: {
                return this.getContainer();
            }
            case 2: {
                return this.getRootContainer();
            }
            case 3: {
                return this.getSchema();
            }
            case 4: {
                return this.getDiagnostics();
            }
            case 5: {
                return this.isRequired() ? Boolean.TRUE : Boolean.FALSE;
            }
            case 6: {
                return this.getValue();
            }
            case 7: {
                return this.getConstraint();
            }
            case 8: {
                return this.getUse();
            }
            case 9: {
                return this.getLexicalValue();
            }
            case 10: {
                return this.getAttributeDeclaration();
            }
            case 11: {
                return this.getContent();
            }
        }
        return this.eDynamicGet(eFeature, resolve);
    }

    public void eSet(EStructuralFeature eFeature, Object newValue) {
        switch (this.eDerivedStructuralFeatureID(eFeature)) {
            case 0: {
                this.setElement((Element)newValue);
                return;
            }
            case 4: {
                this.getDiagnostics().clear();
                this.getDiagnostics().addAll((Collection)newValue);
                return;
            }
            case 5: {
                this.setRequired((Boolean)newValue);
                return;
            }
            case 6: {
                this.setValue(newValue);
                return;
            }
            case 7: {
                this.setConstraint((XSDConstraint)newValue);
                return;
            }
            case 8: {
                this.setUse((XSDAttributeUseCategory)newValue);
                return;
            }
            case 9: {
                this.setLexicalValue((String)newValue);
                return;
            }
            case 10: {
                this.setAttributeDeclaration((XSDAttributeDeclaration)newValue);
                return;
            }
            case 11: {
                this.setContent((XSDAttributeDeclaration)newValue);
                return;
            }
        }
        this.eDynamicSet(eFeature, newValue);
    }

    public void eUnset(EStructuralFeature eFeature) {
        switch (this.eDerivedStructuralFeatureID(eFeature)) {
            case 0: {
                this.setElement(ELEMENT_EDEFAULT);
                return;
            }
            case 4: {
                this.getDiagnostics().clear();
                return;
            }
            case 5: {
                this.setRequired(false);
                return;
            }
            case 6: {
                this.setValue(VALUE_EDEFAULT);
                return;
            }
            case 7: {
                this.unsetConstraint();
                return;
            }
            case 8: {
                this.unsetUse();
                return;
            }
            case 9: {
                this.setLexicalValue(LEXICAL_VALUE_EDEFAULT);
                return;
            }
            case 10: {
                this.setAttributeDeclaration(null);
                return;
            }
            case 11: {
                this.setContent(null);
                return;
            }
        }
        this.eDynamicUnset(eFeature);
    }

    public boolean eIsSet(EStructuralFeature eFeature) {
        switch (this.eDerivedStructuralFeatureID(eFeature)) {
            case 0: {
                return ELEMENT_EDEFAULT == null ? this.element != null : !ELEMENT_EDEFAULT.equals(this.element);
            }
            case 1: {
                return this.getContainer() != null;
            }
            case 2: {
                return this.getRootContainer() != null;
            }
            case 3: {
                return this.getSchema() != null;
            }
            case 4: {
                return this.diagnostics != null && !this.diagnostics.isEmpty();
            }
            case 5: {
                return (this.eFlags & 0x100) != 0;
            }
            case 6: {
                return VALUE_EDEFAULT == null ? this.value != null : !VALUE_EDEFAULT.equals(this.value);
            }
            case 7: {
                return this.isSetConstraint();
            }
            case 8: {
                return this.isSetUse();
            }
            case 9: {
                return LEXICAL_VALUE_EDEFAULT == null ? this.lexicalValue != null : !LEXICAL_VALUE_EDEFAULT.equals(this.lexicalValue);
            }
            case 10: {
                return this.attributeDeclaration != null;
            }
            case 11: {
                return this.content != null;
            }
        }
        return this.eDynamicIsSet(eFeature);
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (required: ");
        result.append((this.eFlags & 0x100) != 0);
        result.append(", value: ");
        result.append(this.value);
        result.append(", constraint: ");
        if ((this.eFlags & 0x200) != 0) {
            result.append(this.constraint);
        } else {
            result.append("<unset>");
        }
        result.append(", use: ");
        if ((this.eFlags & 0x400) != 0) {
            result.append(this.use);
        } else {
            result.append("<unset>");
        }
        result.append(", lexicalValue: ");
        result.append(this.lexicalValue);
        result.append(')');
        return result.toString();
    }

    public Element createElement() {
        Element newElement = null;
        XSDAttributeDeclaration theContent = this.getContent();
        if (theContent != null) {
            newElement = ((XSDConcreteComponentImpl)((Object)theContent)).createElement();
            this.setElement(newElement);
        }
        return newElement;
    }

    protected void patch() {
        super.patch();
        this.patchHelper();
    }

    protected void patchHelper() {
        XSDAttributeDeclaration newAttributeDeclaration = this.getContent();
        if (newAttributeDeclaration != null) {
            newAttributeDeclaration = newAttributeDeclaration.getResolvedAttributeDeclaration();
        }
        if (newAttributeDeclaration != this.getAttributeDeclaration()) {
            this.setAttributeDeclaration(newAttributeDeclaration);
        }
    }

    protected boolean analyze() {
        String theLexicalValue;
        super.analyze();
        Object newValue = null;
        XSDSimpleTypeDefinition xsdSimpleTypeDefinition = this.getAttributeDeclaration().getTypeDefinition();
        if (xsdSimpleTypeDefinition != null && (theLexicalValue = this.getLexicalValue()) != null) {
            try {
                newValue = xsdSimpleTypeDefinition.getValue(theLexicalValue);
            }
            catch (RuntimeException exception) {
                // empty catch block
            }
        }
        if (newValue == null ? this.getValue() != null : !newValue.equals(this.getValue())) {
            this.setValue(newValue);
        }
        return true;
    }

    public void validate() {
        super.validate();
        if (this.getLexicalValue() != null) {
            XSDSimpleTypeDefinition theTypeDefinition = this.getAttributeDeclaration().getTypeDefinition();
            if (theTypeDefinition != null) {
                if (XSDConstants.isOrIsDerivedFromID(theTypeDefinition)) {
                    this.createDiagnostic(XSDDiagnosticSeverity.ERROR_LITERAL, "coss-attribute.3");
                } else {
                    this.checkSimpleTypeConstraint(theTypeDefinition, this.getLexicalValue(), "http://www.w3.org/TR/xmlschema-1/", "element-attribute", this.getElement(), this.getConstraint() == XSDConstraint.FIXED_LITERAL ? "fixed" : "default", false);
                }
            }
            if (!(this.getAttributeDeclaration().getConstraint() != XSDConstraint.FIXED_LITERAL || this.getAttributeDeclaration().getLexicalValue() == null || this.getConstraint() == XSDConstraint.FIXED_LITERAL && theTypeDefinition.equalLiterals(this.getAttributeDeclaration().getLexicalValue(), this.getLexicalValue()))) {
                this.createDiagnostic(XSDDiagnosticSeverity.ERROR_LITERAL, "coss-attruse.2", this.getLexicalValue(), this.getAttributeDeclaration().getLexicalValue());
            }
            if (this.getConstraint() == XSDConstraint.DEFAULT_LITERAL && this.isSetUse() && this.getUse() != XSDAttributeUseCategory.OPTIONAL_LITERAL) {
                this.createDiagnostic(XSDDiagnosticSeverity.ERROR_LITERAL, "src-attribute.2");
            }
        }
    }

    protected Collection getContentNodes(Element changedElement) {
        return Collections.singleton(this.getElement());
    }

    protected void reconcileAttributes(Element changedElement) {
        super.reconcileAttributes(changedElement);
        if (changedElement == this.getElement()) {
            XSDAttributeDeclaration theContent;
            XSDAttributeUseCategory newUse = null;
            if (this.getElement().hasAttributeNS(null, "use")) {
                newUse = XSDAttributeUseCategory.get(this.getElement().getAttributeNS(null, "use"));
            }
            boolean newRequired = false;
            XSDConstraint newConstraint = null;
            String newLexicalValue = null;
            if (newUse != XSDAttributeUseCategory.PROHIBITED_LITERAL) {
                boolean bl = newRequired = newUse == XSDAttributeUseCategory.REQUIRED_LITERAL;
                if (this.getElement().hasAttributeNS(null, "fixed")) {
                    newLexicalValue = this.getElement().getAttributeNS(null, "fixed");
                    if (newLexicalValue != null) {
                        newConstraint = XSDConstraint.FIXED_LITERAL;
                    }
                } else if (this.getElement().hasAttributeNS(null, "default") && (newLexicalValue = this.getElement().getAttributeNS(null, "default")) != null) {
                    newConstraint = XSDConstraint.DEFAULT_LITERAL;
                }
            }
            if (newUse == null) {
                if (this.isSetUse()) {
                    this.unsetUse();
                }
            } else if (!this.isSetUse() || newUse != this.getUse()) {
                this.setUse(newUse);
            }
            if (newRequired != this.isRequired()) {
                this.setRequired(newRequired);
            }
            if (newConstraint == null) {
                if (this.isSetConstraint()) {
                    this.unsetConstraint();
                }
            } else if (!this.isSetConstraint() || newConstraint != this.getConstraint()) {
                this.setConstraint(newConstraint);
            }
            if (newLexicalValue == null ? this.getLexicalValue() != null : !newLexicalValue.equals(this.getLexicalValue())) {
                this.setLexicalValue(newLexicalValue);
            }
            if ((theContent = this.getContent()) != null) {
                theContent.elementAttributesChanged(changedElement);
            }
        }
    }

    protected void reconcileContents(Element changedElement) {
        XSDAttributeDeclaration theContent;
        super.reconcileContents(changedElement);
        if (changedElement == this.getElement() && (theContent = this.getContent()) != null) {
            theContent.elementContentsChanged(changedElement);
            XSDAttributeDeclaration newAttributeDeclaration = theContent.getResolvedAttributeDeclaration();
            if (newAttributeDeclaration != this.getAttributeDeclaration()) {
                this.setAttributeDeclaration(newAttributeDeclaration);
            }
        }
    }

    protected void changeAttribute(EAttribute eAttribute) {
        if (this.isReconciling) {
            return;
        }
        super.changeAttribute(eAttribute);
        Element theElement = this.getElement();
        if (theElement != null) {
            if (eAttribute == null || eAttribute == XSDPackage.eINSTANCE.getXSDAttributeUse_Use()) {
                this.niceSetAttribute(theElement, "use", this.isSetUse() ? this.getUse().getName() : null);
            }
            if (eAttribute == null || eAttribute == XSDPackage.eINSTANCE.getXSDFeature_LexicalValue() || eAttribute == XSDPackage.eINSTANCE.getXSDAttributeUse_Constraint()) {
                if (this.getLexicalValue() != null) {
                    switch (this.getConstraint().getValue()) {
                        case 1: {
                            this.niceSetAttribute(theElement, "fixed", this.getLexicalValue());
                            if (!theElement.hasAttributeNS(null, "default")) break;
                            this.niceSetAttribute(theElement, "default", null);
                            break;
                        }
                        case 0: {
                            this.niceSetAttribute(theElement, "default", this.getLexicalValue());
                            if (!theElement.hasAttributeNS(null, "fixed")) break;
                            this.niceSetAttribute(theElement, "fixed", null);
                        }
                    }
                } else {
                    if (theElement.hasAttributeNS(null, "fixed")) {
                        this.niceSetAttribute(theElement, "fixed", null);
                    }
                    if (theElement.hasAttributeNS(null, "default")) {
                        this.niceSetAttribute(theElement, "default", null);
                    }
                }
            }
        }
    }

    protected void adoptContent(EReference eReference, XSDConcreteComponent xsdConcreteComponent) {
        super.adoptContent(eReference, xsdConcreteComponent);
        if (eReference == XSDPackage.eINSTANCE.getXSDAttributeUse_Content()) {
            this.patchHelper();
            this.traverseToRootForPatching();
        }
    }

    protected void orphanContent(EReference eReference, XSDConcreteComponent xsdConcreteComponent) {
        super.orphanContent(eReference, xsdConcreteComponent);
        if (eReference == XSDPackage.eINSTANCE.getXSDAttributeUse_Content()) {
            this.patchHelper();
            this.traverseToRootForPatching();
        }
    }

    public XSDConcreteComponent cloneConcreteComponent(boolean deep, boolean shareDOM) {
        XSDAttributeUseImpl clonedAttributeUse = (XSDAttributeUseImpl)this.getXSDFactory().createXSDAttributeUse();
        clonedAttributeUse.isReconciling = true;
        if (this.isSetUse()) {
            clonedAttributeUse.setUse(this.getUse());
        }
        clonedAttributeUse.setRequired(this.isRequired());
        if (this.isSetConstraint()) {
            clonedAttributeUse.setConstraint(this.getConstraint());
        }
        if (this.getLexicalValue() != null) {
            clonedAttributeUse.setLexicalValue(this.getLexicalValue());
        }
        clonedAttributeUse.setContent((XSDAttributeDeclaration)this.getContent().cloneConcreteComponent(deep, shareDOM));
        if (shareDOM && this.getElement() != null) {
            clonedAttributeUse.setElement(this.getElement());
        }
        clonedAttributeUse.isReconciling = shareDOM;
        return clonedAttributeUse;
    }
}

