/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.util;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import org.eclipse.osgi.framework.debug.Debug;
import org.eclipse.osgi.framework.internal.core.Msg;
import org.eclipse.osgi.framework.internal.core.Tokenizer;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.BundleException;

public class ManifestElement {
    protected String value;
    protected String[] valueComponents;
    protected Hashtable attributes;
    protected Hashtable directives;

    protected ManifestElement() {
    }

    public String getValue() {
        return this.value;
    }

    public String[] getValueComponents() {
        return this.valueComponents;
    }

    public String getAttribute(String key) {
        return this.getTableValue(this.attributes, key);
    }

    public String[] getAttributes(String key) {
        return this.getTableValues(this.attributes, key);
    }

    public Enumeration getKeys() {
        return this.getTableKeys(this.attributes);
    }

    protected void addAttribute(String key, String value) {
        this.attributes = this.addTableValue(this.attributes, key, value);
    }

    public String getDirective(String key) {
        return this.getTableValue(this.directives, key);
    }

    public String[] getDirectives(String key) {
        return this.getTableValues(this.directives, key);
    }

    public Enumeration getDirectiveKeys() {
        return this.getTableKeys(this.directives);
    }

    protected void addDirective(String key, String value) {
        this.directives = this.addTableValue(this.directives, key, value);
    }

    private String getTableValue(Hashtable table, String key) {
        if (table == null) {
            return null;
        }
        Object result = table.get(key);
        if (result == null) {
            return null;
        }
        if (result instanceof String) {
            return (String)result;
        }
        ArrayList valueList = (ArrayList)result;
        return (String)valueList.get(valueList.size() - 1);
    }

    private String[] getTableValues(Hashtable table, String key) {
        if (table == null) {
            return null;
        }
        Object result = table.get(key);
        if (result == null) {
            return null;
        }
        if (result instanceof String) {
            return new String[]{(String)result};
        }
        ArrayList valueList = (ArrayList)result;
        return valueList.toArray(new String[valueList.size()]);
    }

    private Enumeration getTableKeys(Hashtable table) {
        if (table == null) {
            return null;
        }
        return table.keys();
    }

    private Hashtable addTableValue(Hashtable table, String key, String value) {
        Object curValue;
        if (table == null) {
            table = new Hashtable<String, Object>(7);
        }
        if ((curValue = table.get(key)) != null) {
            ArrayList<String> newList;
            if (curValue instanceof ArrayList) {
                newList = (ArrayList<String>)curValue;
            } else {
                newList = new ArrayList<String>(5);
                newList.add((String)curValue);
            }
            newList.add(value);
            table.put(key, newList);
        } else {
            table.put(key, value);
        }
        return table;
    }

    public static ManifestElement[] parseHeader(String header, String value) throws BundleException {
        char c2;
        if (value == null) {
            return null;
        }
        Vector<ManifestElement> headerElements = new Vector<ManifestElement>(10, 10);
        Tokenizer tokenizer = new Tokenizer(value);
        do {
            String next;
            if ((next = tokenizer.getToken(";,")) == null) {
                throw new BundleException(NLS.bind(Msg.MANIFEST_INVALID_HEADER_EXCEPTION, header, value));
            }
            ArrayList<String> headerValues = new ArrayList<String>();
            StringBuffer headerValue = new StringBuffer(next);
            headerValues.add(next);
            if (Debug.DEBUG_MANIFEST) {
                Debug.print("paserHeader: " + next);
            }
            c2 = tokenizer.getChar();
            while (c2 == ';') {
                next = tokenizer.getToken(";,=:");
                if (next == null) {
                    throw new BundleException(NLS.bind(Msg.MANIFEST_INVALID_HEADER_EXCEPTION, header, value));
                }
                c2 = tokenizer.getChar();
                if (c2 != ';' && c2 != '\u0000') continue;
                headerValues.add(next);
                headerValue.append(";").append(next);
                if (!Debug.DEBUG_MANIFEST) continue;
                Debug.print(";" + next);
            }
            ManifestElement manifestElement = new ManifestElement();
            manifestElement.value = headerValue.toString();
            manifestElement.valueComponents = headerValues.toArray(new String[headerValues.size()]);
            boolean directive = false;
            if (c2 == ':') {
                c2 = tokenizer.getChar();
                if (c2 != '=') {
                    throw new BundleException(NLS.bind(Msg.MANIFEST_INVALID_HEADER_EXCEPTION, header, value));
                }
                directive = true;
            }
            while (c2 == '=') {
                String val = tokenizer.getString(";,");
                if (val == null) {
                    throw new BundleException(NLS.bind(Msg.MANIFEST_INVALID_HEADER_EXCEPTION, header, value));
                }
                if (Debug.DEBUG_MANIFEST) {
                    Debug.print(";" + next + "=" + val);
                }
                try {
                    if (directive) {
                        manifestElement.addDirective(next, val);
                    } else {
                        manifestElement.addAttribute(next, val);
                    }
                    directive = false;
                }
                catch (Exception e2) {
                    throw new BundleException(NLS.bind(Msg.MANIFEST_INVALID_HEADER_EXCEPTION, header, value));
                }
                c2 = tokenizer.getChar();
                if (c2 != ';') continue;
                next = tokenizer.getToken("=:");
                if (next == null) {
                    throw new BundleException(NLS.bind(Msg.MANIFEST_INVALID_HEADER_EXCEPTION, header, value));
                }
                c2 = tokenizer.getChar();
                if (c2 != ':') continue;
                c2 = tokenizer.getChar();
                if (c2 != '=') {
                    throw new BundleException(NLS.bind(Msg.MANIFEST_INVALID_HEADER_EXCEPTION, header, value));
                }
                directive = true;
            }
            headerElements.addElement(manifestElement);
            if (!Debug.DEBUG_MANIFEST) continue;
            Debug.println("");
        } while (c2 == ',');
        if (c2 != '\u0000') {
            throw new BundleException(NLS.bind(Msg.MANIFEST_INVALID_HEADER_EXCEPTION, header, value));
        }
        int size = headerElements.size();
        if (size == 0) {
            return null;
        }
        Object[] result = new ManifestElement[size];
        headerElements.copyInto(result);
        return result;
    }

    public static String[] getArrayFromList(String stringList) {
        if (stringList == null || stringList.trim().equals("")) {
            return null;
        }
        Vector<String> list = new Vector<String>();
        StringTokenizer tokens = new StringTokenizer(stringList, ",");
        while (tokens.hasMoreTokens()) {
            String token = tokens.nextToken().trim();
            if (token.equals("")) continue;
            list.addElement(token);
        }
        return list.isEmpty() ? new String[]{} : list.toArray(new String[list.size()]);
    }
}

