/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.internal.module;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.eclipse.osgi.internal.module.BundleConstraint;
import org.eclipse.osgi.internal.module.ResolverBundle;
import org.eclipse.osgi.internal.module.ResolverExport;
import org.eclipse.osgi.internal.module.ResolverImport;

public class GroupingChecker {
    HashMap bundles = new HashMap();

    private ArrayList getConstraints(ResolverExport constrained) {
        HashMap exports = (HashMap)this.bundles.get(constrained.getExporter());
        if (exports == null) {
            return null;
        }
        ArrayList constraints = (ArrayList)exports.get(constrained);
        if (constraints == null) {
            return null;
        }
        ArrayList results = new ArrayList(constraints.size());
        Iterator iter = constraints.iterator();
        while (iter.hasNext()) {
            ResolverExport impConstraint;
            Object constraint = iter.next();
            if (constraint instanceof ResolverExport && !results.contains(constraint)) {
                results.add(constraint);
                continue;
            }
            ResolverImport imp = (ResolverImport)constraint;
            if (imp.getMatchingExport() == null || (impConstraint = imp.getMatchingExport().getRoot()) == null || results.contains(impConstraint)) continue;
            results.add(impConstraint);
        }
        return results;
    }

    private ArrayList createConstraints(ResolverExport constrained) {
        ArrayList constraints;
        HashMap exports = (HashMap)this.bundles.get(constrained.getExporter());
        if (exports == null) {
            exports = new HashMap();
            this.bundles.put(constrained.getExporter(), exports);
        }
        if ((constraints = (ArrayList)exports.get(constrained)) == null) {
            constraints = new ArrayList();
            exports.put(constrained, constraints);
        }
        return constraints;
    }

    private void addConstraint(ResolverExport constrained, Object constraint) {
        ArrayList list = this.createConstraints(constrained);
        if (!list.contains(constraint)) {
            list.add(constraint);
        }
    }

    private void addConstraints(ResolverExport constrained, ArrayList newConstraints) {
        ArrayList list = this.createConstraints(constrained);
        for (int i2 = 0; i2 < newConstraints.size(); ++i2) {
            Object constraint = newConstraints.get(i2);
            if (list.contains(constraint)) continue;
            list.add(constraint);
        }
    }

    void removeAllExportConstraints(ResolverBundle bundle) {
        this.bundles.remove(bundle);
    }

    ResolverExport isConsistent(ResolverImport imp, ResolverExport exp) {
        int i2;
        ResolverImport[] imports = imp.getBundle().getImportPackages();
        BundleConstraint[] requires = imp.getBundle().getRequires();
        for (i2 = 0; i2 < imports.length; ++i2) {
            ResolverExport re;
            int j2;
            ResolverExport wire = imports[i2].getMatchingExport();
            if (wire == null) continue;
            ArrayList list = this.getConstraints(wire);
            if (list != null) {
                for (j2 = 0; j2 < list.size(); ++j2) {
                    re = (ResolverExport)list.get(j2);
                    if (re.isDropped() || !re.getExporter().isResolvable() || !exp.getName().equals(re.getName()) || ResolverExport.isOnRootPath(re.getExporter(), imp.getMatchingExport()) || imp.isOnRootPathSplit(imp.getMatchingExport().getExporter(), re.getExporter())) continue;
                    return wire;
                }
            }
            if ((list = this.getConstraints(exp)) == null) continue;
            for (j2 = 0; j2 < list.size(); ++j2) {
                re = (ResolverExport)list.get(j2);
                if (re.isDropped()) continue;
                if (re.getExporter().isResolvable() && wire.getName().equals(re.getName()) && !ResolverExport.isOnRootPath(re.getExporter(), imports[i2].getMatchingExport()) && !imp.isOnRootPathSplit(imp.getMatchingExport().getExporter(), re.getExporter())) {
                    return wire;
                }
                for (int k2 = 0; k2 < requires.length; ++k2) {
                    if (requires[k2].getMatchingBundle() == null) continue;
                    ResolverExport[] exports = requires[k2].getMatchingBundle().getExportPackages();
                    for (int m2 = 0; m2 < exports.length; ++m2) {
                        if (!re.getExporter().isResolvable() || !exports[m2].getName().equals(re.getName()) || ResolverExport.isOnRootPath(re.getExporter(), exports[m2])) continue;
                        return re;
                    }
                }
            }
        }
        for (i2 = 0; i2 < requires.length; ++i2) {
            if (requires[i2].getMatchingBundle() == null) continue;
            ResolverExport[] exports = requires[i2].getMatchingBundle().getExportPackages();
            for (int j3 = 0; j3 < exports.length; ++j3) {
                ArrayList list = this.getConstraints(exports[j3]);
                if (list == null) continue;
                for (int k3 = 0; k3 < list.size(); ++k3) {
                    ResolverExport re = (ResolverExport)list.get(k3);
                    if (!re.getExporter().isResolvable() || !exp.getName().equals(re.getName()) || ResolverExport.isOnRootPath(re.getExporter(), imp.getMatchingExport())) continue;
                    return re;
                }
            }
        }
        return null;
    }

    boolean checkRequiresConstraints(ResolverBundle bundle) {
        BundleConstraint[] requires = bundle.getRequires();
        if (requires == null) {
            return true;
        }
        for (int i2 = 0; i2 < requires.length; ++i2) {
            ResolverBundle matchingBundle = requires[i2].getMatchingBundle();
            if (matchingBundle == null) continue;
            ResolverExport[] exports = matchingBundle.getExportPackages();
            for (int j2 = 0; j2 < exports.length; ++j2) {
                ArrayList list = this.getConstraints(exports[j2]);
                if (list == null) continue;
                for (int k2 = 0; k2 < list.size(); ++k2) {
                    ResolverExport constraint = (ResolverExport)list.get(k2);
                    boolean foundPotential = false;
                    boolean found = false;
                    for (int m2 = 0; m2 < requires.length; ++m2) {
                        if (requires[m2].getMatchingBundle() == null) continue;
                        ResolverExport[] exps = requires[m2].getMatchingBundle().getExportPackages();
                        for (int n2 = 0; n2 < exps.length; ++n2) {
                            if (!constraint.getExporter().isResolvable() || !constraint.getName().equals(exps[n2].getName())) continue;
                            foundPotential = true;
                            if (exps[n2] != constraint && !ResolverExport.isOnRootPath(constraint.getExporter(), exps[n2])) continue;
                            found = true;
                            break;
                        }
                        if (found) break;
                    }
                    if (!foundPotential || found) continue;
                    return false;
                }
            }
        }
        return true;
    }

    void addInitialGroupingConstraints(ResolverBundle[] initBundles) {
        for (int i2 = 0; i2 < initBundles.length; ++i2) {
            if (this.bundles.containsKey(initBundles[i2])) continue;
            ResolverExport[] exports = initBundles[i2].getExportPackages();
            for (int j2 = 0; j2 < exports.length; ++j2) {
                String[] uses = (String[])exports[j2].getExportPackageDescription().getDirective("uses");
                if (uses == null) continue;
                for (int k2 = 0; k2 < uses.length; ++k2) {
                    Object constraint = initBundles[i2].getExport(uses[k2]);
                    if (constraint != null) {
                        this.addConstraint(exports[j2], constraint);
                        this.addTransitiveGroupingConstraints(exports[j2], (ResolverExport)constraint);
                    }
                    if ((constraint = initBundles[i2].getImport(uses[k2])) == null) continue;
                    this.addConstraint(exports[j2], constraint);
                }
            }
            if (this.bundles.get(initBundles[i2]) != null) continue;
            this.bundles.put(initBundles[i2], null);
        }
    }

    private void addTransitiveGroupingConstraints(ResolverExport export, ResolverExport constraint) {
        if (export == constraint) {
            return;
        }
        String[] uses = (String[])constraint.getExportPackageDescription().getDirective("uses");
        if (uses == null) {
            return;
        }
        for (int i2 = 0; i2 < uses.length; ++i2) {
            ArrayList list;
            Object newConstraint = export.getExporter().getExport(uses[i2]);
            if (newConstraint == null) {
                newConstraint = export.getExporter().getImport(uses[i2]);
            }
            if (newConstraint == null || newConstraint == constraint || (list = this.getConstraints(export)) != null && list.contains(newConstraint)) continue;
            this.addConstraint(export, newConstraint);
            if (!(newConstraint instanceof ResolverExport)) continue;
            this.addTransitiveGroupingConstraints(export, (ResolverExport)newConstraint);
        }
    }

    void addReExportConstraints(ResolverBundle bundle) {
        ResolverExport[] exports = bundle.getExportPackages();
        for (int i2 = 0; i2 < exports.length; ++i2) {
            ArrayList list;
            ResolverExport root;
            if (exports[i2].getExportPackageDescription().isRoot() || (root = exports[i2].getRoot()) == null || (list = this.getConstraints(root)) == null) continue;
            this.addConstraints(exports[i2], list);
        }
    }

    void addRequireConstraints(ResolverExport[] exports, ResolverBundle bundle) {
        BundleConstraint[] requires = bundle.getRequires();
        for (int i2 = 0; i2 < exports.length; ++i2) {
            if (exports[i2].getExportPackageDescription().isRoot()) continue;
            for (int j2 = 0; j2 < requires.length; ++j2) {
                if (requires[j2].getMatchingBundle() == null || exports[i2].getExporter() == requires[j2].getMatchingBundle()) continue;
                ResolverExport[] requireExports = requires[j2].getMatchingBundle().getExportPackages();
                for (int k2 = 0; k2 < requireExports.length; ++k2) {
                    ArrayList list;
                    if (!exports[i2].getName().equals(requireExports[k2].getName()) || (list = this.getConstraints(requireExports[k2])) == null) continue;
                    for (int m2 = 0; m2 < list.size(); ++m2) {
                        this.addConstraint(exports[i2], list.get(m2));
                    }
                }
            }
        }
    }

    void addReprovideConstraints(ResolverExport re) {
        BundleConstraint[] requires = re.getExporter().getRequires();
        for (int i2 = 0; i2 < requires.length; ++i2) {
            if (requires[i2].getMatchingBundle() == null) {
                return;
            }
            ResolverExport[] requireExports = requires[i2].getMatchingBundle().getExportPackages();
            for (int j2 = 0; j2 < requireExports.length; ++j2) {
                ArrayList list;
                if (!re.getName().equals(requireExports[j2].getName()) || (list = this.getConstraints(requireExports[j2])) == null) continue;
                for (int k2 = 0; k2 < list.size(); ++k2) {
                    this.addConstraint(re, list.get(k2));
                }
            }
        }
    }
}

