/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.framework.internal.reliablefile;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.zip.CRC32;
import java.util.zip.Checksum;

public class ReliableFile {
    public static final int OPEN_BEST_AVAILABLE = 0;
    public static final int OPEN_FAIL_ON_PRIMARY = 1;
    public static final int GENERATION_LATEST = 0;
    public static final int GENERATIONS_INFINITE = 0;
    public static final String tmpExt = ".tmp";
    public static final String PROP_MAX_BUFFER = "osgi.reliableFile.maxInputStreamBuffer";
    public static final String PROP_MAX_GENERATIONS = "osgi.ReliableFile.maxGenerations";
    public static final String PROP_OSGI_LOCKING = "osgi.locking";
    protected static final int FILETYPE_UNKNOWN = -1;
    protected static final int FILETYPE_VALID = 0;
    protected static final int FILETYPE_CORRUPT = 1;
    protected static final int FILETYPE_NOSIGNATURE = 2;
    protected static final byte[] identifier1 = new byte[]{46, 99, 114, 99};
    protected static final byte[] identifier2 = new byte[]{46, 118, 49, 10};
    private static final int BUF_SIZE = 4096;
    private static int maxInputStreamBuffer = 131072;
    private static int defaultMaxGenerations = 2;
    private static boolean fileSharing = true;
    private static File lastGenerationFile = null;
    private static int[] lastGenerations = null;
    private File referenceFile;
    private static Hashtable cacheFiles;
    private File inputFile = null;
    private File outputFile = null;
    private Checksum appendChecksum = null;

    protected static ReliableFile getReliableFile(String name) throws IOException {
        return ReliableFile.getReliableFile(new File(name));
    }

    protected static ReliableFile getReliableFile(File file) throws IOException {
        if (file.isDirectory()) {
            throw new FileNotFoundException("file is a directory");
        }
        return new ReliableFile(file);
    }

    private ReliableFile(File file) {
        this.referenceFile = file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int[] getFileGenerations(File file) {
        ArrayList<Integer> list;
        int[] generations;
        block14: {
            String[] files;
            int prefixLen;
            String prefix;
            block13: {
                if (!fileSharing && lastGenerationFile != null && file.equals(lastGenerationFile)) {
                    return lastGenerations;
                }
                generations = null;
                String name = file.getName();
                prefix = name + '.';
                prefixLen = prefix.length();
                File parent = new File(file.getParent());
                files = parent.list();
                if (files != null) break block13;
                int[] nArray = null;
                Object var12_9 = null;
                if (!fileSharing) {
                    lastGenerationFile = file;
                    lastGenerations = generations;
                }
                return nArray;
            }
            list = new ArrayList<Integer>(defaultMaxGenerations);
            if (file.exists()) {
                list.add(new Integer(0));
            }
            for (int i2 = 0; i2 < files.length; ++i2) {
                if (!files[i2].startsWith(prefix)) continue;
                try {
                    int id = Integer.parseInt(files[i2].substring(prefixLen));
                    list.add(new Integer(id));
                    continue;
                }
                catch (NumberFormatException e2) {
                    // empty catch block
                }
            }
            if (list.size() != 0) break block14;
            int[] i2 = null;
            Object var12_10 = null;
            if (!fileSharing) {
                lastGenerationFile = file;
                lastGenerations = generations;
            }
            return i2;
        }
        try {
            Object[] array = list.toArray();
            Arrays.sort(array);
            generations = new int[array.length];
            int i3 = 0;
            int j2 = array.length - 1;
            while (i3 < array.length) {
                generations[i3] = (Integer)array[j2];
                ++i3;
                --j2;
            }
            int[] nArray = generations;
            Object var12_11 = null;
            if (!fileSharing) {
                lastGenerationFile = file;
                lastGenerations = generations;
            }
            return nArray;
        }
        catch (Throwable throwable) {
            block15: {
                Object var12_12 = null;
                if (fileSharing) break block15;
                lastGenerationFile = file;
                lastGenerations = generations;
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected InputStream getInputStream(int generation, int openMask) throws IOException {
        boolean failOnPrimary;
        if (this.inputFile != null) {
            throw new IOException("Input stream already open");
        }
        int[] generations = ReliableFile.getFileGenerations(this.referenceFile);
        if (generations == null) {
            throw new FileNotFoundException("File not found");
        }
        String name = this.referenceFile.getName();
        File parent = new File(this.referenceFile.getParent());
        boolean bl = failOnPrimary = (openMask & 1) != 0;
        if (failOnPrimary && generation == 0) {
            generation = generations[0];
        }
        File textFile = null;
        InputStream textIS = null;
        block12: for (int idx = 0; idx < generations.length; ++idx) {
            CacheInfo info;
            if (generation != 0 && (generations[idx] > generation || failOnPrimary && generations[idx] != generation)) continue;
            File file = generations[idx] != 0 ? new File(parent, name + '.' + generations[idx]) : this.referenceFile;
            InputStream is = null;
            Hashtable hashtable = cacheFiles;
            synchronized (hashtable) {
                info = (CacheInfo)cacheFiles.get(file);
            }
            long timeStamp = file.lastModified();
            if (info == null || timeStamp != info.timeStamp) {
                try {
                    is = new FileInputStream(file);
                    if (((InputStream)is).available() < maxInputStreamBuffer) {
                        is = new BufferedInputStream(is);
                    }
                    Checksum cksum = this.getChecksumCalculator();
                    int filetype = this.getStreamType(is, cksum);
                    info = new CacheInfo(filetype, cksum, timeStamp);
                    Hashtable hashtable2 = cacheFiles;
                    synchronized (hashtable2) {
                        cacheFiles.put(file, info);
                    }
                }
                catch (IOException e2) {
                    // empty catch block
                }
            }
            if (failOnPrimary) {
                if (info != null && info.filetype == 0) {
                    this.inputFile = file;
                    if (is != null) {
                        return is;
                    }
                    return new FileInputStream(file);
                }
                throw new IOException("ReliableFile is corrupt");
            }
            if (info == null) continue;
            switch (info.filetype) {
                case 0: {
                    this.inputFile = file;
                    if (is != null) {
                        return is;
                    }
                    return new FileInputStream(file);
                }
                case 2: {
                    if (textFile != null) continue block12;
                    textFile = file;
                    textIS = is;
                }
            }
        }
        if (textFile != null) {
            this.inputFile = textFile;
            if (textIS != null) {
                return textIS;
            }
            return new FileInputStream(textFile);
        }
        throw new IOException("ReliableFile is corrupt");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected OutputStream getOutputStream(boolean append, int appendGeneration) throws IOException {
        InputStream is;
        if (this.outputFile != null) {
            throw new IOException("Output stream is already open");
        }
        String name = this.referenceFile.getName();
        File parent = new File(this.referenceFile.getParent());
        File tmpFile = File.createTempFile(name, tmpExt, parent);
        if (!append) {
            FileOutputStream os = new FileOutputStream(tmpFile);
            this.outputFile = tmpFile;
            return os;
        }
        try {
            is = this.getInputStream(appendGeneration, 0);
        }
        catch (FileNotFoundException e2) {
            FileOutputStream os = new FileOutputStream(tmpFile);
            this.outputFile = tmpFile;
            return os;
        }
        try {
            CacheInfo info = (CacheInfo)cacheFiles.get(this.inputFile);
            this.appendChecksum = info.checksum;
            FileOutputStream os = new FileOutputStream(tmpFile);
            if (info.filetype == 2) {
                ReliableFile.cp(is, os, 0);
            } else {
                ReliableFile.cp(is, os, 16);
            }
            this.outputFile = tmpFile;
            FileOutputStream fileOutputStream = os;
            return fileOutputStream;
        }
        finally {
            this.closeInputFile();
        }
    }

    protected void closeOutputFile(Checksum checksum) throws IOException {
        if (this.outputFile == null) {
            throw new IOException("Output stream is not open");
        }
        int[] generations = ReliableFile.getFileGenerations(this.referenceFile);
        String name = this.referenceFile.getName();
        File parent = new File(this.referenceFile.getParent());
        File newFile = generations == null ? new File(parent, name + ".1") : new File(parent, name + '.' + (generations[0] + 1));
        ReliableFile.mv(this.outputFile, newFile);
        this.outputFile = null;
        this.appendChecksum = null;
        CacheInfo info = new CacheInfo(0, checksum, newFile.lastModified());
        cacheFiles.put(newFile, info);
        this.cleanup(generations, true);
        lastGenerationFile = null;
        lastGenerations = null;
    }

    protected void abortOutputFile() {
        if (this.outputFile == null) {
            return;
        }
        this.outputFile.delete();
        this.outputFile = null;
        this.appendChecksum = null;
    }

    protected File getOutputFile() {
        return this.outputFile;
    }

    void closeInputFile() {
        this.inputFile = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanup(int[] generations, boolean generationAdded) {
        if (generations == null) {
            return;
        }
        String name = this.referenceFile.getName();
        File parent = new File(this.referenceFile.getParent());
        int generationCount = generations.length;
        if (generations[generationCount - 1] == 0) {
            --generationCount;
        }
        int rmCount = generationCount - defaultMaxGenerations;
        if (generationAdded) {
            ++rmCount;
        }
        if (rmCount < 1) {
            return;
        }
        Hashtable hashtable = cacheFiles;
        synchronized (hashtable) {
            int idx;
            int count = generationCount - rmCount;
            for (idx = 0; idx < count; ++idx) {
                File file = new File(parent, name + '.' + generations[idx]);
                CacheInfo info = (CacheInfo)cacheFiles.get(file);
                if (info == null || info.filetype != 1) continue;
                --rmCount;
            }
            idx = generationCount - 1;
            while (rmCount > 0) {
                File rmFile = new File(parent, name + '.' + generations[idx]);
                rmFile.delete();
                cacheFiles.remove(rmFile);
                --idx;
                --rmCount;
            }
        }
    }

    private static void mv(File from, File to) throws IOException {
        if (!from.renameTo(to)) {
            throw new IOException("rename failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void cp(InputStream in, OutputStream out, int truncateSize) throws IOException {
        try {
            int length = in.available();
            length = truncateSize > length ? 0 : (length -= truncateSize);
            if (length > 0) {
                int count;
                int bufferSize = length > 4096 ? 4096 : length;
                byte[] buffer = new byte[bufferSize];
                int size = 0;
                while ((count = in.read(buffer, 0, length)) > 0) {
                    if (size + count >= length) {
                        count = length - size;
                    }
                    out.write(buffer, 0, count);
                    size += count;
                }
            }
        }
        finally {
            try {
                in.close();
            }
            catch (IOException iOException) {}
            out.close();
        }
    }

    public static boolean exists(File file) {
        String prefix = file.getName() + '.';
        File parent = new File(file.getParent());
        int prefixLen = prefix.length();
        String[] files = parent.list();
        if (files == null) {
            return false;
        }
        for (int i2 = 0; i2 < files.length; ++i2) {
            if (!files[i2].startsWith(prefix)) continue;
            try {
                Integer.parseInt(files[i2].substring(prefixLen));
                return true;
            }
            catch (NumberFormatException e2) {
                // empty catch block
            }
        }
        return file.exists();
    }

    public static long lastModified(File file) {
        int[] generations = ReliableFile.getFileGenerations(file);
        if (generations == null) {
            return 0L;
        }
        if (generations[0] == 0) {
            return file.lastModified();
        }
        String name = file.getName();
        File parent = new File(file.getParent());
        File newFile = new File(parent, name + '.' + generations[0]);
        return newFile.lastModified();
    }

    public long lastModified() {
        if (this.inputFile != null) {
            return this.inputFile.lastModified();
        }
        return 0L;
    }

    public static int lastModifiedVersion(File file) {
        int[] generations = ReliableFile.getFileGenerations(file);
        if (generations == null) {
            return -1;
        }
        return generations[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean delete(File deleteFile) {
        int[] generations = ReliableFile.getFileGenerations(deleteFile);
        if (generations == null) {
            return false;
        }
        String name = deleteFile.getName();
        File parent = new File(deleteFile.getParent());
        Hashtable hashtable = cacheFiles;
        synchronized (hashtable) {
            for (int idx = 0; idx < generations.length; ++idx) {
                if (generations[idx] == 0) continue;
                File file = new File(parent, name + '.' + generations[idx]);
                if (file.exists()) {
                    file.delete();
                }
                cacheFiles.remove(file);
            }
        }
        return true;
    }

    public static String[] getBaseFiles(File directory) throws IOException {
        int idx;
        if (!directory.isDirectory()) {
            throw new IOException("Not a valid directory");
        }
        String[] files = directory.list();
        HashSet<String> list = new HashSet<String>(files.length / 2);
        for (idx = 0; idx < files.length; ++idx) {
            String file = files[idx];
            int pos = file.lastIndexOf(46);
            if (pos == -1) continue;
            String ext = file.substring(pos + 1);
            int generation = 0;
            try {
                generation = Integer.parseInt(ext);
            }
            catch (NumberFormatException e2) {
                // empty catch block
            }
            if (generation == 0) continue;
            String base = file.substring(0, pos);
            list.add(base);
        }
        files = new String[list.size()];
        idx = 0;
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            files[idx++] = (String)iter.next();
        }
        return files;
    }

    public static void cleanupGenerations(File base) {
        ReliableFile rf = new ReliableFile(base);
        int[] generations = ReliableFile.getFileGenerations(base);
        rf.cleanup(generations, false);
        lastGenerationFile = null;
        lastGenerations = null;
    }

    public static void fileUpdated(File file) {
        lastGenerationFile = null;
        lastGenerations = null;
    }

    protected void writeChecksumSignature(OutputStream out, Checksum checksum) throws IOException {
        out.write(identifier1);
        out.write(ReliableFile.intToHex((int)checksum.getValue()));
        out.write(identifier2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int getSignatureSize() throws IOException {
        if (this.inputFile != null) {
            CacheInfo info;
            Hashtable hashtable = cacheFiles;
            synchronized (hashtable) {
                info = (CacheInfo)cacheFiles.get(this.inputFile);
            }
            if (info != null) {
                switch (info.filetype) {
                    case 0: 
                    case 1: {
                        return 16;
                    }
                    case 2: {
                        return 0;
                    }
                }
            }
        }
        throw new IOException("ReliableFile signature size is unknown");
    }

    protected Checksum getFileChecksum() throws IOException {
        if (this.appendChecksum == null) {
            throw new IOException("Checksum is invalid!");
        }
        return this.appendChecksum;
    }

    protected Checksum getChecksumCalculator() {
        return new CRC32();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getStreamType(InputStream is, Checksum crc) throws IOException {
        boolean markSupported = is.markSupported();
        if (markSupported) {
            is.mark(is.available());
        }
        try {
            int i2;
            int num;
            int len = is.available();
            if (len < 16) {
                byte[] data22;
                int num2;
                if (crc != null && (num2 = is.read(data22 = new byte[16])) > 0) {
                    crc.update(data22, 0, num2);
                }
                int data22 = 2;
                return data22;
            }
            len -= 16;
            byte[] data = new byte[4096];
            for (int pos = 0; pos < len; pos += num) {
                int read = data.length;
                if (pos + read > len) {
                    read = len - pos;
                }
                if ((num = is.read(data, 0, read)) == -1) {
                    throw new IOException("Unable to read entire file.");
                }
                crc.update(data, 0, num);
            }
            int num3 = is.read(data);
            if (num3 != 16) {
                throw new IOException("Unable to read entire file.");
            }
            for (i2 = 0; i2 < 4; ++i2) {
                if (identifier1[i2] == data[i2]) continue;
                crc.update(data, 0, 16);
                int n2 = 2;
                return n2;
            }
            i2 = 0;
            int j2 = 12;
            while (i2 < 4) {
                if (identifier2[i2] != data[j2]) {
                    crc.update(data, 0, 16);
                    int n3 = 2;
                    return n3;
                }
                ++i2;
                ++j2;
            }
            long crccmp = Long.valueOf(new String(data, 4, 8), 16);
            if (crccmp == crc.getValue()) {
                int n4 = 0;
                return n4;
            }
            int n5 = 1;
            return n5;
        }
        finally {
            if (markSupported) {
                is.reset();
            }
        }
    }

    private static byte[] intToHex(int l2) {
        byte[] buffer = new byte[8];
        int count = 8;
        do {
            int ch;
            ch = (ch = l2 & 0xF) > 9 ? ch - 10 + 97 : (ch += 48);
            buffer[--count] = (byte)ch;
            l2 >>= 4;
        } while (count > 0);
        return buffer;
    }

    static {
        String prop = System.getProperty(PROP_MAX_BUFFER);
        if (prop != null) {
            try {
                maxInputStreamBuffer = Integer.parseInt(prop);
            }
            catch (NumberFormatException e2) {
                // empty catch block
            }
        }
        if ((prop = System.getProperty(PROP_MAX_GENERATIONS)) != null) {
            try {
                defaultMaxGenerations = Integer.parseInt(prop);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if ((prop = System.getProperty(PROP_OSGI_LOCKING)) != null && prop.equals("none")) {
            fileSharing = false;
        }
        cacheFiles = new Hashtable(20);
    }

    private class CacheInfo {
        int filetype;
        Checksum checksum;
        long timeStamp;

        CacheInfo(int filetype, Checksum checksum, long timeStamp) {
            this.filetype = filetype;
            this.checksum = checksum;
            this.timeStamp = timeStamp;
        }
    }
}

